/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
//
// **NOTE**: Do not edit directly! This file is generated using `npm run import-typescript`
//


/** Contains all the lib files */
export const libFileMap: Record<string, string> = {}
libFileMap['lib.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/// <reference lib=\"es5\" />\n/// <reference lib=\"dom\" />\n/// <reference lib=\"webworker.importscripts\" />\n/// <reference lib=\"scripthost\" />\n";
libFileMap['lib.decorators.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/**\n * The decorator context types provided to class element decorators.\n */\ntype ClassMemberDecoratorContext =\n    | ClassMethodDecoratorContext\n    | ClassGetterDecoratorContext\n    | ClassSetterDecoratorContext\n    | ClassFieldDecoratorContext\n    | ClassAccessorDecoratorContext;\n\n/**\n * The decorator context types provided to any decorator.\n */\ntype DecoratorContext =\n    | ClassDecoratorContext\n    | ClassMemberDecoratorContext;\n\ntype DecoratorMetadataObject = Record<PropertyKey, unknown> & object;\n\ntype DecoratorMetadata = typeof globalThis extends { Symbol: { readonly metadata: symbol; }; } ? DecoratorMetadataObject : DecoratorMetadataObject | undefined;\n\n/**\n * Context provided to a class decorator.\n * @template Class The type of the decorated class associated with this context.\n */\ninterface ClassDecoratorContext<\n    Class extends abstract new (...args: any) => any = abstract new (...args: any) => any,\n> {\n    /** The kind of element that was decorated. */\n    readonly kind: \"class\";\n\n    /** The name of the decorated class. */\n    readonly name: string | undefined;\n\n    /**\n     * Adds a callback to be invoked after the class definition has been finalized.\n     *\n     * @example\n     * ```ts\n     * function customElement(name: string): ClassDecoratorFunction {\n     *   return (target, context) => {\n     *     context.addInitializer(function () {\n     *       customElements.define(name, this);\n     *     });\n     *   }\n     * }\n     *\n     * @customElement(\"my-element\")\n     * class MyElement {}\n     * ```\n     */\n    addInitializer(initializer: (this: Class) => void): void;\n\n    readonly metadata: DecoratorMetadata;\n}\n\n/**\n * Context provided to a class method decorator.\n * @template This The type on which the class element will be defined. For a static class element, this will be\n * the type of the constructor. For a non-static class element, this will be the type of the instance.\n * @template Value The type of the decorated class method.\n */\ninterface ClassMethodDecoratorContext<\n    This = unknown,\n    Value extends (this: This, ...args: any) => any = (this: This, ...args: any) => any,\n> {\n    /** The kind of class element that was decorated. */\n    readonly kind: \"method\";\n\n    /** The name of the decorated class element. */\n    readonly name: string | symbol;\n\n    /** A value indicating whether the class element is a static (`true`) or instance (`false`) element. */\n    readonly static: boolean;\n\n    /** A value indicating whether the class element has a private name. */\n    readonly private: boolean;\n\n    /** An object that can be used to access the current value of the class element at runtime. */\n    readonly access: {\n        /**\n         * Determines whether an object has a property with the same name as the decorated element.\n         */\n        has(object: This): boolean;\n        /**\n         * Gets the current value of the method from the provided object.\n         *\n         * @example\n         * let fn = context.access.get(instance);\n         */\n        get(object: This): Value;\n    };\n\n    /**\n     * Adds a callback to be invoked either after static methods are defined but before\n     * static initializers are run (when decorating a `static` element), or before instance\n     * initializers are run (when decorating a non-`static` element).\n     *\n     * @example\n     * ```ts\n     * const bound: ClassMethodDecoratorFunction = (value, context) {\n     *   if (context.private) throw new TypeError(\"Not supported on private methods.\");\n     *   context.addInitializer(function () {\n     *     this[context.name] = this[context.name].bind(this);\n     *   });\n     * }\n     *\n     * class C {\n     *   message = \"Hello\";\n     *\n     *   @bound\n     *   m() {\n     *     console.log(this.message);\n     *   }\n     * }\n     * ```\n     */\n    addInitializer(initializer: (this: This) => void): void;\n\n    readonly metadata: DecoratorMetadata;\n}\n\n/**\n * Context provided to a class getter decorator.\n * @template This The type on which the class element will be defined. For a static class element, this will be\n * the type of the constructor. For a non-static class element, this will be the type of the instance.\n * @template Value The property type of the decorated class getter.\n */\ninterface ClassGetterDecoratorContext<\n    This = unknown,\n    Value = unknown,\n> {\n    /** The kind of class element that was decorated. */\n    readonly kind: \"getter\";\n\n    /** The name of the decorated class element. */\n    readonly name: string | symbol;\n\n    /** A value indicating whether the class element is a static (`true`) or instance (`false`) element. */\n    readonly static: boolean;\n\n    /** A value indicating whether the class element has a private name. */\n    readonly private: boolean;\n\n    /** An object that can be used to access the current value of the class element at runtime. */\n    readonly access: {\n        /**\n         * Determines whether an object has a property with the same name as the decorated element.\n         */\n        has(object: This): boolean;\n        /**\n         * Invokes the getter on the provided object.\n         *\n         * @example\n         * let value = context.access.get(instance);\n         */\n        get(object: This): Value;\n    };\n\n    /**\n     * Adds a callback to be invoked either after static methods are defined but before\n     * static initializers are run (when decorating a `static` element), or before instance\n     * initializers are run (when decorating a non-`static` element).\n     */\n    addInitializer(initializer: (this: This) => void): void;\n\n    readonly metadata: DecoratorMetadata;\n}\n\n/**\n * Context provided to a class setter decorator.\n * @template This The type on which the class element will be defined. For a static class element, this will be\n * the type of the constructor. For a non-static class element, this will be the type of the instance.\n * @template Value The type of the decorated class setter.\n */\ninterface ClassSetterDecoratorContext<\n    This = unknown,\n    Value = unknown,\n> {\n    /** The kind of class element that was decorated. */\n    readonly kind: \"setter\";\n\n    /** The name of the decorated class element. */\n    readonly name: string | symbol;\n\n    /** A value indicating whether the class element is a static (`true`) or instance (`false`) element. */\n    readonly static: boolean;\n\n    /** A value indicating whether the class element has a private name. */\n    readonly private: boolean;\n\n    /** An object that can be used to access the current value of the class element at runtime. */\n    readonly access: {\n        /**\n         * Determines whether an object has a property with the same name as the decorated element.\n         */\n        has(object: This): boolean;\n        /**\n         * Invokes the setter on the provided object.\n         *\n         * @example\n         * context.access.set(instance, value);\n         */\n        set(object: This, value: Value): void;\n    };\n\n    /**\n     * Adds a callback to be invoked either after static methods are defined but before\n     * static initializers are run (when decorating a `static` element), or before instance\n     * initializers are run (when decorating a non-`static` element).\n     */\n    addInitializer(initializer: (this: This) => void): void;\n\n    readonly metadata: DecoratorMetadata;\n}\n\n/**\n * Context provided to a class `accessor` field decorator.\n * @template This The type on which the class element will be defined. For a static class element, this will be\n * the type of the constructor. For a non-static class element, this will be the type of the instance.\n * @template Value The type of decorated class field.\n */\ninterface ClassAccessorDecoratorContext<\n    This = unknown,\n    Value = unknown,\n> {\n    /** The kind of class element that was decorated. */\n    readonly kind: \"accessor\";\n\n    /** The name of the decorated class element. */\n    readonly name: string | symbol;\n\n    /** A value indicating whether the class element is a static (`true`) or instance (`false`) element. */\n    readonly static: boolean;\n\n    /** A value indicating whether the class element has a private name. */\n    readonly private: boolean;\n\n    /** An object that can be used to access the current value of the class element at runtime. */\n    readonly access: {\n        /**\n         * Determines whether an object has a property with the same name as the decorated element.\n         */\n        has(object: This): boolean;\n\n        /**\n         * Invokes the getter on the provided object.\n         *\n         * @example\n         * let value = context.access.get(instance);\n         */\n        get(object: This): Value;\n\n        /**\n         * Invokes the setter on the provided object.\n         *\n         * @example\n         * context.access.set(instance, value);\n         */\n        set(object: This, value: Value): void;\n    };\n\n    /**\n     * Adds a callback to be invoked immediately after the auto `accessor` being\n     * decorated is initialized (regardless if the `accessor` is `static` or not).\n     */\n    addInitializer(initializer: (this: This) => void): void;\n\n    readonly metadata: DecoratorMetadata;\n}\n\n/**\n * Describes the target provided to class `accessor` field decorators.\n * @template This The `this` type to which the target applies.\n * @template Value The property type for the class `accessor` field.\n */\ninterface ClassAccessorDecoratorTarget<This, Value> {\n    /**\n     * Invokes the getter that was defined prior to decorator application.\n     *\n     * @example\n     * let value = target.get.call(instance);\n     */\n    get(this: This): Value;\n\n    /**\n     * Invokes the setter that was defined prior to decorator application.\n     *\n     * @example\n     * target.set.call(instance, value);\n     */\n    set(this: This, value: Value): void;\n}\n\n/**\n * Describes the allowed return value from a class `accessor` field decorator.\n * @template This The `this` type to which the target applies.\n * @template Value The property type for the class `accessor` field.\n */\ninterface ClassAccessorDecoratorResult<This, Value> {\n    /**\n     * An optional replacement getter function. If not provided, the existing getter function is used instead.\n     */\n    get?(this: This): Value;\n\n    /**\n     * An optional replacement setter function. If not provided, the existing setter function is used instead.\n     */\n    set?(this: This, value: Value): void;\n\n    /**\n     * An optional initializer mutator that is invoked when the underlying field initializer is evaluated.\n     * @param value The incoming initializer value.\n     * @returns The replacement initializer value.\n     */\n    init?(this: This, value: Value): Value;\n}\n\n/**\n * Context provided to a class field decorator.\n * @template This The type on which the class element will be defined. For a static class element, this will be\n * the type of the constructor. For a non-static class element, this will be the type of the instance.\n * @template Value The type of the decorated class field.\n */\ninterface ClassFieldDecoratorContext<\n    This = unknown,\n    Value = unknown,\n> {\n    /** The kind of class element that was decorated. */\n    readonly kind: \"field\";\n\n    /** The name of the decorated class element. */\n    readonly name: string | symbol;\n\n    /** A value indicating whether the class element is a static (`true`) or instance (`false`) element. */\n    readonly static: boolean;\n\n    /** A value indicating whether the class element has a private name. */\n    readonly private: boolean;\n\n    /** An object that can be used to access the current value of the class element at runtime. */\n    readonly access: {\n        /**\n         * Determines whether an object has a property with the same name as the decorated element.\n         */\n        has(object: This): boolean;\n\n        /**\n         * Gets the value of the field on the provided object.\n         */\n        get(object: This): Value;\n\n        /**\n         * Sets the value of the field on the provided object.\n         */\n        set(object: This, value: Value): void;\n    };\n\n    /**\n     * Adds a callback to be invoked immediately after the field being decorated\n     * is initialized (regardless if the field is `static` or not).\n     */\n    addInitializer(initializer: (this: This) => void): void;\n\n    readonly metadata: DecoratorMetadata;\n}\n";
libFileMap['lib.decorators.legacy.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\ndeclare type ClassDecorator = <TFunction extends Function>(target: TFunction) => TFunction | void;\ndeclare type PropertyDecorator = (target: Object, propertyKey: string | symbol) => void;\ndeclare type MethodDecorator = <T>(target: Object, propertyKey: string | symbol, descriptor: TypedPropertyDescriptor<T>) => TypedPropertyDescriptor<T> | void;\ndeclare type ParameterDecorator = (target: Object, propertyKey: string | symbol | undefined, parameterIndex: number) => void;\n";
libFileMap['lib.dom.asynciterable.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/////////////////////////////\n/// Window Async Iterable APIs\n/////////////////////////////\n\ninterface FileSystemDirectoryHandleAsyncIterator<T> extends AsyncIteratorObject<T, BuiltinIteratorReturn, unknown> {\n    [Symbol.asyncIterator](): FileSystemDirectoryHandleAsyncIterator<T>;\n}\n\ninterface FileSystemDirectoryHandle {\n    [Symbol.asyncIterator](): FileSystemDirectoryHandleAsyncIterator<[string, FileSystemHandle]>;\n    entries(): FileSystemDirectoryHandleAsyncIterator<[string, FileSystemHandle]>;\n    keys(): FileSystemDirectoryHandleAsyncIterator<string>;\n    values(): FileSystemDirectoryHandleAsyncIterator<FileSystemHandle>;\n}\n\ninterface ReadableStreamAsyncIterator<T> extends AsyncIteratorObject<T, BuiltinIteratorReturn, unknown> {\n    [Symbol.asyncIterator](): ReadableStreamAsyncIterator<T>;\n}\n\ninterface ReadableStream<R = any> {\n    [Symbol.asyncIterator](options?: ReadableStreamIteratorOptions): ReadableStreamAsyncIterator<R>;\n    values(options?: ReadableStreamIteratorOptions): ReadableStreamAsyncIterator<R>;\n}\n";
libFileMap['lib.dom.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n/// <reference no-default-lib=\"true\"/>\n\n/////////////////////////////\n/// Window APIs\n/////////////////////////////\n\ninterface AddEventListenerOptions extends EventListenerOptions {\n    once?: boolean;\n    passive?: boolean;\n    signal?: AbortSignal;\n}\n\ninterface AddressErrors {\n    addressLine?: string;\n    city?: string;\n    country?: string;\n    dependentLocality?: string;\n    organization?: string;\n    phone?: string;\n    postalCode?: string;\n    recipient?: string;\n    region?: string;\n    sortingCode?: string;\n}\n\ninterface AesCbcParams extends Algorithm {\n    iv: BufferSource;\n}\n\ninterface AesCtrParams extends Algorithm {\n    counter: BufferSource;\n    length: number;\n}\n\ninterface AesDerivedKeyParams extends Algorithm {\n    length: number;\n}\n\ninterface AesGcmParams extends Algorithm {\n    additionalData?: BufferSource;\n    iv: BufferSource;\n    tagLength?: number;\n}\n\ninterface AesKeyAlgorithm extends KeyAlgorithm {\n    length: number;\n}\n\ninterface AesKeyGenParams extends Algorithm {\n    length: number;\n}\n\ninterface Algorithm {\n    name: string;\n}\n\ninterface AnalyserOptions extends AudioNodeOptions {\n    fftSize?: number;\n    maxDecibels?: number;\n    minDecibels?: number;\n    smoothingTimeConstant?: number;\n}\n\ninterface AnimationEventInit extends EventInit {\n    animationName?: string;\n    elapsedTime?: number;\n    pseudoElement?: string;\n}\n\ninterface AnimationPlaybackEventInit extends EventInit {\n    currentTime?: CSSNumberish | null;\n    timelineTime?: CSSNumberish | null;\n}\n\ninterface AssignedNodesOptions {\n    flatten?: boolean;\n}\n\ninterface AudioBufferOptions {\n    length: number;\n    numberOfChannels?: number;\n    sampleRate: number;\n}\n\ninterface AudioBufferSourceOptions {\n    buffer?: AudioBuffer | null;\n    detune?: number;\n    loop?: boolean;\n    loopEnd?: number;\n    loopStart?: number;\n    playbackRate?: number;\n}\n\ninterface AudioConfiguration {\n    bitrate?: number;\n    channels?: string;\n    contentType: string;\n    samplerate?: number;\n    spatialRendering?: boolean;\n}\n\ninterface AudioContextOptions {\n    latencyHint?: AudioContextLatencyCategory | number;\n    sampleRate?: number;\n}\n\ninterface AudioDataCopyToOptions {\n    format?: AudioSampleFormat;\n    frameCount?: number;\n    frameOffset?: number;\n    planeIndex: number;\n}\n\ninterface AudioDataInit {\n    data: BufferSource;\n    format: AudioSampleFormat;\n    numberOfChannels: number;\n    numberOfFrames: number;\n    sampleRate: number;\n    timestamp: number;\n    transfer?: ArrayBuffer[];\n}\n\ninterface AudioDecoderConfig {\n    codec: string;\n    description?: AllowSharedBufferSource;\n    numberOfChannels: number;\n    sampleRate: number;\n}\n\ninterface AudioDecoderInit {\n    error: WebCodecsErrorCallback;\n    output: AudioDataOutputCallback;\n}\n\ninterface AudioDecoderSupport {\n    config?: AudioDecoderConfig;\n    supported?: boolean;\n}\n\ninterface AudioEncoderConfig {\n    bitrate?: number;\n    bitrateMode?: BitrateMode;\n    codec: string;\n    numberOfChannels: number;\n    opus?: OpusEncoderConfig;\n    sampleRate: number;\n}\n\ninterface AudioEncoderInit {\n    error: WebCodecsErrorCallback;\n    output: EncodedAudioChunkOutputCallback;\n}\n\ninterface AudioEncoderSupport {\n    config?: AudioEncoderConfig;\n    supported?: boolean;\n}\n\ninterface AudioNodeOptions {\n    channelCount?: number;\n    channelCountMode?: ChannelCountMode;\n    channelInterpretation?: ChannelInterpretation;\n}\n\ninterface AudioProcessingEventInit extends EventInit {\n    inputBuffer: AudioBuffer;\n    outputBuffer: AudioBuffer;\n    playbackTime: number;\n}\n\ninterface AudioTimestamp {\n    contextTime?: number;\n    performanceTime?: DOMHighResTimeStamp;\n}\n\ninterface AudioWorkletNodeOptions extends AudioNodeOptions {\n    numberOfInputs?: number;\n    numberOfOutputs?: number;\n    outputChannelCount?: number[];\n    parameterData?: Record<string, number>;\n    processorOptions?: any;\n}\n\ninterface AuthenticationExtensionsClientInputs {\n    appid?: string;\n    credProps?: boolean;\n    credentialProtectionPolicy?: string;\n    enforceCredentialProtectionPolicy?: boolean;\n    hmacCreateSecret?: boolean;\n    largeBlob?: AuthenticationExtensionsLargeBlobInputs;\n    minPinLength?: boolean;\n    prf?: AuthenticationExtensionsPRFInputs;\n}\n\ninterface AuthenticationExtensionsClientInputsJSON {\n    appid?: string;\n    credProps?: boolean;\n    largeBlob?: AuthenticationExtensionsLargeBlobInputsJSON;\n    prf?: AuthenticationExtensionsPRFInputsJSON;\n}\n\ninterface AuthenticationExtensionsClientOutputs {\n    appid?: boolean;\n    credProps?: CredentialPropertiesOutput;\n    hmacCreateSecret?: boolean;\n    largeBlob?: AuthenticationExtensionsLargeBlobOutputs;\n    prf?: AuthenticationExtensionsPRFOutputs;\n}\n\ninterface AuthenticationExtensionsLargeBlobInputs {\n    read?: boolean;\n    support?: string;\n    write?: BufferSource;\n}\n\ninterface AuthenticationExtensionsLargeBlobInputsJSON {\n    read?: boolean;\n    support?: string;\n    write?: Base64URLString;\n}\n\ninterface AuthenticationExtensionsLargeBlobOutputs {\n    blob?: ArrayBuffer;\n    supported?: boolean;\n    written?: boolean;\n}\n\ninterface AuthenticationExtensionsPRFInputs {\n    eval?: AuthenticationExtensionsPRFValues;\n    evalByCredential?: Record<string, AuthenticationExtensionsPRFValues>;\n}\n\ninterface AuthenticationExtensionsPRFInputsJSON {\n    eval?: AuthenticationExtensionsPRFValuesJSON;\n    evalByCredential?: Record<string, AuthenticationExtensionsPRFValuesJSON>;\n}\n\ninterface AuthenticationExtensionsPRFOutputs {\n    enabled?: boolean;\n    results?: AuthenticationExtensionsPRFValues;\n}\n\ninterface AuthenticationExtensionsPRFValues {\n    first: BufferSource;\n    second?: BufferSource;\n}\n\ninterface AuthenticationExtensionsPRFValuesJSON {\n    first: Base64URLString;\n    second?: Base64URLString;\n}\n\ninterface AuthenticatorSelectionCriteria {\n    authenticatorAttachment?: AuthenticatorAttachment;\n    requireResidentKey?: boolean;\n    residentKey?: ResidentKeyRequirement;\n    userVerification?: UserVerificationRequirement;\n}\n\ninterface AvcEncoderConfig {\n    format?: AvcBitstreamFormat;\n}\n\ninterface BiquadFilterOptions extends AudioNodeOptions {\n    Q?: number;\n    detune?: number;\n    frequency?: number;\n    gain?: number;\n    type?: BiquadFilterType;\n}\n\ninterface BlobEventInit extends EventInit {\n    data: Blob;\n    timecode?: DOMHighResTimeStamp;\n}\n\ninterface BlobPropertyBag {\n    endings?: EndingType;\n    type?: string;\n}\n\ninterface CSSMatrixComponentOptions {\n    is2D?: boolean;\n}\n\ninterface CSSNumericType {\n    angle?: number;\n    flex?: number;\n    frequency?: number;\n    length?: number;\n    percent?: number;\n    percentHint?: CSSNumericBaseType;\n    resolution?: number;\n    time?: number;\n}\n\ninterface CSSStyleSheetInit {\n    baseURL?: string;\n    disabled?: boolean;\n    media?: MediaList | string;\n}\n\ninterface CacheQueryOptions {\n    ignoreMethod?: boolean;\n    ignoreSearch?: boolean;\n    ignoreVary?: boolean;\n}\n\ninterface CanvasRenderingContext2DSettings {\n    alpha?: boolean;\n    colorSpace?: PredefinedColorSpace;\n    desynchronized?: boolean;\n    willReadFrequently?: boolean;\n}\n\ninterface CaretPositionFromPointOptions {\n    shadowRoots?: ShadowRoot[];\n}\n\ninterface ChannelMergerOptions extends AudioNodeOptions {\n    numberOfInputs?: number;\n}\n\ninterface ChannelSplitterOptions extends AudioNodeOptions {\n    numberOfOutputs?: number;\n}\n\ninterface CheckVisibilityOptions {\n    checkOpacity?: boolean;\n    checkVisibilityCSS?: boolean;\n    contentVisibilityAuto?: boolean;\n    opacityProperty?: boolean;\n    visibilityProperty?: boolean;\n}\n\ninterface ClientQueryOptions {\n    includeUncontrolled?: boolean;\n    type?: ClientTypes;\n}\n\ninterface ClipboardEventInit extends EventInit {\n    clipboardData?: DataTransfer | null;\n}\n\ninterface ClipboardItemOptions {\n    presentationStyle?: PresentationStyle;\n}\n\ninterface CloseEventInit extends EventInit {\n    code?: number;\n    reason?: string;\n    wasClean?: boolean;\n}\n\ninterface CompositionEventInit extends UIEventInit {\n    data?: string;\n}\n\ninterface ComputedEffectTiming extends EffectTiming {\n    activeDuration?: CSSNumberish;\n    currentIteration?: number | null;\n    endTime?: CSSNumberish;\n    localTime?: CSSNumberish | null;\n    progress?: number | null;\n    startTime?: CSSNumberish;\n}\n\ninterface ComputedKeyframe {\n    composite: CompositeOperationOrAuto;\n    computedOffset: number;\n    easing: string;\n    offset: number | null;\n    [property: string]: string | number | null | undefined;\n}\n\ninterface ConstantSourceOptions {\n    offset?: number;\n}\n\ninterface ConstrainBooleanParameters {\n    exact?: boolean;\n    ideal?: boolean;\n}\n\ninterface ConstrainDOMStringParameters {\n    exact?: string | string[];\n    ideal?: string | string[];\n}\n\ninterface ConstrainDoubleRange extends DoubleRange {\n    exact?: number;\n    ideal?: number;\n}\n\ninterface ConstrainULongRange extends ULongRange {\n    exact?: number;\n    ideal?: number;\n}\n\ninterface ContentVisibilityAutoStateChangeEventInit extends EventInit {\n    skipped?: boolean;\n}\n\ninterface ConvolverOptions extends AudioNodeOptions {\n    buffer?: AudioBuffer | null;\n    disableNormalization?: boolean;\n}\n\ninterface CookieChangeEventInit extends EventInit {\n    changed?: CookieList;\n    deleted?: CookieList;\n}\n\ninterface CookieInit {\n    domain?: string | null;\n    expires?: DOMHighResTimeStamp | null;\n    name: string;\n    partitioned?: boolean;\n    path?: string;\n    sameSite?: CookieSameSite;\n    value: string;\n}\n\ninterface CookieListItem {\n    name?: string;\n    value?: string;\n}\n\ninterface CookieStoreDeleteOptions {\n    domain?: string | null;\n    name: string;\n    partitioned?: boolean;\n    path?: string;\n}\n\ninterface CookieStoreGetOptions {\n    name?: string;\n    url?: string;\n}\n\ninterface CredentialCreationOptions {\n    publicKey?: PublicKeyCredentialCreationOptions;\n    signal?: AbortSignal;\n}\n\ninterface CredentialPropertiesOutput {\n    rk?: boolean;\n}\n\ninterface CredentialRequestOptions {\n    mediation?: CredentialMediationRequirement;\n    publicKey?: PublicKeyCredentialRequestOptions;\n    signal?: AbortSignal;\n}\n\ninterface CryptoKeyPair {\n    privateKey: CryptoKey;\n    publicKey: CryptoKey;\n}\n\ninterface CustomEventInit<T = any> extends EventInit {\n    detail?: T;\n}\n\ninterface DOMMatrix2DInit {\n    a?: number;\n    b?: number;\n    c?: number;\n    d?: number;\n    e?: number;\n    f?: number;\n    m11?: number;\n    m12?: number;\n    m21?: number;\n    m22?: number;\n    m41?: number;\n    m42?: number;\n}\n\ninterface DOMMatrixInit extends DOMMatrix2DInit {\n    is2D?: boolean;\n    m13?: number;\n    m14?: number;\n    m23?: number;\n    m24?: number;\n    m31?: number;\n    m32?: number;\n    m33?: number;\n    m34?: number;\n    m43?: number;\n    m44?: number;\n}\n\ninterface DOMPointInit {\n    w?: number;\n    x?: number;\n    y?: number;\n    z?: number;\n}\n\ninterface DOMQuadInit {\n    p1?: DOMPointInit;\n    p2?: DOMPointInit;\n    p3?: DOMPointInit;\n    p4?: DOMPointInit;\n}\n\ninterface DOMRectInit {\n    height?: number;\n    width?: number;\n    x?: number;\n    y?: number;\n}\n\ninterface DelayOptions extends AudioNodeOptions {\n    delayTime?: number;\n    maxDelayTime?: number;\n}\n\ninterface DeviceMotionEventAccelerationInit {\n    x?: number | null;\n    y?: number | null;\n    z?: number | null;\n}\n\ninterface DeviceMotionEventInit extends EventInit {\n    acceleration?: DeviceMotionEventAccelerationInit;\n    accelerationIncludingGravity?: DeviceMotionEventAccelerationInit;\n    interval?: number;\n    rotationRate?: DeviceMotionEventRotationRateInit;\n}\n\ninterface DeviceMotionEventRotationRateInit {\n    alpha?: number | null;\n    beta?: number | null;\n    gamma?: number | null;\n}\n\ninterface DeviceOrientationEventInit extends EventInit {\n    absolute?: boolean;\n    alpha?: number | null;\n    beta?: number | null;\n    gamma?: number | null;\n}\n\ninterface DisplayMediaStreamOptions {\n    audio?: boolean | MediaTrackConstraints;\n    video?: boolean | MediaTrackConstraints;\n}\n\ninterface DocumentTimelineOptions {\n    originTime?: DOMHighResTimeStamp;\n}\n\ninterface DoubleRange {\n    max?: number;\n    min?: number;\n}\n\ninterface DragEventInit extends MouseEventInit {\n    dataTransfer?: DataTransfer | null;\n}\n\ninterface DynamicsCompressorOptions extends AudioNodeOptions {\n    attack?: number;\n    knee?: number;\n    ratio?: number;\n    release?: number;\n    threshold?: number;\n}\n\ninterface EcKeyAlgorithm extends KeyAlgorithm {\n    namedCurve: NamedCurve;\n}\n\ninterface EcKeyGenParams extends Algorithm {\n    namedCurve: NamedCurve;\n}\n\ninterface EcKeyImportParams extends Algorithm {\n    namedCurve: NamedCurve;\n}\n\ninterface EcdhKeyDeriveParams extends Algorithm {\n    public: CryptoKey;\n}\n\ninterface EcdsaParams extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n}\n\ninterface EffectTiming {\n    delay?: number;\n    direction?: PlaybackDirection;\n    duration?: number | CSSNumericValue | string;\n    easing?: string;\n    endDelay?: number;\n    fill?: FillMode;\n    iterationStart?: number;\n    iterations?: number;\n    playbackRate?: number;\n}\n\ninterface ElementCreationOptions {\n    customElementRegistry?: CustomElementRegistry;\n    is?: string;\n}\n\ninterface ElementDefinitionOptions {\n    extends?: string;\n}\n\ninterface EncodedAudioChunkInit {\n    data: AllowSharedBufferSource;\n    duration?: number;\n    timestamp: number;\n    transfer?: ArrayBuffer[];\n    type: EncodedAudioChunkType;\n}\n\ninterface EncodedAudioChunkMetadata {\n    decoderConfig?: AudioDecoderConfig;\n}\n\ninterface EncodedVideoChunkInit {\n    data: AllowSharedBufferSource;\n    duration?: number;\n    timestamp: number;\n    type: EncodedVideoChunkType;\n}\n\ninterface EncodedVideoChunkMetadata {\n    decoderConfig?: VideoDecoderConfig;\n}\n\ninterface ErrorEventInit extends EventInit {\n    colno?: number;\n    error?: any;\n    filename?: string;\n    lineno?: number;\n    message?: string;\n}\n\ninterface EventInit {\n    bubbles?: boolean;\n    cancelable?: boolean;\n    composed?: boolean;\n}\n\ninterface EventListenerOptions {\n    capture?: boolean;\n}\n\ninterface EventModifierInit extends UIEventInit {\n    altKey?: boolean;\n    ctrlKey?: boolean;\n    metaKey?: boolean;\n    modifierAltGraph?: boolean;\n    modifierCapsLock?: boolean;\n    modifierFn?: boolean;\n    modifierFnLock?: boolean;\n    modifierHyper?: boolean;\n    modifierNumLock?: boolean;\n    modifierScrollLock?: boolean;\n    modifierSuper?: boolean;\n    modifierSymbol?: boolean;\n    modifierSymbolLock?: boolean;\n    shiftKey?: boolean;\n}\n\ninterface EventSourceInit {\n    withCredentials?: boolean;\n}\n\ninterface FilePropertyBag extends BlobPropertyBag {\n    lastModified?: number;\n}\n\ninterface FileSystemCreateWritableOptions {\n    keepExistingData?: boolean;\n}\n\ninterface FileSystemFlags {\n    create?: boolean;\n    exclusive?: boolean;\n}\n\ninterface FileSystemGetDirectoryOptions {\n    create?: boolean;\n}\n\ninterface FileSystemGetFileOptions {\n    create?: boolean;\n}\n\ninterface FileSystemRemoveOptions {\n    recursive?: boolean;\n}\n\ninterface FocusEventInit extends UIEventInit {\n    relatedTarget?: EventTarget | null;\n}\n\ninterface FocusOptions {\n    preventScroll?: boolean;\n}\n\ninterface FontFaceDescriptors {\n    ascentOverride?: string;\n    descentOverride?: string;\n    display?: FontDisplay;\n    featureSettings?: string;\n    lineGapOverride?: string;\n    stretch?: string;\n    style?: string;\n    unicodeRange?: string;\n    weight?: string;\n}\n\ninterface FontFaceSetLoadEventInit extends EventInit {\n    fontfaces?: FontFace[];\n}\n\ninterface FormDataEventInit extends EventInit {\n    formData: FormData;\n}\n\ninterface FullscreenOptions {\n    navigationUI?: FullscreenNavigationUI;\n}\n\ninterface GainOptions extends AudioNodeOptions {\n    gain?: number;\n}\n\ninterface GamepadEffectParameters {\n    duration?: number;\n    leftTrigger?: number;\n    rightTrigger?: number;\n    startDelay?: number;\n    strongMagnitude?: number;\n    weakMagnitude?: number;\n}\n\ninterface GamepadEventInit extends EventInit {\n    gamepad: Gamepad;\n}\n\ninterface GetAnimationsOptions {\n    subtree?: boolean;\n}\n\ninterface GetComposedRangesOptions {\n    shadowRoots?: ShadowRoot[];\n}\n\ninterface GetHTMLOptions {\n    serializableShadowRoots?: boolean;\n    shadowRoots?: ShadowRoot[];\n}\n\ninterface GetNotificationOptions {\n    tag?: string;\n}\n\ninterface GetRootNodeOptions {\n    composed?: boolean;\n}\n\ninterface HashChangeEventInit extends EventInit {\n    newURL?: string;\n    oldURL?: string;\n}\n\ninterface HkdfParams extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n    info: BufferSource;\n    salt: BufferSource;\n}\n\ninterface HmacImportParams extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n    length?: number;\n}\n\ninterface HmacKeyAlgorithm extends KeyAlgorithm {\n    hash: KeyAlgorithm;\n    length: number;\n}\n\ninterface HmacKeyGenParams extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n    length?: number;\n}\n\ninterface IDBDatabaseInfo {\n    name?: string;\n    version?: number;\n}\n\ninterface IDBIndexParameters {\n    multiEntry?: boolean;\n    unique?: boolean;\n}\n\ninterface IDBObjectStoreParameters {\n    autoIncrement?: boolean;\n    keyPath?: string | string[] | null;\n}\n\ninterface IDBTransactionOptions {\n    durability?: IDBTransactionDurability;\n}\n\ninterface IDBVersionChangeEventInit extends EventInit {\n    newVersion?: number | null;\n    oldVersion?: number;\n}\n\ninterface IIRFilterOptions extends AudioNodeOptions {\n    feedback: number[];\n    feedforward: number[];\n}\n\ninterface IdleRequestOptions {\n    timeout?: number;\n}\n\ninterface ImageBitmapOptions {\n    colorSpaceConversion?: ColorSpaceConversion;\n    imageOrientation?: ImageOrientation;\n    premultiplyAlpha?: PremultiplyAlpha;\n    resizeHeight?: number;\n    resizeQuality?: ResizeQuality;\n    resizeWidth?: number;\n}\n\ninterface ImageBitmapRenderingContextSettings {\n    alpha?: boolean;\n}\n\ninterface ImageDataSettings {\n    colorSpace?: PredefinedColorSpace;\n}\n\ninterface ImageDecodeOptions {\n    completeFramesOnly?: boolean;\n    frameIndex?: number;\n}\n\ninterface ImageDecodeResult {\n    complete: boolean;\n    image: VideoFrame;\n}\n\ninterface ImageDecoderInit {\n    colorSpaceConversion?: ColorSpaceConversion;\n    data: ImageBufferSource;\n    desiredHeight?: number;\n    desiredWidth?: number;\n    preferAnimation?: boolean;\n    transfer?: ArrayBuffer[];\n    type: string;\n}\n\ninterface ImageEncodeOptions {\n    quality?: number;\n    type?: string;\n}\n\ninterface ImportNodeOptions {\n    customElementRegistry?: CustomElementRegistry;\n    selfOnly?: boolean;\n}\n\ninterface InputEventInit extends UIEventInit {\n    data?: string | null;\n    dataTransfer?: DataTransfer | null;\n    inputType?: string;\n    isComposing?: boolean;\n    targetRanges?: StaticRange[];\n}\n\ninterface IntersectionObserverInit {\n    root?: Element | Document | null;\n    rootMargin?: string;\n    threshold?: number | number[];\n}\n\ninterface JsonWebKey {\n    alg?: string;\n    crv?: string;\n    d?: string;\n    dp?: string;\n    dq?: string;\n    e?: string;\n    ext?: boolean;\n    k?: string;\n    key_ops?: string[];\n    kty?: string;\n    n?: string;\n    oth?: RsaOtherPrimesInfo[];\n    p?: string;\n    q?: string;\n    qi?: string;\n    use?: string;\n    x?: string;\n    y?: string;\n}\n\ninterface KeyAlgorithm {\n    name: string;\n}\n\ninterface KeySystemTrackConfiguration {\n    robustness?: string;\n}\n\ninterface KeyboardEventInit extends EventModifierInit {\n    /** @deprecated */\n    charCode?: number;\n    code?: string;\n    isComposing?: boolean;\n    key?: string;\n    /** @deprecated */\n    keyCode?: number;\n    location?: number;\n    repeat?: boolean;\n}\n\ninterface Keyframe {\n    composite?: CompositeOperationOrAuto;\n    easing?: string;\n    offset?: number | null;\n    [property: string]: string | number | null | undefined;\n}\n\ninterface KeyframeAnimationOptions extends KeyframeEffectOptions {\n    id?: string;\n    timeline?: AnimationTimeline | null;\n}\n\ninterface KeyframeEffectOptions extends EffectTiming {\n    composite?: CompositeOperation;\n    iterationComposite?: IterationCompositeOperation;\n    pseudoElement?: string | null;\n}\n\ninterface LockInfo {\n    clientId?: string;\n    mode?: LockMode;\n    name?: string;\n}\n\ninterface LockManagerSnapshot {\n    held?: LockInfo[];\n    pending?: LockInfo[];\n}\n\ninterface LockOptions {\n    ifAvailable?: boolean;\n    mode?: LockMode;\n    signal?: AbortSignal;\n    steal?: boolean;\n}\n\ninterface MIDIConnectionEventInit extends EventInit {\n    port?: MIDIPort;\n}\n\ninterface MIDIMessageEventInit extends EventInit {\n    data?: Uint8Array<ArrayBuffer>;\n}\n\ninterface MIDIOptions {\n    software?: boolean;\n    sysex?: boolean;\n}\n\ninterface MediaCapabilitiesDecodingInfo extends MediaCapabilitiesInfo {\n    keySystemAccess: MediaKeySystemAccess | null;\n}\n\ninterface MediaCapabilitiesEncodingInfo extends MediaCapabilitiesInfo {\n}\n\ninterface MediaCapabilitiesInfo {\n    powerEfficient: boolean;\n    smooth: boolean;\n    supported: boolean;\n}\n\ninterface MediaCapabilitiesKeySystemConfiguration {\n    audio?: KeySystemTrackConfiguration;\n    distinctiveIdentifier?: MediaKeysRequirement;\n    initDataType?: string;\n    keySystem: string;\n    persistentState?: MediaKeysRequirement;\n    sessionTypes?: string[];\n    video?: KeySystemTrackConfiguration;\n}\n\ninterface MediaConfiguration {\n    audio?: AudioConfiguration;\n    video?: VideoConfiguration;\n}\n\ninterface MediaDecodingConfiguration extends MediaConfiguration {\n    keySystemConfiguration?: MediaCapabilitiesKeySystemConfiguration;\n    type: MediaDecodingType;\n}\n\ninterface MediaElementAudioSourceOptions {\n    mediaElement: HTMLMediaElement;\n}\n\ninterface MediaEncodingConfiguration extends MediaConfiguration {\n    type: MediaEncodingType;\n}\n\ninterface MediaEncryptedEventInit extends EventInit {\n    initData?: ArrayBuffer | null;\n    initDataType?: string;\n}\n\ninterface MediaImage {\n    sizes?: string;\n    src: string;\n    type?: string;\n}\n\ninterface MediaKeyMessageEventInit extends EventInit {\n    message: ArrayBuffer;\n    messageType: MediaKeyMessageType;\n}\n\ninterface MediaKeySystemConfiguration {\n    audioCapabilities?: MediaKeySystemMediaCapability[];\n    distinctiveIdentifier?: MediaKeysRequirement;\n    initDataTypes?: string[];\n    label?: string;\n    persistentState?: MediaKeysRequirement;\n    sessionTypes?: string[];\n    videoCapabilities?: MediaKeySystemMediaCapability[];\n}\n\ninterface MediaKeySystemMediaCapability {\n    contentType?: string;\n    encryptionScheme?: string | null;\n    robustness?: string;\n}\n\ninterface MediaKeysPolicy {\n    minHdcpVersion?: string;\n}\n\ninterface MediaMetadataInit {\n    album?: string;\n    artist?: string;\n    artwork?: MediaImage[];\n    title?: string;\n}\n\ninterface MediaPositionState {\n    duration?: number;\n    playbackRate?: number;\n    position?: number;\n}\n\ninterface MediaQueryListEventInit extends EventInit {\n    matches?: boolean;\n    media?: string;\n}\n\ninterface MediaRecorderOptions {\n    audioBitsPerSecond?: number;\n    bitsPerSecond?: number;\n    mimeType?: string;\n    videoBitsPerSecond?: number;\n}\n\ninterface MediaSessionActionDetails {\n    action: MediaSessionAction;\n    fastSeek?: boolean;\n    seekOffset?: number;\n    seekTime?: number;\n}\n\ninterface MediaSettingsRange {\n    max?: number;\n    min?: number;\n    step?: number;\n}\n\ninterface MediaStreamAudioSourceOptions {\n    mediaStream: MediaStream;\n}\n\ninterface MediaStreamConstraints {\n    audio?: boolean | MediaTrackConstraints;\n    peerIdentity?: string;\n    preferCurrentTab?: boolean;\n    video?: boolean | MediaTrackConstraints;\n}\n\ninterface MediaStreamTrackEventInit extends EventInit {\n    track: MediaStreamTrack;\n}\n\ninterface MediaTrackCapabilities {\n    aspectRatio?: DoubleRange;\n    autoGainControl?: boolean[];\n    backgroundBlur?: boolean[];\n    channelCount?: ULongRange;\n    deviceId?: string;\n    displaySurface?: string;\n    echoCancellation?: boolean[];\n    facingMode?: string[];\n    frameRate?: DoubleRange;\n    groupId?: string;\n    height?: ULongRange;\n    noiseSuppression?: boolean[];\n    sampleRate?: ULongRange;\n    sampleSize?: ULongRange;\n    width?: ULongRange;\n}\n\ninterface MediaTrackConstraintSet {\n    aspectRatio?: ConstrainDouble;\n    autoGainControl?: ConstrainBoolean;\n    backgroundBlur?: ConstrainBoolean;\n    channelCount?: ConstrainULong;\n    deviceId?: ConstrainDOMString;\n    displaySurface?: ConstrainDOMString;\n    echoCancellation?: ConstrainBoolean;\n    facingMode?: ConstrainDOMString;\n    frameRate?: ConstrainDouble;\n    groupId?: ConstrainDOMString;\n    height?: ConstrainULong;\n    noiseSuppression?: ConstrainBoolean;\n    sampleRate?: ConstrainULong;\n    sampleSize?: ConstrainULong;\n    width?: ConstrainULong;\n}\n\ninterface MediaTrackConstraints extends MediaTrackConstraintSet {\n    advanced?: MediaTrackConstraintSet[];\n}\n\ninterface MediaTrackSettings {\n    aspectRatio?: number;\n    autoGainControl?: boolean;\n    backgroundBlur?: boolean;\n    channelCount?: number;\n    deviceId?: string;\n    displaySurface?: string;\n    echoCancellation?: boolean;\n    facingMode?: string;\n    frameRate?: number;\n    groupId?: string;\n    height?: number;\n    noiseSuppression?: boolean;\n    sampleRate?: number;\n    sampleSize?: number;\n    torch?: boolean;\n    whiteBalanceMode?: string;\n    width?: number;\n    zoom?: number;\n}\n\ninterface MediaTrackSupportedConstraints {\n    aspectRatio?: boolean;\n    autoGainControl?: boolean;\n    backgroundBlur?: boolean;\n    channelCount?: boolean;\n    deviceId?: boolean;\n    displaySurface?: boolean;\n    echoCancellation?: boolean;\n    facingMode?: boolean;\n    frameRate?: boolean;\n    groupId?: boolean;\n    height?: boolean;\n    noiseSuppression?: boolean;\n    sampleRate?: boolean;\n    sampleSize?: boolean;\n    width?: boolean;\n}\n\ninterface MessageEventInit<T = any> extends EventInit {\n    data?: T;\n    lastEventId?: string;\n    origin?: string;\n    ports?: MessagePort[];\n    source?: MessageEventSource | null;\n}\n\ninterface MouseEventInit extends EventModifierInit {\n    button?: number;\n    buttons?: number;\n    clientX?: number;\n    clientY?: number;\n    movementX?: number;\n    movementY?: number;\n    relatedTarget?: EventTarget | null;\n    screenX?: number;\n    screenY?: number;\n}\n\ninterface MultiCacheQueryOptions extends CacheQueryOptions {\n    cacheName?: string;\n}\n\ninterface MutationObserverInit {\n    /** Set to a list of attribute local names (without namespace) if not all attribute mutations need to be observed and attributes is true or omitted. */\n    attributeFilter?: string[];\n    /** Set to true if attributes is true or omitted and target's attribute value before the mutation needs to be recorded. */\n    attributeOldValue?: boolean;\n    /** Set to true if mutations to target's attributes are to be observed. Can be omitted if attributeOldValue or attributeFilter is specified. */\n    attributes?: boolean;\n    /** Set to true if mutations to target's data are to be observed. Can be omitted if characterDataOldValue is specified. */\n    characterData?: boolean;\n    /** Set to true if characterData is set to true or omitted and target's data before the mutation needs to be recorded. */\n    characterDataOldValue?: boolean;\n    /** Set to true if mutations to target's children are to be observed. */\n    childList?: boolean;\n    /** Set to true if mutations to not just target, but also target's descendants are to be observed. */\n    subtree?: boolean;\n}\n\ninterface NavigationPreloadState {\n    enabled?: boolean;\n    headerValue?: string;\n}\n\ninterface NotificationOptions {\n    badge?: string;\n    body?: string;\n    data?: any;\n    dir?: NotificationDirection;\n    icon?: string;\n    lang?: string;\n    requireInteraction?: boolean;\n    silent?: boolean | null;\n    tag?: string;\n}\n\ninterface OfflineAudioCompletionEventInit extends EventInit {\n    renderedBuffer: AudioBuffer;\n}\n\ninterface OfflineAudioContextOptions {\n    length: number;\n    numberOfChannels?: number;\n    sampleRate: number;\n}\n\ninterface OptionalEffectTiming {\n    delay?: number;\n    direction?: PlaybackDirection;\n    duration?: number | string;\n    easing?: string;\n    endDelay?: number;\n    fill?: FillMode;\n    iterationStart?: number;\n    iterations?: number;\n    playbackRate?: number;\n}\n\ninterface OpusEncoderConfig {\n    complexity?: number;\n    format?: OpusBitstreamFormat;\n    frameDuration?: number;\n    packetlossperc?: number;\n    usedtx?: boolean;\n    useinbandfec?: boolean;\n}\n\ninterface OscillatorOptions extends AudioNodeOptions {\n    detune?: number;\n    frequency?: number;\n    periodicWave?: PeriodicWave;\n    type?: OscillatorType;\n}\n\ninterface PageRevealEventInit extends EventInit {\n    viewTransition?: ViewTransition | null;\n}\n\ninterface PageSwapEventInit extends EventInit {\n    activation?: NavigationActivation | null;\n    viewTransition?: ViewTransition | null;\n}\n\ninterface PageTransitionEventInit extends EventInit {\n    persisted?: boolean;\n}\n\ninterface PannerOptions extends AudioNodeOptions {\n    coneInnerAngle?: number;\n    coneOuterAngle?: number;\n    coneOuterGain?: number;\n    distanceModel?: DistanceModelType;\n    maxDistance?: number;\n    orientationX?: number;\n    orientationY?: number;\n    orientationZ?: number;\n    panningModel?: PanningModelType;\n    positionX?: number;\n    positionY?: number;\n    positionZ?: number;\n    refDistance?: number;\n    rolloffFactor?: number;\n}\n\ninterface PayerErrors {\n    email?: string;\n    name?: string;\n    phone?: string;\n}\n\ninterface PaymentCurrencyAmount {\n    currency: string;\n    value: string;\n}\n\ninterface PaymentDetailsBase {\n    displayItems?: PaymentItem[];\n    modifiers?: PaymentDetailsModifier[];\n    shippingOptions?: PaymentShippingOption[];\n}\n\ninterface PaymentDetailsInit extends PaymentDetailsBase {\n    id?: string;\n    total: PaymentItem;\n}\n\ninterface PaymentDetailsModifier {\n    additionalDisplayItems?: PaymentItem[];\n    data?: any;\n    supportedMethods: string;\n    total?: PaymentItem;\n}\n\ninterface PaymentDetailsUpdate extends PaymentDetailsBase {\n    error?: string;\n    paymentMethodErrors?: any;\n    shippingAddressErrors?: AddressErrors;\n    total?: PaymentItem;\n}\n\ninterface PaymentItem {\n    amount: PaymentCurrencyAmount;\n    label: string;\n    pending?: boolean;\n}\n\ninterface PaymentMethodChangeEventInit extends PaymentRequestUpdateEventInit {\n    methodDetails?: any;\n    methodName?: string;\n}\n\ninterface PaymentMethodData {\n    data?: any;\n    supportedMethods: string;\n}\n\ninterface PaymentOptions {\n    requestPayerEmail?: boolean;\n    requestPayerName?: boolean;\n    requestPayerPhone?: boolean;\n    requestShipping?: boolean;\n    shippingType?: PaymentShippingType;\n}\n\ninterface PaymentRequestUpdateEventInit extends EventInit {\n}\n\ninterface PaymentShippingOption {\n    amount: PaymentCurrencyAmount;\n    id: string;\n    label: string;\n    selected?: boolean;\n}\n\ninterface PaymentValidationErrors {\n    error?: string;\n    payer?: PayerErrors;\n    shippingAddress?: AddressErrors;\n}\n\ninterface Pbkdf2Params extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n    iterations: number;\n    salt: BufferSource;\n}\n\ninterface PerformanceMarkOptions {\n    detail?: any;\n    startTime?: DOMHighResTimeStamp;\n}\n\ninterface PerformanceMeasureOptions {\n    detail?: any;\n    duration?: DOMHighResTimeStamp;\n    end?: string | DOMHighResTimeStamp;\n    start?: string | DOMHighResTimeStamp;\n}\n\ninterface PerformanceObserverInit {\n    buffered?: boolean;\n    entryTypes?: string[];\n    type?: string;\n}\n\ninterface PeriodicWaveConstraints {\n    disableNormalization?: boolean;\n}\n\ninterface PeriodicWaveOptions extends PeriodicWaveConstraints {\n    imag?: number[] | Float32Array;\n    real?: number[] | Float32Array;\n}\n\ninterface PermissionDescriptor {\n    name: PermissionName;\n}\n\ninterface PhotoCapabilities {\n    fillLightMode?: FillLightMode[];\n    imageHeight?: MediaSettingsRange;\n    imageWidth?: MediaSettingsRange;\n    redEyeReduction?: RedEyeReduction;\n}\n\ninterface PhotoSettings {\n    fillLightMode?: FillLightMode;\n    imageHeight?: number;\n    imageWidth?: number;\n    redEyeReduction?: boolean;\n}\n\ninterface PictureInPictureEventInit extends EventInit {\n    pictureInPictureWindow: PictureInPictureWindow;\n}\n\ninterface PlaneLayout {\n    offset: number;\n    stride: number;\n}\n\ninterface PointerEventInit extends MouseEventInit {\n    altitudeAngle?: number;\n    azimuthAngle?: number;\n    coalescedEvents?: PointerEvent[];\n    height?: number;\n    isPrimary?: boolean;\n    pointerId?: number;\n    pointerType?: string;\n    predictedEvents?: PointerEvent[];\n    pressure?: number;\n    tangentialPressure?: number;\n    tiltX?: number;\n    tiltY?: number;\n    twist?: number;\n    width?: number;\n}\n\ninterface PointerLockOptions {\n    unadjustedMovement?: boolean;\n}\n\ninterface PopStateEventInit extends EventInit {\n    state?: any;\n}\n\ninterface PositionOptions {\n    enableHighAccuracy?: boolean;\n    maximumAge?: number;\n    timeout?: number;\n}\n\ninterface ProgressEventInit extends EventInit {\n    lengthComputable?: boolean;\n    loaded?: number;\n    total?: number;\n}\n\ninterface PromiseRejectionEventInit extends EventInit {\n    promise: Promise<any>;\n    reason?: any;\n}\n\ninterface PropertyDefinition {\n    inherits: boolean;\n    initialValue?: string;\n    name: string;\n    syntax?: string;\n}\n\ninterface PropertyIndexedKeyframes {\n    composite?: CompositeOperationOrAuto | CompositeOperationOrAuto[];\n    easing?: string | string[];\n    offset?: number | (number | null)[];\n    [property: string]: string | string[] | number | null | (number | null)[] | undefined;\n}\n\ninterface PublicKeyCredentialCreationOptions {\n    attestation?: AttestationConveyancePreference;\n    authenticatorSelection?: AuthenticatorSelectionCriteria;\n    challenge: BufferSource;\n    excludeCredentials?: PublicKeyCredentialDescriptor[];\n    extensions?: AuthenticationExtensionsClientInputs;\n    pubKeyCredParams: PublicKeyCredentialParameters[];\n    rp: PublicKeyCredentialRpEntity;\n    timeout?: number;\n    user: PublicKeyCredentialUserEntity;\n}\n\ninterface PublicKeyCredentialCreationOptionsJSON {\n    attestation?: string;\n    authenticatorSelection?: AuthenticatorSelectionCriteria;\n    challenge: Base64URLString;\n    excludeCredentials?: PublicKeyCredentialDescriptorJSON[];\n    extensions?: AuthenticationExtensionsClientInputsJSON;\n    hints?: string[];\n    pubKeyCredParams: PublicKeyCredentialParameters[];\n    rp: PublicKeyCredentialRpEntity;\n    timeout?: number;\n    user: PublicKeyCredentialUserEntityJSON;\n}\n\ninterface PublicKeyCredentialDescriptor {\n    id: BufferSource;\n    transports?: AuthenticatorTransport[];\n    type: PublicKeyCredentialType;\n}\n\ninterface PublicKeyCredentialDescriptorJSON {\n    id: Base64URLString;\n    transports?: string[];\n    type: string;\n}\n\ninterface PublicKeyCredentialEntity {\n    name: string;\n}\n\ninterface PublicKeyCredentialParameters {\n    alg: COSEAlgorithmIdentifier;\n    type: PublicKeyCredentialType;\n}\n\ninterface PublicKeyCredentialRequestOptions {\n    allowCredentials?: PublicKeyCredentialDescriptor[];\n    challenge: BufferSource;\n    extensions?: AuthenticationExtensionsClientInputs;\n    rpId?: string;\n    timeout?: number;\n    userVerification?: UserVerificationRequirement;\n}\n\ninterface PublicKeyCredentialRequestOptionsJSON {\n    allowCredentials?: PublicKeyCredentialDescriptorJSON[];\n    challenge: Base64URLString;\n    extensions?: AuthenticationExtensionsClientInputsJSON;\n    hints?: string[];\n    rpId?: string;\n    timeout?: number;\n    userVerification?: string;\n}\n\ninterface PublicKeyCredentialRpEntity extends PublicKeyCredentialEntity {\n    id?: string;\n}\n\ninterface PublicKeyCredentialUserEntity extends PublicKeyCredentialEntity {\n    displayName: string;\n    id: BufferSource;\n}\n\ninterface PublicKeyCredentialUserEntityJSON {\n    displayName: string;\n    id: Base64URLString;\n    name: string;\n}\n\ninterface PushSubscriptionJSON {\n    endpoint?: string;\n    expirationTime?: EpochTimeStamp | null;\n    keys?: Record<string, string>;\n}\n\ninterface PushSubscriptionOptionsInit {\n    applicationServerKey?: BufferSource | string | null;\n    userVisibleOnly?: boolean;\n}\n\ninterface QueuingStrategy<T = any> {\n    highWaterMark?: number;\n    size?: QueuingStrategySize<T>;\n}\n\ninterface QueuingStrategyInit {\n    /**\n     * Creates a new ByteLengthQueuingStrategy with the provided high water mark.\n     *\n     * Note that the provided high water mark will not be validated ahead of time. Instead, if it is negative, NaN, or not a number, the resulting ByteLengthQueuingStrategy will cause the corresponding stream constructor to throw.\n     */\n    highWaterMark: number;\n}\n\ninterface RTCAnswerOptions extends RTCOfferAnswerOptions {\n}\n\ninterface RTCCertificateExpiration {\n    expires?: number;\n}\n\ninterface RTCConfiguration {\n    bundlePolicy?: RTCBundlePolicy;\n    certificates?: RTCCertificate[];\n    iceCandidatePoolSize?: number;\n    iceServers?: RTCIceServer[];\n    iceTransportPolicy?: RTCIceTransportPolicy;\n    rtcpMuxPolicy?: RTCRtcpMuxPolicy;\n}\n\ninterface RTCDTMFToneChangeEventInit extends EventInit {\n    tone?: string;\n}\n\ninterface RTCDataChannelEventInit extends EventInit {\n    channel: RTCDataChannel;\n}\n\ninterface RTCDataChannelInit {\n    id?: number;\n    maxPacketLifeTime?: number;\n    maxRetransmits?: number;\n    negotiated?: boolean;\n    ordered?: boolean;\n    protocol?: string;\n}\n\ninterface RTCDtlsFingerprint {\n    algorithm?: string;\n    value?: string;\n}\n\ninterface RTCEncodedAudioFrameMetadata extends RTCEncodedFrameMetadata {\n    sequenceNumber?: number;\n}\n\ninterface RTCEncodedFrameMetadata {\n    contributingSources?: number[];\n    mimeType?: string;\n    payloadType?: number;\n    rtpTimestamp?: number;\n    synchronizationSource?: number;\n}\n\ninterface RTCEncodedVideoFrameMetadata extends RTCEncodedFrameMetadata {\n    dependencies?: number[];\n    frameId?: number;\n    height?: number;\n    spatialIndex?: number;\n    temporalIndex?: number;\n    timestamp?: number;\n    width?: number;\n}\n\ninterface RTCErrorEventInit extends EventInit {\n    error: RTCError;\n}\n\ninterface RTCErrorInit {\n    errorDetail: RTCErrorDetailType;\n    httpRequestStatusCode?: number;\n    receivedAlert?: number;\n    sctpCauseCode?: number;\n    sdpLineNumber?: number;\n    sentAlert?: number;\n}\n\ninterface RTCIceCandidateInit {\n    candidate?: string;\n    sdpMLineIndex?: number | null;\n    sdpMid?: string | null;\n    usernameFragment?: string | null;\n}\n\ninterface RTCIceCandidatePairStats extends RTCStats {\n    availableIncomingBitrate?: number;\n    availableOutgoingBitrate?: number;\n    bytesDiscardedOnSend?: number;\n    bytesReceived?: number;\n    bytesSent?: number;\n    consentRequestsSent?: number;\n    currentRoundTripTime?: number;\n    lastPacketReceivedTimestamp?: DOMHighResTimeStamp;\n    lastPacketSentTimestamp?: DOMHighResTimeStamp;\n    localCandidateId: string;\n    nominated?: boolean;\n    packetsDiscardedOnSend?: number;\n    packetsReceived?: number;\n    packetsSent?: number;\n    remoteCandidateId: string;\n    requestsReceived?: number;\n    requestsSent?: number;\n    responsesReceived?: number;\n    responsesSent?: number;\n    state: RTCStatsIceCandidatePairState;\n    totalRoundTripTime?: number;\n    transportId: string;\n}\n\ninterface RTCIceServer {\n    credential?: string;\n    urls: string | string[];\n    username?: string;\n}\n\ninterface RTCInboundRtpStreamStats extends RTCReceivedRtpStreamStats {\n    audioLevel?: number;\n    bytesReceived?: number;\n    concealedSamples?: number;\n    concealmentEvents?: number;\n    decoderImplementation?: string;\n    estimatedPlayoutTimestamp?: DOMHighResTimeStamp;\n    fecBytesReceived?: number;\n    fecPacketsDiscarded?: number;\n    fecPacketsReceived?: number;\n    fecSsrc?: number;\n    firCount?: number;\n    frameHeight?: number;\n    frameWidth?: number;\n    framesAssembledFromMultiplePackets?: number;\n    framesDecoded?: number;\n    framesDropped?: number;\n    framesPerSecond?: number;\n    framesReceived?: number;\n    framesRendered?: number;\n    freezeCount?: number;\n    headerBytesReceived?: number;\n    insertedSamplesForDeceleration?: number;\n    jitterBufferDelay?: number;\n    jitterBufferEmittedCount?: number;\n    jitterBufferMinimumDelay?: number;\n    jitterBufferTargetDelay?: number;\n    keyFramesDecoded?: number;\n    lastPacketReceivedTimestamp?: DOMHighResTimeStamp;\n    mid?: string;\n    nackCount?: number;\n    packetsDiscarded?: number;\n    pauseCount?: number;\n    playoutId?: string;\n    pliCount?: number;\n    qpSum?: number;\n    remoteId?: string;\n    removedSamplesForAcceleration?: number;\n    retransmittedBytesReceived?: number;\n    retransmittedPacketsReceived?: number;\n    rtxSsrc?: number;\n    silentConcealedSamples?: number;\n    totalAssemblyTime?: number;\n    totalAudioEnergy?: number;\n    totalDecodeTime?: number;\n    totalFreezesDuration?: number;\n    totalInterFrameDelay?: number;\n    totalPausesDuration?: number;\n    totalProcessingDelay?: number;\n    totalSamplesDuration?: number;\n    totalSamplesReceived?: number;\n    totalSquaredInterFrameDelay?: number;\n    trackIdentifier: string;\n}\n\ninterface RTCLocalIceCandidateInit extends RTCIceCandidateInit {\n}\n\ninterface RTCLocalSessionDescriptionInit {\n    sdp?: string;\n    type?: RTCSdpType;\n}\n\ninterface RTCOfferAnswerOptions {\n}\n\ninterface RTCOfferOptions extends RTCOfferAnswerOptions {\n    iceRestart?: boolean;\n    offerToReceiveAudio?: boolean;\n    offerToReceiveVideo?: boolean;\n}\n\ninterface RTCOutboundRtpStreamStats extends RTCSentRtpStreamStats {\n    active?: boolean;\n    firCount?: number;\n    frameHeight?: number;\n    frameWidth?: number;\n    framesEncoded?: number;\n    framesPerSecond?: number;\n    framesSent?: number;\n    headerBytesSent?: number;\n    hugeFramesSent?: number;\n    keyFramesEncoded?: number;\n    mediaSourceId?: string;\n    mid?: string;\n    nackCount?: number;\n    pliCount?: number;\n    qpSum?: number;\n    qualityLimitationDurations?: Record<string, number>;\n    qualityLimitationReason?: RTCQualityLimitationReason;\n    qualityLimitationResolutionChanges?: number;\n    remoteId?: string;\n    retransmittedBytesSent?: number;\n    retransmittedPacketsSent?: number;\n    rid?: string;\n    rtxSsrc?: number;\n    scalabilityMode?: string;\n    targetBitrate?: number;\n    totalEncodeTime?: number;\n    totalEncodedBytesTarget?: number;\n    totalPacketSendDelay?: number;\n}\n\ninterface RTCPeerConnectionIceErrorEventInit extends EventInit {\n    address?: string | null;\n    errorCode: number;\n    errorText?: string;\n    port?: number | null;\n    url?: string;\n}\n\ninterface RTCPeerConnectionIceEventInit extends EventInit {\n    candidate?: RTCIceCandidate | null;\n}\n\ninterface RTCReceivedRtpStreamStats extends RTCRtpStreamStats {\n    jitter?: number;\n    packetsLost?: number;\n    packetsReceived?: number;\n}\n\ninterface RTCRtcpParameters {\n    cname?: string;\n    reducedSize?: boolean;\n}\n\ninterface RTCRtpCapabilities {\n    codecs: RTCRtpCodec[];\n    headerExtensions: RTCRtpHeaderExtensionCapability[];\n}\n\ninterface RTCRtpCodec {\n    channels?: number;\n    clockRate: number;\n    mimeType: string;\n    sdpFmtpLine?: string;\n}\n\ninterface RTCRtpCodecParameters extends RTCRtpCodec {\n    payloadType: number;\n}\n\ninterface RTCRtpCodingParameters {\n    rid?: string;\n}\n\ninterface RTCRtpContributingSource {\n    audioLevel?: number;\n    rtpTimestamp: number;\n    source: number;\n    timestamp: DOMHighResTimeStamp;\n}\n\ninterface RTCRtpEncodingParameters extends RTCRtpCodingParameters {\n    active?: boolean;\n    maxBitrate?: number;\n    maxFramerate?: number;\n    networkPriority?: RTCPriorityType;\n    priority?: RTCPriorityType;\n    scaleResolutionDownBy?: number;\n}\n\ninterface RTCRtpHeaderExtensionCapability {\n    uri: string;\n}\n\ninterface RTCRtpHeaderExtensionParameters {\n    encrypted?: boolean;\n    id: number;\n    uri: string;\n}\n\ninterface RTCRtpParameters {\n    codecs: RTCRtpCodecParameters[];\n    headerExtensions: RTCRtpHeaderExtensionParameters[];\n    rtcp: RTCRtcpParameters;\n}\n\ninterface RTCRtpReceiveParameters extends RTCRtpParameters {\n}\n\ninterface RTCRtpSendParameters extends RTCRtpParameters {\n    degradationPreference?: RTCDegradationPreference;\n    encodings: RTCRtpEncodingParameters[];\n    transactionId: string;\n}\n\ninterface RTCRtpStreamStats extends RTCStats {\n    codecId?: string;\n    kind: string;\n    ssrc: number;\n    transportId?: string;\n}\n\ninterface RTCRtpSynchronizationSource extends RTCRtpContributingSource {\n}\n\ninterface RTCRtpTransceiverInit {\n    direction?: RTCRtpTransceiverDirection;\n    sendEncodings?: RTCRtpEncodingParameters[];\n    streams?: MediaStream[];\n}\n\ninterface RTCSentRtpStreamStats extends RTCRtpStreamStats {\n    bytesSent?: number;\n    packetsSent?: number;\n}\n\ninterface RTCSessionDescriptionInit {\n    sdp?: string;\n    type: RTCSdpType;\n}\n\ninterface RTCSetParameterOptions {\n}\n\ninterface RTCStats {\n    id: string;\n    timestamp: DOMHighResTimeStamp;\n    type: RTCStatsType;\n}\n\ninterface RTCTrackEventInit extends EventInit {\n    receiver: RTCRtpReceiver;\n    streams?: MediaStream[];\n    track: MediaStreamTrack;\n    transceiver: RTCRtpTransceiver;\n}\n\ninterface RTCTransportStats extends RTCStats {\n    bytesReceived?: number;\n    bytesSent?: number;\n    dtlsCipher?: string;\n    dtlsRole?: RTCDtlsRole;\n    dtlsState: RTCDtlsTransportState;\n    iceLocalUsernameFragment?: string;\n    iceRole?: RTCIceRole;\n    iceState?: RTCIceTransportState;\n    localCertificateId?: string;\n    packetsReceived?: number;\n    packetsSent?: number;\n    remoteCertificateId?: string;\n    selectedCandidatePairChanges?: number;\n    selectedCandidatePairId?: string;\n    srtpCipher?: string;\n    tlsVersion?: string;\n}\n\ninterface ReadableStreamGetReaderOptions {\n    /**\n     * Creates a ReadableStreamBYOBReader and locks the stream to the new reader.\n     *\n     * This call behaves the same way as the no-argument variant, except that it only works on readable byte streams, i.e. streams which were constructed specifically with the ability to handle \"bring your own buffer\" reading. The returned BYOB reader provides the ability to directly read individual chunks from the stream via its read() method, into developer-supplied buffers, allowing more precise control over allocation.\n     */\n    mode?: ReadableStreamReaderMode;\n}\n\ninterface ReadableStreamIteratorOptions {\n    /**\n     * Asynchronously iterates over the chunks in the stream's internal queue.\n     *\n     * Asynchronously iterating over the stream will lock it, preventing any other consumer from acquiring a reader. The lock will be released if the async iterator's return() method is called, e.g. by breaking out of the loop.\n     *\n     * By default, calling the async iterator's return() method will also cancel the stream. To prevent this, use the stream's values() method, passing true for the preventCancel option.\n     */\n    preventCancel?: boolean;\n}\n\ninterface ReadableStreamReadDoneResult<T> {\n    done: true;\n    value: T | undefined;\n}\n\ninterface ReadableStreamReadValueResult<T> {\n    done: false;\n    value: T;\n}\n\ninterface ReadableWritablePair<R = any, W = any> {\n    readable: ReadableStream<R>;\n    /**\n     * Provides a convenient, chainable way of piping this readable stream through a transform stream (or any other { writable, readable } pair). It simply pipes the stream into the writable side of the supplied pair, and returns the readable side for further use.\n     *\n     * Piping a stream will lock it for the duration of the pipe, preventing any other consumer from acquiring a reader.\n     */\n    writable: WritableStream<W>;\n}\n\ninterface RegistrationOptions {\n    scope?: string;\n    type?: WorkerType;\n    updateViaCache?: ServiceWorkerUpdateViaCache;\n}\n\ninterface ReportingObserverOptions {\n    buffered?: boolean;\n    types?: string[];\n}\n\ninterface RequestInit {\n    /** A BodyInit object or null to set request's body. */\n    body?: BodyInit | null;\n    /** A string indicating how the request will interact with the browser's cache to set request's cache. */\n    cache?: RequestCache;\n    /** A string indicating whether credentials will be sent with the request always, never, or only when sent to a same-origin URL. Sets request's credentials. */\n    credentials?: RequestCredentials;\n    /** A Headers object, an object literal, or an array of two-item arrays to set request's headers. */\n    headers?: HeadersInit;\n    /** A cryptographic hash of the resource to be fetched by request. Sets request's integrity. */\n    integrity?: string;\n    /** A boolean to set request's keepalive. */\n    keepalive?: boolean;\n    /** A string to set request's method. */\n    method?: string;\n    /** A string to indicate whether the request will use CORS, or will be restricted to same-origin URLs. Sets request's mode. */\n    mode?: RequestMode;\n    priority?: RequestPriority;\n    /** A string indicating whether request follows redirects, results in an error upon encountering a redirect, or returns the redirect (in an opaque fashion). Sets request's redirect. */\n    redirect?: RequestRedirect;\n    /** A string whose value is a same-origin URL, \"about:client\", or the empty string, to set request's referrer. */\n    referrer?: string;\n    /** A referrer policy to set request's referrerPolicy. */\n    referrerPolicy?: ReferrerPolicy;\n    /** An AbortSignal to set request's signal. */\n    signal?: AbortSignal | null;\n    /** Can only be null. Used to disassociate request from any Window. */\n    window?: null;\n}\n\ninterface ResizeObserverOptions {\n    box?: ResizeObserverBoxOptions;\n}\n\ninterface ResponseInit {\n    headers?: HeadersInit;\n    status?: number;\n    statusText?: string;\n}\n\ninterface RsaHashedImportParams extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n}\n\ninterface RsaHashedKeyAlgorithm extends RsaKeyAlgorithm {\n    hash: KeyAlgorithm;\n}\n\ninterface RsaHashedKeyGenParams extends RsaKeyGenParams {\n    hash: HashAlgorithmIdentifier;\n}\n\ninterface RsaKeyAlgorithm extends KeyAlgorithm {\n    modulusLength: number;\n    publicExponent: BigInteger;\n}\n\ninterface RsaKeyGenParams extends Algorithm {\n    modulusLength: number;\n    publicExponent: BigInteger;\n}\n\ninterface RsaOaepParams extends Algorithm {\n    label?: BufferSource;\n}\n\ninterface RsaOtherPrimesInfo {\n    d?: string;\n    r?: string;\n    t?: string;\n}\n\ninterface RsaPssParams extends Algorithm {\n    saltLength: number;\n}\n\ninterface SVGBoundingBoxOptions {\n    clipped?: boolean;\n    fill?: boolean;\n    markers?: boolean;\n    stroke?: boolean;\n}\n\ninterface ScrollIntoViewOptions extends ScrollOptions {\n    block?: ScrollLogicalPosition;\n    inline?: ScrollLogicalPosition;\n}\n\ninterface ScrollOptions {\n    behavior?: ScrollBehavior;\n}\n\ninterface ScrollToOptions extends ScrollOptions {\n    left?: number;\n    top?: number;\n}\n\ninterface SecurityPolicyViolationEventInit extends EventInit {\n    blockedURI?: string;\n    columnNumber?: number;\n    disposition?: SecurityPolicyViolationEventDisposition;\n    documentURI?: string;\n    effectiveDirective?: string;\n    lineNumber?: number;\n    originalPolicy?: string;\n    referrer?: string;\n    sample?: string;\n    sourceFile?: string;\n    statusCode?: number;\n    violatedDirective?: string;\n}\n\ninterface ShadowRootInit {\n    clonable?: boolean;\n    customElementRegistry?: CustomElementRegistry;\n    delegatesFocus?: boolean;\n    mode: ShadowRootMode;\n    serializable?: boolean;\n    slotAssignment?: SlotAssignmentMode;\n}\n\ninterface ShareData {\n    files?: File[];\n    text?: string;\n    title?: string;\n    url?: string;\n}\n\ninterface SpeechSynthesisErrorEventInit extends SpeechSynthesisEventInit {\n    error: SpeechSynthesisErrorCode;\n}\n\ninterface SpeechSynthesisEventInit extends EventInit {\n    charIndex?: number;\n    charLength?: number;\n    elapsedTime?: number;\n    name?: string;\n    utterance: SpeechSynthesisUtterance;\n}\n\ninterface StartViewTransitionOptions {\n    types?: string[] | null;\n    update?: ViewTransitionUpdateCallback | null;\n}\n\ninterface StaticRangeInit {\n    endContainer: Node;\n    endOffset: number;\n    startContainer: Node;\n    startOffset: number;\n}\n\ninterface StereoPannerOptions extends AudioNodeOptions {\n    pan?: number;\n}\n\ninterface StorageEstimate {\n    quota?: number;\n    usage?: number;\n}\n\ninterface StorageEventInit extends EventInit {\n    key?: string | null;\n    newValue?: string | null;\n    oldValue?: string | null;\n    storageArea?: Storage | null;\n    url?: string;\n}\n\ninterface StreamPipeOptions {\n    preventAbort?: boolean;\n    preventCancel?: boolean;\n    /**\n     * Pipes this readable stream to a given writable stream destination. The way in which the piping process behaves under various error conditions can be customized with a number of passed options. It returns a promise that fulfills when the piping process completes successfully, or rejects if any errors were encountered.\n     *\n     * Piping a stream will lock it for the duration of the pipe, preventing any other consumer from acquiring a reader.\n     *\n     * Errors and closures of the source and destination streams propagate as follows:\n     *\n     * An error in this source readable stream will abort destination, unless preventAbort is truthy. The returned promise will be rejected with the source's error, or with any error that occurs during aborting the destination.\n     *\n     * An error in destination will cancel this source readable stream, unless preventCancel is truthy. The returned promise will be rejected with the destination's error, or with any error that occurs during canceling the source.\n     *\n     * When this source readable stream closes, destination will be closed, unless preventClose is truthy. The returned promise will be fulfilled once this process completes, unless an error is encountered while closing the destination, in which case it will be rejected with that error.\n     *\n     * If destination starts out closed or closing, this source readable stream will be canceled, unless preventCancel is true. The returned promise will be rejected with an error indicating piping to a closed stream failed, or with any error that occurs during canceling the source.\n     *\n     * The signal option can be set to an AbortSignal to allow aborting an ongoing pipe operation via the corresponding AbortController. In this case, this source readable stream will be canceled, and destination aborted, unless the respective options preventCancel or preventAbort are set.\n     */\n    preventClose?: boolean;\n    signal?: AbortSignal;\n}\n\ninterface StructuredSerializeOptions {\n    transfer?: Transferable[];\n}\n\ninterface SubmitEventInit extends EventInit {\n    submitter?: HTMLElement | null;\n}\n\ninterface TextDecodeOptions {\n    stream?: boolean;\n}\n\ninterface TextDecoderOptions {\n    fatal?: boolean;\n    ignoreBOM?: boolean;\n}\n\ninterface TextEncoderEncodeIntoResult {\n    read: number;\n    written: number;\n}\n\ninterface ToggleEventInit extends EventInit {\n    newState?: string;\n    oldState?: string;\n}\n\ninterface TouchEventInit extends EventModifierInit {\n    changedTouches?: Touch[];\n    targetTouches?: Touch[];\n    touches?: Touch[];\n}\n\ninterface TouchInit {\n    altitudeAngle?: number;\n    azimuthAngle?: number;\n    clientX?: number;\n    clientY?: number;\n    force?: number;\n    identifier: number;\n    pageX?: number;\n    pageY?: number;\n    radiusX?: number;\n    radiusY?: number;\n    rotationAngle?: number;\n    screenX?: number;\n    screenY?: number;\n    target: EventTarget;\n    touchType?: TouchType;\n}\n\ninterface TrackEventInit extends EventInit {\n    track?: TextTrack | null;\n}\n\ninterface Transformer<I = any, O = any> {\n    flush?: TransformerFlushCallback<O>;\n    readableType?: undefined;\n    start?: TransformerStartCallback<O>;\n    transform?: TransformerTransformCallback<I, O>;\n    writableType?: undefined;\n}\n\ninterface TransitionEventInit extends EventInit {\n    elapsedTime?: number;\n    propertyName?: string;\n    pseudoElement?: string;\n}\n\ninterface UIEventInit extends EventInit {\n    detail?: number;\n    view?: Window | null;\n    /** @deprecated */\n    which?: number;\n}\n\ninterface ULongRange {\n    max?: number;\n    min?: number;\n}\n\ninterface UnderlyingByteSource {\n    autoAllocateChunkSize?: number;\n    cancel?: UnderlyingSourceCancelCallback;\n    pull?: (controller: ReadableByteStreamController) => void | PromiseLike<void>;\n    start?: (controller: ReadableByteStreamController) => any;\n    type: \"bytes\";\n}\n\ninterface UnderlyingDefaultSource<R = any> {\n    cancel?: UnderlyingSourceCancelCallback;\n    pull?: (controller: ReadableStreamDefaultController<R>) => void | PromiseLike<void>;\n    start?: (controller: ReadableStreamDefaultController<R>) => any;\n    type?: undefined;\n}\n\ninterface UnderlyingSink<W = any> {\n    abort?: UnderlyingSinkAbortCallback;\n    close?: UnderlyingSinkCloseCallback;\n    start?: UnderlyingSinkStartCallback;\n    type?: undefined;\n    write?: UnderlyingSinkWriteCallback<W>;\n}\n\ninterface UnderlyingSource<R = any> {\n    autoAllocateChunkSize?: number;\n    cancel?: UnderlyingSourceCancelCallback;\n    pull?: UnderlyingSourcePullCallback<R>;\n    start?: UnderlyingSourceStartCallback<R>;\n    type?: ReadableStreamType;\n}\n\ninterface ValidityStateFlags {\n    badInput?: boolean;\n    customError?: boolean;\n    patternMismatch?: boolean;\n    rangeOverflow?: boolean;\n    rangeUnderflow?: boolean;\n    stepMismatch?: boolean;\n    tooLong?: boolean;\n    tooShort?: boolean;\n    typeMismatch?: boolean;\n    valueMissing?: boolean;\n}\n\ninterface VideoColorSpaceInit {\n    fullRange?: boolean | null;\n    matrix?: VideoMatrixCoefficients | null;\n    primaries?: VideoColorPrimaries | null;\n    transfer?: VideoTransferCharacteristics | null;\n}\n\ninterface VideoConfiguration {\n    bitrate: number;\n    colorGamut?: ColorGamut;\n    contentType: string;\n    framerate: number;\n    hasAlphaChannel?: boolean;\n    hdrMetadataType?: HdrMetadataType;\n    height: number;\n    scalabilityMode?: string;\n    transferFunction?: TransferFunction;\n    width: number;\n}\n\ninterface VideoDecoderConfig {\n    codec: string;\n    codedHeight?: number;\n    codedWidth?: number;\n    colorSpace?: VideoColorSpaceInit;\n    description?: AllowSharedBufferSource;\n    displayAspectHeight?: number;\n    displayAspectWidth?: number;\n    hardwareAcceleration?: HardwareAcceleration;\n    optimizeForLatency?: boolean;\n}\n\ninterface VideoDecoderInit {\n    error: WebCodecsErrorCallback;\n    output: VideoFrameOutputCallback;\n}\n\ninterface VideoDecoderSupport {\n    config?: VideoDecoderConfig;\n    supported?: boolean;\n}\n\ninterface VideoEncoderConfig {\n    alpha?: AlphaOption;\n    avc?: AvcEncoderConfig;\n    bitrate?: number;\n    bitrateMode?: VideoEncoderBitrateMode;\n    codec: string;\n    contentHint?: string;\n    displayHeight?: number;\n    displayWidth?: number;\n    framerate?: number;\n    hardwareAcceleration?: HardwareAcceleration;\n    height: number;\n    latencyMode?: LatencyMode;\n    scalabilityMode?: string;\n    width: number;\n}\n\ninterface VideoEncoderEncodeOptions {\n    avc?: VideoEncoderEncodeOptionsForAvc;\n    keyFrame?: boolean;\n}\n\ninterface VideoEncoderEncodeOptionsForAvc {\n    quantizer?: number | null;\n}\n\ninterface VideoEncoderInit {\n    error: WebCodecsErrorCallback;\n    output: EncodedVideoChunkOutputCallback;\n}\n\ninterface VideoEncoderSupport {\n    config?: VideoEncoderConfig;\n    supported?: boolean;\n}\n\ninterface VideoFrameBufferInit {\n    codedHeight: number;\n    codedWidth: number;\n    colorSpace?: VideoColorSpaceInit;\n    displayHeight?: number;\n    displayWidth?: number;\n    duration?: number;\n    format: VideoPixelFormat;\n    layout?: PlaneLayout[];\n    timestamp: number;\n    visibleRect?: DOMRectInit;\n}\n\ninterface VideoFrameCallbackMetadata {\n    captureTime?: DOMHighResTimeStamp;\n    expectedDisplayTime: DOMHighResTimeStamp;\n    height: number;\n    mediaTime: number;\n    presentationTime: DOMHighResTimeStamp;\n    presentedFrames: number;\n    processingDuration?: number;\n    receiveTime?: DOMHighResTimeStamp;\n    rtpTimestamp?: number;\n    width: number;\n}\n\ninterface VideoFrameCopyToOptions {\n    colorSpace?: PredefinedColorSpace;\n    format?: VideoPixelFormat;\n    layout?: PlaneLayout[];\n    rect?: DOMRectInit;\n}\n\ninterface VideoFrameInit {\n    alpha?: AlphaOption;\n    displayHeight?: number;\n    displayWidth?: number;\n    duration?: number;\n    timestamp?: number;\n    visibleRect?: DOMRectInit;\n}\n\ninterface WaveShaperOptions extends AudioNodeOptions {\n    curve?: number[] | Float32Array;\n    oversample?: OverSampleType;\n}\n\ninterface WebGLContextAttributes {\n    alpha?: boolean;\n    antialias?: boolean;\n    depth?: boolean;\n    desynchronized?: boolean;\n    failIfMajorPerformanceCaveat?: boolean;\n    powerPreference?: WebGLPowerPreference;\n    premultipliedAlpha?: boolean;\n    preserveDrawingBuffer?: boolean;\n    stencil?: boolean;\n}\n\ninterface WebGLContextEventInit extends EventInit {\n    statusMessage?: string;\n}\n\ninterface WebTransportCloseInfo {\n    closeCode?: number;\n    reason?: string;\n}\n\ninterface WebTransportErrorOptions {\n    source?: WebTransportErrorSource;\n    streamErrorCode?: number | null;\n}\n\ninterface WebTransportHash {\n    algorithm?: string;\n    value?: BufferSource;\n}\n\ninterface WebTransportOptions {\n    allowPooling?: boolean;\n    congestionControl?: WebTransportCongestionControl;\n    requireUnreliable?: boolean;\n    serverCertificateHashes?: WebTransportHash[];\n}\n\ninterface WebTransportSendOptions {\n    sendOrder?: number;\n}\n\ninterface WebTransportSendStreamOptions extends WebTransportSendOptions {\n}\n\ninterface WheelEventInit extends MouseEventInit {\n    deltaMode?: number;\n    deltaX?: number;\n    deltaY?: number;\n    deltaZ?: number;\n}\n\ninterface WindowPostMessageOptions extends StructuredSerializeOptions {\n    targetOrigin?: string;\n}\n\ninterface WorkerOptions {\n    credentials?: RequestCredentials;\n    name?: string;\n    type?: WorkerType;\n}\n\ninterface WorkletOptions {\n    credentials?: RequestCredentials;\n}\n\ninterface WriteParams {\n    data?: BufferSource | Blob | string | null;\n    position?: number | null;\n    size?: number | null;\n    type: WriteCommandType;\n}\n\ntype NodeFilter = ((node: Node) => number) | { acceptNode(node: Node): number; };\n\ndeclare var NodeFilter: {\n    readonly FILTER_ACCEPT: 1;\n    readonly FILTER_REJECT: 2;\n    readonly FILTER_SKIP: 3;\n    readonly SHOW_ALL: 0xFFFFFFFF;\n    readonly SHOW_ELEMENT: 0x1;\n    readonly SHOW_ATTRIBUTE: 0x2;\n    readonly SHOW_TEXT: 0x4;\n    readonly SHOW_CDATA_SECTION: 0x8;\n    readonly SHOW_ENTITY_REFERENCE: 0x10;\n    readonly SHOW_ENTITY: 0x20;\n    readonly SHOW_PROCESSING_INSTRUCTION: 0x40;\n    readonly SHOW_COMMENT: 0x80;\n    readonly SHOW_DOCUMENT: 0x100;\n    readonly SHOW_DOCUMENT_TYPE: 0x200;\n    readonly SHOW_DOCUMENT_FRAGMENT: 0x400;\n    readonly SHOW_NOTATION: 0x800;\n};\n\ntype XPathNSResolver = ((prefix: string | null) => string | null) | { lookupNamespaceURI(prefix: string | null): string | null; };\n\n/**\n * The **`ANGLE_instanced_arrays`** extension is part of the WebGL API and allows to draw the same object, or groups of similar objects multiple times, if they share the same vertex data, primitive count and type.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ANGLE_instanced_arrays)\n */\ninterface ANGLE_instanced_arrays {\n    /**\n     * The **`ANGLE_instanced_arrays.drawArraysInstancedANGLE()`** method of the WebGL API renders primitives from array data like the WebGLRenderingContext.drawArrays() method.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ANGLE_instanced_arrays/drawArraysInstancedANGLE)\n     */\n    drawArraysInstancedANGLE(mode: GLenum, first: GLint, count: GLsizei, primcount: GLsizei): void;\n    /**\n     * The **`ANGLE_instanced_arrays.drawElementsInstancedANGLE()`** method of the WebGL API renders primitives from array data like the WebGLRenderingContext.drawElements() method.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ANGLE_instanced_arrays/drawElementsInstancedANGLE)\n     */\n    drawElementsInstancedANGLE(mode: GLenum, count: GLsizei, type: GLenum, offset: GLintptr, primcount: GLsizei): void;\n    /**\n     * The **ANGLE_instanced_arrays.vertexAttribDivisorANGLE()** method of the WebGL API modifies the rate at which generic vertex attributes advance when rendering multiple instances of primitives with ANGLE_instanced_arrays.drawArraysInstancedANGLE() and ANGLE_instanced_arrays.drawElementsInstancedANGLE().\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ANGLE_instanced_arrays/vertexAttribDivisorANGLE)\n     */\n    vertexAttribDivisorANGLE(index: GLuint, divisor: GLuint): void;\n    readonly VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE: 0x88FE;\n}\n\ninterface ARIAMixin {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaActiveDescendantElement) */\n    ariaActiveDescendantElement: Element | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaAtomic) */\n    ariaAtomic: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaAutoComplete) */\n    ariaAutoComplete: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaBrailleLabel) */\n    ariaBrailleLabel: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaBrailleRoleDescription) */\n    ariaBrailleRoleDescription: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaBusy) */\n    ariaBusy: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaChecked) */\n    ariaChecked: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaColCount) */\n    ariaColCount: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaColIndex) */\n    ariaColIndex: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaColIndexText) */\n    ariaColIndexText: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaColSpan) */\n    ariaColSpan: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaControlsElements) */\n    ariaControlsElements: ReadonlyArray<Element> | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaCurrent) */\n    ariaCurrent: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaDescribedByElements) */\n    ariaDescribedByElements: ReadonlyArray<Element> | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaDescription) */\n    ariaDescription: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaDetailsElements) */\n    ariaDetailsElements: ReadonlyArray<Element> | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaDisabled) */\n    ariaDisabled: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaErrorMessageElements) */\n    ariaErrorMessageElements: ReadonlyArray<Element> | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaExpanded) */\n    ariaExpanded: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaFlowToElements) */\n    ariaFlowToElements: ReadonlyArray<Element> | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaHasPopup) */\n    ariaHasPopup: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaHidden) */\n    ariaHidden: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaInvalid) */\n    ariaInvalid: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaKeyShortcuts) */\n    ariaKeyShortcuts: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaLabel) */\n    ariaLabel: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaLabelledByElements) */\n    ariaLabelledByElements: ReadonlyArray<Element> | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaLevel) */\n    ariaLevel: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaLive) */\n    ariaLive: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaModal) */\n    ariaModal: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaMultiLine) */\n    ariaMultiLine: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaMultiSelectable) */\n    ariaMultiSelectable: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaOrientation) */\n    ariaOrientation: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaOwnsElements) */\n    ariaOwnsElements: ReadonlyArray<Element> | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaPlaceholder) */\n    ariaPlaceholder: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaPosInSet) */\n    ariaPosInSet: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaPressed) */\n    ariaPressed: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaReadOnly) */\n    ariaReadOnly: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaRelevant) */\n    ariaRelevant: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaRequired) */\n    ariaRequired: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaRoleDescription) */\n    ariaRoleDescription: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaRowCount) */\n    ariaRowCount: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaRowIndex) */\n    ariaRowIndex: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaRowIndexText) */\n    ariaRowIndexText: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaRowSpan) */\n    ariaRowSpan: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaSelected) */\n    ariaSelected: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaSetSize) */\n    ariaSetSize: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaSort) */\n    ariaSort: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaValueMax) */\n    ariaValueMax: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaValueMin) */\n    ariaValueMin: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaValueNow) */\n    ariaValueNow: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/ariaValueText) */\n    ariaValueText: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/role) */\n    role: string | null;\n}\n\n/**\n * The **`AbortController`** interface represents a controller object that allows you to abort one or more Web requests as and when desired.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortController)\n */\ninterface AbortController {\n    /**\n     * The **`signal`** read-only property of the AbortController interface returns an AbortSignal object instance, which can be used to communicate with/abort an asynchronous operation as desired.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortController/signal)\n     */\n    readonly signal: AbortSignal;\n    /**\n     * The **`abort()`** method of the AbortController interface aborts an asynchronous operation before it has completed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortController/abort)\n     */\n    abort(reason?: any): void;\n}\n\ndeclare var AbortController: {\n    prototype: AbortController;\n    new(): AbortController;\n};\n\ninterface AbortSignalEventMap {\n    \"abort\": Event;\n}\n\n/**\n * The **`AbortSignal`** interface represents a signal object that allows you to communicate with an asynchronous operation (such as a fetch request) and abort it if required via an AbortController object.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortSignal)\n */\ninterface AbortSignal extends EventTarget {\n    /**\n     * The **`aborted`** read-only property returns a value that indicates whether the asynchronous operations the signal is communicating with are aborted (`true`) or not (`false`).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortSignal/aborted)\n     */\n    readonly aborted: boolean;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortSignal/abort_event) */\n    onabort: ((this: AbortSignal, ev: Event) => any) | null;\n    /**\n     * The **`reason`** read-only property returns a JavaScript value that indicates the abort reason.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortSignal/reason)\n     */\n    readonly reason: any;\n    /**\n     * The **`throwIfAborted()`** method throws the signal's abort AbortSignal.reason if the signal has been aborted; otherwise it does nothing.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortSignal/throwIfAborted)\n     */\n    throwIfAborted(): void;\n    addEventListener<K extends keyof AbortSignalEventMap>(type: K, listener: (this: AbortSignal, ev: AbortSignalEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AbortSignalEventMap>(type: K, listener: (this: AbortSignal, ev: AbortSignalEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AbortSignal: {\n    prototype: AbortSignal;\n    new(): AbortSignal;\n    /**\n     * The **`AbortSignal.abort()`** static method returns an AbortSignal that is already set as aborted (and which does not trigger an AbortSignal/abort_event event).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortSignal/abort_static)\n     */\n    abort(reason?: any): AbortSignal;\n    /**\n     * The **`AbortSignal.any()`** static method takes an iterable of abort signals and returns an AbortSignal.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortSignal/any_static)\n     */\n    any(signals: AbortSignal[]): AbortSignal;\n    /**\n     * The **`AbortSignal.timeout()`** static method returns an AbortSignal that will automatically abort after a specified time.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbortSignal/timeout_static)\n     */\n    timeout(milliseconds: number): AbortSignal;\n};\n\n/**\n * The **`AbstractRange`** abstract interface is the base class upon which all DOM range types are defined.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbstractRange)\n */\ninterface AbstractRange {\n    /**\n     * The read-only **`collapsed`** property of the AbstractRange interface returns `true` if the range's start position and end position are the same.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbstractRange/collapsed)\n     */\n    readonly collapsed: boolean;\n    /**\n     * The read-only **`endContainer`** property of the AbstractRange interface returns the Node in which the end of the range is located.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbstractRange/endContainer)\n     */\n    readonly endContainer: Node;\n    /**\n     * The **`endOffset`** property of the AbstractRange interface returns the offset into the end node of the range's end position.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbstractRange/endOffset)\n     */\n    readonly endOffset: number;\n    /**\n     * The read-only **`startContainer`** property of the AbstractRange interface returns the start Node for the range.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbstractRange/startContainer)\n     */\n    readonly startContainer: Node;\n    /**\n     * The read-only **`startOffset`** property of the AbstractRange interface returns the offset into the start node of the range's start position.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AbstractRange/startOffset)\n     */\n    readonly startOffset: number;\n}\n\ndeclare var AbstractRange: {\n    prototype: AbstractRange;\n    new(): AbstractRange;\n};\n\ninterface AbstractWorkerEventMap {\n    \"error\": ErrorEvent;\n}\n\ninterface AbstractWorker {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ServiceWorker/error_event) */\n    onerror: ((this: AbstractWorker, ev: ErrorEvent) => any) | null;\n    addEventListener<K extends keyof AbstractWorkerEventMap>(type: K, listener: (this: AbstractWorker, ev: AbstractWorkerEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AbstractWorkerEventMap>(type: K, listener: (this: AbstractWorker, ev: AbstractWorkerEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/**\n * The **`AnalyserNode`** interface represents a node able to provide real-time frequency and time-domain analysis information.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode)\n */\ninterface AnalyserNode extends AudioNode {\n    /**\n     * The **`fftSize`** property of the AnalyserNode interface is an unsigned long value and represents the window size in samples that is used when performing a Fast Fourier Transform (FFT) to get frequency domain data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/fftSize)\n     */\n    fftSize: number;\n    /**\n     * The **`frequencyBinCount`** read-only property of the AnalyserNode interface contains the total number of data points available to AudioContext BaseAudioContext.sampleRate.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/frequencyBinCount)\n     */\n    readonly frequencyBinCount: number;\n    /**\n     * The **`maxDecibels`** property of the AnalyserNode interface is a double value representing the maximum power value in the scaling range for the FFT analysis data, for conversion to unsigned byte values — basically, this specifies the maximum value for the range of results when using `getByteFrequencyData()`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/maxDecibels)\n     */\n    maxDecibels: number;\n    /**\n     * The **`minDecibels`** property of the AnalyserNode interface is a double value representing the minimum power value in the scaling range for the FFT analysis data, for conversion to unsigned byte values — basically, this specifies the minimum value for the range of results when using `getByteFrequencyData()`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/minDecibels)\n     */\n    minDecibels: number;\n    /**\n     * The **`smoothingTimeConstant`** property of the AnalyserNode interface is a double value representing the averaging constant with the last analysis frame.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/smoothingTimeConstant)\n     */\n    smoothingTimeConstant: number;\n    /**\n     * The **`getByteFrequencyData()`** method of the AnalyserNode interface copies the current frequency data into a Uint8Array (unsigned byte array) passed into it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/getByteFrequencyData)\n     */\n    getByteFrequencyData(array: Uint8Array<ArrayBuffer>): void;\n    /**\n     * The **`getByteTimeDomainData()`** method of the AnalyserNode Interface copies the current waveform, or time-domain, data into a Uint8Array (unsigned byte array) passed into it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/getByteTimeDomainData)\n     */\n    getByteTimeDomainData(array: Uint8Array<ArrayBuffer>): void;\n    /**\n     * The **`getFloatFrequencyData()`** method of the AnalyserNode Interface copies the current frequency data into a Float32Array array passed into it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/getFloatFrequencyData)\n     */\n    getFloatFrequencyData(array: Float32Array<ArrayBuffer>): void;\n    /**\n     * The **`getFloatTimeDomainData()`** method of the AnalyserNode Interface copies the current waveform, or time-domain, data into a Float32Array array passed into it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnalyserNode/getFloatTimeDomainData)\n     */\n    getFloatTimeDomainData(array: Float32Array<ArrayBuffer>): void;\n}\n\ndeclare var AnalyserNode: {\n    prototype: AnalyserNode;\n    new(context: BaseAudioContext, options?: AnalyserOptions): AnalyserNode;\n};\n\ninterface Animatable {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/animate) */\n    animate(keyframes: Keyframe[] | PropertyIndexedKeyframes | null, options?: number | KeyframeAnimationOptions): Animation;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getAnimations) */\n    getAnimations(options?: GetAnimationsOptions): Animation[];\n}\n\ninterface AnimationEventMap {\n    \"cancel\": AnimationPlaybackEvent;\n    \"finish\": AnimationPlaybackEvent;\n    \"remove\": AnimationPlaybackEvent;\n}\n\n/**\n * The **`Animation`** interface of the Web Animations API represents a single animation player and provides playback controls and a timeline for an animation node or source.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation)\n */\ninterface Animation extends EventTarget {\n    /**\n     * The **`Animation.currentTime`** property of the Web Animations API returns and sets the current time value of the animation in milliseconds, whether running or paused.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/currentTime)\n     */\n    currentTime: CSSNumberish | null;\n    /**\n     * The **`Animation.effect`** property of the Web Animations API gets and sets the target effect of an animation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/effect)\n     */\n    effect: AnimationEffect | null;\n    /**\n     * The **`Animation.finished`** read-only property of the Web Animations API returns a Promise which resolves once the animation has finished playing.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/finished)\n     */\n    readonly finished: Promise<Animation>;\n    /**\n     * The **`Animation.id`** property of the Web Animations API returns or sets a string used to identify the animation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/id)\n     */\n    id: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/cancel_event) */\n    oncancel: ((this: Animation, ev: AnimationPlaybackEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/finish_event) */\n    onfinish: ((this: Animation, ev: AnimationPlaybackEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/remove_event) */\n    onremove: ((this: Animation, ev: AnimationPlaybackEvent) => any) | null;\n    /**\n     * The read-only **`Animation.pending`** property of the Web Animations API indicates whether the animation is currently waiting for an asynchronous operation such as initiating playback or pausing a running animation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/pending)\n     */\n    readonly pending: boolean;\n    /**\n     * The read-only **`Animation.playState`** property of the Web Animations API returns an enumerated value describing the playback state of an animation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/playState)\n     */\n    readonly playState: AnimationPlayState;\n    /**\n     * The **`Animation.playbackRate`** property of the Web Animations API returns or sets the playback rate of the animation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/playbackRate)\n     */\n    playbackRate: number;\n    /**\n     * The read-only **`Animation.ready`** property of the Web Animations API returns a Promise which resolves when the animation is ready to play.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/ready)\n     */\n    readonly ready: Promise<Animation>;\n    /**\n     * The read-only **`Animation.replaceState`** property of the Web Animations API indicates whether the animation has been removed by the browser automatically after being replaced by another animation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/replaceState)\n     */\n    readonly replaceState: AnimationReplaceState;\n    /**\n     * The **`Animation.startTime`** property of the Animation interface is a double-precision floating-point value which indicates the scheduled time when an animation's playback should begin.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/startTime)\n     */\n    startTime: CSSNumberish | null;\n    /**\n     * The **`Animation.timeline`** property of the Animation interface returns or sets the AnimationTimeline associated with this animation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/timeline)\n     */\n    timeline: AnimationTimeline | null;\n    /**\n     * The Web Animations API's **`cancel()`** method of the Animation interface clears all KeyframeEffects caused by this animation and aborts its playback.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/cancel)\n     */\n    cancel(): void;\n    /**\n     * The `commitStyles()` method of the Web Animations API's Animation interface writes the computed values of the animation's current styles into its target element's `style` attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/commitStyles)\n     */\n    commitStyles(): void;\n    /**\n     * The **`finish()`** method of the Web Animations API's Animation Interface sets the current playback time to the end of the animation corresponding to the current playback direction.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/finish)\n     */\n    finish(): void;\n    /**\n     * The **`pause()`** method of the Web Animations API's Animation interface suspends playback of the animation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/pause)\n     */\n    pause(): void;\n    /**\n     * The `persist()` method of the Web Animations API's Animation interface explicitly persists an animation, preventing it from being automatically removed when it is replaced by another animation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/persist)\n     */\n    persist(): void;\n    /**\n     * The **`play()`** method of the Web Animations API's Animation Interface starts or resumes playing of an animation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/play)\n     */\n    play(): void;\n    /**\n     * The **`Animation.reverse()`** method of the Animation Interface reverses the playback direction, meaning the animation ends at its beginning.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/reverse)\n     */\n    reverse(): void;\n    /**\n     * The **`updatePlaybackRate()`** method of the Web Animations API's synchronizing its playback position.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Animation/updatePlaybackRate)\n     */\n    updatePlaybackRate(playbackRate: number): void;\n    addEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: Animation, ev: AnimationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: Animation, ev: AnimationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var Animation: {\n    prototype: Animation;\n    new(effect?: AnimationEffect | null, timeline?: AnimationTimeline | null): Animation;\n};\n\n/**\n * The `AnimationEffect` interface of the Web Animations API is an interface representing animation effects.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationEffect)\n */\ninterface AnimationEffect {\n    /**\n     * The `getComputedTiming()` method of the AnimationEffect interface returns the calculated timing properties for this animation effect.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationEffect/getComputedTiming)\n     */\n    getComputedTiming(): ComputedEffectTiming;\n    /**\n     * The `AnimationEffect.getTiming()` method of the AnimationEffect interface returns an object containing the timing properties for the Animation Effect.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationEffect/getTiming)\n     */\n    getTiming(): EffectTiming;\n    /**\n     * The `updateTiming()` method of the AnimationEffect interface updates the specified timing properties for an animation effect.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationEffect/updateTiming)\n     */\n    updateTiming(timing?: OptionalEffectTiming): void;\n}\n\ndeclare var AnimationEffect: {\n    prototype: AnimationEffect;\n    new(): AnimationEffect;\n};\n\n/**\n * The **`AnimationEvent`** interface represents events providing information related to animations.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationEvent)\n */\ninterface AnimationEvent extends Event {\n    /**\n     * The **`AnimationEvent.animationName`** read-only property is a string containing the value of the animation-name CSS property associated with the transition.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationEvent/animationName)\n     */\n    readonly animationName: string;\n    /**\n     * The **`AnimationEvent.elapsedTime`** read-only property is a `float` giving the amount of time the animation has been running, in seconds, when this event fired, excluding any time the animation was paused.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationEvent/elapsedTime)\n     */\n    readonly elapsedTime: number;\n    /**\n     * The **`AnimationEvent.pseudoElement`** read-only property is a string, starting with `'::'`, containing the name of the pseudo-element the animation runs on.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationEvent/pseudoElement)\n     */\n    readonly pseudoElement: string;\n}\n\ndeclare var AnimationEvent: {\n    prototype: AnimationEvent;\n    new(type: string, animationEventInitDict?: AnimationEventInit): AnimationEvent;\n};\n\ninterface AnimationFrameProvider {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DedicatedWorkerGlobalScope/cancelAnimationFrame) */\n    cancelAnimationFrame(handle: number): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DedicatedWorkerGlobalScope/requestAnimationFrame) */\n    requestAnimationFrame(callback: FrameRequestCallback): number;\n}\n\n/**\n * The AnimationPlaybackEvent interface of the Web Animations API represents animation events.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationPlaybackEvent)\n */\ninterface AnimationPlaybackEvent extends Event {\n    /**\n     * The **`currentTime`** read-only property of the AnimationPlaybackEvent interface represents the current time of the animation that generated the event at the moment the event is queued.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationPlaybackEvent/currentTime)\n     */\n    readonly currentTime: CSSNumberish | null;\n    /**\n     * The **`timelineTime`** read-only property of the AnimationPlaybackEvent interface represents the time value of the animation's AnimationTimeline at the moment the event is queued.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationPlaybackEvent/timelineTime)\n     */\n    readonly timelineTime: CSSNumberish | null;\n}\n\ndeclare var AnimationPlaybackEvent: {\n    prototype: AnimationPlaybackEvent;\n    new(type: string, eventInitDict?: AnimationPlaybackEventInit): AnimationPlaybackEvent;\n};\n\n/**\n * The `AnimationTimeline` interface of the Web Animations API represents the timeline of an animation.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationTimeline)\n */\ninterface AnimationTimeline {\n    /**\n     * The **`currentTime`** read-only property of the Web Animations API's AnimationTimeline interface returns the timeline's current time in milliseconds, or `null` if the timeline is inactive.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AnimationTimeline/currentTime)\n     */\n    readonly currentTime: CSSNumberish | null;\n}\n\ndeclare var AnimationTimeline: {\n    prototype: AnimationTimeline;\n    new(): AnimationTimeline;\n};\n\n/**\n * The **`Attr`** interface represents one of an element's attributes as an object.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Attr)\n */\ninterface Attr extends Node {\n    /**\n     * The read-only **`localName`** property of the Attr interface returns the _local part_ of the _qualified name_ of an attribute, that is the name of the attribute, stripped from any namespace in front of it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Attr/localName)\n     */\n    readonly localName: string;\n    /**\n     * The read-only **`name`** property of the Attr interface returns the _qualified name_ of an attribute, that is the name of the attribute, with the namespace prefix, if any, in front of it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Attr/name)\n     */\n    readonly name: string;\n    /**\n     * The read-only **`namespaceURI`** property of the Attr interface returns the namespace URI of the attribute, or `null` if the element is not in a namespace.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Attr/namespaceURI)\n     */\n    readonly namespaceURI: string | null;\n    readonly ownerDocument: Document;\n    /**\n     * The read-only **`ownerElement`** property of the Attr interface returns the Element the attribute belongs to.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Attr/ownerElement)\n     */\n    readonly ownerElement: Element | null;\n    /**\n     * The read-only **`prefix`** property of the Attr returns the namespace prefix of the attribute, or `null` if no prefix is specified.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Attr/prefix)\n     */\n    readonly prefix: string | null;\n    /**\n     * The read-only **`specified`** property of the Attr interface always returns `true`.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Attr/specified)\n     */\n    readonly specified: boolean;\n    /**\n     * The **`value`** property of the Attr interface contains the value of the attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Attr/value)\n     */\n    value: string;\n    /** [MDN Reference](https://developer.mozilla.org/en-US/docs/Web/API/Node/textContent) */\n    get textContent(): string;\n    set textContent(value: string | null);\n}\n\ndeclare var Attr: {\n    prototype: Attr;\n    new(): Attr;\n};\n\n/**\n * The **`AudioBuffer`** interface represents a short audio asset residing in memory, created from an audio file using the BaseAudioContext/decodeAudioData method, or from raw data using BaseAudioContext/createBuffer.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBuffer)\n */\ninterface AudioBuffer {\n    /**\n     * The **`duration`** property of the AudioBuffer interface returns a double representing the duration, in seconds, of the PCM data stored in the buffer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBuffer/duration)\n     */\n    readonly duration: number;\n    /**\n     * The **`length`** property of the AudioBuffer interface returns an integer representing the length, in sample-frames, of the PCM data stored in the buffer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBuffer/length)\n     */\n    readonly length: number;\n    /**\n     * The `numberOfChannels` property of the AudioBuffer interface returns an integer representing the number of discrete audio channels described by the PCM data stored in the buffer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBuffer/numberOfChannels)\n     */\n    readonly numberOfChannels: number;\n    /**\n     * The **`sampleRate`** property of the AudioBuffer interface returns a float representing the sample rate, in samples per second, of the PCM data stored in the buffer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBuffer/sampleRate)\n     */\n    readonly sampleRate: number;\n    /**\n     * The **`copyFromChannel()`** method of the channel of the `AudioBuffer` to a specified ```js-nolint copyFromChannel(destination, channelNumber, startInChannel) ``` - `destination` - : A Float32Array to copy the channel's samples to.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBuffer/copyFromChannel)\n     */\n    copyFromChannel(destination: Float32Array<ArrayBuffer>, channelNumber: number, bufferOffset?: number): void;\n    /**\n     * The `copyToChannel()` method of the AudioBuffer interface copies the samples to the specified channel of the `AudioBuffer`, from the source array.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBuffer/copyToChannel)\n     */\n    copyToChannel(source: Float32Array<ArrayBuffer>, channelNumber: number, bufferOffset?: number): void;\n    /**\n     * The **`getChannelData()`** method of the AudioBuffer Interface returns a Float32Array containing the PCM data associated with the channel, defined by the channel parameter (with 0 representing the first channel).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBuffer/getChannelData)\n     */\n    getChannelData(channel: number): Float32Array<ArrayBuffer>;\n}\n\ndeclare var AudioBuffer: {\n    prototype: AudioBuffer;\n    new(options: AudioBufferOptions): AudioBuffer;\n};\n\n/**\n * The **`AudioBufferSourceNode`** interface is an AudioScheduledSourceNode which represents an audio source consisting of in-memory audio data, stored in an AudioBuffer.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBufferSourceNode)\n */\ninterface AudioBufferSourceNode extends AudioScheduledSourceNode {\n    /**\n     * The **`buffer`** property of the AudioBufferSourceNode interface provides the ability to play back audio using an AudioBuffer as the source of the sound data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBufferSourceNode/buffer)\n     */\n    buffer: AudioBuffer | null;\n    /**\n     * The **`detune`** property of the representing detuning of oscillation in cents.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBufferSourceNode/detune)\n     */\n    readonly detune: AudioParam;\n    /**\n     * The `loop` property of the AudioBufferSourceNode interface is a Boolean indicating if the audio asset must be replayed when the end of the AudioBuffer is reached.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBufferSourceNode/loop)\n     */\n    loop: boolean;\n    /**\n     * The `loopEnd` property of the AudioBufferSourceNode interface specifies is a floating point number specifying, in seconds, at what offset into playing the AudioBuffer playback should loop back to the time indicated by the AudioBufferSourceNode.loopStart property.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBufferSourceNode/loopEnd)\n     */\n    loopEnd: number;\n    /**\n     * The **`loopStart`** property of the AudioBufferSourceNode interface is a floating-point value indicating, in seconds, where in the AudioBuffer the restart of the play must happen.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBufferSourceNode/loopStart)\n     */\n    loopStart: number;\n    /**\n     * The **`playbackRate`** property of the AudioBufferSourceNode interface Is a k-rate AudioParam that defines the speed at which the audio asset will be played.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBufferSourceNode/playbackRate)\n     */\n    readonly playbackRate: AudioParam;\n    /**\n     * The `start()` method of the AudioBufferSourceNode Interface is used to schedule playback of the audio data contained in the buffer, or to begin playback immediately.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioBufferSourceNode/start)\n     */\n    start(when?: number, offset?: number, duration?: number): void;\n    addEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: AudioBufferSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: AudioBufferSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AudioBufferSourceNode: {\n    prototype: AudioBufferSourceNode;\n    new(context: BaseAudioContext, options?: AudioBufferSourceOptions): AudioBufferSourceNode;\n};\n\n/**\n * The `AudioContext` interface represents an audio-processing graph built from audio modules linked together, each represented by an AudioNode.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext)\n */\ninterface AudioContext extends BaseAudioContext {\n    /**\n     * The **`baseLatency`** read-only property of the seconds of processing latency incurred by the `AudioContext` passing an audio buffer from the AudioDestinationNode — i.e., the end of the audio graph — into the host system's audio subsystem ready for playing.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/baseLatency)\n     */\n    readonly baseLatency: number;\n    /**\n     * The **`outputLatency`** read-only property of the AudioContext Interface provides an estimation of the output latency of the current audio context.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/outputLatency)\n     */\n    readonly outputLatency: number;\n    /**\n     * The `close()` method of the AudioContext Interface closes the audio context, releasing any system audio resources that it uses.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/close)\n     */\n    close(): Promise<void>;\n    /**\n     * The `createMediaElementSource()` method of the AudioContext Interface is used to create a new MediaElementAudioSourceNode object, given an existing HTML audio or video element, the audio from which can then be played and manipulated.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/createMediaElementSource)\n     */\n    createMediaElementSource(mediaElement: HTMLMediaElement): MediaElementAudioSourceNode;\n    /**\n     * The `createMediaStreamDestination()` method of the AudioContext Interface is used to create a new MediaStreamAudioDestinationNode object associated with a WebRTC MediaStream representing an audio stream, which may be stored in a local file or sent to another computer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/createMediaStreamDestination)\n     */\n    createMediaStreamDestination(): MediaStreamAudioDestinationNode;\n    /**\n     * The `createMediaStreamSource()` method of the AudioContext Interface is used to create a new MediaStreamAudioSourceNode object, given a media stream (say, from a MediaDevices.getUserMedia instance), the audio from which can then be played and manipulated.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/createMediaStreamSource)\n     */\n    createMediaStreamSource(mediaStream: MediaStream): MediaStreamAudioSourceNode;\n    /**\n     * The **`getOutputTimestamp()`** method of the containing two audio timestamp values relating to the current audio context.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/getOutputTimestamp)\n     */\n    getOutputTimestamp(): AudioTimestamp;\n    /**\n     * The **`resume()`** method of the AudioContext interface resumes the progression of time in an audio context that has previously been suspended.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/resume)\n     */\n    resume(): Promise<void>;\n    /**\n     * The `suspend()` method of the AudioContext Interface suspends the progression of time in the audio context, temporarily halting audio hardware access and reducing CPU/battery usage in the process — this is useful if you want an application to power down the audio hardware when it will not be using an audio context for a while.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioContext/suspend)\n     */\n    suspend(): Promise<void>;\n    addEventListener<K extends keyof BaseAudioContextEventMap>(type: K, listener: (this: AudioContext, ev: BaseAudioContextEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof BaseAudioContextEventMap>(type: K, listener: (this: AudioContext, ev: BaseAudioContextEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AudioContext: {\n    prototype: AudioContext;\n    new(contextOptions?: AudioContextOptions): AudioContext;\n};\n\n/**\n * The **`AudioData`** interface of the WebCodecs API represents an audio sample.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioData)\n */\ninterface AudioData {\n    /**\n     * The **`duration`** read-only property of the AudioData interface returns the duration in microseconds of this `AudioData` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioData/duration)\n     */\n    readonly duration: number;\n    /**\n     * The **`format`** read-only property of the AudioData interface returns the sample format of the `AudioData` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioData/format)\n     */\n    readonly format: AudioSampleFormat | null;\n    /**\n     * The **`numberOfChannels`** read-only property of the AudioData interface returns the number of channels in the `AudioData` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioData/numberOfChannels)\n     */\n    readonly numberOfChannels: number;\n    /**\n     * The **`numberOfFrames`** read-only property of the AudioData interface returns the number of frames in the `AudioData` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioData/numberOfFrames)\n     */\n    readonly numberOfFrames: number;\n    /**\n     * The **`sampleRate`** read-only property of the AudioData interface returns the sample rate in Hz.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioData/sampleRate)\n     */\n    readonly sampleRate: number;\n    /**\n     * The **`timestamp`** read-only property of the AudioData interface returns the timestamp of this `AudioData` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioData/timestamp)\n     */\n    readonly timestamp: number;\n    /**\n     * The **`allocationSize()`** method of the AudioData interface returns the size in bytes required to hold the current sample as filtered by options passed into the method.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioData/allocationSize)\n     */\n    allocationSize(options: AudioDataCopyToOptions): number;\n    /**\n     * The **`clone()`** method of the AudioData interface creates a new `AudioData` object with reference to the same media resource as the original.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioData/clone)\n     */\n    clone(): AudioData;\n    /**\n     * The **`close()`** method of the AudioData interface clears all states and releases the reference to the media resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioData/close)\n     */\n    close(): void;\n    /**\n     * The **`copyTo()`** method of the AudioData interface copies a plane of an `AudioData` object to a destination buffer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioData/copyTo)\n     */\n    copyTo(destination: AllowSharedBufferSource, options: AudioDataCopyToOptions): void;\n}\n\ndeclare var AudioData: {\n    prototype: AudioData;\n    new(init: AudioDataInit): AudioData;\n};\n\ninterface AudioDecoderEventMap {\n    \"dequeue\": Event;\n}\n\n/**\n * The **`AudioDecoder`** interface of the WebCodecs API decodes chunks of audio.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioDecoder)\n */\ninterface AudioDecoder extends EventTarget {\n    /**\n     * The **`decodeQueueSize`** read-only property of the AudioDecoder interface returns the number of pending decode requests in the queue.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioDecoder/decodeQueueSize)\n     */\n    readonly decodeQueueSize: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioDecoder/dequeue_event) */\n    ondequeue: ((this: AudioDecoder, ev: Event) => any) | null;\n    /**\n     * The **`state`** read-only property of the AudioDecoder interface returns the current state of the underlying codec.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioDecoder/state)\n     */\n    readonly state: CodecState;\n    /**\n     * The **`close()`** method of the AudioDecoder interface ends all pending work and releases system resources.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioDecoder/close)\n     */\n    close(): void;\n    /**\n     * The **`configure()`** method of the AudioDecoder interface enqueues a control message to configure the audio decoder for decoding chunks.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioDecoder/configure)\n     */\n    configure(config: AudioDecoderConfig): void;\n    /**\n     * The **`decode()`** method of the AudioDecoder interface enqueues a control message to decode a given chunk of audio.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioDecoder/decode)\n     */\n    decode(chunk: EncodedAudioChunk): void;\n    /**\n     * The **`flush()`** method of the AudioDecoder interface returns a Promise that resolves once all pending messages in the queue have been completed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioDecoder/flush)\n     */\n    flush(): Promise<void>;\n    /**\n     * The **`reset()`** method of the AudioDecoder interface resets all states including configuration, control messages in the control message queue, and all pending callbacks.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioDecoder/reset)\n     */\n    reset(): void;\n    addEventListener<K extends keyof AudioDecoderEventMap>(type: K, listener: (this: AudioDecoder, ev: AudioDecoderEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AudioDecoderEventMap>(type: K, listener: (this: AudioDecoder, ev: AudioDecoderEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AudioDecoder: {\n    prototype: AudioDecoder;\n    new(init: AudioDecoderInit): AudioDecoder;\n    /**\n     * The **`isConfigSupported()`** static method of the AudioDecoder interface checks if the given config is supported (that is, if AudioDecoder objects can be successfully configured with the given config).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioDecoder/isConfigSupported_static)\n     */\n    isConfigSupported(config: AudioDecoderConfig): Promise<AudioDecoderSupport>;\n};\n\n/**\n * The `AudioDestinationNode` interface represents the end destination of an audio graph in a given context — usually the speakers of your device.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioDestinationNode)\n */\ninterface AudioDestinationNode extends AudioNode {\n    /**\n     * The `maxChannelCount` property of the AudioDestinationNode interface is an `unsigned long` defining the maximum amount of channels that the physical device can handle.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioDestinationNode/maxChannelCount)\n     */\n    readonly maxChannelCount: number;\n}\n\ndeclare var AudioDestinationNode: {\n    prototype: AudioDestinationNode;\n    new(): AudioDestinationNode;\n};\n\ninterface AudioEncoderEventMap {\n    \"dequeue\": Event;\n}\n\n/**\n * The **`AudioEncoder`** interface of the WebCodecs API encodes AudioData objects.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioEncoder)\n */\ninterface AudioEncoder extends EventTarget {\n    /**\n     * The **`encodeQueueSize`** read-only property of the AudioEncoder interface returns the number of pending encode requests in the queue.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioEncoder/encodeQueueSize)\n     */\n    readonly encodeQueueSize: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioEncoder/dequeue_event) */\n    ondequeue: ((this: AudioEncoder, ev: Event) => any) | null;\n    /**\n     * The **`state`** read-only property of the AudioEncoder interface returns the current state of the underlying codec.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioEncoder/state)\n     */\n    readonly state: CodecState;\n    /**\n     * The **`close()`** method of the AudioEncoder interface ends all pending work and releases system resources.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioEncoder/close)\n     */\n    close(): void;\n    /**\n     * The **`configure()`** method of the AudioEncoder interface enqueues a control message to configure the audio encoder for encoding chunks.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioEncoder/configure)\n     */\n    configure(config: AudioEncoderConfig): void;\n    /**\n     * The **`encode()`** method of the AudioEncoder interface enqueues a control message to encode a given AudioData object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioEncoder/encode)\n     */\n    encode(data: AudioData): void;\n    /**\n     * The **`flush()`** method of the AudioEncoder interface returns a Promise that resolves once all pending messages in the queue have been completed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioEncoder/flush)\n     */\n    flush(): Promise<void>;\n    /**\n     * The **`reset()`** method of the AudioEncoder interface resets all states including configuration, control messages in the control message queue, and all pending callbacks.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioEncoder/reset)\n     */\n    reset(): void;\n    addEventListener<K extends keyof AudioEncoderEventMap>(type: K, listener: (this: AudioEncoder, ev: AudioEncoderEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AudioEncoderEventMap>(type: K, listener: (this: AudioEncoder, ev: AudioEncoderEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AudioEncoder: {\n    prototype: AudioEncoder;\n    new(init: AudioEncoderInit): AudioEncoder;\n    /**\n     * The **`isConfigSupported()`** static method of the AudioEncoder interface checks if the given config is supported (that is, if AudioEncoder objects can be successfully configured with the given config).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioEncoder/isConfigSupported_static)\n     */\n    isConfigSupported(config: AudioEncoderConfig): Promise<AudioEncoderSupport>;\n};\n\n/**\n * The `AudioListener` interface represents the position and orientation of the unique person listening to the audio scene, and is used in audio spatialization.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioListener)\n */\ninterface AudioListener {\n    /**\n     * The `forwardX` read-only property of the AudioListener interface is an AudioParam representing the x value of the direction vector defining the forward direction the listener is pointing in.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioListener/forwardX)\n     */\n    readonly forwardX: AudioParam;\n    /**\n     * The `forwardY` read-only property of the AudioListener interface is an AudioParam representing the y value of the direction vector defining the forward direction the listener is pointing in.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioListener/forwardY)\n     */\n    readonly forwardY: AudioParam;\n    /**\n     * The `forwardZ` read-only property of the AudioListener interface is an AudioParam representing the z value of the direction vector defining the forward direction the listener is pointing in.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioListener/forwardZ)\n     */\n    readonly forwardZ: AudioParam;\n    /**\n     * The `positionX` read-only property of the AudioListener interface is an AudioParam representing the x position of the listener in 3D cartesian space.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioListener/positionX)\n     */\n    readonly positionX: AudioParam;\n    /**\n     * The `positionY` read-only property of the AudioListener interface is an AudioParam representing the y position of the listener in 3D cartesian space.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioListener/positionY)\n     */\n    readonly positionY: AudioParam;\n    /**\n     * The `positionZ` read-only property of the AudioListener interface is an AudioParam representing the z position of the listener in 3D cartesian space.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioListener/positionZ)\n     */\n    readonly positionZ: AudioParam;\n    /**\n     * The `upX` read-only property of the AudioListener interface is an AudioParam representing the x value of the direction vector defining the up direction the listener is pointing in.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioListener/upX)\n     */\n    readonly upX: AudioParam;\n    /**\n     * The `upY` read-only property of the AudioListener interface is an AudioParam representing the y value of the direction vector defining the up direction the listener is pointing in.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioListener/upY)\n     */\n    readonly upY: AudioParam;\n    /**\n     * The `upZ` read-only property of the AudioListener interface is an AudioParam representing the z value of the direction vector defining the up direction the listener is pointing in.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioListener/upZ)\n     */\n    readonly upZ: AudioParam;\n    /**\n     * The `setOrientation()` method of the AudioListener interface defines the orientation of the listener.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioListener/setOrientation)\n     */\n    setOrientation(x: number, y: number, z: number, xUp: number, yUp: number, zUp: number): void;\n    /**\n     * The `setPosition()` method of the AudioListener Interface defines the position of the listener.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioListener/setPosition)\n     */\n    setPosition(x: number, y: number, z: number): void;\n}\n\ndeclare var AudioListener: {\n    prototype: AudioListener;\n    new(): AudioListener;\n};\n\n/**\n * The **`AudioNode`** interface is a generic interface for representing an audio processing module.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode)\n */\ninterface AudioNode extends EventTarget {\n    /**\n     * The **`channelCount`** property of the AudioNode interface represents an integer used to determine how many channels are used when up-mixing and down-mixing connections to any inputs to the node.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode/channelCount)\n     */\n    channelCount: number;\n    /**\n     * The `channelCountMode` property of the AudioNode interface represents an enumerated value describing the way channels must be matched between the node's inputs and outputs.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode/channelCountMode)\n     */\n    channelCountMode: ChannelCountMode;\n    /**\n     * The **`channelInterpretation`** property of the AudioNode interface represents an enumerated value describing how input channels are mapped to output channels when the number of inputs/outputs is different.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode/channelInterpretation)\n     */\n    channelInterpretation: ChannelInterpretation;\n    /**\n     * The read-only `context` property of the the node is participating in.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode/context)\n     */\n    readonly context: BaseAudioContext;\n    /**\n     * The `numberOfInputs` property of the AudioNode interface returns the number of inputs feeding the node.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode/numberOfInputs)\n     */\n    readonly numberOfInputs: number;\n    /**\n     * The `numberOfOutputs` property of the AudioNode interface returns the number of outputs coming out of the node.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode/numberOfOutputs)\n     */\n    readonly numberOfOutputs: number;\n    /**\n     * The `connect()` method of the AudioNode interface lets you connect one of the node's outputs to a target, which may be either another `AudioNode` (thereby directing the sound data to the specified node) or an change the value of that parameter over time.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode/connect)\n     */\n    connect(destinationNode: AudioNode, output?: number, input?: number): AudioNode;\n    connect(destinationParam: AudioParam, output?: number): void;\n    /**\n     * The **`disconnect()`** method of the AudioNode interface lets you disconnect one or more nodes from the node on which the method is called.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioNode/disconnect)\n     */\n    disconnect(): void;\n    disconnect(output: number): void;\n    disconnect(destinationNode: AudioNode): void;\n    disconnect(destinationNode: AudioNode, output: number): void;\n    disconnect(destinationNode: AudioNode, output: number, input: number): void;\n    disconnect(destinationParam: AudioParam): void;\n    disconnect(destinationParam: AudioParam, output: number): void;\n}\n\ndeclare var AudioNode: {\n    prototype: AudioNode;\n    new(): AudioNode;\n};\n\n/**\n * The Web Audio API's `AudioParam` interface represents an audio-related parameter, usually a parameter of an AudioNode (such as GainNode.gain).\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam)\n */\ninterface AudioParam {\n    automationRate: AutomationRate;\n    /**\n     * The **`defaultValue`** read-only property of the AudioParam interface represents the initial value of the attributes as defined by the specific AudioNode creating the `AudioParam`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/defaultValue)\n     */\n    readonly defaultValue: number;\n    /**\n     * The **`maxValue`** read-only property of the AudioParam interface represents the maximum possible value for the parameter's nominal (effective) range.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/maxValue)\n     */\n    readonly maxValue: number;\n    /**\n     * The **`minValue`** read-only property of the AudioParam interface represents the minimum possible value for the parameter's nominal (effective) range.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/minValue)\n     */\n    readonly minValue: number;\n    /**\n     * The **`value`** property of the AudioParam interface gets or sets the value of this `AudioParam` at the current time.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/value)\n     */\n    value: number;\n    /**\n     * The **`cancelAndHoldAtTime()`** method of the `AudioParam` but holds its value at a given time until further changes are made using other methods.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/cancelAndHoldAtTime)\n     */\n    cancelAndHoldAtTime(cancelTime: number): AudioParam;\n    /**\n     * The `cancelScheduledValues()` method of the AudioParam Interface cancels all scheduled future changes to the `AudioParam`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/cancelScheduledValues)\n     */\n    cancelScheduledValues(cancelTime: number): AudioParam;\n    /**\n     * The **`exponentialRampToValueAtTime()`** method of the AudioParam Interface schedules a gradual exponential change in the value of the AudioParam.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/exponentialRampToValueAtTime)\n     */\n    exponentialRampToValueAtTime(value: number, endTime: number): AudioParam;\n    /**\n     * The `linearRampToValueAtTime()` method of the AudioParam Interface schedules a gradual linear change in the value of the `AudioParam`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/linearRampToValueAtTime)\n     */\n    linearRampToValueAtTime(value: number, endTime: number): AudioParam;\n    /**\n     * The `setTargetAtTime()` method of the `AudioParam` value.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/setTargetAtTime)\n     */\n    setTargetAtTime(target: number, startTime: number, timeConstant: number): AudioParam;\n    /**\n     * The `setValueAtTime()` method of the `AudioParam` value at a precise time, as measured against ```js-nolint setValueAtTime(value, startTime) ``` - `value` - : A floating point number representing the value the AudioParam will change to at the given time.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/setValueAtTime)\n     */\n    setValueAtTime(value: number, startTime: number): AudioParam;\n    /**\n     * The **`setValueCurveAtTime()`** method of the following a curve defined by a list of values.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParam/setValueCurveAtTime)\n     */\n    setValueCurveAtTime(values: number[] | Float32Array, startTime: number, duration: number): AudioParam;\n}\n\ndeclare var AudioParam: {\n    prototype: AudioParam;\n    new(): AudioParam;\n};\n\n/**\n * The **`AudioParamMap`** interface of the Web Audio API represents an iterable and read-only set of multiple audio parameters.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioParamMap)\n */\ninterface AudioParamMap {\n    forEach(callbackfn: (value: AudioParam, key: string, parent: AudioParamMap) => void, thisArg?: any): void;\n}\n\ndeclare var AudioParamMap: {\n    prototype: AudioParamMap;\n    new(): AudioParamMap;\n};\n\n/**\n * The `AudioProcessingEvent` interface of the Web Audio API represents events that occur when a ScriptProcessorNode input buffer is ready to be processed.\n * @deprecated As of the August 29 2014 Web Audio API spec publication, this feature has been marked as deprecated, and is soon to be replaced by AudioWorklet.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioProcessingEvent)\n */\ninterface AudioProcessingEvent extends Event {\n    /**\n     * The **`inputBuffer`** read-only property of the AudioProcessingEvent interface represents the input buffer of an audio processing event.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioProcessingEvent/inputBuffer)\n     */\n    readonly inputBuffer: AudioBuffer;\n    /**\n     * The **`outputBuffer`** read-only property of the AudioProcessingEvent interface represents the output buffer of an audio processing event.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioProcessingEvent/outputBuffer)\n     */\n    readonly outputBuffer: AudioBuffer;\n    /**\n     * The **`playbackTime`** read-only property of the AudioProcessingEvent interface represents the time when the audio will be played.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioProcessingEvent/playbackTime)\n     */\n    readonly playbackTime: number;\n}\n\n/** @deprecated */\ndeclare var AudioProcessingEvent: {\n    prototype: AudioProcessingEvent;\n    new(type: string, eventInitDict: AudioProcessingEventInit): AudioProcessingEvent;\n};\n\ninterface AudioScheduledSourceNodeEventMap {\n    \"ended\": Event;\n}\n\n/**\n * The `AudioScheduledSourceNode` interface—part of the Web Audio API—is a parent interface for several types of audio source node interfaces which share the ability to be started and stopped, optionally at specified times.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioScheduledSourceNode)\n */\ninterface AudioScheduledSourceNode extends AudioNode {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioScheduledSourceNode/ended_event) */\n    onended: ((this: AudioScheduledSourceNode, ev: Event) => any) | null;\n    /**\n     * The `start()` method on AudioScheduledSourceNode schedules a sound to begin playback at the specified time.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioScheduledSourceNode/start)\n     */\n    start(when?: number): void;\n    /**\n     * The `stop()` method on AudioScheduledSourceNode schedules a sound to cease playback at the specified time.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioScheduledSourceNode/stop)\n     */\n    stop(when?: number): void;\n    addEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: AudioScheduledSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: AudioScheduledSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AudioScheduledSourceNode: {\n    prototype: AudioScheduledSourceNode;\n    new(): AudioScheduledSourceNode;\n};\n\n/**\n * The **`AudioWorklet`** interface of the Web Audio API is used to supply custom audio processing scripts that execute in a separate thread to provide very low latency audio processing.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorklet)\n */\ninterface AudioWorklet extends Worklet {\n}\n\ndeclare var AudioWorklet: {\n    prototype: AudioWorklet;\n    new(): AudioWorklet;\n};\n\ninterface AudioWorkletNodeEventMap {\n    \"processorerror\": ErrorEvent;\n}\n\n/**\n * The **`AudioWorkletNode`** interface of the Web Audio API represents a base class for a user-defined AudioNode, which can be connected to an audio routing graph along with other nodes.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorkletNode)\n */\ninterface AudioWorkletNode extends AudioNode {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorkletNode/processorerror_event) */\n    onprocessorerror: ((this: AudioWorkletNode, ev: ErrorEvent) => any) | null;\n    /**\n     * The read-only **`parameters`** property of the underlying AudioWorkletProcessor according to its getter.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorkletNode/parameters)\n     */\n    readonly parameters: AudioParamMap;\n    /**\n     * The read-only **`port`** property of the associated AudioWorkletProcessor.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AudioWorkletNode/port)\n     */\n    readonly port: MessagePort;\n    addEventListener<K extends keyof AudioWorkletNodeEventMap>(type: K, listener: (this: AudioWorkletNode, ev: AudioWorkletNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AudioWorkletNodeEventMap>(type: K, listener: (this: AudioWorkletNode, ev: AudioWorkletNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AudioWorkletNode: {\n    prototype: AudioWorkletNode;\n    new(context: BaseAudioContext, name: string, options?: AudioWorkletNodeOptions): AudioWorkletNode;\n};\n\n/**\n * The **`AuthenticatorAssertionResponse`** interface of the Web Authentication API contains a digital signature from the private key of a particular WebAuthn credential.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAssertionResponse)\n */\ninterface AuthenticatorAssertionResponse extends AuthenticatorResponse {\n    /**\n     * The **`authenticatorData`** property of the AuthenticatorAssertionResponse interface returns an ArrayBuffer containing information from the authenticator such as the Relying Party ID Hash (rpIdHash), a signature counter, test of user presence, user verification flags, and any extensions processed by the authenticator.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAssertionResponse/authenticatorData)\n     */\n    readonly authenticatorData: ArrayBuffer;\n    /**\n     * The **`signature`** read-only property of the object which is the signature of the authenticator for both the client data (AuthenticatorResponse.clientDataJSON).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAssertionResponse/signature)\n     */\n    readonly signature: ArrayBuffer;\n    /**\n     * The **`userHandle`** read-only property of the AuthenticatorAssertionResponse interface is an ArrayBuffer object providing an opaque identifier for the given user.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAssertionResponse/userHandle)\n     */\n    readonly userHandle: ArrayBuffer | null;\n}\n\ndeclare var AuthenticatorAssertionResponse: {\n    prototype: AuthenticatorAssertionResponse;\n    new(): AuthenticatorAssertionResponse;\n};\n\n/**\n * The **`AuthenticatorAttestationResponse`** interface of the Web Authentication API is the result of a WebAuthn credential registration.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAttestationResponse)\n */\ninterface AuthenticatorAttestationResponse extends AuthenticatorResponse {\n    /**\n     * The **`attestationObject`** property of the entire `attestationObject` with a private key that is stored in the authenticator when it is manufactured.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAttestationResponse/attestationObject)\n     */\n    readonly attestationObject: ArrayBuffer;\n    /**\n     * The **`getAuthenticatorData()`** method of the AuthenticatorAttestationResponse interface returns an ArrayBuffer containing the authenticator data contained within the AuthenticatorAttestationResponse.attestationObject property.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAttestationResponse/getAuthenticatorData)\n     */\n    getAuthenticatorData(): ArrayBuffer;\n    /**\n     * The **`getPublicKey()`** method of the AuthenticatorAttestationResponse interface returns an ArrayBuffer containing the DER `SubjectPublicKeyInfo` of the new credential (see Subject Public Key Info), or `null` if this is not available.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAttestationResponse/getPublicKey)\n     */\n    getPublicKey(): ArrayBuffer | null;\n    /**\n     * The **`getPublicKeyAlgorithm()`** method of the AuthenticatorAttestationResponse interface returns a number that is equal to a COSE Algorithm Identifier, representing the cryptographic algorithm used for the new credential.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAttestationResponse/getPublicKeyAlgorithm)\n     */\n    getPublicKeyAlgorithm(): COSEAlgorithmIdentifier;\n    /**\n     * The **`getTransports()`** method of the AuthenticatorAttestationResponse interface returns an array of strings describing the different transports which may be used by the authenticator.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorAttestationResponse/getTransports)\n     */\n    getTransports(): string[];\n}\n\ndeclare var AuthenticatorAttestationResponse: {\n    prototype: AuthenticatorAttestationResponse;\n    new(): AuthenticatorAttestationResponse;\n};\n\n/**\n * The **`AuthenticatorResponse`** interface of the Web Authentication API is the base interface for interfaces that provide a cryptographic root of trust for a key pair.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorResponse)\n */\ninterface AuthenticatorResponse {\n    /**\n     * The **`clientDataJSON`** property of the AuthenticatorResponse interface stores a JSON string in an An ArrayBuffer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/AuthenticatorResponse/clientDataJSON)\n     */\n    readonly clientDataJSON: ArrayBuffer;\n}\n\ndeclare var AuthenticatorResponse: {\n    prototype: AuthenticatorResponse;\n    new(): AuthenticatorResponse;\n};\n\n/**\n * The **`BarProp`** interface of the Document Object Model represents the web browser user interface elements that are exposed to scripts in web pages.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BarProp)\n */\ninterface BarProp {\n    /**\n     * The **`visible`** read-only property of the BarProp interface returns `true` if the user interface element it represents is visible.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BarProp/visible)\n     */\n    readonly visible: boolean;\n}\n\ndeclare var BarProp: {\n    prototype: BarProp;\n    new(): BarProp;\n};\n\ninterface BaseAudioContextEventMap {\n    \"statechange\": Event;\n}\n\n/**\n * The `BaseAudioContext` interface of the Web Audio API acts as a base definition for online and offline audio-processing graphs, as represented by AudioContext and OfflineAudioContext respectively.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext)\n */\ninterface BaseAudioContext extends EventTarget {\n    /**\n     * The `audioWorklet` read-only property of the processing.\n     * Available only in secure contexts.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/audioWorklet)\n     */\n    readonly audioWorklet: AudioWorklet;\n    /**\n     * The `currentTime` read-only property of the BaseAudioContext interface returns a double representing an ever-increasing hardware timestamp in seconds that can be used for scheduling audio playback, visualizing timelines, etc.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/currentTime)\n     */\n    readonly currentTime: number;\n    /**\n     * The `destination` property of the BaseAudioContext interface returns an AudioDestinationNode representing the final destination of all audio in the context.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/destination)\n     */\n    readonly destination: AudioDestinationNode;\n    /**\n     * The `listener` property of the BaseAudioContext interface returns an AudioListener object that can then be used for implementing 3D audio spatialization.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/listener)\n     */\n    readonly listener: AudioListener;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/statechange_event) */\n    onstatechange: ((this: BaseAudioContext, ev: Event) => any) | null;\n    /**\n     * The `sampleRate` property of the BaseAudioContext interface returns a floating point number representing the sample rate, in samples per second, used by all nodes in this audio context.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/sampleRate)\n     */\n    readonly sampleRate: number;\n    /**\n     * The `state` read-only property of the BaseAudioContext interface returns the current state of the `AudioContext`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/state)\n     */\n    readonly state: AudioContextState;\n    /**\n     * The `createAnalyser()` method of the can be used to expose audio time and frequency data and create data visualizations.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createAnalyser)\n     */\n    createAnalyser(): AnalyserNode;\n    /**\n     * The `createBiquadFilter()` method of the BaseAudioContext interface creates a BiquadFilterNode, which represents a second order filter configurable as several different common filter types.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createBiquadFilter)\n     */\n    createBiquadFilter(): BiquadFilterNode;\n    /**\n     * The `createBuffer()` method of the BaseAudioContext Interface is used to create a new, empty AudioBuffer object, which can then be populated by data, and played via an AudioBufferSourceNode.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createBuffer)\n     */\n    createBuffer(numberOfChannels: number, length: number, sampleRate: number): AudioBuffer;\n    /**\n     * The `createBufferSource()` method of the BaseAudioContext Interface is used to create a new AudioBufferSourceNode, which can be used to play audio data contained within an AudioBuffer object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createBufferSource)\n     */\n    createBufferSource(): AudioBufferSourceNode;\n    /**\n     * The `createChannelMerger()` method of the BaseAudioContext interface creates a ChannelMergerNode, which combines channels from multiple audio streams into a single audio stream.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createChannelMerger)\n     */\n    createChannelMerger(numberOfInputs?: number): ChannelMergerNode;\n    /**\n     * The `createChannelSplitter()` method of the BaseAudioContext Interface is used to create a ChannelSplitterNode, which is used to access the individual channels of an audio stream and process them separately.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createChannelSplitter)\n     */\n    createChannelSplitter(numberOfOutputs?: number): ChannelSplitterNode;\n    /**\n     * The **`createConstantSource()`** property of the BaseAudioContext interface creates a outputs a monaural (one-channel) sound signal whose samples all have the same value.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createConstantSource)\n     */\n    createConstantSource(): ConstantSourceNode;\n    /**\n     * The `createConvolver()` method of the BaseAudioContext interface creates a ConvolverNode, which is commonly used to apply reverb effects to your audio.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createConvolver)\n     */\n    createConvolver(): ConvolverNode;\n    /**\n     * The `createDelay()` method of the which is used to delay the incoming audio signal by a certain amount of time.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createDelay)\n     */\n    createDelay(maxDelayTime?: number): DelayNode;\n    /**\n     * The `createDynamicsCompressor()` method of the BaseAudioContext Interface is used to create a DynamicsCompressorNode, which can be used to apply compression to an audio signal.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createDynamicsCompressor)\n     */\n    createDynamicsCompressor(): DynamicsCompressorNode;\n    /**\n     * The `createGain()` method of the BaseAudioContext interface creates a GainNode, which can be used to control the overall gain (or volume) of the audio graph.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createGain)\n     */\n    createGain(): GainNode;\n    /**\n     * The **`createIIRFilter()`** method of the BaseAudioContext interface creates an IIRFilterNode, which represents a general **infinite impulse response** (IIR) filter which can be configured to serve as various types of filter.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createIIRFilter)\n     */\n    createIIRFilter(feedforward: number[], feedback: number[]): IIRFilterNode;\n    /**\n     * The `createOscillator()` method of the BaseAudioContext interface creates an OscillatorNode, a source representing a periodic waveform.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createOscillator)\n     */\n    createOscillator(): OscillatorNode;\n    /**\n     * The `createPanner()` method of the BaseAudioContext Interface is used to create a new PannerNode, which is used to spatialize an incoming audio stream in 3D space.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createPanner)\n     */\n    createPanner(): PannerNode;\n    /**\n     * The `createPeriodicWave()` method of the BaseAudioContext interface is used to create a PeriodicWave.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createPeriodicWave)\n     */\n    createPeriodicWave(real: number[] | Float32Array, imag: number[] | Float32Array, constraints?: PeriodicWaveConstraints): PeriodicWave;\n    /**\n     * The `createScriptProcessor()` method of the BaseAudioContext interface creates a ScriptProcessorNode used for direct audio processing.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createScriptProcessor)\n     */\n    createScriptProcessor(bufferSize?: number, numberOfInputChannels?: number, numberOfOutputChannels?: number): ScriptProcessorNode;\n    /**\n     * The `createStereoPanner()` method of the BaseAudioContext interface creates a StereoPannerNode, which can be used to apply stereo panning to an audio source.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createStereoPanner)\n     */\n    createStereoPanner(): StereoPannerNode;\n    /**\n     * The `createWaveShaper()` method of the BaseAudioContext interface creates a WaveShaperNode, which represents a non-linear distortion.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/createWaveShaper)\n     */\n    createWaveShaper(): WaveShaperNode;\n    /**\n     * The `decodeAudioData()` method of the BaseAudioContext Interface is used to asynchronously decode audio file data contained in an rate, then passed to a callback or promise.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BaseAudioContext/decodeAudioData)\n     */\n    decodeAudioData(audioData: ArrayBuffer, successCallback?: DecodeSuccessCallback | null, errorCallback?: DecodeErrorCallback | null): Promise<AudioBuffer>;\n    addEventListener<K extends keyof BaseAudioContextEventMap>(type: K, listener: (this: BaseAudioContext, ev: BaseAudioContextEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof BaseAudioContextEventMap>(type: K, listener: (this: BaseAudioContext, ev: BaseAudioContextEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var BaseAudioContext: {\n    prototype: BaseAudioContext;\n    new(): BaseAudioContext;\n};\n\n/**\n * The **`BeforeUnloadEvent`** interface represents the event object for the Window/beforeunload_event event, which is fired when the current window, contained document, and associated resources are about to be unloaded.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BeforeUnloadEvent)\n */\ninterface BeforeUnloadEvent extends Event {\n    /**\n     * The **`returnValue`** property of the `returnValue` is initialized to an empty string (`''`) value.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BeforeUnloadEvent/returnValue)\n     */\n    returnValue: any;\n}\n\ndeclare var BeforeUnloadEvent: {\n    prototype: BeforeUnloadEvent;\n    new(): BeforeUnloadEvent;\n};\n\n/**\n * The `BiquadFilterNode` interface represents a simple low-order filter, and is created using the BaseAudioContext/createBiquadFilter method.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BiquadFilterNode)\n */\ninterface BiquadFilterNode extends AudioNode {\n    /**\n     * The `Q` property of the BiquadFilterNode interface is an a-rate AudioParam, a double representing a Q factor, or _quality factor_.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BiquadFilterNode/Q)\n     */\n    readonly Q: AudioParam;\n    /**\n     * The `detune` property of the BiquadFilterNode interface is an a-rate AudioParam representing detuning of the frequency in cents.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BiquadFilterNode/detune)\n     */\n    readonly detune: AudioParam;\n    /**\n     * The `frequency` property of the BiquadFilterNode interface is an a-rate AudioParam — a double representing a frequency in the current filtering algorithm measured in hertz (Hz).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BiquadFilterNode/frequency)\n     */\n    readonly frequency: AudioParam;\n    /**\n     * The `gain` property of the BiquadFilterNode interface is an a-rate AudioParam — a double representing the gain used in the current filtering algorithm.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BiquadFilterNode/gain)\n     */\n    readonly gain: AudioParam;\n    /**\n     * The `type` property of the BiquadFilterNode interface is a string (enum) value defining the kind of filtering algorithm the node is implementing.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BiquadFilterNode/type)\n     */\n    type: BiquadFilterType;\n    /**\n     * The `getFrequencyResponse()` method of the BiquadFilterNode interface takes the current filtering algorithm's settings and calculates the frequency response for frequencies specified in a specified array of frequencies.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BiquadFilterNode/getFrequencyResponse)\n     */\n    getFrequencyResponse(frequencyHz: Float32Array<ArrayBuffer>, magResponse: Float32Array<ArrayBuffer>, phaseResponse: Float32Array<ArrayBuffer>): void;\n}\n\ndeclare var BiquadFilterNode: {\n    prototype: BiquadFilterNode;\n    new(context: BaseAudioContext, options?: BiquadFilterOptions): BiquadFilterNode;\n};\n\n/**\n * The **`Blob`** interface represents a blob, which is a file-like object of immutable, raw data; they can be read as text or binary data, or converted into a ReadableStream so its methods can be used for processing the data.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob)\n */\ninterface Blob {\n    /**\n     * The **`size`** read-only property of the Blob interface returns the size of the Blob or File in bytes.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/size)\n     */\n    readonly size: number;\n    /**\n     * The **`type`** read-only property of the Blob interface returns the MIME type of the file.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/type)\n     */\n    readonly type: string;\n    /**\n     * The **`arrayBuffer()`** method of the Blob interface returns a Promise that resolves with the contents of the blob as binary data contained in an ArrayBuffer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/arrayBuffer)\n     */\n    arrayBuffer(): Promise<ArrayBuffer>;\n    /**\n     * The **`bytes()`** method of the Blob interface returns a Promise that resolves with a Uint8Array containing the contents of the blob as an array of bytes.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/bytes)\n     */\n    bytes(): Promise<Uint8Array<ArrayBuffer>>;\n    /**\n     * The **`slice()`** method of the Blob interface creates and returns a new `Blob` object which contains data from a subset of the blob on which it's called.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/slice)\n     */\n    slice(start?: number, end?: number, contentType?: string): Blob;\n    /**\n     * The **`stream()`** method of the Blob interface returns a ReadableStream which upon reading returns the data contained within the `Blob`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/stream)\n     */\n    stream(): ReadableStream<Uint8Array<ArrayBuffer>>;\n    /**\n     * The **`text()`** method of the string containing the contents of the blob, interpreted as UTF-8.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Blob/text)\n     */\n    text(): Promise<string>;\n}\n\ndeclare var Blob: {\n    prototype: Blob;\n    new(blobParts?: BlobPart[], options?: BlobPropertyBag): Blob;\n};\n\n/**\n * The **`BlobEvent`** interface of the MediaStream Recording API represents events associated with a Blob.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BlobEvent)\n */\ninterface BlobEvent extends Event {\n    /**\n     * The **`data`** read-only property of the BlobEvent interface represents a Blob associated with the event.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BlobEvent/data)\n     */\n    readonly data: Blob;\n    /**\n     * The **`timecode`** read-only property of the BlobEvent interface indicates the difference between the timestamp of the first chunk of data, and the timestamp of the first chunk in the first `BlobEvent` produced by this recorder.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BlobEvent/timecode)\n     */\n    readonly timecode: DOMHighResTimeStamp;\n}\n\ndeclare var BlobEvent: {\n    prototype: BlobEvent;\n    new(type: string, eventInitDict: BlobEventInit): BlobEvent;\n};\n\ninterface Body {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/body) */\n    readonly body: ReadableStream<Uint8Array<ArrayBuffer>> | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/bodyUsed) */\n    readonly bodyUsed: boolean;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/arrayBuffer) */\n    arrayBuffer(): Promise<ArrayBuffer>;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/blob) */\n    blob(): Promise<Blob>;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/bytes) */\n    bytes(): Promise<Uint8Array<ArrayBuffer>>;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/formData) */\n    formData(): Promise<FormData>;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/json) */\n    json(): Promise<any>;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Request/text) */\n    text(): Promise<string>;\n}\n\ninterface BroadcastChannelEventMap {\n    \"message\": MessageEvent;\n    \"messageerror\": MessageEvent;\n}\n\n/**\n * The **`BroadcastChannel`** interface represents a named channel that any browsing context of a given origin can subscribe to.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BroadcastChannel)\n */\ninterface BroadcastChannel extends EventTarget {\n    /**\n     * The **`name`** read-only property of the BroadcastChannel interface returns a string, which uniquely identifies the given channel with its name.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BroadcastChannel/name)\n     */\n    readonly name: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BroadcastChannel/message_event) */\n    onmessage: ((this: BroadcastChannel, ev: MessageEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/BroadcastChannel/messageerror_event) */\n    onmessageerror: ((this: BroadcastChannel, ev: MessageEvent) => any) | null;\n    /**\n     * The **`close()`** method of the BroadcastChannel interface terminates the connection to the underlying channel, allowing the object to be garbage collected.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BroadcastChannel/close)\n     */\n    close(): void;\n    /**\n     * The **`postMessage()`** method of the BroadcastChannel interface sends a message, which can be of any kind of Object, to each listener in any browsing context with the same origin.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/BroadcastChannel/postMessage)\n     */\n    postMessage(message: any): void;\n    addEventListener<K extends keyof BroadcastChannelEventMap>(type: K, listener: (this: BroadcastChannel, ev: BroadcastChannelEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof BroadcastChannelEventMap>(type: K, listener: (this: BroadcastChannel, ev: BroadcastChannelEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var BroadcastChannel: {\n    prototype: BroadcastChannel;\n    new(name: string): BroadcastChannel;\n};\n\n/**\n * The **`ByteLengthQueuingStrategy`** interface of the Streams API provides a built-in byte length queuing strategy that can be used when constructing streams.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ByteLengthQueuingStrategy)\n */\ninterface ByteLengthQueuingStrategy extends QueuingStrategy<ArrayBufferView> {\n    /**\n     * The read-only **`ByteLengthQueuingStrategy.highWaterMark`** property returns the total number of bytes that can be contained in the internal queue before backpressure is applied.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ByteLengthQueuingStrategy/highWaterMark)\n     */\n    readonly highWaterMark: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/ByteLengthQueuingStrategy/size) */\n    readonly size: QueuingStrategySize<ArrayBufferView>;\n}\n\ndeclare var ByteLengthQueuingStrategy: {\n    prototype: ByteLengthQueuingStrategy;\n    new(init: QueuingStrategyInit): ByteLengthQueuingStrategy;\n};\n\n/**\n * The **`CDATASection`** interface represents a CDATA section that can be used within XML to include extended portions of unescaped text.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CDATASection)\n */\ninterface CDATASection extends Text {\n}\n\ndeclare var CDATASection: {\n    prototype: CDATASection;\n    new(): CDATASection;\n};\n\n/**\n * The `CSPViolationReportBody` interface is an extension of the Reporting API that represents the body of a Content Security Policy (CSP) violation report.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSPViolationReportBody)\n */\ninterface CSPViolationReportBody extends ReportBody {\n    /**\n     * The **`blockedURL`** read-only property of the CSPViolationReportBody interface is a string value that represents the resource that was blocked because it violates a Content Security Policy (CSP).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSPViolationReportBody/blockedURL)\n     */\n    readonly blockedURL: string | null;\n    /**\n     * The **`columnNumber`** read-only property of the CSPViolationReportBody interface indicates the column number in the source file that triggered the Content Security Policy (CSP) violation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSPViolationReportBody/columnNumber)\n     */\n    readonly columnNumber: number | null;\n    /**\n     * The **`disposition`** read-only property of the CSPViolationReportBody interface indicates whether the user agent is configured to enforce Content Security Policy (CSP) violations or only report them.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSPViolationReportBody/disposition)\n     */\n    readonly disposition: SecurityPolicyViolationEventDisposition;\n    /**\n     * The **`documentURL`** read-only property of the CSPViolationReportBody interface is a string that represents the URL of the document or worker that violated the Content Security Policy (CSP).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSPViolationReportBody/documentURL)\n     */\n    readonly documentURL: string;\n    /**\n     * The **`effectiveDirective`** read-only property of the CSPViolationReportBody interface is a string that represents the effective Content Security Policy (CSP) directive that was violated.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSPViolationReportBody/effectiveDirective)\n     */\n    readonly effectiveDirective: string;\n    /**\n     * The **`lineNumber`** read-only property of the CSPViolationReportBody interface indicates the line number in the source file that triggered the Content Security Policy (CSP) violation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSPViolationReportBody/lineNumber)\n     */\n    readonly lineNumber: number | null;\n    /**\n     * The **`originalPolicy`** read-only property of the CSPViolationReportBody interface is a string that represents the Content Security Policy (CSP) whose enforcement uncovered the violation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSPViolationReportBody/originalPolicy)\n     */\n    readonly originalPolicy: string;\n    /**\n     * The **`referrer`** read-only property of the CSPViolationReportBody interface is a string that represents the URL of the referring page of the resource who's Content Security Policy (CSP) was violated.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSPViolationReportBody/referrer)\n     */\n    readonly referrer: string | null;\n    /**\n     * The **`sample`** read-only property of the CSPViolationReportBody interface is a string that contains a part of the resource that violated the Content Security Policy (CSP).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSPViolationReportBody/sample)\n     */\n    readonly sample: string | null;\n    /**\n     * The **`sourceFile`** read-only property of the CSPViolationReportBody interface indicates the URL of the source file that violated the Content Security Policy (CSP).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSPViolationReportBody/sourceFile)\n     */\n    readonly sourceFile: string | null;\n    /**\n     * The **`statusCode`** read-only property of the CSPViolationReportBody interface is a number representing the HTTP status code of the response to the request that triggered a Content Security Policy (CSP) violation (when loading a window or worker).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSPViolationReportBody/statusCode)\n     */\n    readonly statusCode: number;\n    /**\n     * The **`toJSON()`** method of the CSPViolationReportBody interface is a _serializer_, which returns a JSON representation of the `CSPViolationReportBody` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSPViolationReportBody/toJSON)\n     */\n    toJSON(): any;\n}\n\ndeclare var CSPViolationReportBody: {\n    prototype: CSPViolationReportBody;\n    new(): CSPViolationReportBody;\n};\n\n/**\n * The **`CSSAnimation`** interface of the Web Animations API represents an Animation object.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSAnimation)\n */\ninterface CSSAnimation extends Animation {\n    /**\n     * The **`animationName`** property of the specifies one or more keyframe at-rules which describe the animation applied to the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSAnimation/animationName)\n     */\n    readonly animationName: string;\n    addEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: CSSAnimation, ev: AnimationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: CSSAnimation, ev: AnimationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var CSSAnimation: {\n    prototype: CSSAnimation;\n    new(): CSSAnimation;\n};\n\n/**\n * An object implementing the **`CSSConditionRule`** interface represents a single condition CSS at-rule, which consists of a condition and a statement block.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSConditionRule)\n */\ninterface CSSConditionRule extends CSSGroupingRule {\n    /**\n     * The read-only **`conditionText`** property of the CSSConditionRule interface returns or sets the text of the CSS rule.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSConditionRule/conditionText)\n     */\n    readonly conditionText: string;\n}\n\ndeclare var CSSConditionRule: {\n    prototype: CSSConditionRule;\n    new(): CSSConditionRule;\n};\n\n/**\n * The **`CSSContainerRule`** interface represents a single CSS @container rule.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSContainerRule)\n */\ninterface CSSContainerRule extends CSSConditionRule {\n    /**\n     * The read-only **`containerName`** property of the CSSContainerRule interface represents the container name of the associated CSS @container at-rule.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSContainerRule/containerName)\n     */\n    readonly containerName: string;\n    /**\n     * The read-only **`containerQuery`** property of the CSSContainerRule interface returns a string representing the container conditions that are evaluated when the container changes size in order to determine if the styles in the associated @container are applied.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSContainerRule/containerQuery)\n     */\n    readonly containerQuery: string;\n}\n\ndeclare var CSSContainerRule: {\n    prototype: CSSContainerRule;\n    new(): CSSContainerRule;\n};\n\n/**\n * The **`CSSCounterStyleRule`** interface represents an @counter-style at-rule.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule)\n */\ninterface CSSCounterStyleRule extends CSSRule {\n    /**\n     * The **`additiveSymbols`** property of the CSSCounterStyleRule interface gets and sets the value of the @counter-style/additive-symbols descriptor.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/additiveSymbols)\n     */\n    additiveSymbols: string;\n    /**\n     * The **`fallback`** property of the CSSCounterStyleRule interface gets and sets the value of the @counter-style/fallback descriptor.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/fallback)\n     */\n    fallback: string;\n    /**\n     * The **`name`** property of the CSSCounterStyleRule interface gets and sets the &lt;custom-ident&gt; defined as the `name` for the associated rule.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/name)\n     */\n    name: string;\n    /**\n     * The **`negative`** property of the CSSCounterStyleRule interface gets and sets the value of the @counter-style/negative descriptor.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/negative)\n     */\n    negative: string;\n    /**\n     * The **`pad`** property of the CSSCounterStyleRule interface gets and sets the value of the @counter-style/pad descriptor.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/pad)\n     */\n    pad: string;\n    /**\n     * The **`prefix`** property of the CSSCounterStyleRule interface gets and sets the value of the @counter-style/prefix descriptor.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/prefix)\n     */\n    prefix: string;\n    /**\n     * The **`range`** property of the CSSCounterStyleRule interface gets and sets the value of the @counter-style/range descriptor.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/range)\n     */\n    range: string;\n    /**\n     * The **`speakAs`** property of the CSSCounterStyleRule interface gets and sets the value of the @counter-style/speak-as descriptor.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/speakAs)\n     */\n    speakAs: string;\n    /**\n     * The **`suffix`** property of the CSSCounterStyleRule interface gets and sets the value of the @counter-style/suffix descriptor.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/suffix)\n     */\n    suffix: string;\n    /**\n     * The **`symbols`** property of the CSSCounterStyleRule interface gets and sets the value of the @counter-style/symbols descriptor.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/symbols)\n     */\n    symbols: string;\n    /**\n     * The **`system`** property of the CSSCounterStyleRule interface gets and sets the value of the @counter-style/system descriptor.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSCounterStyleRule/system)\n     */\n    system: string;\n}\n\ndeclare var CSSCounterStyleRule: {\n    prototype: CSSCounterStyleRule;\n    new(): CSSCounterStyleRule;\n};\n\n/**\n * The **`CSSFontFaceRule`** interface represents an @font-face at-rule.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontFaceRule)\n */\ninterface CSSFontFaceRule extends CSSRule {\n    /**\n     * The read-only **`style`** property of the CSSFontFaceRule interface returns the style information from the @font-face at-rule.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontFaceRule/style)\n     */\n    get style(): CSSStyleDeclaration;\n    set style(cssText: string);\n}\n\ndeclare var CSSFontFaceRule: {\n    prototype: CSSFontFaceRule;\n    new(): CSSFontFaceRule;\n};\n\n/**\n * The **`CSSFontFeatureValuesRule`** interface represents an @font-feature-values at-rule, letting developers assign for each font face a common name to specify features indices to be used in font-variant-alternates.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontFeatureValuesRule)\n */\ninterface CSSFontFeatureValuesRule extends CSSRule {\n    /**\n     * The **`fontFamily`** property of the CSSConditionRule interface represents the name of the font family it applies to.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontFeatureValuesRule/fontFamily)\n     */\n    fontFamily: string;\n}\n\ndeclare var CSSFontFeatureValuesRule: {\n    prototype: CSSFontFeatureValuesRule;\n    new(): CSSFontFeatureValuesRule;\n};\n\n/**\n * The **`CSSFontPaletteValuesRule`** interface represents an @font-palette-values at-rule.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontPaletteValuesRule)\n */\ninterface CSSFontPaletteValuesRule extends CSSRule {\n    /**\n     * The read-only **`basePalette`** property of the CSSFontPaletteValuesRule interface indicates the base palette associated with the rule.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontPaletteValuesRule/basePalette)\n     */\n    readonly basePalette: string;\n    /**\n     * The read-only **`fontFamily`** property of the CSSFontPaletteValuesRule interface lists the font families the rule can be applied to.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontPaletteValuesRule/fontFamily)\n     */\n    readonly fontFamily: string;\n    /**\n     * The read-only **`name`** property of the CSSFontPaletteValuesRule interface represents the name identifying the associated @font-palette-values at-rule.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontPaletteValuesRule/name)\n     */\n    readonly name: string;\n    /**\n     * The read-only **`overrideColors`** property of the CSSFontPaletteValuesRule interface is a string containing a list of color index and color pair that are to be used instead.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSFontPaletteValuesRule/overrideColors)\n     */\n    readonly overrideColors: string;\n}\n\ndeclare var CSSFontPaletteValuesRule: {\n    prototype: CSSFontPaletteValuesRule;\n    new(): CSSFontPaletteValuesRule;\n};\n\n/**\n * The **`CSSGroupingRule`** interface of the CSS Object Model represents any CSS at-rule that contains other rules nested within it.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSGroupingRule)\n */\ninterface CSSGroupingRule extends CSSRule {\n    /**\n     * The **`cssRules`** property of the a collection of CSSRule objects.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSGroupingRule/cssRules)\n     */\n    readonly cssRules: CSSRuleList;\n    /**\n     * The **`deleteRule()`** method of the rules.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSGroupingRule/deleteRule)\n     */\n    deleteRule(index: number): void;\n    /**\n     * The **`insertRule()`** method of the ```js-nolint insertRule(rule) insertRule(rule, index) ``` - `rule` - : A string - `index` [MISSING: optional_inline] - : An optional index at which to insert the rule; defaults to 0.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSGroupingRule/insertRule)\n     */\n    insertRule(rule: string, index?: number): number;\n}\n\ndeclare var CSSGroupingRule: {\n    prototype: CSSGroupingRule;\n    new(): CSSGroupingRule;\n};\n\n/**\n * The **`CSSImageValue`** interface of the CSS Typed Object Model API represents values for properties that take an image, for example background-image, list-style-image, or border-image-source.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSImageValue)\n */\ninterface CSSImageValue extends CSSStyleValue {\n}\n\ndeclare var CSSImageValue: {\n    prototype: CSSImageValue;\n    new(): CSSImageValue;\n};\n\n/**\n * The **`CSSImportRule`** interface represents an @import at-rule.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSImportRule)\n */\ninterface CSSImportRule extends CSSRule {\n    /**\n     * The read-only **`href`** property of the The resolved URL will be the `href` attribute of the associated stylesheet.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSImportRule/href)\n     */\n    readonly href: string;\n    /**\n     * The read-only **`layerName`** property of the CSSImportRule interface returns the name of the cascade layer created by the @import at-rule.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSImportRule/layerName)\n     */\n    readonly layerName: string | null;\n    /**\n     * The read-only **`media`** property of the containing the value of the `media` attribute of the associated stylesheet.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSImportRule/media)\n     */\n    get media(): MediaList;\n    set media(mediaText: string);\n    /**\n     * The read-only **`styleSheet`** property of the in the form of a CSSStyleSheet object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSImportRule/styleSheet)\n     */\n    readonly styleSheet: CSSStyleSheet | null;\n    /**\n     * The read-only **`supportsText`** property of the CSSImportRule interface returns the supports condition specified by the @import at-rule.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSImportRule/supportsText)\n     */\n    readonly supportsText: string | null;\n}\n\ndeclare var CSSImportRule: {\n    prototype: CSSImportRule;\n    new(): CSSImportRule;\n};\n\n/**\n * The **`CSSKeyframeRule`** interface describes an object representing a set of styles for a given keyframe.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframeRule)\n */\ninterface CSSKeyframeRule extends CSSRule {\n    /**\n     * The **`keyText`** property of the CSSKeyframeRule interface represents the keyframe selector as a comma-separated list of percentage values.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframeRule/keyText)\n     */\n    keyText: string;\n    /**\n     * The read-only **`CSSKeyframeRule.style`** property is the CSSStyleDeclaration interface for the declaration block of the CSSKeyframeRule.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframeRule/style)\n     */\n    get style(): CSSStyleDeclaration;\n    set style(cssText: string);\n}\n\ndeclare var CSSKeyframeRule: {\n    prototype: CSSKeyframeRule;\n    new(): CSSKeyframeRule;\n};\n\n/**\n * The **`CSSKeyframesRule`** interface describes an object representing a complete set of keyframes for a CSS animation.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframesRule)\n */\ninterface CSSKeyframesRule extends CSSRule {\n    /**\n     * The read-only **`cssRules`** property of the CSSKeyframeRule interface returns a CSSRuleList containing the rules in the keyframes at-rule.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframesRule/cssRules)\n     */\n    readonly cssRules: CSSRuleList;\n    /**\n     * The read-only **`length`** property of the CSSKeyframeRule interface returns the number of CSSKeyframeRule objects in its list.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframesRule/length)\n     */\n    readonly length: number;\n    /**\n     * The **`name`** property of the CSSKeyframeRule interface gets and sets the name of the animation as used by the animation-name property.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframesRule/name)\n     */\n    name: string;\n    /**\n     * The **`appendRule()`** method of the CSSKeyframeRule interface appends a CSSKeyFrameRule to the end of the rules.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframesRule/appendRule)\n     */\n    appendRule(rule: string): void;\n    /**\n     * The **`deleteRule()`** method of the CSSKeyframeRule interface deletes the CSSKeyFrameRule that matches the specified keyframe selector.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframesRule/deleteRule)\n     */\n    deleteRule(select: string): void;\n    /**\n     * The **`findRule()`** method of the CSSKeyframeRule interface finds the CSSKeyFrameRule that matches the specified keyframe selector.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeyframesRule/findRule)\n     */\n    findRule(select: string): CSSKeyframeRule | null;\n    [index: number]: CSSKeyframeRule;\n}\n\ndeclare var CSSKeyframesRule: {\n    prototype: CSSKeyframesRule;\n    new(): CSSKeyframesRule;\n};\n\n/**\n * The **`CSSKeywordValue`** interface of the CSS Typed Object Model API creates an object to represent CSS keywords and other identifiers.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeywordValue)\n */\ninterface CSSKeywordValue extends CSSStyleValue {\n    /**\n     * The **`value`** property of the `CSSKeywordValue`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSKeywordValue/value)\n     */\n    value: string;\n}\n\ndeclare var CSSKeywordValue: {\n    prototype: CSSKeywordValue;\n    new(value: string): CSSKeywordValue;\n};\n\n/**\n * The **`CSSLayerBlockRule`** represents a @layer block rule.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSLayerBlockRule)\n */\ninterface CSSLayerBlockRule extends CSSGroupingRule {\n    /**\n     * The read-only **`name`** property of the CSSLayerBlockRule interface represents the name of the associated cascade layer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSLayerBlockRule/name)\n     */\n    readonly name: string;\n}\n\ndeclare var CSSLayerBlockRule: {\n    prototype: CSSLayerBlockRule;\n    new(): CSSLayerBlockRule;\n};\n\n/**\n * The **`CSSLayerStatementRule`** represents a @layer statement rule.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSLayerStatementRule)\n */\ninterface CSSLayerStatementRule extends CSSRule {\n    /**\n     * The read-only **`nameList`** property of the CSSLayerStatementRule interface return the list of associated cascade layer names.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSLayerStatementRule/nameList)\n     */\n    readonly nameList: ReadonlyArray<string>;\n}\n\ndeclare var CSSLayerStatementRule: {\n    prototype: CSSLayerStatementRule;\n    new(): CSSLayerStatementRule;\n};\n\ninterface CSSMathClamp extends CSSMathValue {\n    readonly lower: CSSNumericValue;\n    readonly upper: CSSNumericValue;\n    readonly value: CSSNumericValue;\n}\n\ndeclare var CSSMathClamp: {\n    prototype: CSSMathClamp;\n    new(lower: CSSNumberish, value: CSSNumberish, upper: CSSNumberish): CSSMathClamp;\n};\n\n/**\n * The **`CSSMathInvert`** interface of the CSS Typed Object Model API represents a CSS calc used as `calc(1 / <value>)`.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMathInvert)\n */\ninterface CSSMathInvert extends CSSMathValue {\n    /**\n     * The CSSMathInvert.value read-only property of the A CSSNumericValue.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMathInvert/value)\n     */\n    readonly value: CSSNumericValue;\n}\n\ndeclare var CSSMathInvert: {\n    prototype: CSSMathInvert;\n    new(arg: CSSNumberish): CSSMathInvert;\n};\n\n/**\n * The **`CSSMathMax`** interface of the CSS Typed Object Model API represents the CSS max function.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMathMax)\n */\ninterface CSSMathMax extends CSSMathValue {\n    /**\n     * The CSSMathMax.values read-only property of the which contains one or more CSSNumericValue objects.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMathMax/values)\n     */\n    readonly values: CSSNumericArray;\n}\n\ndeclare var CSSMathMax: {\n    prototype: CSSMathMax;\n    new(...args: CSSNumberish[]): CSSMathMax;\n};\n\n/**\n * The **`CSSMathMin`** interface of the CSS Typed Object Model API represents the CSS min function.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMathMin)\n */\ninterface CSSMathMin extends CSSMathValue {\n    /**\n     * The CSSMathMin.values read-only property of the which contains one or more CSSNumericValue objects.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMathMin/values)\n     */\n    readonly values: CSSNumericArray;\n}\n\ndeclare var CSSMathMin: {\n    prototype: CSSMathMin;\n    new(...args: CSSNumberish[]): CSSMathMin;\n};\n\n/**\n * The **`CSSMathNegate`** interface of the CSS Typed Object Model API negates the value passed into it.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMathNegate)\n */\ninterface CSSMathNegate extends CSSMathValue {\n    /**\n     * The CSSMathNegate.value read-only property of the A CSSNumericValue.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMathNegate/value)\n     */\n    readonly value: CSSNumericValue;\n}\n\ndeclare var CSSMathNegate: {\n    prototype: CSSMathNegate;\n    new(arg: CSSNumberish): CSSMathNegate;\n};\n\n/**\n * The **`CSSMathProduct`** interface of the CSS Typed Object Model API represents the result obtained by calling CSSNumericValue.add, CSSNumericValue.sub, or CSSNumericValue.toSum on CSSNumericValue.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMathProduct)\n */\ninterface CSSMathProduct extends CSSMathValue {\n    /**\n     * The **`CSSMathProduct.values`** read-only property of the CSSMathProduct interface returns a A CSSNumericArray.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMathProduct/values)\n     */\n    readonly values: CSSNumericArray;\n}\n\ndeclare var CSSMathProduct: {\n    prototype: CSSMathProduct;\n    new(...args: CSSNumberish[]): CSSMathProduct;\n};\n\n/**\n * The **`CSSMathSum`** interface of the CSS Typed Object Model API represents the result obtained by calling CSSNumericValue.add, CSSNumericValue.sub, or CSSNumericValue.toSum on CSSNumericValue.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMathSum)\n */\ninterface CSSMathSum extends CSSMathValue {\n    /**\n     * The **`CSSMathSum.values`** read-only property of the CSSMathSum interface returns a CSSNumericArray object which contains one or more CSSNumericValue objects.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMathSum/values)\n     */\n    readonly values: CSSNumericArray;\n}\n\ndeclare var CSSMathSum: {\n    prototype: CSSMathSum;\n    new(...args: CSSNumberish[]): CSSMathSum;\n};\n\n/**\n * The **`CSSMathValue`** interface of the CSS Typed Object Model API a base class for classes representing complex numeric values.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMathValue)\n */\ninterface CSSMathValue extends CSSNumericValue {\n    /**\n     * The **`CSSMathValue.operator`** read-only property of the CSSMathValue interface indicates the operator that the current subtype represents.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMathValue/operator)\n     */\n    readonly operator: CSSMathOperator;\n}\n\ndeclare var CSSMathValue: {\n    prototype: CSSMathValue;\n    new(): CSSMathValue;\n};\n\n/**\n * The **`CSSMatrixComponent`** interface of the CSS Typed Object Model API represents the matrix() and matrix3d() values of the individual transform property in CSS.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMatrixComponent)\n */\ninterface CSSMatrixComponent extends CSSTransformComponent {\n    /**\n     * The **`matrix`** property of the See the matrix() and matrix3d() pages for examples.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMatrixComponent/matrix)\n     */\n    matrix: DOMMatrix;\n}\n\ndeclare var CSSMatrixComponent: {\n    prototype: CSSMatrixComponent;\n    new(matrix: DOMMatrixReadOnly, options?: CSSMatrixComponentOptions): CSSMatrixComponent;\n};\n\n/**\n * The **`CSSMediaRule`** interface represents a single CSS @media rule.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMediaRule)\n */\ninterface CSSMediaRule extends CSSConditionRule {\n    /**\n     * The read-only **`media`** property of the destination medium for style information.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSMediaRule/media)\n     */\n    get media(): MediaList;\n    set media(mediaText: string);\n}\n\ndeclare var CSSMediaRule: {\n    prototype: CSSMediaRule;\n    new(): CSSMediaRule;\n};\n\n/**\n * The **`CSSNamespaceRule`** interface describes an object representing a single CSS @namespace at-rule.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNamespaceRule)\n */\ninterface CSSNamespaceRule extends CSSRule {\n    /**\n     * The read-only **`namespaceURI`** property of the CSSNamespaceRule returns a string containing the text of the URI of the given namespace.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNamespaceRule/namespaceURI)\n     */\n    readonly namespaceURI: string;\n    /**\n     * The read-only **`prefix`** property of the CSSNamespaceRule returns a string with the name of the prefix associated to this namespace.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNamespaceRule/prefix)\n     */\n    readonly prefix: string;\n}\n\ndeclare var CSSNamespaceRule: {\n    prototype: CSSNamespaceRule;\n    new(): CSSNamespaceRule;\n};\n\n/**\n * The **`CSSNestedDeclarations`** interface of the CSS Rule API is used to group nested CSSRules.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNestedDeclarations)\n */\ninterface CSSNestedDeclarations extends CSSRule {\n    /**\n     * The read-only **`style`** property of the CSSNestedDeclarations interface represents the styles associated with the nested rules.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNestedDeclarations/style)\n     */\n    get style(): CSSStyleDeclaration;\n    set style(cssText: string);\n}\n\ndeclare var CSSNestedDeclarations: {\n    prototype: CSSNestedDeclarations;\n    new(): CSSNestedDeclarations;\n};\n\n/**\n * The **`CSSNumericArray`** interface of the CSS Typed Object Model API contains a list of CSSNumericValue objects.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNumericArray)\n */\ninterface CSSNumericArray {\n    /**\n     * The read-only **`length`** property of the An integer representing the number of CSSNumericValue objects in the list.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNumericArray/length)\n     */\n    readonly length: number;\n    forEach(callbackfn: (value: CSSNumericValue, key: number, parent: CSSNumericArray) => void, thisArg?: any): void;\n    [index: number]: CSSNumericValue;\n}\n\ndeclare var CSSNumericArray: {\n    prototype: CSSNumericArray;\n    new(): CSSNumericArray;\n};\n\n/**\n * The **`CSSNumericValue`** interface of the CSS Typed Object Model API represents operations that all numeric values can perform.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNumericValue)\n */\ninterface CSSNumericValue extends CSSStyleValue {\n    /**\n     * The **`add()`** method of the `CSSNumericValue`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNumericValue/add)\n     */\n    add(...values: CSSNumberish[]): CSSNumericValue;\n    /**\n     * The **`div()`** method of the supplied value.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNumericValue/div)\n     */\n    div(...values: CSSNumberish[]): CSSNumericValue;\n    /**\n     * The **`equals()`** method of the value are strictly equal.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNumericValue/equals)\n     */\n    equals(...value: CSSNumberish[]): boolean;\n    /**\n     * The **`max()`** method of the passed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNumericValue/max)\n     */\n    max(...values: CSSNumberish[]): CSSNumericValue;\n    /**\n     * The **`min()`** method of the values passed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNumericValue/min)\n     */\n    min(...values: CSSNumberish[]): CSSNumericValue;\n    /**\n     * The **`mul()`** method of the the supplied value.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNumericValue/mul)\n     */\n    mul(...values: CSSNumberish[]): CSSNumericValue;\n    /**\n     * The **`sub()`** method of the `CSSNumericValue`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNumericValue/sub)\n     */\n    sub(...values: CSSNumberish[]): CSSNumericValue;\n    /**\n     * The **`to()`** method of the another.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNumericValue/to)\n     */\n    to(unit: string): CSSUnitValue;\n    /**\n     * The **`toSum()`** method of the ```js-nolint toSum(units) ``` - `units` - : The units to convert to.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNumericValue/toSum)\n     */\n    toSum(...units: string[]): CSSMathSum;\n    /**\n     * The **`type()`** method of the `CSSNumericValue`, one of `angle`, `flex`, `frequency`, `length`, `resolution`, `percent`, `percentHint`, or `time`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNumericValue/type)\n     */\n    type(): CSSNumericType;\n}\n\ndeclare var CSSNumericValue: {\n    prototype: CSSNumericValue;\n    new(): CSSNumericValue;\n    /**\n     * The **`parse()`** static method of the members are value and the units.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSNumericValue/parse_static)\n     */\n    parse(cssText: string): CSSNumericValue;\n};\n\n/**\n * **`CSSPageRule`** represents a single CSS @page rule.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPageRule)\n */\ninterface CSSPageRule extends CSSGroupingRule {\n    /**\n     * The **`selectorText`** property of the CSSPageRule interface gets and sets the selectors associated with the `CSSPageRule`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPageRule/selectorText)\n     */\n    selectorText: string;\n    /**\n     * The **`style`** read-only property of the CSSPageRule interface returns a CSSPageDescriptors object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPageRule/style)\n     */\n    get style(): CSSStyleDeclaration;\n    set style(cssText: string);\n}\n\ndeclare var CSSPageRule: {\n    prototype: CSSPageRule;\n    new(): CSSPageRule;\n};\n\n/**\n * The **`CSSPerspective`** interface of the CSS Typed Object Model API represents the perspective() value of the individual transform property in CSS.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPerspective)\n */\ninterface CSSPerspective extends CSSTransformComponent {\n    /**\n     * The **`length`** property of the It is used to apply a perspective transform to the element and its content.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPerspective/length)\n     */\n    length: CSSPerspectiveValue;\n}\n\ndeclare var CSSPerspective: {\n    prototype: CSSPerspective;\n    new(length: CSSPerspectiveValue): CSSPerspective;\n};\n\n/**\n * The **`CSSPropertyRule`** interface of the CSS Properties and Values API represents a single CSS @property rule.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPropertyRule)\n */\ninterface CSSPropertyRule extends CSSRule {\n    /**\n     * The read-only **`inherits`** property of the CSSPropertyRule interface returns the inherit flag of the custom property registration represented by the @property rule, a boolean describing whether or not the property inherits by default.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPropertyRule/inherits)\n     */\n    readonly inherits: boolean;\n    /**\n     * The read-only **`initialValue`** nullable property of the CSSPropertyRule interface returns the initial value of the custom property registration represented by the @property rule, controlling the property's initial value.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPropertyRule/initialValue)\n     */\n    readonly initialValue: string | null;\n    /**\n     * The read-only **`name`** property of the CSSPropertyRule interface represents the property name, this being the serialization of the name given to the custom property in the @property rule's prelude.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPropertyRule/name)\n     */\n    readonly name: string;\n    /**\n     * The read-only **`syntax`** property of the CSSPropertyRule interface returns the literal syntax of the custom property registration represented by the @property rule, controlling how the property's value is parsed at computed-value time.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSPropertyRule/syntax)\n     */\n    readonly syntax: string;\n}\n\ndeclare var CSSPropertyRule: {\n    prototype: CSSPropertyRule;\n    new(): CSSPropertyRule;\n};\n\n/**\n * The **`CSSRotate`** interface of the CSS Typed Object Model API represents the rotate value of the individual transform property in CSS.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRotate)\n */\ninterface CSSRotate extends CSSTransformComponent {\n    /**\n     * The **`angle`** property of the denotes a clockwise rotation, a negative angle a counter-clockwise one.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRotate/angle)\n     */\n    angle: CSSNumericValue;\n    /**\n     * The **`x`** property of the translating vector.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRotate/x)\n     */\n    x: CSSNumberish;\n    /**\n     * The **`y`** property of the translating vector.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRotate/y)\n     */\n    y: CSSNumberish;\n    /**\n     * The **`z`** property of the vector.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRotate/z)\n     */\n    z: CSSNumberish;\n}\n\ndeclare var CSSRotate: {\n    prototype: CSSRotate;\n    new(angle: CSSNumericValue): CSSRotate;\n    new(x: CSSNumberish, y: CSSNumberish, z: CSSNumberish, angle: CSSNumericValue): CSSRotate;\n};\n\n/**\n * The **`CSSRule`** interface represents a single CSS rule.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRule)\n */\ninterface CSSRule {\n    /**\n     * The **`cssText`** property of the CSSRule interface returns the actual text of a CSSStyleSheet style-rule.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRule/cssText)\n     */\n    cssText: string;\n    /**\n     * The **`parentRule`** property of the CSSRule interface returns the containing rule of the current rule if this exists, or otherwise returns null.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRule/parentRule)\n     */\n    readonly parentRule: CSSRule | null;\n    /**\n     * The **`parentStyleSheet`** property of the the current rule is defined.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRule/parentStyleSheet)\n     */\n    readonly parentStyleSheet: CSSStyleSheet | null;\n    /**\n     * The read-only **`type`** property of the indicating which type of rule the CSSRule represents.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRule/type)\n     */\n    readonly type: number;\n    readonly STYLE_RULE: 1;\n    readonly CHARSET_RULE: 2;\n    readonly IMPORT_RULE: 3;\n    readonly MEDIA_RULE: 4;\n    readonly FONT_FACE_RULE: 5;\n    readonly PAGE_RULE: 6;\n    readonly NAMESPACE_RULE: 10;\n    readonly KEYFRAMES_RULE: 7;\n    readonly KEYFRAME_RULE: 8;\n    readonly SUPPORTS_RULE: 12;\n    readonly COUNTER_STYLE_RULE: 11;\n    readonly FONT_FEATURE_VALUES_RULE: 14;\n}\n\ndeclare var CSSRule: {\n    prototype: CSSRule;\n    new(): CSSRule;\n    readonly STYLE_RULE: 1;\n    readonly CHARSET_RULE: 2;\n    readonly IMPORT_RULE: 3;\n    readonly MEDIA_RULE: 4;\n    readonly FONT_FACE_RULE: 5;\n    readonly PAGE_RULE: 6;\n    readonly NAMESPACE_RULE: 10;\n    readonly KEYFRAMES_RULE: 7;\n    readonly KEYFRAME_RULE: 8;\n    readonly SUPPORTS_RULE: 12;\n    readonly COUNTER_STYLE_RULE: 11;\n    readonly FONT_FEATURE_VALUES_RULE: 14;\n};\n\n/**\n * A `CSSRuleList` represents an ordered collection of read-only CSSRule objects.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRuleList)\n */\ninterface CSSRuleList {\n    /**\n     * The **`length`** property of the CSSRuleList interface returns the number of CSSRule objects in the list.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRuleList/length)\n     */\n    readonly length: number;\n    /**\n     * The **`item()`** method of the CSSRuleList interface returns the CSSRule object at the specified `index` or `null` if the specified `index` doesn't exist.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSRuleList/item)\n     */\n    item(index: number): CSSRule | null;\n    [index: number]: CSSRule;\n}\n\ndeclare var CSSRuleList: {\n    prototype: CSSRuleList;\n    new(): CSSRuleList;\n};\n\n/**\n * The **`CSSScale`** interface of the CSS Typed Object Model API represents the scale() and scale3d() values of the individual transform property in CSS.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSScale)\n */\ninterface CSSScale extends CSSTransformComponent {\n    /**\n     * The **`x`** property of the translating vector.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSScale/x)\n     */\n    x: CSSNumberish;\n    /**\n     * The **`y`** property of the translating vector.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSScale/y)\n     */\n    y: CSSNumberish;\n    /**\n     * The **`z`** property of the vector.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSScale/z)\n     */\n    z: CSSNumberish;\n}\n\ndeclare var CSSScale: {\n    prototype: CSSScale;\n    new(x: CSSNumberish, y: CSSNumberish, z?: CSSNumberish): CSSScale;\n};\n\n/**\n * The **`CSSScopeRule`** interface of the CSS Object Model represents a CSS @scope at-rule.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSScopeRule)\n */\ninterface CSSScopeRule extends CSSGroupingRule {\n    /**\n     * The **`end`** property of the CSSScopeRule interface returns a string containing the value of the `@scope` at-rule's scope limit.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSScopeRule/end)\n     */\n    readonly end: string | null;\n    /**\n     * The **`start`** property of the CSSScopeRule interface returns a string containing the value of the `@scope` at-rule's scope root.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSScopeRule/start)\n     */\n    readonly start: string | null;\n}\n\ndeclare var CSSScopeRule: {\n    prototype: CSSScopeRule;\n    new(): CSSScopeRule;\n};\n\n/**\n * The **`CSSSkew`** interface of the CSS Typed Object Model API is part of the CSSTransformValue interface.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSSkew)\n */\ninterface CSSSkew extends CSSTransformComponent {\n    /**\n     * The **`ax`** property of the along the x-axis (or abscissa).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSSkew/ax)\n     */\n    ax: CSSNumericValue;\n    /**\n     * The **`ay`** property of the along the y-axis (or ordinate).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSSkew/ay)\n     */\n    ay: CSSNumericValue;\n}\n\ndeclare var CSSSkew: {\n    prototype: CSSSkew;\n    new(ax: CSSNumericValue, ay: CSSNumericValue): CSSSkew;\n};\n\n/**\n * The **`CSSSkewX`** interface of the CSS Typed Object Model API represents the `skewX()` value of the individual transform property in CSS.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSSkewX)\n */\ninterface CSSSkewX extends CSSTransformComponent {\n    /**\n     * The **`ax`** property of the along the x-axis (or abscissa).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSSkewX/ax)\n     */\n    ax: CSSNumericValue;\n}\n\ndeclare var CSSSkewX: {\n    prototype: CSSSkewX;\n    new(ax: CSSNumericValue): CSSSkewX;\n};\n\n/**\n * The **`CSSSkewY`** interface of the CSS Typed Object Model API represents the `skewY()` value of the individual transform property in CSS.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSSkewY)\n */\ninterface CSSSkewY extends CSSTransformComponent {\n    /**\n     * The **`ay`** property of the along the y-axis (or ordinate).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSSkewY/ay)\n     */\n    ay: CSSNumericValue;\n}\n\ndeclare var CSSSkewY: {\n    prototype: CSSSkewY;\n    new(ay: CSSNumericValue): CSSSkewY;\n};\n\n/**\n * The **`CSSStartingStyleRule`** interface of the CSS Object Model represents a CSS @starting-style at-rule.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStartingStyleRule)\n */\ninterface CSSStartingStyleRule extends CSSGroupingRule {\n}\n\ndeclare var CSSStartingStyleRule: {\n    prototype: CSSStartingStyleRule;\n    new(): CSSStartingStyleRule;\n};\n\n/**\n * The **`CSSStyleDeclaration`** interface represents an object that is a CSS declaration block, and exposes style information and various style-related methods and properties.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration)\n */\ninterface CSSStyleDeclaration {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/accent-color) */\n    accentColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/align-content) */\n    alignContent: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/align-items) */\n    alignItems: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/align-self) */\n    alignSelf: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/alignment-baseline) */\n    alignmentBaseline: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/all) */\n    all: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation) */\n    animation: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-composition) */\n    animationComposition: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-delay) */\n    animationDelay: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-direction) */\n    animationDirection: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-duration) */\n    animationDuration: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-fill-mode) */\n    animationFillMode: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-iteration-count) */\n    animationIterationCount: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-name) */\n    animationName: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-play-state) */\n    animationPlayState: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-timing-function) */\n    animationTimingFunction: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/appearance) */\n    appearance: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/aspect-ratio) */\n    aspectRatio: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/backdrop-filter) */\n    backdropFilter: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/backface-visibility) */\n    backfaceVisibility: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background) */\n    background: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-attachment) */\n    backgroundAttachment: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-blend-mode) */\n    backgroundBlendMode: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-clip) */\n    backgroundClip: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-color) */\n    backgroundColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-image) */\n    backgroundImage: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-origin) */\n    backgroundOrigin: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-position) */\n    backgroundPosition: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-position-x) */\n    backgroundPositionX: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-position-y) */\n    backgroundPositionY: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-repeat) */\n    backgroundRepeat: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-size) */\n    backgroundSize: string;\n    baselineShift: string;\n    baselineSource: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/block-size) */\n    blockSize: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border) */\n    border: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block) */\n    borderBlock: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-color) */\n    borderBlockColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-end) */\n    borderBlockEnd: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-end-color) */\n    borderBlockEndColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-end-style) */\n    borderBlockEndStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-end-width) */\n    borderBlockEndWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-start) */\n    borderBlockStart: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-start-color) */\n    borderBlockStartColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-start-style) */\n    borderBlockStartStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-start-width) */\n    borderBlockStartWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-style) */\n    borderBlockStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-block-width) */\n    borderBlockWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-bottom) */\n    borderBottom: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-bottom-color) */\n    borderBottomColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-bottom-left-radius) */\n    borderBottomLeftRadius: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-bottom-right-radius) */\n    borderBottomRightRadius: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-bottom-style) */\n    borderBottomStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-bottom-width) */\n    borderBottomWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-collapse) */\n    borderCollapse: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-color) */\n    borderColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-end-end-radius) */\n    borderEndEndRadius: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-end-start-radius) */\n    borderEndStartRadius: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-image) */\n    borderImage: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-image-outset) */\n    borderImageOutset: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-image-repeat) */\n    borderImageRepeat: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-image-slice) */\n    borderImageSlice: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-image-source) */\n    borderImageSource: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-image-width) */\n    borderImageWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline) */\n    borderInline: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-color) */\n    borderInlineColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-end) */\n    borderInlineEnd: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-end-color) */\n    borderInlineEndColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-end-style) */\n    borderInlineEndStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-end-width) */\n    borderInlineEndWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-start) */\n    borderInlineStart: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-start-color) */\n    borderInlineStartColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-start-style) */\n    borderInlineStartStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-start-width) */\n    borderInlineStartWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-style) */\n    borderInlineStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-inline-width) */\n    borderInlineWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-left) */\n    borderLeft: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-left-color) */\n    borderLeftColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-left-style) */\n    borderLeftStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-left-width) */\n    borderLeftWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-radius) */\n    borderRadius: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-right) */\n    borderRight: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-right-color) */\n    borderRightColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-right-style) */\n    borderRightStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-right-width) */\n    borderRightWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-spacing) */\n    borderSpacing: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-start-end-radius) */\n    borderStartEndRadius: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-start-start-radius) */\n    borderStartStartRadius: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-style) */\n    borderStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-top) */\n    borderTop: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-top-color) */\n    borderTopColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-top-left-radius) */\n    borderTopLeftRadius: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-top-right-radius) */\n    borderTopRightRadius: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-top-style) */\n    borderTopStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-top-width) */\n    borderTopWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-width) */\n    borderWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/bottom) */\n    bottom: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-decoration-break) */\n    boxDecorationBreak: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-shadow) */\n    boxShadow: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-sizing) */\n    boxSizing: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/break-after) */\n    breakAfter: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/break-before) */\n    breakBefore: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/break-inside) */\n    breakInside: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/caption-side) */\n    captionSide: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/caret-color) */\n    caretColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/clear) */\n    clear: string;\n    /**\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/clip)\n     */\n    clip: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/clip-path) */\n    clipPath: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/clip-rule) */\n    clipRule: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/color) */\n    color: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/color-interpolation) */\n    colorInterpolation: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/color-interpolation-filters) */\n    colorInterpolationFilters: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/color-scheme) */\n    colorScheme: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-count) */\n    columnCount: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-fill) */\n    columnFill: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-gap) */\n    columnGap: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-rule) */\n    columnRule: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-rule-color) */\n    columnRuleColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-rule-style) */\n    columnRuleStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-rule-width) */\n    columnRuleWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-span) */\n    columnSpan: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/column-width) */\n    columnWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/columns) */\n    columns: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/contain) */\n    contain: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/contain-intrinsic-block-size) */\n    containIntrinsicBlockSize: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/contain-intrinsic-height) */\n    containIntrinsicHeight: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/contain-intrinsic-inline-size) */\n    containIntrinsicInlineSize: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/contain-intrinsic-size) */\n    containIntrinsicSize: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/contain-intrinsic-width) */\n    containIntrinsicWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/container) */\n    container: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/container-name) */\n    containerName: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/container-type) */\n    containerType: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/content) */\n    content: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/content-visibility) */\n    contentVisibility: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/counter-increment) */\n    counterIncrement: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/counter-reset) */\n    counterReset: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/counter-set) */\n    counterSet: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/cssFloat) */\n    cssFloat: string;\n    /**\n     * The **`cssText`** property of the CSSStyleDeclaration interface returns or sets the text of the element's **inline** style declaration only.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/cssText)\n     */\n    cssText: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/cursor) */\n    cursor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/cx) */\n    cx: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/cy) */\n    cy: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/d) */\n    d: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/direction) */\n    direction: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/display) */\n    display: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/dominant-baseline) */\n    dominantBaseline: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/empty-cells) */\n    emptyCells: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/fill) */\n    fill: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/fill-opacity) */\n    fillOpacity: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/fill-rule) */\n    fillRule: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/filter) */\n    filter: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex) */\n    flex: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-basis) */\n    flexBasis: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-direction) */\n    flexDirection: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-flow) */\n    flexFlow: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-grow) */\n    flexGrow: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-shrink) */\n    flexShrink: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-wrap) */\n    flexWrap: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/float) */\n    float: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flood-color) */\n    floodColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flood-opacity) */\n    floodOpacity: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font) */\n    font: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-family) */\n    fontFamily: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-feature-settings) */\n    fontFeatureSettings: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-kerning) */\n    fontKerning: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-optical-sizing) */\n    fontOpticalSizing: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-palette) */\n    fontPalette: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-size) */\n    fontSize: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-size-adjust) */\n    fontSizeAdjust: string;\n    /**\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-stretch)\n     */\n    fontStretch: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-style) */\n    fontStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-synthesis) */\n    fontSynthesis: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-synthesis-small-caps) */\n    fontSynthesisSmallCaps: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-synthesis-style) */\n    fontSynthesisStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-synthesis-weight) */\n    fontSynthesisWeight: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variant) */\n    fontVariant: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variant-alternates) */\n    fontVariantAlternates: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variant-caps) */\n    fontVariantCaps: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variant-east-asian) */\n    fontVariantEastAsian: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variant-ligatures) */\n    fontVariantLigatures: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variant-numeric) */\n    fontVariantNumeric: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variant-position) */\n    fontVariantPosition: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-variation-settings) */\n    fontVariationSettings: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/font-weight) */\n    fontWeight: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/forced-color-adjust) */\n    forcedColorAdjust: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/gap) */\n    gap: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid) */\n    grid: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-area) */\n    gridArea: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-auto-columns) */\n    gridAutoColumns: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-auto-flow) */\n    gridAutoFlow: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-auto-rows) */\n    gridAutoRows: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-column) */\n    gridColumn: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-column-end) */\n    gridColumnEnd: string;\n    /** @deprecated This is a legacy alias of `columnGap`. */\n    gridColumnGap: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-column-start) */\n    gridColumnStart: string;\n    /** @deprecated This is a legacy alias of `gap`. */\n    gridGap: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-row) */\n    gridRow: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-row-end) */\n    gridRowEnd: string;\n    /** @deprecated This is a legacy alias of `rowGap`. */\n    gridRowGap: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-row-start) */\n    gridRowStart: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-template) */\n    gridTemplate: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-template-areas) */\n    gridTemplateAreas: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-template-columns) */\n    gridTemplateColumns: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/grid-template-rows) */\n    gridTemplateRows: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/height) */\n    height: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/hyphenate-character) */\n    hyphenateCharacter: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/hyphenate-limit-chars) */\n    hyphenateLimitChars: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/hyphens) */\n    hyphens: string;\n    /**\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/image-orientation)\n     */\n    imageOrientation: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/image-rendering) */\n    imageRendering: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/inline-size) */\n    inlineSize: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/inset) */\n    inset: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/inset-block) */\n    insetBlock: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/inset-block-end) */\n    insetBlockEnd: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/inset-block-start) */\n    insetBlockStart: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/inset-inline) */\n    insetInline: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/inset-inline-end) */\n    insetInlineEnd: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/inset-inline-start) */\n    insetInlineStart: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/isolation) */\n    isolation: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/justify-content) */\n    justifyContent: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/justify-items) */\n    justifyItems: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/justify-self) */\n    justifySelf: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/left) */\n    left: string;\n    /**\n     * The read-only property returns an integer that represents the number of style declarations in this CSS declaration block.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/length)\n     */\n    readonly length: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/letter-spacing) */\n    letterSpacing: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/lighting-color) */\n    lightingColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/line-break) */\n    lineBreak: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/line-height) */\n    lineHeight: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/list-style) */\n    listStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/list-style-image) */\n    listStyleImage: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/list-style-position) */\n    listStylePosition: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/list-style-type) */\n    listStyleType: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin) */\n    margin: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-block) */\n    marginBlock: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-block-end) */\n    marginBlockEnd: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-block-start) */\n    marginBlockStart: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-bottom) */\n    marginBottom: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-inline) */\n    marginInline: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-inline-end) */\n    marginInlineEnd: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-inline-start) */\n    marginInlineStart: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-left) */\n    marginLeft: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-right) */\n    marginRight: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/margin-top) */\n    marginTop: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/marker) */\n    marker: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/marker-end) */\n    markerEnd: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/marker-mid) */\n    markerMid: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/marker-start) */\n    markerStart: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask) */\n    mask: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-clip) */\n    maskClip: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-composite) */\n    maskComposite: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-image) */\n    maskImage: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-mode) */\n    maskMode: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-origin) */\n    maskOrigin: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-position) */\n    maskPosition: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-repeat) */\n    maskRepeat: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-size) */\n    maskSize: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-type) */\n    maskType: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/math-depth) */\n    mathDepth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/math-style) */\n    mathStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/max-block-size) */\n    maxBlockSize: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/max-height) */\n    maxHeight: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/max-inline-size) */\n    maxInlineSize: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/max-width) */\n    maxWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/min-block-size) */\n    minBlockSize: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/min-height) */\n    minHeight: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/min-inline-size) */\n    minInlineSize: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/min-width) */\n    minWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mix-blend-mode) */\n    mixBlendMode: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/object-fit) */\n    objectFit: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/object-position) */\n    objectPosition: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/offset) */\n    offset: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/offset-anchor) */\n    offsetAnchor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/offset-distance) */\n    offsetDistance: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/offset-path) */\n    offsetPath: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/offset-position) */\n    offsetPosition: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/offset-rotate) */\n    offsetRotate: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/opacity) */\n    opacity: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/order) */\n    order: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/orphans) */\n    orphans: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/outline) */\n    outline: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/outline-color) */\n    outlineColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/outline-offset) */\n    outlineOffset: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/outline-style) */\n    outlineStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/outline-width) */\n    outlineWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow) */\n    overflow: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow-anchor) */\n    overflowAnchor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow-block) */\n    overflowBlock: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow-clip-margin) */\n    overflowClipMargin: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow-inline) */\n    overflowInline: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow-wrap) */\n    overflowWrap: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow-x) */\n    overflowX: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow-y) */\n    overflowY: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior) */\n    overscrollBehavior: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-block) */\n    overscrollBehaviorBlock: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-inline) */\n    overscrollBehaviorInline: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-x) */\n    overscrollBehaviorX: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-y) */\n    overscrollBehaviorY: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding) */\n    padding: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-block) */\n    paddingBlock: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-block-end) */\n    paddingBlockEnd: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-block-start) */\n    paddingBlockStart: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-bottom) */\n    paddingBottom: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-inline) */\n    paddingInline: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-inline-end) */\n    paddingInlineEnd: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-inline-start) */\n    paddingInlineStart: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-left) */\n    paddingLeft: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-right) */\n    paddingRight: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/padding-top) */\n    paddingTop: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/page) */\n    page: string;\n    /**\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/page-break-after)\n     */\n    pageBreakAfter: string;\n    /**\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/page-break-before)\n     */\n    pageBreakBefore: string;\n    /**\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/page-break-inside)\n     */\n    pageBreakInside: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/paint-order) */\n    paintOrder: string;\n    /**\n     * The **CSSStyleDeclaration.parentRule** read-only property returns a CSSRule that is the parent of this style block, e.g., a CSSStyleRule representing the style for a CSS selector.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/parentRule)\n     */\n    readonly parentRule: CSSRule | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/perspective) */\n    perspective: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/perspective-origin) */\n    perspectiveOrigin: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/place-content) */\n    placeContent: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/place-items) */\n    placeItems: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/place-self) */\n    placeSelf: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/pointer-events) */\n    pointerEvents: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/position) */\n    position: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/print-color-adjust) */\n    printColorAdjust: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/quotes) */\n    quotes: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/r) */\n    r: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/resize) */\n    resize: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/right) */\n    right: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/rotate) */\n    rotate: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/row-gap) */\n    rowGap: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/ruby-align) */\n    rubyAlign: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/ruby-position) */\n    rubyPosition: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/rx) */\n    rx: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/ry) */\n    ry: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scale) */\n    scale: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-behavior) */\n    scrollBehavior: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin) */\n    scrollMargin: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-block) */\n    scrollMarginBlock: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-block-end) */\n    scrollMarginBlockEnd: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-block-start) */\n    scrollMarginBlockStart: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-bottom) */\n    scrollMarginBottom: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-inline) */\n    scrollMarginInline: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-inline-end) */\n    scrollMarginInlineEnd: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-inline-start) */\n    scrollMarginInlineStart: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-left) */\n    scrollMarginLeft: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-right) */\n    scrollMarginRight: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-margin-top) */\n    scrollMarginTop: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding) */\n    scrollPadding: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block) */\n    scrollPaddingBlock: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block-end) */\n    scrollPaddingBlockEnd: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block-start) */\n    scrollPaddingBlockStart: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-bottom) */\n    scrollPaddingBottom: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline) */\n    scrollPaddingInline: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline-end) */\n    scrollPaddingInlineEnd: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline-start) */\n    scrollPaddingInlineStart: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-left) */\n    scrollPaddingLeft: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-right) */\n    scrollPaddingRight: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-padding-top) */\n    scrollPaddingTop: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-snap-align) */\n    scrollSnapAlign: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-snap-stop) */\n    scrollSnapStop: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scroll-snap-type) */\n    scrollSnapType: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scrollbar-color) */\n    scrollbarColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scrollbar-gutter) */\n    scrollbarGutter: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/scrollbar-width) */\n    scrollbarWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/shape-image-threshold) */\n    shapeImageThreshold: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/shape-margin) */\n    shapeMargin: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/shape-outside) */\n    shapeOutside: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/shape-rendering) */\n    shapeRendering: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/stop-color) */\n    stopColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/stop-opacity) */\n    stopOpacity: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/stroke) */\n    stroke: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/stroke-dasharray) */\n    strokeDasharray: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/stroke-dashoffset) */\n    strokeDashoffset: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/stroke-linecap) */\n    strokeLinecap: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/stroke-linejoin) */\n    strokeLinejoin: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/stroke-miterlimit) */\n    strokeMiterlimit: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/stroke-opacity) */\n    strokeOpacity: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/stroke-width) */\n    strokeWidth: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/tab-size) */\n    tabSize: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/table-layout) */\n    tableLayout: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-align) */\n    textAlign: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-align-last) */\n    textAlignLast: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-anchor) */\n    textAnchor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-box) */\n    textBox: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-box-edge) */\n    textBoxEdge: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-box-trim) */\n    textBoxTrim: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-combine-upright) */\n    textCombineUpright: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-decoration) */\n    textDecoration: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-decoration-color) */\n    textDecorationColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-decoration-line) */\n    textDecorationLine: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-decoration-skip-ink) */\n    textDecorationSkipInk: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-decoration-style) */\n    textDecorationStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-decoration-thickness) */\n    textDecorationThickness: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-emphasis) */\n    textEmphasis: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-emphasis-color) */\n    textEmphasisColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-emphasis-position) */\n    textEmphasisPosition: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-emphasis-style) */\n    textEmphasisStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-indent) */\n    textIndent: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-orientation) */\n    textOrientation: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-overflow) */\n    textOverflow: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-rendering) */\n    textRendering: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-shadow) */\n    textShadow: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-transform) */\n    textTransform: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-underline-offset) */\n    textUnderlineOffset: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-underline-position) */\n    textUnderlinePosition: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-wrap) */\n    textWrap: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-wrap-mode) */\n    textWrapMode: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-wrap-style) */\n    textWrapStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/top) */\n    top: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/touch-action) */\n    touchAction: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transform) */\n    transform: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transform-box) */\n    transformBox: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transform-origin) */\n    transformOrigin: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transform-style) */\n    transformStyle: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition) */\n    transition: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-behavior) */\n    transitionBehavior: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-delay) */\n    transitionDelay: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-duration) */\n    transitionDuration: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-property) */\n    transitionProperty: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-timing-function) */\n    transitionTimingFunction: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/translate) */\n    translate: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/unicode-bidi) */\n    unicodeBidi: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/user-select) */\n    userSelect: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/vector-effect) */\n    vectorEffect: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/vertical-align) */\n    verticalAlign: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/view-transition-class) */\n    viewTransitionClass: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/view-transition-name) */\n    viewTransitionName: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/visibility) */\n    visibility: string;\n    /**\n     * @deprecated This is a legacy alias of `alignContent`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/align-content)\n     */\n    webkitAlignContent: string;\n    /**\n     * @deprecated This is a legacy alias of `alignItems`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/align-items)\n     */\n    webkitAlignItems: string;\n    /**\n     * @deprecated This is a legacy alias of `alignSelf`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/align-self)\n     */\n    webkitAlignSelf: string;\n    /**\n     * @deprecated This is a legacy alias of `animation`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation)\n     */\n    webkitAnimation: string;\n    /**\n     * @deprecated This is a legacy alias of `animationDelay`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-delay)\n     */\n    webkitAnimationDelay: string;\n    /**\n     * @deprecated This is a legacy alias of `animationDirection`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-direction)\n     */\n    webkitAnimationDirection: string;\n    /**\n     * @deprecated This is a legacy alias of `animationDuration`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-duration)\n     */\n    webkitAnimationDuration: string;\n    /**\n     * @deprecated This is a legacy alias of `animationFillMode`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-fill-mode)\n     */\n    webkitAnimationFillMode: string;\n    /**\n     * @deprecated This is a legacy alias of `animationIterationCount`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-iteration-count)\n     */\n    webkitAnimationIterationCount: string;\n    /**\n     * @deprecated This is a legacy alias of `animationName`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-name)\n     */\n    webkitAnimationName: string;\n    /**\n     * @deprecated This is a legacy alias of `animationPlayState`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-play-state)\n     */\n    webkitAnimationPlayState: string;\n    /**\n     * @deprecated This is a legacy alias of `animationTimingFunction`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/animation-timing-function)\n     */\n    webkitAnimationTimingFunction: string;\n    /**\n     * @deprecated This is a legacy alias of `appearance`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/appearance)\n     */\n    webkitAppearance: string;\n    /**\n     * @deprecated This is a legacy alias of `backfaceVisibility`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/backface-visibility)\n     */\n    webkitBackfaceVisibility: string;\n    /**\n     * @deprecated This is a legacy alias of `backgroundClip`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-clip)\n     */\n    webkitBackgroundClip: string;\n    /**\n     * @deprecated This is a legacy alias of `backgroundOrigin`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-origin)\n     */\n    webkitBackgroundOrigin: string;\n    /**\n     * @deprecated This is a legacy alias of `backgroundSize`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/background-size)\n     */\n    webkitBackgroundSize: string;\n    /**\n     * @deprecated This is a legacy alias of `borderBottomLeftRadius`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-bottom-left-radius)\n     */\n    webkitBorderBottomLeftRadius: string;\n    /**\n     * @deprecated This is a legacy alias of `borderBottomRightRadius`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-bottom-right-radius)\n     */\n    webkitBorderBottomRightRadius: string;\n    /**\n     * @deprecated This is a legacy alias of `borderRadius`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-radius)\n     */\n    webkitBorderRadius: string;\n    /**\n     * @deprecated This is a legacy alias of `borderTopLeftRadius`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-top-left-radius)\n     */\n    webkitBorderTopLeftRadius: string;\n    /**\n     * @deprecated This is a legacy alias of `borderTopRightRadius`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/border-top-right-radius)\n     */\n    webkitBorderTopRightRadius: string;\n    /**\n     * @deprecated This is a legacy alias of `boxAlign`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-align)\n     */\n    webkitBoxAlign: string;\n    /**\n     * @deprecated This is a legacy alias of `boxFlex`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-flex)\n     */\n    webkitBoxFlex: string;\n    /**\n     * @deprecated This is a legacy alias of `boxOrdinalGroup`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-ordinal-group)\n     */\n    webkitBoxOrdinalGroup: string;\n    /**\n     * @deprecated This is a legacy alias of `boxOrient`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-orient)\n     */\n    webkitBoxOrient: string;\n    /**\n     * @deprecated This is a legacy alias of `boxPack`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-pack)\n     */\n    webkitBoxPack: string;\n    /**\n     * @deprecated This is a legacy alias of `boxShadow`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-shadow)\n     */\n    webkitBoxShadow: string;\n    /**\n     * @deprecated This is a legacy alias of `boxSizing`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/box-sizing)\n     */\n    webkitBoxSizing: string;\n    /**\n     * @deprecated This is a legacy alias of `filter`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/filter)\n     */\n    webkitFilter: string;\n    /**\n     * @deprecated This is a legacy alias of `flex`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex)\n     */\n    webkitFlex: string;\n    /**\n     * @deprecated This is a legacy alias of `flexBasis`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-basis)\n     */\n    webkitFlexBasis: string;\n    /**\n     * @deprecated This is a legacy alias of `flexDirection`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-direction)\n     */\n    webkitFlexDirection: string;\n    /**\n     * @deprecated This is a legacy alias of `flexFlow`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-flow)\n     */\n    webkitFlexFlow: string;\n    /**\n     * @deprecated This is a legacy alias of `flexGrow`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-grow)\n     */\n    webkitFlexGrow: string;\n    /**\n     * @deprecated This is a legacy alias of `flexShrink`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-shrink)\n     */\n    webkitFlexShrink: string;\n    /**\n     * @deprecated This is a legacy alias of `flexWrap`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/flex-wrap)\n     */\n    webkitFlexWrap: string;\n    /**\n     * @deprecated This is a legacy alias of `justifyContent`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/justify-content)\n     */\n    webkitJustifyContent: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/line-clamp) */\n    webkitLineClamp: string;\n    /**\n     * @deprecated This is a legacy alias of `mask`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask)\n     */\n    webkitMask: string;\n    /**\n     * @deprecated This is a legacy alias of `maskBorder`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border)\n     */\n    webkitMaskBoxImage: string;\n    /**\n     * @deprecated This is a legacy alias of `maskBorderOutset`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border-outset)\n     */\n    webkitMaskBoxImageOutset: string;\n    /**\n     * @deprecated This is a legacy alias of `maskBorderRepeat`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border-repeat)\n     */\n    webkitMaskBoxImageRepeat: string;\n    /**\n     * @deprecated This is a legacy alias of `maskBorderSlice`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border-slice)\n     */\n    webkitMaskBoxImageSlice: string;\n    /**\n     * @deprecated This is a legacy alias of `maskBorderSource`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border-source)\n     */\n    webkitMaskBoxImageSource: string;\n    /**\n     * @deprecated This is a legacy alias of `maskBorderWidth`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-border-width)\n     */\n    webkitMaskBoxImageWidth: string;\n    /**\n     * @deprecated This is a legacy alias of `maskClip`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-clip)\n     */\n    webkitMaskClip: string;\n    /**\n     * @deprecated This is a legacy alias of `maskComposite`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-composite)\n     */\n    webkitMaskComposite: string;\n    /**\n     * @deprecated This is a legacy alias of `maskImage`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-image)\n     */\n    webkitMaskImage: string;\n    /**\n     * @deprecated This is a legacy alias of `maskOrigin`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-origin)\n     */\n    webkitMaskOrigin: string;\n    /**\n     * @deprecated This is a legacy alias of `maskPosition`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-position)\n     */\n    webkitMaskPosition: string;\n    /**\n     * @deprecated This is a legacy alias of `maskRepeat`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-repeat)\n     */\n    webkitMaskRepeat: string;\n    /**\n     * @deprecated This is a legacy alias of `maskSize`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/mask-size)\n     */\n    webkitMaskSize: string;\n    /**\n     * @deprecated This is a legacy alias of `order`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/order)\n     */\n    webkitOrder: string;\n    /**\n     * @deprecated This is a legacy alias of `perspective`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/perspective)\n     */\n    webkitPerspective: string;\n    /**\n     * @deprecated This is a legacy alias of `perspectiveOrigin`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/perspective-origin)\n     */\n    webkitPerspectiveOrigin: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/-webkit-text-fill-color) */\n    webkitTextFillColor: string;\n    /**\n     * @deprecated This is a legacy alias of `textSizeAdjust`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/text-size-adjust)\n     */\n    webkitTextSizeAdjust: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/-webkit-text-stroke) */\n    webkitTextStroke: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/-webkit-text-stroke-color) */\n    webkitTextStrokeColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/-webkit-text-stroke-width) */\n    webkitTextStrokeWidth: string;\n    /**\n     * @deprecated This is a legacy alias of `transform`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transform)\n     */\n    webkitTransform: string;\n    /**\n     * @deprecated This is a legacy alias of `transformOrigin`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transform-origin)\n     */\n    webkitTransformOrigin: string;\n    /**\n     * @deprecated This is a legacy alias of `transformStyle`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transform-style)\n     */\n    webkitTransformStyle: string;\n    /**\n     * @deprecated This is a legacy alias of `transition`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition)\n     */\n    webkitTransition: string;\n    /**\n     * @deprecated This is a legacy alias of `transitionDelay`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-delay)\n     */\n    webkitTransitionDelay: string;\n    /**\n     * @deprecated This is a legacy alias of `transitionDuration`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-duration)\n     */\n    webkitTransitionDuration: string;\n    /**\n     * @deprecated This is a legacy alias of `transitionProperty`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-property)\n     */\n    webkitTransitionProperty: string;\n    /**\n     * @deprecated This is a legacy alias of `transitionTimingFunction`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/transition-timing-function)\n     */\n    webkitTransitionTimingFunction: string;\n    /**\n     * @deprecated This is a legacy alias of `userSelect`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/user-select)\n     */\n    webkitUserSelect: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/white-space) */\n    whiteSpace: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/white-space-collapse) */\n    whiteSpaceCollapse: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/widows) */\n    widows: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/width) */\n    width: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/will-change) */\n    willChange: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/word-break) */\n    wordBreak: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/word-spacing) */\n    wordSpacing: string;\n    /**\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/overflow-wrap)\n     */\n    wordWrap: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/writing-mode) */\n    writingMode: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/x) */\n    x: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/y) */\n    y: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/z-index) */\n    zIndex: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/CSS/zoom) */\n    zoom: string;\n    /**\n     * The **CSSStyleDeclaration.getPropertyPriority()** method interface returns a string that provides all explicitly set priorities on the CSS property.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/getPropertyPriority)\n     */\n    getPropertyPriority(property: string): string;\n    /**\n     * The **CSSStyleDeclaration.getPropertyValue()** method interface returns a string containing the value of a specified CSS property.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/getPropertyValue)\n     */\n    getPropertyValue(property: string): string;\n    /**\n     * The `CSSStyleDeclaration.item()` method interface returns a CSS property name from a CSSStyleDeclaration by index.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/item)\n     */\n    item(index: number): string;\n    /**\n     * The **`CSSStyleDeclaration.removeProperty()`** method interface removes a property from a CSS style declaration object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/removeProperty)\n     */\n    removeProperty(property: string): string;\n    /**\n     * The **`CSSStyleDeclaration.setProperty()`** method interface sets a new value for a property on a CSS style declaration object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleDeclaration/setProperty)\n     */\n    setProperty(property: string, value: string | null, priority?: string): void;\n    [index: number]: string;\n}\n\ndeclare var CSSStyleDeclaration: {\n    prototype: CSSStyleDeclaration;\n    new(): CSSStyleDeclaration;\n};\n\n/**\n * The **`CSSStyleRule`** interface represents a single CSS style rule.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleRule)\n */\ninterface CSSStyleRule extends CSSGroupingRule {\n    /**\n     * The **`selectorText`** property of the CSSStyleRule interface gets and sets the selectors associated with the `CSSStyleRule`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleRule/selectorText)\n     */\n    selectorText: string;\n    /**\n     * The read-only **`style`** property is the CSSStyleDeclaration interface for the declaration block of the CSSStyleRule.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleRule/style)\n     */\n    get style(): CSSStyleDeclaration;\n    set style(cssText: string);\n    /**\n     * The **`styleMap`** read-only property of the which provides access to the rule's property-value pairs.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleRule/styleMap)\n     */\n    readonly styleMap: StylePropertyMap;\n}\n\ndeclare var CSSStyleRule: {\n    prototype: CSSStyleRule;\n    new(): CSSStyleRule;\n};\n\n/**\n * The **`CSSStyleSheet`** interface represents a single CSS stylesheet, and lets you inspect and modify the list of rules contained in the stylesheet.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet)\n */\ninterface CSSStyleSheet extends StyleSheet {\n    /**\n     * The read-only CSSStyleSheet property **`cssRules`** returns a live CSSRuleList which provides a real-time, up-to-date list of every CSS rule which comprises the stylesheet.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/cssRules)\n     */\n    readonly cssRules: CSSRuleList;\n    /**\n     * The read-only CSSStyleSheet property **`ownerRule`** returns the CSSImportRule corresponding to the @import at-rule which imported the stylesheet into the document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/ownerRule)\n     */\n    readonly ownerRule: CSSRule | null;\n    /**\n     * **`rules`** is a _deprecated_ _legacy property_ of the CSSStyleSheet interface.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/rules)\n     */\n    readonly rules: CSSRuleList;\n    /**\n     * The obsolete CSSStyleSheet interface's **`addRule()`** _legacy method_ adds a new rule to the stylesheet.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/addRule)\n     */\n    addRule(selector?: string, style?: string, index?: number): number;\n    /**\n     * The CSSStyleSheet method **`deleteRule()`** removes a rule from the stylesheet object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/deleteRule)\n     */\n    deleteRule(index: number): void;\n    /**\n     * The **`CSSStyleSheet.insertRule()`** method inserts a new CSS rule into the current style sheet.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/insertRule)\n     */\n    insertRule(rule: string, index?: number): number;\n    /**\n     * The obsolete CSSStyleSheet method **`removeRule()`** removes a rule from the stylesheet object.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/removeRule)\n     */\n    removeRule(index?: number): void;\n    /**\n     * The **`replace()`** method of the CSSStyleSheet interface asynchronously replaces the content of the stylesheet with the content passed into it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/replace)\n     */\n    replace(text: string): Promise<CSSStyleSheet>;\n    /**\n     * The **`replaceSync()`** method of the CSSStyleSheet interface synchronously replaces the content of the stylesheet with the content passed into it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleSheet/replaceSync)\n     */\n    replaceSync(text: string): void;\n}\n\ndeclare var CSSStyleSheet: {\n    prototype: CSSStyleSheet;\n    new(options?: CSSStyleSheetInit): CSSStyleSheet;\n};\n\n/**\n * The **`CSSStyleValue`** interface of the CSS Typed Object Model API is the base class of all CSS values accessible through the Typed OM API.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleValue)\n */\ninterface CSSStyleValue {\n    toString(): string;\n}\n\ndeclare var CSSStyleValue: {\n    prototype: CSSStyleValue;\n    new(): CSSStyleValue;\n    /**\n     * The **`parse()`** static method of the CSSStyleValue interface sets a specific CSS property to the specified values and returns the first value as a CSSStyleValue object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleValue/parse_static)\n     */\n    parse(property: string, cssText: string): CSSStyleValue;\n    /**\n     * The **`parseAll()`** static method of the CSSStyleValue interface sets all occurrences of a specific CSS property to the specified value and returns an array of CSSStyleValue objects, each containing one of the supplied values.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSStyleValue/parseAll_static)\n     */\n    parseAll(property: string, cssText: string): CSSStyleValue[];\n};\n\n/**\n * The **`CSSSupportsRule`** interface represents a single CSS @supports at-rule.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSSupportsRule)\n */\ninterface CSSSupportsRule extends CSSConditionRule {\n}\n\ndeclare var CSSSupportsRule: {\n    prototype: CSSSupportsRule;\n    new(): CSSSupportsRule;\n};\n\n/**\n * The **`CSSTransformComponent`** interface of the CSS Typed Object Model API is part of the CSSTransformValue interface.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSTransformComponent)\n */\ninterface CSSTransformComponent {\n    /**\n     * The **`is2D`** read-only property of the CSSTransformComponent interface indicates where the transform is 2D or 3D.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSTransformComponent/is2D)\n     */\n    is2D: boolean;\n    /**\n     * The **`toMatrix()`** method of the object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSTransformComponent/toMatrix)\n     */\n    toMatrix(): DOMMatrix;\n    toString(): string;\n}\n\ndeclare var CSSTransformComponent: {\n    prototype: CSSTransformComponent;\n    new(): CSSTransformComponent;\n};\n\n/**\n * The **`CSSTransformValue`** interface of the CSS Typed Object Model API represents `transform-list` values as used by the CSS transform property.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSTransformValue)\n */\ninterface CSSTransformValue extends CSSStyleValue {\n    /**\n     * The read-only **`is2D`** property of the In the case of the `CSSTransformValue` this property returns true unless any of the individual functions return false for `Is2D`, in which case it returns false.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSTransformValue/is2D)\n     */\n    readonly is2D: boolean;\n    /**\n     * The read-only **`length`** property of the the list.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSTransformValue/length)\n     */\n    readonly length: number;\n    /**\n     * The **`toMatrix()`** method of the ```js-nolint toMatrix() ``` None.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSTransformValue/toMatrix)\n     */\n    toMatrix(): DOMMatrix;\n    forEach(callbackfn: (value: CSSTransformComponent, key: number, parent: CSSTransformValue) => void, thisArg?: any): void;\n    [index: number]: CSSTransformComponent;\n}\n\ndeclare var CSSTransformValue: {\n    prototype: CSSTransformValue;\n    new(transforms: CSSTransformComponent[]): CSSTransformValue;\n};\n\n/**\n * The **`CSSTransition`** interface of the Web Animations API represents an Animation object used for a CSS Transition.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSTransition)\n */\ninterface CSSTransition extends Animation {\n    /**\n     * The **`transitionProperty`** property of the name** of the transition.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSTransition/transitionProperty)\n     */\n    readonly transitionProperty: string;\n    addEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: CSSTransition, ev: AnimationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: CSSTransition, ev: AnimationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var CSSTransition: {\n    prototype: CSSTransition;\n    new(): CSSTransition;\n};\n\n/**\n * The **`CSSTranslate`** interface of the CSS Typed Object Model API represents the translate() value of the individual transform property in CSS.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSTranslate)\n */\ninterface CSSTranslate extends CSSTransformComponent {\n    /**\n     * The **`x`** property of the translating vector.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSTranslate/x)\n     */\n    x: CSSNumericValue;\n    /**\n     * The **`y`** property of the translating vector.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSTranslate/y)\n     */\n    y: CSSNumericValue;\n    /**\n     * The **`z`** property of the vector.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSTranslate/z)\n     */\n    z: CSSNumericValue;\n}\n\ndeclare var CSSTranslate: {\n    prototype: CSSTranslate;\n    new(x: CSSNumericValue, y: CSSNumericValue, z?: CSSNumericValue): CSSTranslate;\n};\n\n/**\n * The **`CSSUnitValue`** interface of the CSS Typed Object Model API represents values that contain a single unit type.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSUnitValue)\n */\ninterface CSSUnitValue extends CSSNumericValue {\n    /**\n     * The **`CSSUnitValue.unit`** read-only property of the CSSUnitValue interface returns a string indicating the type of unit.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSUnitValue/unit)\n     */\n    readonly unit: string;\n    /**\n     * The **`CSSUnitValue.value`** property of the A double.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSUnitValue/value)\n     */\n    value: number;\n}\n\ndeclare var CSSUnitValue: {\n    prototype: CSSUnitValue;\n    new(value: number, unit: string): CSSUnitValue;\n};\n\n/**\n * The **`CSSUnparsedValue`** interface of the CSS Typed Object Model API represents property values that reference custom properties.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSUnparsedValue)\n */\ninterface CSSUnparsedValue extends CSSStyleValue {\n    /**\n     * The **`length`** read-only property of the An integer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSUnparsedValue/length)\n     */\n    readonly length: number;\n    forEach(callbackfn: (value: CSSUnparsedSegment, key: number, parent: CSSUnparsedValue) => void, thisArg?: any): void;\n    [index: number]: CSSUnparsedSegment;\n}\n\ndeclare var CSSUnparsedValue: {\n    prototype: CSSUnparsedValue;\n    new(members: CSSUnparsedSegment[]): CSSUnparsedValue;\n};\n\n/**\n * The **`CSSVariableReferenceValue`** interface of the CSS Typed Object Model API allows you to create a custom name for a built-in CSS value.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSVariableReferenceValue)\n */\ninterface CSSVariableReferenceValue {\n    /**\n     * The **`fallback`** read-only property of the A CSSUnparsedValue.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSVariableReferenceValue/fallback)\n     */\n    readonly fallback: CSSUnparsedValue | null;\n    /**\n     * The **`variable`** property of the A string beginning with `--` (that is, a custom property name).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CSSVariableReferenceValue/variable)\n     */\n    variable: string;\n}\n\ndeclare var CSSVariableReferenceValue: {\n    prototype: CSSVariableReferenceValue;\n    new(variable: string, fallback?: CSSUnparsedValue | null): CSSVariableReferenceValue;\n};\n\ninterface CSSViewTransitionRule extends CSSRule {\n    readonly navigation: string;\n    readonly types: ReadonlyArray<string>;\n}\n\ndeclare var CSSViewTransitionRule: {\n    prototype: CSSViewTransitionRule;\n    new(): CSSViewTransitionRule;\n};\n\n/**\n * The **`Cache`** interface provides a persistent storage mechanism for Request / Response object pairs that are cached in long lived memory.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Cache)\n */\ninterface Cache {\n    /**\n     * The **`add()`** method of the Cache interface takes a URL, retrieves it, and adds the resulting response object to the given cache.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Cache/add)\n     */\n    add(request: RequestInfo | URL): Promise<void>;\n    /**\n     * The **`addAll()`** method of the Cache interface takes an array of URLs, retrieves them, and adds the resulting response objects to the given cache.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Cache/addAll)\n     */\n    addAll(requests: RequestInfo[]): Promise<void>;\n    /**\n     * The **`delete()`** method of the Cache interface finds the Cache entry whose key is the request, and if found, deletes the Cache entry and returns a Promise that resolves to `true`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Cache/delete)\n     */\n    delete(request: RequestInfo | URL, options?: CacheQueryOptions): Promise<boolean>;\n    /**\n     * The **`keys()`** method of the Cache interface returns a representing the keys of the Cache.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Cache/keys)\n     */\n    keys(request?: RequestInfo | URL, options?: CacheQueryOptions): Promise<ReadonlyArray<Request>>;\n    /**\n     * The **`match()`** method of the Cache interface returns a Promise that resolves to the Response associated with the first matching request in the Cache object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Cache/match)\n     */\n    match(request: RequestInfo | URL, options?: CacheQueryOptions): Promise<Response | undefined>;\n    /**\n     * The **`matchAll()`** method of the Cache interface returns a Promise that resolves to an array of all matching responses in the Cache object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Cache/matchAll)\n     */\n    matchAll(request?: RequestInfo | URL, options?: CacheQueryOptions): Promise<ReadonlyArray<Response>>;\n    /**\n     * The **`put()`** method of the Often, you will just want to Window/fetch one or more requests, then add the result straight to your cache.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Cache/put)\n     */\n    put(request: RequestInfo | URL, response: Response): Promise<void>;\n}\n\ndeclare var Cache: {\n    prototype: Cache;\n    new(): Cache;\n};\n\n/**\n * The **`CacheStorage`** interface represents the storage for Cache objects.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CacheStorage)\n */\ninterface CacheStorage {\n    /**\n     * The **`delete()`** method of the CacheStorage interface finds the Cache object matching the `cacheName`, and if found, deletes the Cache object and returns a Promise that resolves to `true`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CacheStorage/delete)\n     */\n    delete(cacheName: string): Promise<boolean>;\n    /**\n     * The **`has()`** method of the CacheStorage interface returns a Promise that resolves to `true` if a You can access `CacheStorage` through the Window.caches property in windows or through the WorkerGlobalScope.caches property in workers.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CacheStorage/has)\n     */\n    has(cacheName: string): Promise<boolean>;\n    /**\n     * The **`keys()`** method of the CacheStorage interface returns a Promise that will resolve with an array containing strings corresponding to all of the named Cache objects tracked by the CacheStorage object in the order they were created.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CacheStorage/keys)\n     */\n    keys(): Promise<string[]>;\n    /**\n     * The **`match()`** method of the CacheStorage interface checks if a given Request or URL string is a key for a stored Response.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CacheStorage/match)\n     */\n    match(request: RequestInfo | URL, options?: MultiCacheQueryOptions): Promise<Response | undefined>;\n    /**\n     * The **`open()`** method of the the Cache object matching the `cacheName`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CacheStorage/open)\n     */\n    open(cacheName: string): Promise<Cache>;\n}\n\ndeclare var CacheStorage: {\n    prototype: CacheStorage;\n    new(): CacheStorage;\n};\n\n/**\n * The **`CanvasCaptureMediaStreamTrack`** interface of the Media Capture and Streams API represents the video track contained in a MediaStream being generated from a canvas following a call to HTMLCanvasElement.captureStream().\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasCaptureMediaStreamTrack)\n */\ninterface CanvasCaptureMediaStreamTrack extends MediaStreamTrack {\n    /**\n     * The **`canvas`** read-only property of the CanvasCaptureMediaStreamTrack interface returns the HTMLCanvasElement from which frames are being captured.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasCaptureMediaStreamTrack/canvas)\n     */\n    readonly canvas: HTMLCanvasElement;\n    /**\n     * The **`requestFrame()`** method of the CanvasCaptureMediaStreamTrack interface requests that a frame be captured from the canvas and sent to the stream.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasCaptureMediaStreamTrack/requestFrame)\n     */\n    requestFrame(): void;\n    addEventListener<K extends keyof MediaStreamTrackEventMap>(type: K, listener: (this: CanvasCaptureMediaStreamTrack, ev: MediaStreamTrackEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaStreamTrackEventMap>(type: K, listener: (this: CanvasCaptureMediaStreamTrack, ev: MediaStreamTrackEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var CanvasCaptureMediaStreamTrack: {\n    prototype: CanvasCaptureMediaStreamTrack;\n    new(): CanvasCaptureMediaStreamTrack;\n};\n\ninterface CanvasCompositing {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/globalAlpha) */\n    globalAlpha: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/globalCompositeOperation) */\n    globalCompositeOperation: GlobalCompositeOperation;\n}\n\ninterface CanvasDrawImage {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/drawImage) */\n    drawImage(image: CanvasImageSource, dx: number, dy: number): void;\n    drawImage(image: CanvasImageSource, dx: number, dy: number, dw: number, dh: number): void;\n    drawImage(image: CanvasImageSource, sx: number, sy: number, sw: number, sh: number, dx: number, dy: number, dw: number, dh: number): void;\n}\n\ninterface CanvasDrawPath {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/beginPath) */\n    beginPath(): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/clip) */\n    clip(fillRule?: CanvasFillRule): void;\n    clip(path: Path2D, fillRule?: CanvasFillRule): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/fill) */\n    fill(fillRule?: CanvasFillRule): void;\n    fill(path: Path2D, fillRule?: CanvasFillRule): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/isPointInPath) */\n    isPointInPath(x: number, y: number, fillRule?: CanvasFillRule): boolean;\n    isPointInPath(path: Path2D, x: number, y: number, fillRule?: CanvasFillRule): boolean;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/isPointInStroke) */\n    isPointInStroke(x: number, y: number): boolean;\n    isPointInStroke(path: Path2D, x: number, y: number): boolean;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/stroke) */\n    stroke(): void;\n    stroke(path: Path2D): void;\n}\n\ninterface CanvasFillStrokeStyles {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/fillStyle) */\n    fillStyle: string | CanvasGradient | CanvasPattern;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/strokeStyle) */\n    strokeStyle: string | CanvasGradient | CanvasPattern;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/createConicGradient) */\n    createConicGradient(startAngle: number, x: number, y: number): CanvasGradient;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/createLinearGradient) */\n    createLinearGradient(x0: number, y0: number, x1: number, y1: number): CanvasGradient;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/createPattern) */\n    createPattern(image: CanvasImageSource, repetition: string | null): CanvasPattern | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/createRadialGradient) */\n    createRadialGradient(x0: number, y0: number, r0: number, x1: number, y1: number, r1: number): CanvasGradient;\n}\n\ninterface CanvasFilters {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/filter) */\n    filter: string;\n}\n\n/**\n * The **`CanvasGradient`** interface represents an opaque object describing a gradient.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasGradient)\n */\ninterface CanvasGradient {\n    /**\n     * The **`CanvasGradient.addColorStop()`** method adds a new color stop, defined by an `offset` and a `color`, to a given canvas gradient.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasGradient/addColorStop)\n     */\n    addColorStop(offset: number, color: string): void;\n}\n\ndeclare var CanvasGradient: {\n    prototype: CanvasGradient;\n    new(): CanvasGradient;\n};\n\ninterface CanvasImageData {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/createImageData) */\n    createImageData(sw: number, sh: number, settings?: ImageDataSettings): ImageData;\n    createImageData(imageData: ImageData): ImageData;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/getImageData) */\n    getImageData(sx: number, sy: number, sw: number, sh: number, settings?: ImageDataSettings): ImageData;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/putImageData) */\n    putImageData(imageData: ImageData, dx: number, dy: number): void;\n    putImageData(imageData: ImageData, dx: number, dy: number, dirtyX: number, dirtyY: number, dirtyWidth: number, dirtyHeight: number): void;\n}\n\ninterface CanvasImageSmoothing {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/imageSmoothingEnabled) */\n    imageSmoothingEnabled: boolean;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/imageSmoothingQuality) */\n    imageSmoothingQuality: ImageSmoothingQuality;\n}\n\ninterface CanvasPath {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/arc) */\n    arc(x: number, y: number, radius: number, startAngle: number, endAngle: number, counterclockwise?: boolean): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/arcTo) */\n    arcTo(x1: number, y1: number, x2: number, y2: number, radius: number): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/bezierCurveTo) */\n    bezierCurveTo(cp1x: number, cp1y: number, cp2x: number, cp2y: number, x: number, y: number): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/closePath) */\n    closePath(): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/ellipse) */\n    ellipse(x: number, y: number, radiusX: number, radiusY: number, rotation: number, startAngle: number, endAngle: number, counterclockwise?: boolean): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/lineTo) */\n    lineTo(x: number, y: number): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/moveTo) */\n    moveTo(x: number, y: number): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/quadraticCurveTo) */\n    quadraticCurveTo(cpx: number, cpy: number, x: number, y: number): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/rect) */\n    rect(x: number, y: number, w: number, h: number): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/roundRect) */\n    roundRect(x: number, y: number, w: number, h: number, radii?: number | DOMPointInit | (number | DOMPointInit)[]): void;\n}\n\ninterface CanvasPathDrawingStyles {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/lineCap) */\n    lineCap: CanvasLineCap;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/lineDashOffset) */\n    lineDashOffset: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/lineJoin) */\n    lineJoin: CanvasLineJoin;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/lineWidth) */\n    lineWidth: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/miterLimit) */\n    miterLimit: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/getLineDash) */\n    getLineDash(): number[];\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/setLineDash) */\n    setLineDash(segments: number[]): void;\n}\n\n/**\n * The **`CanvasPattern`** interface represents an opaque object describing a pattern, based on an image, a canvas, or a video, created by the CanvasRenderingContext2D.createPattern() method.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasPattern)\n */\ninterface CanvasPattern {\n    /**\n     * The **`CanvasPattern.setTransform()`** method uses a DOMMatrix object as the pattern's transformation matrix and invokes it on the pattern.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasPattern/setTransform)\n     */\n    setTransform(transform?: DOMMatrix2DInit): void;\n}\n\ndeclare var CanvasPattern: {\n    prototype: CanvasPattern;\n    new(): CanvasPattern;\n};\n\ninterface CanvasRect {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/clearRect) */\n    clearRect(x: number, y: number, w: number, h: number): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/fillRect) */\n    fillRect(x: number, y: number, w: number, h: number): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/strokeRect) */\n    strokeRect(x: number, y: number, w: number, h: number): void;\n}\n\n/**\n * The **`CanvasRenderingContext2D`** interface, part of the Canvas API, provides the 2D rendering context for the drawing surface of a canvas element.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D)\n */\ninterface CanvasRenderingContext2D extends CanvasCompositing, CanvasDrawImage, CanvasDrawPath, CanvasFillStrokeStyles, CanvasFilters, CanvasImageData, CanvasImageSmoothing, CanvasPath, CanvasPathDrawingStyles, CanvasRect, CanvasSettings, CanvasShadowStyles, CanvasState, CanvasText, CanvasTextDrawingStyles, CanvasTransform, CanvasUserInterface {\n    /**\n     * The **`CanvasRenderingContext2D.canvas`** property, part of the Canvas API, is a read-only reference to the might be `null` if there is no associated canvas element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/canvas)\n     */\n    readonly canvas: HTMLCanvasElement;\n}\n\ndeclare var CanvasRenderingContext2D: {\n    prototype: CanvasRenderingContext2D;\n    new(): CanvasRenderingContext2D;\n};\n\ninterface CanvasSettings {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/getContextAttributes) */\n    getContextAttributes(): CanvasRenderingContext2DSettings;\n}\n\ninterface CanvasShadowStyles {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/shadowBlur) */\n    shadowBlur: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/shadowColor) */\n    shadowColor: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/shadowOffsetX) */\n    shadowOffsetX: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/shadowOffsetY) */\n    shadowOffsetY: number;\n}\n\ninterface CanvasState {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/isContextLost) */\n    isContextLost(): boolean;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/reset) */\n    reset(): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/restore) */\n    restore(): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/save) */\n    save(): void;\n}\n\ninterface CanvasText {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/fillText) */\n    fillText(text: string, x: number, y: number, maxWidth?: number): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/measureText) */\n    measureText(text: string): TextMetrics;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/strokeText) */\n    strokeText(text: string, x: number, y: number, maxWidth?: number): void;\n}\n\ninterface CanvasTextDrawingStyles {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/direction) */\n    direction: CanvasDirection;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/font) */\n    font: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/fontKerning) */\n    fontKerning: CanvasFontKerning;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/fontStretch) */\n    fontStretch: CanvasFontStretch;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/fontVariantCaps) */\n    fontVariantCaps: CanvasFontVariantCaps;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/letterSpacing) */\n    letterSpacing: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/textAlign) */\n    textAlign: CanvasTextAlign;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/textBaseline) */\n    textBaseline: CanvasTextBaseline;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/textRendering) */\n    textRendering: CanvasTextRendering;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/wordSpacing) */\n    wordSpacing: string;\n}\n\ninterface CanvasTransform {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/getTransform) */\n    getTransform(): DOMMatrix;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/resetTransform) */\n    resetTransform(): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/rotate) */\n    rotate(angle: number): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/scale) */\n    scale(x: number, y: number): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/setTransform) */\n    setTransform(a: number, b: number, c: number, d: number, e: number, f: number): void;\n    setTransform(transform?: DOMMatrix2DInit): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/transform) */\n    transform(a: number, b: number, c: number, d: number, e: number, f: number): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/translate) */\n    translate(x: number, y: number): void;\n}\n\ninterface CanvasUserInterface {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/drawFocusIfNeeded) */\n    drawFocusIfNeeded(element: Element): void;\n    drawFocusIfNeeded(path: Path2D, element: Element): void;\n}\n\n/**\n * The `CaretPosition` interface represents the caret position, an indicator for the text insertion point.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CaretPosition)\n */\ninterface CaretPosition {\n    readonly offset: number;\n    readonly offsetNode: Node;\n    getClientRect(): DOMRect | null;\n}\n\ndeclare var CaretPosition: {\n    prototype: CaretPosition;\n    new(): CaretPosition;\n};\n\n/**\n * The `ChannelMergerNode` interface, often used in conjunction with its opposite, ChannelSplitterNode, reunites different mono inputs into a single output.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ChannelMergerNode)\n */\ninterface ChannelMergerNode extends AudioNode {\n}\n\ndeclare var ChannelMergerNode: {\n    prototype: ChannelMergerNode;\n    new(context: BaseAudioContext, options?: ChannelMergerOptions): ChannelMergerNode;\n};\n\n/**\n * The `ChannelSplitterNode` interface, often used in conjunction with its opposite, ChannelMergerNode, separates the different channels of an audio source into a set of mono outputs.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ChannelSplitterNode)\n */\ninterface ChannelSplitterNode extends AudioNode {\n}\n\ndeclare var ChannelSplitterNode: {\n    prototype: ChannelSplitterNode;\n    new(context: BaseAudioContext, options?: ChannelSplitterOptions): ChannelSplitterNode;\n};\n\n/**\n * The **`CharacterData`** abstract interface represents a Node object that contains characters.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData)\n */\ninterface CharacterData extends Node, ChildNode, NonDocumentTypeChildNode {\n    /**\n     * The **`data`** property of the CharacterData interface represent the value of the current object's data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/data)\n     */\n    data: string;\n    /**\n     * The read-only **`CharacterData.length`** property returns the number of characters in the contained data, as a positive integer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/length)\n     */\n    readonly length: number;\n    readonly ownerDocument: Document;\n    /**\n     * The **`appendData()`** method of the CharacterData interface adds the provided data to the end of the node's current data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/appendData)\n     */\n    appendData(data: string): void;\n    /**\n     * The **`deleteData()`** method of the CharacterData interface removes all or part of the data from this `CharacterData` node.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/deleteData)\n     */\n    deleteData(offset: number, count: number): void;\n    /**\n     * The **`insertData()`** method of the CharacterData interface inserts the provided data into this `CharacterData` node's current data, at the provided offset from the start of the existing data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/insertData)\n     */\n    insertData(offset: number, data: string): void;\n    /**\n     * The **`replaceData()`** method of the CharacterData interface removes a certain number of characters of the existing text in a given `CharacterData` node and replaces those characters with the text provided.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/replaceData)\n     */\n    replaceData(offset: number, count: number, data: string): void;\n    /**\n     * The **`substringData()`** method of the CharacterData interface returns a portion of the existing data, starting at the specified index and extending for a given number of characters afterwards.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/substringData)\n     */\n    substringData(offset: number, count: number): string;\n    /** [MDN Reference](https://developer.mozilla.org/en-US/docs/Web/API/Node/textContent) */\n    get textContent(): string;\n    set textContent(value: string | null);\n}\n\ndeclare var CharacterData: {\n    prototype: CharacterData;\n    new(): CharacterData;\n};\n\ninterface ChildNode extends Node {\n    /**\n     * Inserts nodes just after node, while replacing strings in nodes with equivalent Text nodes.\n     *\n     * Throws a \"HierarchyRequestError\" DOMException if the constraints of the node tree are violated.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/after)\n     */\n    after(...nodes: (Node | string)[]): void;\n    /**\n     * Inserts nodes just before node, while replacing strings in nodes with equivalent Text nodes.\n     *\n     * Throws a \"HierarchyRequestError\" DOMException if the constraints of the node tree are violated.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/before)\n     */\n    before(...nodes: (Node | string)[]): void;\n    /**\n     * Removes node.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/remove)\n     */\n    remove(): void;\n    /**\n     * Replaces node with nodes, while replacing strings in nodes with equivalent Text nodes.\n     *\n     * Throws a \"HierarchyRequestError\" DOMException if the constraints of the node tree are violated.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CharacterData/replaceWith)\n     */\n    replaceWith(...nodes: (Node | string)[]): void;\n}\n\n/** @deprecated */\ninterface ClientRect extends DOMRect {\n}\n\n/**\n * The **`Clipboard`** interface of the Clipboard API provides read and write access to the contents of the system clipboard.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Clipboard)\n */\ninterface Clipboard extends EventTarget {\n    /**\n     * The **`read()`** method of the Clipboard interface requests a copy of the clipboard's contents, fulfilling the returned Promise with the data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Clipboard/read)\n     */\n    read(): Promise<ClipboardItems>;\n    /**\n     * The **`readText()`** method of the Clipboard interface returns a Promise which fulfills with a copy of the textual contents of the system clipboard.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Clipboard/readText)\n     */\n    readText(): Promise<string>;\n    /**\n     * The **`write()`** method of the Clipboard interface writes arbitrary ClipboardItem data such as images and text to the clipboard, fulfilling the returned Promise on completion.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Clipboard/write)\n     */\n    write(data: ClipboardItems): Promise<void>;\n    /**\n     * The **`writeText()`** method of the Clipboard interface writes the specified text to the system clipboard, returning a Promise that is resolved once the system clipboard has been updated.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Clipboard/writeText)\n     */\n    writeText(data: string): Promise<void>;\n}\n\ndeclare var Clipboard: {\n    prototype: Clipboard;\n    new(): Clipboard;\n};\n\n/**\n * The **`ClipboardEvent`** interface of the Clipboard API represents events providing information related to modification of the clipboard, that is Element/cut_event, Element/copy_event, and Element/paste_event events.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ClipboardEvent)\n */\ninterface ClipboardEvent extends Event {\n    /**\n     * The **`clipboardData`** property of the ClipboardEvent interface holds a DataTransfer object, which can be used to: - specify what data should be put into the clipboard from the Element/cut_event and Element/copy_event event handlers, typically with a DataTransfer.setData call; - obtain the data to be pasted from the Element/paste_event event handler, typically with a DataTransfer.getData call.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ClipboardEvent/clipboardData)\n     */\n    readonly clipboardData: DataTransfer | null;\n}\n\ndeclare var ClipboardEvent: {\n    prototype: ClipboardEvent;\n    new(type: string, eventInitDict?: ClipboardEventInit): ClipboardEvent;\n};\n\n/**\n * The **`ClipboardItem`** interface of the Clipboard API represents a single item format, used when reading or writing clipboard data using Clipboard.read() and Clipboard.write() respectively.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ClipboardItem)\n */\ninterface ClipboardItem {\n    /**\n     * The read-only **`presentationStyle`** property of the ClipboardItem interface returns a string indicating how an item should be presented.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ClipboardItem/presentationStyle)\n     */\n    readonly presentationStyle: PresentationStyle;\n    /**\n     * The read-only **`types`** property of the ClipboardItem interface returns an Array of MIME type available within the ClipboardItem.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ClipboardItem/types)\n     */\n    readonly types: ReadonlyArray<string>;\n    /**\n     * The **`getType()`** method of the ClipboardItem interface returns a Promise that resolves with a Blob of the requested MIME type or an error if the MIME type is not found.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ClipboardItem/getType)\n     */\n    getType(type: string): Promise<Blob>;\n}\n\ndeclare var ClipboardItem: {\n    prototype: ClipboardItem;\n    new(items: Record<string, string | Blob | PromiseLike<string | Blob>>, options?: ClipboardItemOptions): ClipboardItem;\n    /**\n     * The **`supports()`** static method of the ClipboardItem interface returns `true` if the given MIME type is supported by the clipboard, and `false` otherwise.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ClipboardItem/supports_static)\n     */\n    supports(type: string): boolean;\n};\n\n/**\n * A `CloseEvent` is sent to clients using WebSockets when the connection is closed.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CloseEvent)\n */\ninterface CloseEvent extends Event {\n    /**\n     * The **`code`** read-only property of the CloseEvent interface returns a WebSocket connection close code indicating the reason the connection was closed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CloseEvent/code)\n     */\n    readonly code: number;\n    /**\n     * The **`reason`** read-only property of the CloseEvent interface returns the WebSocket connection close reason the server gave for closing the connection; that is, a concise human-readable prose explanation for the closure.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CloseEvent/reason)\n     */\n    readonly reason: string;\n    /**\n     * The **`wasClean`** read-only property of the CloseEvent interface returns `true` if the connection closed cleanly.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CloseEvent/wasClean)\n     */\n    readonly wasClean: boolean;\n}\n\ndeclare var CloseEvent: {\n    prototype: CloseEvent;\n    new(type: string, eventInitDict?: CloseEventInit): CloseEvent;\n};\n\n/**\n * The **`Comment`** interface represents textual notations within markup; although it is generally not visually shown, such comments are available to be read in the source view.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Comment)\n */\ninterface Comment extends CharacterData {\n}\n\ndeclare var Comment: {\n    prototype: Comment;\n    new(data?: string): Comment;\n};\n\n/**\n * The DOM **`CompositionEvent`** represents events that occur due to the user indirectly entering text.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CompositionEvent)\n */\ninterface CompositionEvent extends UIEvent {\n    /**\n     * The **`data`** read-only property of the method that raised the event; its exact nature varies depending on the type of event that generated the `CompositionEvent` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CompositionEvent/data)\n     */\n    readonly data: string;\n    /**\n     * The **`initCompositionEvent()`** method of the CompositionEvent interface initializes the attributes of a `CompositionEvent` object instance.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CompositionEvent/initCompositionEvent)\n     */\n    initCompositionEvent(typeArg: string, bubblesArg?: boolean, cancelableArg?: boolean, viewArg?: WindowProxy | null, dataArg?: string): void;\n}\n\ndeclare var CompositionEvent: {\n    prototype: CompositionEvent;\n    new(type: string, eventInitDict?: CompositionEventInit): CompositionEvent;\n};\n\n/**\n * The **`CompressionStream`** interface of the Compression Streams API is an API for compressing a stream of data.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CompressionStream)\n */\ninterface CompressionStream extends GenericTransformStream {\n    readonly readable: ReadableStream<Uint8Array<ArrayBuffer>>;\n    readonly writable: WritableStream<BufferSource>;\n}\n\ndeclare var CompressionStream: {\n    prototype: CompressionStream;\n    new(format: CompressionFormat): CompressionStream;\n};\n\n/**\n * The `ConstantSourceNode` interface—part of the Web Audio API—represents an audio source (based upon AudioScheduledSourceNode) whose output is single unchanging value.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ConstantSourceNode)\n */\ninterface ConstantSourceNode extends AudioScheduledSourceNode {\n    /**\n     * The read-only `offset` property of the ConstantSourceNode interface returns a AudioParam object indicating the numeric a-rate value which is always returned by the source when asked for the next sample.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ConstantSourceNode/offset)\n     */\n    readonly offset: AudioParam;\n    addEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: ConstantSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: ConstantSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var ConstantSourceNode: {\n    prototype: ConstantSourceNode;\n    new(context: BaseAudioContext, options?: ConstantSourceOptions): ConstantSourceNode;\n};\n\n/**\n * The **`ContentVisibilityAutoStateChangeEvent`** interface is the event object for the element/contentvisibilityautostatechange_event event, which fires on any element with content-visibility set on it when it starts or stops being relevant to the user and skipping its contents.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ContentVisibilityAutoStateChangeEvent)\n */\ninterface ContentVisibilityAutoStateChangeEvent extends Event {\n    /**\n     * The `skipped` read-only property of the ContentVisibilityAutoStateChangeEvent interface returns `true` if the user agent skips the element's contents, or `false` otherwise.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ContentVisibilityAutoStateChangeEvent/skipped)\n     */\n    readonly skipped: boolean;\n}\n\ndeclare var ContentVisibilityAutoStateChangeEvent: {\n    prototype: ContentVisibilityAutoStateChangeEvent;\n    new(type: string, eventInitDict?: ContentVisibilityAutoStateChangeEventInit): ContentVisibilityAutoStateChangeEvent;\n};\n\n/**\n * The `ConvolverNode` interface is an AudioNode that performs a Linear Convolution on a given AudioBuffer, often used to achieve a reverb effect.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ConvolverNode)\n */\ninterface ConvolverNode extends AudioNode {\n    /**\n     * The **`buffer`** property of the ConvolverNode interface represents a mono, stereo, or 4-channel AudioBuffer containing the (possibly multichannel) impulse response used by the `ConvolverNode` to create the reverb effect.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ConvolverNode/buffer)\n     */\n    buffer: AudioBuffer | null;\n    /**\n     * The `normalize` property of the ConvolverNode interface is a boolean that controls whether the impulse response from the buffer will be scaled by an equal-power normalization when the `buffer` attribute is set, or not.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ConvolverNode/normalize)\n     */\n    normalize: boolean;\n}\n\ndeclare var ConvolverNode: {\n    prototype: ConvolverNode;\n    new(context: BaseAudioContext, options?: ConvolverOptions): ConvolverNode;\n};\n\n/**\n * The **`CookieChangeEvent`** interface of the Cookie Store API is the event type of the CookieStore/change_event event fired at a CookieStore when any cookies are created or deleted.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CookieChangeEvent)\n */\ninterface CookieChangeEvent extends Event {\n    /**\n     * The **`changed`** read-only property of the CookieChangeEvent interface returns an array of the cookies that have been changed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CookieChangeEvent/changed)\n     */\n    readonly changed: ReadonlyArray<CookieListItem>;\n    /**\n     * The **`deleted`** read-only property of the CookieChangeEvent interface returns an array of the cookies that have been deleted by the given `CookieChangeEvent` instance.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CookieChangeEvent/deleted)\n     */\n    readonly deleted: ReadonlyArray<CookieListItem>;\n}\n\ndeclare var CookieChangeEvent: {\n    prototype: CookieChangeEvent;\n    new(type: string, eventInitDict?: CookieChangeEventInit): CookieChangeEvent;\n};\n\ninterface CookieStoreEventMap {\n    \"change\": CookieChangeEvent;\n}\n\n/**\n * The **`CookieStore`** interface of the Cookie Store API provides methods for getting and setting cookies asynchronously from either a page or a service worker.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CookieStore)\n */\ninterface CookieStore extends EventTarget {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CookieStore/change_event) */\n    onchange: ((this: CookieStore, ev: CookieChangeEvent) => any) | null;\n    /**\n     * The **`delete()`** method of the CookieStore interface deletes a cookie that matches the given `name` or `options` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CookieStore/delete)\n     */\n    delete(name: string): Promise<void>;\n    delete(options: CookieStoreDeleteOptions): Promise<void>;\n    /**\n     * The **`get()`** method of the CookieStore interface returns a Promise that resolves to a single cookie matching the given `name` or `options` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CookieStore/get)\n     */\n    get(name: string): Promise<CookieListItem | null>;\n    get(options?: CookieStoreGetOptions): Promise<CookieListItem | null>;\n    /**\n     * The **`getAll()`** method of the CookieStore interface returns a Promise that resolves as an array of cookies that match the `name` or `options` passed to it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CookieStore/getAll)\n     */\n    getAll(name: string): Promise<CookieList>;\n    getAll(options?: CookieStoreGetOptions): Promise<CookieList>;\n    /**\n     * The **`set()`** method of the CookieStore interface sets a cookie with the given `name` and `value` or `options` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CookieStore/set)\n     */\n    set(name: string, value: string): Promise<void>;\n    set(options: CookieInit): Promise<void>;\n    addEventListener<K extends keyof CookieStoreEventMap>(type: K, listener: (this: CookieStore, ev: CookieStoreEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof CookieStoreEventMap>(type: K, listener: (this: CookieStore, ev: CookieStoreEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var CookieStore: {\n    prototype: CookieStore;\n    new(): CookieStore;\n};\n\n/**\n * The **`CookieStoreManager`** interface of the Cookie Store API allows service workers to subscribe to cookie change events.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CookieStoreManager)\n */\ninterface CookieStoreManager {\n    /**\n     * The **`getSubscriptions()`** method of the CookieStoreManager interface returns a list of all the cookie change subscriptions for this ServiceWorkerRegistration.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CookieStoreManager/getSubscriptions)\n     */\n    getSubscriptions(): Promise<CookieStoreGetOptions[]>;\n    /**\n     * The **`subscribe()`** method of the CookieStoreManager interface subscribes a ServiceWorkerRegistration to cookie change events.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CookieStoreManager/subscribe)\n     */\n    subscribe(subscriptions: CookieStoreGetOptions[]): Promise<void>;\n    /**\n     * The **`unsubscribe()`** method of the CookieStoreManager interface stops the ServiceWorkerRegistration from receiving previously subscribed events.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CookieStoreManager/unsubscribe)\n     */\n    unsubscribe(subscriptions: CookieStoreGetOptions[]): Promise<void>;\n}\n\ndeclare var CookieStoreManager: {\n    prototype: CookieStoreManager;\n    new(): CookieStoreManager;\n};\n\n/**\n * The **`CountQueuingStrategy`** interface of the Streams API provides a built-in chunk counting queuing strategy that can be used when constructing streams.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CountQueuingStrategy)\n */\ninterface CountQueuingStrategy extends QueuingStrategy {\n    /**\n     * The read-only **`CountQueuingStrategy.highWaterMark`** property returns the total number of chunks that can be contained in the internal queue before backpressure is applied.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CountQueuingStrategy/highWaterMark)\n     */\n    readonly highWaterMark: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CountQueuingStrategy/size) */\n    readonly size: QueuingStrategySize;\n}\n\ndeclare var CountQueuingStrategy: {\n    prototype: CountQueuingStrategy;\n    new(init: QueuingStrategyInit): CountQueuingStrategy;\n};\n\n/**\n * The **`Credential`** interface of the Credential Management API provides information about an entity (usually a user) normally as a prerequisite to a trust decision.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Credential)\n */\ninterface Credential {\n    /**\n     * The **`id`** read-only property of the Credential interface returns a string containing the credential's identifier.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Credential/id)\n     */\n    readonly id: string;\n    /**\n     * The **`type`** read-only property of the Credential interface returns a string containing the credential's type.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Credential/type)\n     */\n    readonly type: string;\n}\n\ndeclare var Credential: {\n    prototype: Credential;\n    new(): Credential;\n};\n\n/**\n * The **`CredentialsContainer`** interface of the Credential Management API exposes methods to request credentials and notify the user agent when events such as successful sign in or sign out happen.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CredentialsContainer)\n */\ninterface CredentialsContainer {\n    /**\n     * The **`create()`** method of the CredentialsContainer interface creates a new credential, which can then be stored and later retrieved using the CredentialsContainer.get method.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CredentialsContainer/create)\n     */\n    create(options?: CredentialCreationOptions): Promise<Credential | null>;\n    /**\n     * The **`get()`** method of the CredentialsContainer interface returns a Promise that fulfills with a single credential, which can then be used to authenticate a user to a website.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CredentialsContainer/get)\n     */\n    get(options?: CredentialRequestOptions): Promise<Credential | null>;\n    /**\n     * The **`preventSilentAccess()`** method of the CredentialsContainer interface sets a flag that specifies whether automatic log in is allowed for future visits to the current origin, then returns a Promise that resolves to `undefined`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CredentialsContainer/preventSilentAccess)\n     */\n    preventSilentAccess(): Promise<void>;\n    /**\n     * The **`store()`** method of the ```js-nolint store(credentials) ``` - `credentials` - : A valid Credential instance.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CredentialsContainer/store)\n     */\n    store(credential: Credential): Promise<void>;\n}\n\ndeclare var CredentialsContainer: {\n    prototype: CredentialsContainer;\n    new(): CredentialsContainer;\n};\n\n/**\n * The **`Crypto`** interface represents basic cryptography features available in the current context.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Crypto)\n */\ninterface Crypto {\n    /**\n     * The **`Crypto.subtle`** read-only property returns a cryptographic operations.\n     * Available only in secure contexts.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Crypto/subtle)\n     */\n    readonly subtle: SubtleCrypto;\n    /**\n     * The **`Crypto.getRandomValues()`** method lets you get cryptographically strong random values.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Crypto/getRandomValues)\n     */\n    getRandomValues<T extends ArrayBufferView>(array: T): T;\n    /**\n     * The **`randomUUID()`** method of the Crypto interface is used to generate a v4 UUID using a cryptographically secure random number generator.\n     * Available only in secure contexts.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Crypto/randomUUID)\n     */\n    randomUUID(): `${string}-${string}-${string}-${string}-${string}`;\n}\n\ndeclare var Crypto: {\n    prototype: Crypto;\n    new(): Crypto;\n};\n\n/**\n * The **`CryptoKey`** interface of the Web Crypto API represents a cryptographic key obtained from one of the SubtleCrypto methods SubtleCrypto.generateKey, SubtleCrypto.deriveKey, SubtleCrypto.importKey, or SubtleCrypto.unwrapKey.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CryptoKey)\n */\ninterface CryptoKey {\n    /**\n     * The read-only **`algorithm`** property of the CryptoKey interface returns an object describing the algorithm for which this key can be used, and any associated extra parameters.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CryptoKey/algorithm)\n     */\n    readonly algorithm: KeyAlgorithm;\n    /**\n     * The read-only **`extractable`** property of the CryptoKey interface indicates whether or not the key may be extracted using `SubtleCrypto.exportKey()` or `SubtleCrypto.wrapKey()`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CryptoKey/extractable)\n     */\n    readonly extractable: boolean;\n    /**\n     * The read-only **`type`** property of the CryptoKey interface indicates which kind of key is represented by the object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CryptoKey/type)\n     */\n    readonly type: KeyType;\n    /**\n     * The read-only **`usages`** property of the CryptoKey interface indicates what can be done with the key.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CryptoKey/usages)\n     */\n    readonly usages: KeyUsage[];\n}\n\ndeclare var CryptoKey: {\n    prototype: CryptoKey;\n    new(): CryptoKey;\n};\n\n/**\n * The **`CustomElementRegistry`** interface provides methods for registering custom elements and querying registered elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomElementRegistry)\n */\ninterface CustomElementRegistry {\n    /**\n     * The **`define()`** method of the CustomElementRegistry interface adds a definition for a custom element to the custom element registry, mapping its name to the constructor which will be used to create it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomElementRegistry/define)\n     */\n    define(name: string, constructor: CustomElementConstructor, options?: ElementDefinitionOptions): void;\n    /**\n     * The **`get()`** method of the previously-defined custom element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomElementRegistry/get)\n     */\n    get(name: string): CustomElementConstructor | undefined;\n    /**\n     * The **`getName()`** method of the previously-defined custom element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomElementRegistry/getName)\n     */\n    getName(constructor: CustomElementConstructor): string | null;\n    /**\n     * The **`upgrade()`** method of the elements in a Node subtree, even before they are connected to the main document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomElementRegistry/upgrade)\n     */\n    upgrade(root: Node): void;\n    /**\n     * The **`whenDefined()`** method of the resolves when the named element is defined.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomElementRegistry/whenDefined)\n     */\n    whenDefined(name: string): Promise<CustomElementConstructor>;\n}\n\ndeclare var CustomElementRegistry: {\n    prototype: CustomElementRegistry;\n    new(): CustomElementRegistry;\n};\n\n/**\n * The **`CustomEvent`** interface represents events initialized by an application for any purpose.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomEvent)\n */\ninterface CustomEvent<T = any> extends Event {\n    /**\n     * The read-only **`detail`** property of the CustomEvent interface returns any data passed when initializing the event.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomEvent/detail)\n     */\n    readonly detail: T;\n    /**\n     * The **`CustomEvent.initCustomEvent()`** method initializes a CustomEvent object.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomEvent/initCustomEvent)\n     */\n    initCustomEvent(type: string, bubbles?: boolean, cancelable?: boolean, detail?: T): void;\n}\n\ndeclare var CustomEvent: {\n    prototype: CustomEvent;\n    new<T>(type: string, eventInitDict?: CustomEventInit<T>): CustomEvent<T>;\n};\n\n/**\n * The **`CustomStateSet`** interface of the Document Object Model stores a list of states for an autonomous custom element, and allows states to be added and removed from the set.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/CustomStateSet)\n */\ninterface CustomStateSet {\n    forEach(callbackfn: (value: string, key: string, parent: CustomStateSet) => void, thisArg?: any): void;\n}\n\ndeclare var CustomStateSet: {\n    prototype: CustomStateSet;\n    new(): CustomStateSet;\n};\n\n/**\n * The **`DOMException`** interface represents an abnormal event (called an **exception**) that occurs as a result of calling a method or accessing a property of a web API.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMException)\n */\ninterface DOMException extends Error {\n    /**\n     * The **`code`** read-only property of the DOMException interface returns one of the legacy error code constants, or `0` if none match.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMException/code)\n     */\n    readonly code: number;\n    /**\n     * The **`message`** read-only property of the a message or description associated with the given error name.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMException/message)\n     */\n    readonly message: string;\n    /**\n     * The **`name`** read-only property of the one of the strings associated with an error name.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMException/name)\n     */\n    readonly name: string;\n    readonly INDEX_SIZE_ERR: 1;\n    readonly DOMSTRING_SIZE_ERR: 2;\n    readonly HIERARCHY_REQUEST_ERR: 3;\n    readonly WRONG_DOCUMENT_ERR: 4;\n    readonly INVALID_CHARACTER_ERR: 5;\n    readonly NO_DATA_ALLOWED_ERR: 6;\n    readonly NO_MODIFICATION_ALLOWED_ERR: 7;\n    readonly NOT_FOUND_ERR: 8;\n    readonly NOT_SUPPORTED_ERR: 9;\n    readonly INUSE_ATTRIBUTE_ERR: 10;\n    readonly INVALID_STATE_ERR: 11;\n    readonly SYNTAX_ERR: 12;\n    readonly INVALID_MODIFICATION_ERR: 13;\n    readonly NAMESPACE_ERR: 14;\n    readonly INVALID_ACCESS_ERR: 15;\n    readonly VALIDATION_ERR: 16;\n    readonly TYPE_MISMATCH_ERR: 17;\n    readonly SECURITY_ERR: 18;\n    readonly NETWORK_ERR: 19;\n    readonly ABORT_ERR: 20;\n    readonly URL_MISMATCH_ERR: 21;\n    readonly QUOTA_EXCEEDED_ERR: 22;\n    readonly TIMEOUT_ERR: 23;\n    readonly INVALID_NODE_TYPE_ERR: 24;\n    readonly DATA_CLONE_ERR: 25;\n}\n\ndeclare var DOMException: {\n    prototype: DOMException;\n    new(message?: string, name?: string): DOMException;\n    readonly INDEX_SIZE_ERR: 1;\n    readonly DOMSTRING_SIZE_ERR: 2;\n    readonly HIERARCHY_REQUEST_ERR: 3;\n    readonly WRONG_DOCUMENT_ERR: 4;\n    readonly INVALID_CHARACTER_ERR: 5;\n    readonly NO_DATA_ALLOWED_ERR: 6;\n    readonly NO_MODIFICATION_ALLOWED_ERR: 7;\n    readonly NOT_FOUND_ERR: 8;\n    readonly NOT_SUPPORTED_ERR: 9;\n    readonly INUSE_ATTRIBUTE_ERR: 10;\n    readonly INVALID_STATE_ERR: 11;\n    readonly SYNTAX_ERR: 12;\n    readonly INVALID_MODIFICATION_ERR: 13;\n    readonly NAMESPACE_ERR: 14;\n    readonly INVALID_ACCESS_ERR: 15;\n    readonly VALIDATION_ERR: 16;\n    readonly TYPE_MISMATCH_ERR: 17;\n    readonly SECURITY_ERR: 18;\n    readonly NETWORK_ERR: 19;\n    readonly ABORT_ERR: 20;\n    readonly URL_MISMATCH_ERR: 21;\n    readonly QUOTA_EXCEEDED_ERR: 22;\n    readonly TIMEOUT_ERR: 23;\n    readonly INVALID_NODE_TYPE_ERR: 24;\n    readonly DATA_CLONE_ERR: 25;\n};\n\n/**\n * The **`DOMImplementation`** interface represents an object providing methods which are not dependent on any particular document.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMImplementation)\n */\ninterface DOMImplementation {\n    /**\n     * The **`DOMImplementation.createDocument()`** method creates and returns an XMLDocument.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMImplementation/createDocument)\n     */\n    createDocument(namespace: string | null, qualifiedName: string | null, doctype?: DocumentType | null): XMLDocument;\n    /**\n     * The **`DOMImplementation.createDocumentType()`** method returns a DocumentType object which can either be used with into the document via methods like Node.insertBefore() or ```js-nolint createDocumentType(qualifiedNameStr, publicId, systemId) ``` - `qualifiedNameStr` - : A string containing the qualified name, like `svg:svg`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMImplementation/createDocumentType)\n     */\n    createDocumentType(name: string, publicId: string, systemId: string): DocumentType;\n    /**\n     * The **`DOMImplementation.createHTMLDocument()`** method creates a new HTML Document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMImplementation/createHTMLDocument)\n     */\n    createHTMLDocument(title?: string): Document;\n    /**\n     * The **`DOMImplementation.hasFeature()`** method returns a boolean flag indicating if a given feature is supported.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMImplementation/hasFeature)\n     */\n    hasFeature(...args: any[]): true;\n}\n\ndeclare var DOMImplementation: {\n    prototype: DOMImplementation;\n    new(): DOMImplementation;\n};\n\n/**\n * The **`DOMMatrix`** interface represents 4×4 matrices, suitable for 2D and 3D operations including rotation and translation.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix)\n */\ninterface DOMMatrix extends DOMMatrixReadOnly {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    a: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    b: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    c: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    d: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    e: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    f: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    m11: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    m12: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    m13: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    m14: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    m21: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    m22: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    m23: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    m24: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    m31: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    m32: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    m33: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    m34: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    m41: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    m42: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    m43: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix#instance_properties) */\n    m44: number;\n    /**\n     * The **`invertSelf()`** method of the DOMMatrix interface inverts the original matrix.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix/invertSelf)\n     */\n    invertSelf(): DOMMatrix;\n    /**\n     * The **`multiplySelf()`** method of the DOMMatrix interface multiplies a matrix by the `otherMatrix` parameter, computing the dot product of the original matrix and the specified matrix: `A⋅B`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix/multiplySelf)\n     */\n    multiplySelf(other?: DOMMatrixInit): DOMMatrix;\n    /**\n     * The **`preMultiplySelf()`** method of the DOMMatrix interface modifies the matrix by pre-multiplying it with the specified `DOMMatrix`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix/preMultiplySelf)\n     */\n    preMultiplySelf(other?: DOMMatrixInit): DOMMatrix;\n    /**\n     * The `rotateAxisAngleSelf()` method of the DOMMatrix interface is a transformation method that rotates the source matrix by the given vector and angle, returning the altered matrix.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix/rotateAxisAngleSelf)\n     */\n    rotateAxisAngleSelf(x?: number, y?: number, z?: number, angle?: number): DOMMatrix;\n    /**\n     * The `rotateFromVectorSelf()` method of the DOMMatrix interface is a mutable transformation method that modifies a matrix by rotating the matrix by the angle between the specified vector and `(1, 0)`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix/rotateFromVectorSelf)\n     */\n    rotateFromVectorSelf(x?: number, y?: number): DOMMatrix;\n    /**\n     * The `rotateSelf()` method of the DOMMatrix interface is a mutable transformation method that modifies a matrix.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix/rotateSelf)\n     */\n    rotateSelf(rotX?: number, rotY?: number, rotZ?: number): DOMMatrix;\n    /**\n     * The **`scale3dSelf()`** method of the DOMMatrix interface is a mutable transformation method that modifies a matrix by applying a specified scaling factor to all three axes, centered on the given origin, with a default origin of `(0, 0, 0)`, returning the 3D-scaled matrix.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix/scale3dSelf)\n     */\n    scale3dSelf(scale?: number, originX?: number, originY?: number, originZ?: number): DOMMatrix;\n    /**\n     * The **`scaleSelf()`** method of the DOMMatrix interface is a mutable transformation method that modifies a matrix by applying a specified scaling factor, centered on the given origin, with a default origin of `(0, 0)`, returning the scaled matrix.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix/scaleSelf)\n     */\n    scaleSelf(scaleX?: number, scaleY?: number, scaleZ?: number, originX?: number, originY?: number, originZ?: number): DOMMatrix;\n    /**\n     * The **`setMatrixValue()`** method of the DOMMatrix interface replaces the contents of the matrix with the matrix described by the specified transform or transforms, returning itself.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix/setMatrixValue)\n     */\n    setMatrixValue(transformList: string): DOMMatrix;\n    /**\n     * The `skewXSelf()` method of the DOMMatrix interface is a mutable transformation method that modifies a matrix.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix/skewXSelf)\n     */\n    skewXSelf(sx?: number): DOMMatrix;\n    /**\n     * The `skewYSelf()` method of the DOMMatrix interface is a mutable transformation method that modifies a matrix.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix/skewYSelf)\n     */\n    skewYSelf(sy?: number): DOMMatrix;\n    /**\n     * The `translateSelf()` method of the DOMMatrix interface is a mutable transformation method that modifies a matrix.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrix/translateSelf)\n     */\n    translateSelf(tx?: number, ty?: number, tz?: number): DOMMatrix;\n}\n\ndeclare var DOMMatrix: {\n    prototype: DOMMatrix;\n    new(init?: string | number[]): DOMMatrix;\n    fromFloat32Array(array32: Float32Array<ArrayBuffer>): DOMMatrix;\n    fromFloat64Array(array64: Float64Array<ArrayBuffer>): DOMMatrix;\n    fromMatrix(other?: DOMMatrixInit): DOMMatrix;\n};\n\ntype SVGMatrix = DOMMatrix;\ndeclare var SVGMatrix: typeof DOMMatrix;\n\ntype WebKitCSSMatrix = DOMMatrix;\ndeclare var WebKitCSSMatrix: typeof DOMMatrix;\n\n/**\n * The **`DOMMatrixReadOnly`** interface represents a read-only 4×4 matrix, suitable for 2D and 3D operations.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly)\n */\ninterface DOMMatrixReadOnly {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly a: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly b: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly c: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly d: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly e: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly f: number;\n    /**\n     * The readonly **`is2D`** property of the DOMMatrixReadOnly interface is a Boolean flag that is `true` when the matrix is 2D.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/is2D)\n     */\n    readonly is2D: boolean;\n    /**\n     * The readonly **`isIdentity`** property of the DOMMatrixReadOnly interface is a Boolean whose value is `true` if the matrix is the identity matrix.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/isIdentity)\n     */\n    readonly isIdentity: boolean;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly m11: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly m12: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly m13: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly m14: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly m21: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly m22: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly m23: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly m24: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly m31: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly m32: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly m33: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly m34: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly m41: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly m42: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly m43: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly#instance_properties) */\n    readonly m44: number;\n    /**\n     * The **`flipX()`** method of the DOMMatrixReadOnly interface creates a new matrix being the result of the original matrix flipped about the x-axis.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/flipX)\n     */\n    flipX(): DOMMatrix;\n    /**\n     * The **`flipY()`** method of the DOMMatrixReadOnly interface creates a new matrix being the result of the original matrix flipped about the y-axis.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/flipY)\n     */\n    flipY(): DOMMatrix;\n    /**\n     * The **`inverse()`** method of the DOMMatrixReadOnly interface creates a new matrix which is the inverse of the original matrix.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/inverse)\n     */\n    inverse(): DOMMatrix;\n    /**\n     * The **`multiply()`** method of the DOMMatrixReadOnly interface creates and returns a new matrix which is the dot product of the matrix and the `otherMatrix` parameter.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/multiply)\n     */\n    multiply(other?: DOMMatrixInit): DOMMatrix;\n    /**\n     * The `rotate()` method of the DOMMatrixReadOnly interface returns a new DOMMatrix created by rotating the source matrix around each of its axes by the specified number of degrees.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/rotate)\n     */\n    rotate(rotX?: number, rotY?: number, rotZ?: number): DOMMatrix;\n    /**\n     * The `rotateAxisAngle()` method of the DOMMatrixReadOnly interface returns a new DOMMatrix created by rotating the source matrix by the given vector and angle.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/rotateAxisAngle)\n     */\n    rotateAxisAngle(x?: number, y?: number, z?: number, angle?: number): DOMMatrix;\n    /**\n     * The `rotateFromVector()` method of the DOMMatrixReadOnly interface is returns a new DOMMatrix created by rotating the source matrix by the angle between the specified vector and `(1, 0)`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/rotateFromVector)\n     */\n    rotateFromVector(x?: number, y?: number): DOMMatrix;\n    /**\n     * The **`scale()`** method of the original matrix with a scale transform applied.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/scale)\n     */\n    scale(scaleX?: number, scaleY?: number, scaleZ?: number, originX?: number, originY?: number, originZ?: number): DOMMatrix;\n    /**\n     * The **`scale3d()`** method of the DOMMatrixReadOnly interface creates a new matrix which is the result of a 3D scale transform being applied to the matrix.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/scale3d)\n     */\n    scale3d(scale?: number, originX?: number, originY?: number, originZ?: number): DOMMatrix;\n    /** @deprecated */\n    scaleNonUniform(scaleX?: number, scaleY?: number): DOMMatrix;\n    /**\n     * The `skewX()` method of the DOMMatrixReadOnly interface returns a new DOMMatrix created by applying the specified skew transformation to the source matrix along its x-axis.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/skewX)\n     */\n    skewX(sx?: number): DOMMatrix;\n    /**\n     * The `skewY()` method of the DOMMatrixReadOnly interface returns a new DOMMatrix created by applying the specified skew transformation to the source matrix along its y-axis.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/skewY)\n     */\n    skewY(sy?: number): DOMMatrix;\n    /**\n     * The **`toFloat32Array()`** method of the DOMMatrixReadOnly interface returns a new Float32Array containing all 16 elements (`m11`, `m12`, `m13`, `m14`, `m21`, `m22`, `m23`, `m24`, `m31`, `m32`, `m33`, `m34`, `m41`, `m42`, `m43`, `m44`) which comprise the matrix.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/toFloat32Array)\n     */\n    toFloat32Array(): Float32Array<ArrayBuffer>;\n    /**\n     * The **`toFloat64Array()`** method of the DOMMatrixReadOnly interface returns a new Float64Array containing all 16 elements (`m11`, `m12`, `m13`, `m14`, `m21`, `m22`, `m23`, `m24`, `m31`, `m32`, `m33`, `m34`, `m41`, `m42`, `m43`, `m44`) which comprise the matrix.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/toFloat64Array)\n     */\n    toFloat64Array(): Float64Array<ArrayBuffer>;\n    /**\n     * The **`toJSON()`** method of the DOMMatrixReadOnly interface creates and returns a JSON object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/toJSON)\n     */\n    toJSON(): any;\n    /**\n     * The **`transformPoint`** method of the You can also create a new `DOMPoint` by applying a matrix to a point with the DOMPointReadOnly.matrixTransform() method.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/transformPoint)\n     */\n    transformPoint(point?: DOMPointInit): DOMPoint;\n    /**\n     * The `translate()` method of the DOMMatrixReadOnly interface creates a new matrix being the result of the original matrix with a translation applied.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMMatrixReadOnly/translate)\n     */\n    translate(tx?: number, ty?: number, tz?: number): DOMMatrix;\n    toString(): string;\n}\n\ndeclare var DOMMatrixReadOnly: {\n    prototype: DOMMatrixReadOnly;\n    new(init?: string | number[]): DOMMatrixReadOnly;\n    fromFloat32Array(array32: Float32Array<ArrayBuffer>): DOMMatrixReadOnly;\n    fromFloat64Array(array64: Float64Array<ArrayBuffer>): DOMMatrixReadOnly;\n    fromMatrix(other?: DOMMatrixInit): DOMMatrixReadOnly;\n};\n\n/**\n * The **`DOMParser`** interface provides the ability to parse XML or HTML source code from a string into a DOM Document.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMParser)\n */\ninterface DOMParser {\n    /**\n     * The **`parseFromString()`** method of the DOMParser interface parses a string containing either HTML or XML, returning an HTMLDocument or an XMLDocument.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMParser/parseFromString)\n     */\n    parseFromString(string: string, type: DOMParserSupportedType): Document;\n}\n\ndeclare var DOMParser: {\n    prototype: DOMParser;\n    new(): DOMParser;\n};\n\n/**\n * A **`DOMPoint`** object represents a 2D or 3D point in a coordinate system; it includes values for the coordinates in up to three dimensions, as well as an optional perspective value.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPoint)\n */\ninterface DOMPoint extends DOMPointReadOnly {\n    /**\n     * The **`DOMPoint`** interface's **`w`** property holds the point's perspective value, w, for a point in space.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPoint/w)\n     */\n    w: number;\n    /**\n     * The **`DOMPoint`** interface's **`x`** property holds the horizontal coordinate, x, for a point in space.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPoint/x)\n     */\n    x: number;\n    /**\n     * The **`DOMPoint`** interface's **`y`** property holds the vertical coordinate, _y_, for a point in space.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPoint/y)\n     */\n    y: number;\n    /**\n     * The **`DOMPoint`** interface's **`z`** property specifies the depth coordinate of a point in space.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPoint/z)\n     */\n    z: number;\n}\n\ndeclare var DOMPoint: {\n    prototype: DOMPoint;\n    new(x?: number, y?: number, z?: number, w?: number): DOMPoint;\n    /**\n     * The **`fromPoint()`** static method of the DOMPoint interface creates and returns a new mutable `DOMPoint` object given a source point.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPoint/fromPoint_static)\n     */\n    fromPoint(other?: DOMPointInit): DOMPoint;\n};\n\ntype SVGPoint = DOMPoint;\ndeclare var SVGPoint: typeof DOMPoint;\n\n/**\n * The **`DOMPointReadOnly`** interface specifies the coordinate and perspective fields used by DOMPoint to define a 2D or 3D point in a coordinate system.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPointReadOnly)\n */\ninterface DOMPointReadOnly {\n    /**\n     * The **`DOMPointReadOnly`** interface's **`w`** property holds the point's perspective value, `w`, for a read-only point in space.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPointReadOnly/w)\n     */\n    readonly w: number;\n    /**\n     * The **`DOMPointReadOnly`** interface's **`x`** property holds the horizontal coordinate, x, for a read-only point in space.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPointReadOnly/x)\n     */\n    readonly x: number;\n    /**\n     * The **`DOMPointReadOnly`** interface's **`y`** property holds the vertical coordinate, y, for a read-only point in space.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPointReadOnly/y)\n     */\n    readonly y: number;\n    /**\n     * The **`DOMPointReadOnly`** interface's **`z`** property holds the depth coordinate, z, for a read-only point in space.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPointReadOnly/z)\n     */\n    readonly z: number;\n    /**\n     * The **`matrixTransform()`** method of the DOMPointReadOnly interface applies a matrix transform specified as an object to the DOMPointReadOnly object, creating and returning a new `DOMPointReadOnly` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPointReadOnly/matrixTransform)\n     */\n    matrixTransform(matrix?: DOMMatrixInit): DOMPoint;\n    /**\n     * The DOMPointReadOnly method `toJSON()` returns an object giving the ```js-nolint toJSON() ``` None.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPointReadOnly/toJSON)\n     */\n    toJSON(): any;\n}\n\ndeclare var DOMPointReadOnly: {\n    prototype: DOMPointReadOnly;\n    new(x?: number, y?: number, z?: number, w?: number): DOMPointReadOnly;\n    /**\n     * The static **DOMPointReadOnly** method `fromPoint()` creates and returns a new `DOMPointReadOnly` object given a source point.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMPointReadOnly/fromPoint_static)\n     */\n    fromPoint(other?: DOMPointInit): DOMPointReadOnly;\n};\n\n/**\n * A `DOMQuad` is a collection of four `DOMPoint`s defining the corners of an arbitrary quadrilateral.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMQuad)\n */\ninterface DOMQuad {\n    /**\n     * The **`DOMQuad`** interface's **`p1`** property holds the DOMPoint object that represents one of the four corners of the `DOMQuad`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMQuad/p1)\n     */\n    readonly p1: DOMPoint;\n    /**\n     * The **`DOMQuad`** interface's **`p2`** property holds the DOMPoint object that represents one of the four corners of the `DOMQuad`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMQuad/p2)\n     */\n    readonly p2: DOMPoint;\n    /**\n     * The **`DOMQuad`** interface's **`p3`** property holds the DOMPoint object that represents one of the four corners of the `DOMQuad`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMQuad/p3)\n     */\n    readonly p3: DOMPoint;\n    /**\n     * The **`DOMQuad`** interface's **`p4`** property holds the DOMPoint object that represents one of the four corners of the `DOMQuad`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMQuad/p4)\n     */\n    readonly p4: DOMPoint;\n    /**\n     * The DOMQuad method `getBounds()` returns a DOMRect object representing the smallest rectangle that fully contains the `DOMQuad` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMQuad/getBounds)\n     */\n    getBounds(): DOMRect;\n    /**\n     * The DOMQuad method `toJSON()` returns a ```js-nolint toJSON() ``` None.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMQuad/toJSON)\n     */\n    toJSON(): any;\n}\n\ndeclare var DOMQuad: {\n    prototype: DOMQuad;\n    new(p1?: DOMPointInit, p2?: DOMPointInit, p3?: DOMPointInit, p4?: DOMPointInit): DOMQuad;\n    fromQuad(other?: DOMQuadInit): DOMQuad;\n    fromRect(other?: DOMRectInit): DOMQuad;\n};\n\n/**\n * A **`DOMRect`** describes the size and position of a rectangle.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRect)\n */\ninterface DOMRect extends DOMRectReadOnly {\n    /**\n     * The **`height`** property of the DOMRect interface represents the height of the rectangle.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRect/height)\n     */\n    height: number;\n    /**\n     * The **`width`** property of the DOMRect interface represents the width of the rectangle.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRect/width)\n     */\n    width: number;\n    /**\n     * The **`x`** property of the DOMRect interface represents the x-coordinate of the rectangle, which is the horizontal distance between the viewport's left edge and the rectangle's origin.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRect/x)\n     */\n    x: number;\n    /**\n     * The **`y`** property of the DOMRect interface represents the y-coordinate of the rectangle, which is the vertical distance between the viewport's top edge and the rectangle's origin.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRect/y)\n     */\n    y: number;\n}\n\ndeclare var DOMRect: {\n    prototype: DOMRect;\n    new(x?: number, y?: number, width?: number, height?: number): DOMRect;\n    /**\n     * The **`fromRect()`** static method of the object with a given location and dimensions.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRect/fromRect_static)\n     */\n    fromRect(other?: DOMRectInit): DOMRect;\n};\n\ntype SVGRect = DOMRect;\ndeclare var SVGRect: typeof DOMRect;\n\n/**\n * The **`DOMRectList`** interface represents a collection of DOMRect objects, typically used to hold the rectangles associated with a particular element, like bounding boxes returned by methods such as Element.getClientRects.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectList)\n */\ninterface DOMRectList {\n    /**\n     * The read-only **`length`** property of the DOMRectList interface returns the number of DOMRect objects in the list.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectList/length)\n     */\n    readonly length: number;\n    /**\n     * The DOMRectList method `item()` returns the DOMRect at the specified index within the list, or `null` if the index is out of range.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectList/item)\n     */\n    item(index: number): DOMRect | null;\n    [index: number]: DOMRect;\n}\n\ndeclare var DOMRectList: {\n    prototype: DOMRectList;\n    new(): DOMRectList;\n};\n\n/**\n * The **`DOMRectReadOnly`** interface specifies the standard properties (also used by DOMRect) to define a rectangle whose properties are immutable.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly)\n */\ninterface DOMRectReadOnly {\n    /**\n     * The **`bottom`** read-only property of the **`DOMRectReadOnly`** interface returns the bottom coordinate value of the `DOMRect`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/bottom)\n     */\n    readonly bottom: number;\n    /**\n     * The **`height`** read-only property of the **`DOMRectReadOnly`** interface represents the height of the `DOMRect`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/height)\n     */\n    readonly height: number;\n    /**\n     * The **`left`** read-only property of the **`DOMRectReadOnly`** interface returns the left coordinate value of the `DOMRect`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/left)\n     */\n    readonly left: number;\n    /**\n     * The **`right`** read-only property of the **`DOMRectReadOnly`** interface returns the right coordinate value of the `DOMRect`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/right)\n     */\n    readonly right: number;\n    /**\n     * The **`top`** read-only property of the **`DOMRectReadOnly`** interface returns the top coordinate value of the `DOMRect`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/top)\n     */\n    readonly top: number;\n    /**\n     * The **`width`** read-only property of the **`DOMRectReadOnly`** interface represents the width of the `DOMRect`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/width)\n     */\n    readonly width: number;\n    /**\n     * The **`x`** read-only property of the **`DOMRectReadOnly`** interface represents the x coordinate of the `DOMRect`'s origin.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/x)\n     */\n    readonly x: number;\n    /**\n     * The **`y`** read-only property of the **`DOMRectReadOnly`** interface represents the y coordinate of the `DOMRect`'s origin.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/y)\n     */\n    readonly y: number;\n    /**\n     * The DOMRectReadOnly method `toJSON()` returns a JSON representation of the `DOMRectReadOnly` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/toJSON)\n     */\n    toJSON(): any;\n}\n\ndeclare var DOMRectReadOnly: {\n    prototype: DOMRectReadOnly;\n    new(x?: number, y?: number, width?: number, height?: number): DOMRectReadOnly;\n    /**\n     * The **`fromRect()`** static method of the object with a given location and dimensions.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMRectReadOnly/fromRect_static)\n     */\n    fromRect(other?: DOMRectInit): DOMRectReadOnly;\n};\n\n/**\n * The **`DOMStringList`** interface is a legacy type returned by some APIs and represents a non-modifiable list of strings (`DOMString`).\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMStringList)\n */\ninterface DOMStringList {\n    /**\n     * The read-only **`length`** property indicates the number of strings in the DOMStringList.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMStringList/length)\n     */\n    readonly length: number;\n    /**\n     * The **`contains()`** method returns a boolean indicating whether the given string is in the list.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMStringList/contains)\n     */\n    contains(string: string): boolean;\n    /**\n     * The **`item()`** method returns a string from a `DOMStringList` by index.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMStringList/item)\n     */\n    item(index: number): string | null;\n    [index: number]: string;\n}\n\ndeclare var DOMStringList: {\n    prototype: DOMStringList;\n    new(): DOMStringList;\n};\n\n/**\n * The **`DOMStringMap`** interface is used for the HTMLElement.dataset attribute, to represent data for custom attributes added to elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMStringMap)\n */\ninterface DOMStringMap {\n    [name: string]: string | undefined;\n}\n\ndeclare var DOMStringMap: {\n    prototype: DOMStringMap;\n    new(): DOMStringMap;\n};\n\n/**\n * The **`DOMTokenList`** interface represents a set of space-separated tokens.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList)\n */\ninterface DOMTokenList {\n    /**\n     * The read-only **`length`** property of the DOMTokenList interface is an `integer` representing the number of objects stored in the object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/length)\n     */\n    readonly length: number;\n    /**\n     * The **`value`** property of the DOMTokenList interface is a stringifier that returns the value of the list serialized as a string, or clears and sets the list to the given value.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/value)\n     */\n    value: string;\n    toString(): string;\n    /**\n     * The **`add()`** method of the DOMTokenList interface adds the given tokens to the list, omitting any that are already present.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/add)\n     */\n    add(...tokens: string[]): void;\n    /**\n     * The **`contains()`** method of the DOMTokenList interface returns a boolean value — `true` if the underlying list contains the given token, otherwise `false`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/contains)\n     */\n    contains(token: string): boolean;\n    /**\n     * The **`item()`** method of the DOMTokenList interface returns an item in the list, determined by its position in the list, its index.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/item)\n     */\n    item(index: number): string | null;\n    /**\n     * The **`remove()`** method of the DOMTokenList interface removes the specified _tokens_ from the list.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/remove)\n     */\n    remove(...tokens: string[]): void;\n    /**\n     * The **`replace()`** method of the DOMTokenList interface replaces an existing token with a new token.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/replace)\n     */\n    replace(token: string, newToken: string): boolean;\n    /**\n     * The **`supports()`** method of the DOMTokenList interface returns `true` if a given `token` is in the associated attribute's supported tokens.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/supports)\n     */\n    supports(token: string): boolean;\n    /**\n     * The **`toggle()`** method of the DOMTokenList interface removes an existing token from the list and returns `false`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DOMTokenList/toggle)\n     */\n    toggle(token: string, force?: boolean): boolean;\n    forEach(callbackfn: (value: string, key: number, parent: DOMTokenList) => void, thisArg?: any): void;\n    [index: number]: string;\n}\n\ndeclare var DOMTokenList: {\n    prototype: DOMTokenList;\n    new(): DOMTokenList;\n};\n\n/**\n * The **`DataTransfer`** object is used to hold any data transferred between contexts, such as a drag and drop operation, or clipboard read/write.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer)\n */\ninterface DataTransfer {\n    /**\n     * The **`DataTransfer.dropEffect`** property controls the feedback (typically visual) the user is given during a drag and drop operation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/dropEffect)\n     */\n    dropEffect: \"none\" | \"copy\" | \"link\" | \"move\";\n    /**\n     * The **`DataTransfer.effectAllowed`** property specifies the effect that is allowed for a drag operation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/effectAllowed)\n     */\n    effectAllowed: \"none\" | \"copy\" | \"copyLink\" | \"copyMove\" | \"link\" | \"linkMove\" | \"move\" | \"all\" | \"uninitialized\";\n    /**\n     * The **`files`** read-only property of `DataTransfer` objects is a list of the files in the drag operation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/files)\n     */\n    readonly files: FileList;\n    /**\n     * The read-only `items` property of the DataTransfer interface is a A DataTransferItemList object containing DataTransferItem objects representing the items being dragged in a drag operation, one list item for each object being dragged.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/items)\n     */\n    readonly items: DataTransferItemList;\n    /**\n     * The **`DataTransfer.types`** read-only property returns the available types that exist in the DataTransfer.items.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/types)\n     */\n    readonly types: ReadonlyArray<string>;\n    /**\n     * The **`DataTransfer.clearData()`** method removes the drag operation's drag data for the given type.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/clearData)\n     */\n    clearData(format?: string): void;\n    /**\n     * The **`DataTransfer.getData()`** method retrieves drag data (as a string) for the specified type.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/getData)\n     */\n    getData(format: string): string;\n    /**\n     * The **`DataTransfer.setData()`** method sets the drag operation's drag data to the specified data and type.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/setData)\n     */\n    setData(format: string, data: string): void;\n    /**\n     * When a drag occurs, a translucent image is generated from the drag target (the element the HTMLElement/dragstart_event event is fired at), and follows the mouse pointer during the drag.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransfer/setDragImage)\n     */\n    setDragImage(image: Element, x: number, y: number): void;\n}\n\ndeclare var DataTransfer: {\n    prototype: DataTransfer;\n    new(): DataTransfer;\n};\n\n/**\n * The **`DataTransferItem`** object represents one drag data item.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItem)\n */\ninterface DataTransferItem {\n    /**\n     * The read-only **`DataTransferItem.kind`** property returns the kind–a string or a file–of the DataTransferItem object representing the _drag data item_.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItem/kind)\n     */\n    readonly kind: string;\n    /**\n     * The read-only **`DataTransferItem.type`** property returns the type (format) of the DataTransferItem object representing the drag data item.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItem/type)\n     */\n    readonly type: string;\n    /**\n     * If the item is a file, the **`DataTransferItem.getAsFile()`** method returns the drag data item's File object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItem/getAsFile)\n     */\n    getAsFile(): File | null;\n    /**\n     * The **`DataTransferItem.getAsString()`** method invokes the given callback with the drag data item's string data as the argument if the item's DataTransferItem.kind is a _Plain unicode string_ (i.e., `kind` is `string`).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItem/getAsString)\n     */\n    getAsString(callback: FunctionStringCallback | null): void;\n    /**\n     * If the item described by the DataTransferItem is a file, `webkitGetAsEntry()` returns a FileSystemFileEntry or FileSystemDirectoryEntry representing it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItem/webkitGetAsEntry)\n     */\n    webkitGetAsEntry(): FileSystemEntry | null;\n}\n\ndeclare var DataTransferItem: {\n    prototype: DataTransferItem;\n    new(): DataTransferItem;\n};\n\n/**\n * The **`DataTransferItemList`** object is a list of DataTransferItem objects representing items being dragged.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItemList)\n */\ninterface DataTransferItemList {\n    /**\n     * The read-only **`length`** property of the the drag item list.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItemList/length)\n     */\n    readonly length: number;\n    /**\n     * The **`DataTransferItemList.add()`** method creates a new list.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItemList/add)\n     */\n    add(data: string, type: string): DataTransferItem | null;\n    add(data: File): DataTransferItem | null;\n    /**\n     * The DataTransferItemList method **`clear()`** removes all DataTransferItem objects from the drag data items list, leaving the list empty.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItemList/clear)\n     */\n    clear(): void;\n    /**\n     * The **`DataTransferItemList.remove()`** method removes the less than zero or greater than one less than the length of the list, the list will not be changed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DataTransferItemList/remove)\n     */\n    remove(index: number): void;\n    [index: number]: DataTransferItem;\n}\n\ndeclare var DataTransferItemList: {\n    prototype: DataTransferItemList;\n    new(): DataTransferItemList;\n};\n\n/**\n * The **`DecompressionStream`** interface of the Compression Streams API is an API for decompressing a stream of data.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DecompressionStream)\n */\ninterface DecompressionStream extends GenericTransformStream {\n    readonly readable: ReadableStream<Uint8Array<ArrayBuffer>>;\n    readonly writable: WritableStream<BufferSource>;\n}\n\ndeclare var DecompressionStream: {\n    prototype: DecompressionStream;\n    new(format: CompressionFormat): DecompressionStream;\n};\n\n/**\n * The **`DelayNode`** interface represents a delay-line; an AudioNode audio-processing module that causes a delay between the arrival of an input data and its propagation to the output.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DelayNode)\n */\ninterface DelayNode extends AudioNode {\n    /**\n     * The `delayTime` property of the DelayNode interface is an a-rate AudioParam representing the amount of delay to apply.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DelayNode/delayTime)\n     */\n    readonly delayTime: AudioParam;\n}\n\ndeclare var DelayNode: {\n    prototype: DelayNode;\n    new(context: BaseAudioContext, options?: DelayOptions): DelayNode;\n};\n\n/**\n * The **`DeviceMotionEvent`** interface of the Device Orientation Events provides web developers with information about the speed of changes for the device's position and orientation.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEvent)\n */\ninterface DeviceMotionEvent extends Event {\n    /**\n     * The **`acceleration`** read-only property of the DeviceMotionEvent interface returns the acceleration recorded by the device, in meters per second squared (m/s²).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEvent/acceleration)\n     */\n    readonly acceleration: DeviceMotionEventAcceleration | null;\n    /**\n     * The **`accelerationIncludingGravity`** read-only property of the DeviceMotionEvent interface returns the amount of acceleration recorded by the device, in meters per second squared (m/s²).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEvent/accelerationIncludingGravity)\n     */\n    readonly accelerationIncludingGravity: DeviceMotionEventAcceleration | null;\n    /**\n     * The **`interval`** read-only property of the DeviceMotionEvent interface returns the interval, in milliseconds, at which data is obtained from the underlying hardware.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEvent/interval)\n     */\n    readonly interval: number;\n    /**\n     * The **`rotationRate`** read-only property of the DeviceMotionEvent interface returns the rate at which the device is rotating around each of its axes in degrees per second.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEvent/rotationRate)\n     */\n    readonly rotationRate: DeviceMotionEventRotationRate | null;\n}\n\ndeclare var DeviceMotionEvent: {\n    prototype: DeviceMotionEvent;\n    new(type: string, eventInitDict?: DeviceMotionEventInit): DeviceMotionEvent;\n};\n\n/**\n * The **`DeviceMotionEventAcceleration`** interface of the Device Orientation Events provides information about the amount of acceleration the device is experiencing along all three axes.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEventAcceleration)\n */\ninterface DeviceMotionEventAcceleration {\n    /**\n     * The **`x`** read-only property of the DeviceMotionEventAcceleration interface indicates the amount of acceleration that occurred along the X axis in a `DeviceMotionEventAcceleration` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEventAcceleration/x)\n     */\n    readonly x: number | null;\n    /**\n     * The **`y`** read-only property of the DeviceMotionEventAcceleration interface indicates the amount of acceleration that occurred along the Y axis in a `DeviceMotionEventAcceleration` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEventAcceleration/y)\n     */\n    readonly y: number | null;\n    /**\n     * The **`z`** read-only property of the DeviceMotionEventAcceleration interface indicates the amount of acceleration that occurred along the Z axis in a `DeviceMotionEventAcceleration` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEventAcceleration/z)\n     */\n    readonly z: number | null;\n}\n\n/**\n * A **`DeviceMotionEventRotationRate`** interface of the Device Orientation Events provides information about the rate at which the device is rotating around all three axes.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEventRotationRate)\n */\ninterface DeviceMotionEventRotationRate {\n    /**\n     * The **`alpha`** read-only property of the DeviceMotionEventRotationRate interface indicates the rate of rotation around the Z axis, in degrees per second.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEventRotationRate/alpha)\n     */\n    readonly alpha: number | null;\n    /**\n     * The **`beta`** read-only property of the DeviceMotionEventRotationRate interface indicates the rate of rotation around the X axis, in degrees per second.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEventRotationRate/beta)\n     */\n    readonly beta: number | null;\n    /**\n     * The **`gamma`** read-only property of the DeviceMotionEventRotationRate interface indicates the rate of rotation around the Y axis, in degrees per second.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceMotionEventRotationRate/gamma)\n     */\n    readonly gamma: number | null;\n}\n\n/**\n * The **`DeviceOrientationEvent`** interface of the Device Orientation Events provides web developers with information from the physical orientation of the device running the web page.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceOrientationEvent)\n */\ninterface DeviceOrientationEvent extends Event {\n    /**\n     * The **`absolute`** read-only property of the DeviceOrientationEvent interface indicates whether or not the device is providing orientation data absolutely (that is, in reference to the Earth's coordinate frame) or using some arbitrary frame determined by the device.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceOrientationEvent/absolute)\n     */\n    readonly absolute: boolean;\n    /**\n     * The **`alpha`** read-only property of the DeviceOrientationEvent interface returns the rotation of the device around the Z axis; that is, the number of degrees by which the device is being twisted around the center of the screen.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceOrientationEvent/alpha)\n     */\n    readonly alpha: number | null;\n    /**\n     * The **`beta`** read-only property of the DeviceOrientationEvent interface returns the rotation of the device around the X axis; that is, the number of degrees, ranged between -180 and 180, by which the device is tipped forward or backward.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceOrientationEvent/beta)\n     */\n    readonly beta: number | null;\n    /**\n     * The **`gamma`** read-only property of the DeviceOrientationEvent interface returns the rotation of the device around the Y axis; that is, the number of degrees, ranged between `-90` and `90`, by which the device is tilted left or right.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DeviceOrientationEvent/gamma)\n     */\n    readonly gamma: number | null;\n}\n\ndeclare var DeviceOrientationEvent: {\n    prototype: DeviceOrientationEvent;\n    new(type: string, eventInitDict?: DeviceOrientationEventInit): DeviceOrientationEvent;\n};\n\ninterface DocumentEventMap extends GlobalEventHandlersEventMap {\n    \"DOMContentLoaded\": Event;\n    \"fullscreenchange\": Event;\n    \"fullscreenerror\": Event;\n    \"pointerlockchange\": Event;\n    \"pointerlockerror\": Event;\n    \"readystatechange\": Event;\n    \"visibilitychange\": Event;\n}\n\n/**\n * The **`Document`** interface represents any web page loaded in the browser and serves as an entry point into the web page's content, which is the DOM tree.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document)\n */\ninterface Document extends Node, DocumentOrShadowRoot, FontFaceSource, GlobalEventHandlers, NonElementParentNode, ParentNode, XPathEvaluatorBase {\n    /**\n     * The **`URL`** read-only property of the Document interface returns the document location as a string.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/URL)\n     */\n    readonly URL: string;\n    /**\n     * Returns or sets the color of an active link in the document body.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/alinkColor)\n     */\n    alinkColor: string;\n    /**\n     * The Document interface's read-only **`all`** property returns an HTMLAllCollection rooted at the document node.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/all)\n     */\n    readonly all: HTMLAllCollection;\n    /**\n     * The **`anchors`** read-only property of the An HTMLCollection.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/anchors)\n     */\n    readonly anchors: HTMLCollectionOf<HTMLAnchorElement>;\n    /**\n     * The **`applets`** property of the Document returns an empty HTMLCollection.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/applets)\n     */\n    readonly applets: HTMLCollection;\n    /**\n     * The deprecated `bgColor` property gets or sets the background color of the current document.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/bgColor)\n     */\n    bgColor: string;\n    /**\n     * The **`Document.body`** property represents the `null` if no such element exists.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/body)\n     */\n    body: HTMLElement;\n    /**\n     * The **`Document.characterSet`** read-only property returns the character encoding of the document that it's currently rendered with.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/characterSet)\n     */\n    readonly characterSet: string;\n    /**\n     * @deprecated This is a legacy alias of `characterSet`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/characterSet)\n     */\n    readonly charset: string;\n    /**\n     * The **`Document.compatMode`** read-only property indicates whether the document is rendered in Quirks mode or Standards mode.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/compatMode)\n     */\n    readonly compatMode: string;\n    /**\n     * The **`Document.contentType`** read-only property returns the MIME type that the document is being rendered as.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/contentType)\n     */\n    readonly contentType: string;\n    /**\n     * The Document property `cookie` lets you read and write cookies associated with the document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/cookie)\n     */\n    cookie: string;\n    /**\n     * The **`Document.currentScript`** property returns the script element whose script is currently being processed and isn't a JavaScript module.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/currentScript)\n     */\n    readonly currentScript: HTMLOrSVGScriptElement | null;\n    /**\n     * In browsers, **`document.defaultView`** returns the This property is read-only.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/defaultView)\n     */\n    readonly defaultView: (WindowProxy & typeof globalThis) | null;\n    /**\n     * **`document.designMode`** controls whether the entire document is editable.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/designMode)\n     */\n    designMode: string;\n    /**\n     * The **`Document.dir`** property is a string representing the directionality of the text of the document, whether left to right (default) or right to left.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/dir)\n     */\n    dir: string;\n    /**\n     * The **`doctype`** read-only property of the Document interface is a DocumentType object representing the Doctype associated with the current document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/doctype)\n     */\n    readonly doctype: DocumentType | null;\n    /**\n     * The **`documentElement`** read-only property of the Document interface returns the example, the html element for HTML documents).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/documentElement)\n     */\n    readonly documentElement: HTMLElement;\n    /**\n     * The **`documentURI`** read-only property of the A string.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/documentURI)\n     */\n    readonly documentURI: string;\n    /**\n     * The **`domain`** property of the Document interface gets/sets the domain portion of the origin of the current document, as used by the same-origin policy.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/domain)\n     */\n    domain: string;\n    /**\n     * The **`embeds`** read-only property of the An HTMLCollection.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/embeds)\n     */\n    readonly embeds: HTMLCollectionOf<HTMLEmbedElement>;\n    /**\n     * **`fgColor`** gets/sets the foreground color, or text color, of the current document.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fgColor)\n     */\n    fgColor: string;\n    /**\n     * The **`forms`** read-only property of the Document interface returns an HTMLCollection listing all the form elements contained in the document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/forms)\n     */\n    readonly forms: HTMLCollectionOf<HTMLFormElement>;\n    /**\n     * The **`fragmentDirective`** read-only property of the Document interface returns the FragmentDirective for the current document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fragmentDirective)\n     */\n    readonly fragmentDirective: FragmentDirective;\n    /**\n     * The obsolete Document interface's **`fullscreen`** read-only property reports whether or not the document is currently displaying content in fullscreen mode.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fullscreen)\n     */\n    readonly fullscreen: boolean;\n    /**\n     * The read-only **`fullscreenEnabled`** property on the Document interface indicates whether or not fullscreen mode is available.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fullscreenEnabled)\n     */\n    readonly fullscreenEnabled: boolean;\n    /**\n     * The **`head`** read-only property of the Document interface returns the head element of the current document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/head)\n     */\n    readonly head: HTMLHeadElement;\n    /**\n     * The **`Document.hidden`** read-only property returns a Boolean value indicating if the page is considered hidden or not.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/hidden)\n     */\n    readonly hidden: boolean;\n    /**\n     * The **`images`** read-only property of the Document interface returns a collection of the images in the current HTML document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/images)\n     */\n    readonly images: HTMLCollectionOf<HTMLImageElement>;\n    /**\n     * The **`Document.implementation`** property returns a A DOMImplementation object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/implementation)\n     */\n    readonly implementation: DOMImplementation;\n    /**\n     * @deprecated This is a legacy alias of `characterSet`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/characterSet)\n     */\n    readonly inputEncoding: string;\n    /**\n     * The **`lastModified`** property of the Document interface returns a string containing the date and local time on which the current document was last modified.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/lastModified)\n     */\n    readonly lastModified: string;\n    /**\n     * The **`Document.linkColor`** property gets/sets the color of links within the document.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/linkColor)\n     */\n    linkColor: string;\n    /**\n     * The **`links`** read-only property of the Document interface returns a collection of all area elements and a elements in a document with a value for the href attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/links)\n     */\n    readonly links: HTMLCollectionOf<HTMLAnchorElement | HTMLAreaElement>;\n    /**\n     * The **`Document.location`** read-only property returns a and provides methods for changing that URL and loading another URL.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/location)\n     */\n    get location(): Location;\n    set location(href: string);\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fullscreenchange_event) */\n    onfullscreenchange: ((this: Document, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fullscreenerror_event) */\n    onfullscreenerror: ((this: Document, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/pointerlockchange_event) */\n    onpointerlockchange: ((this: Document, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/pointerlockerror_event) */\n    onpointerlockerror: ((this: Document, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/readystatechange_event) */\n    onreadystatechange: ((this: Document, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/visibilitychange_event) */\n    onvisibilitychange: ((this: Document, ev: Event) => any) | null;\n    readonly ownerDocument: null;\n    /**\n     * The read-only **`pictureInPictureEnabled`** property of the available.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/pictureInPictureEnabled)\n     */\n    readonly pictureInPictureEnabled: boolean;\n    /**\n     * The **`plugins`** read-only property of the containing one or more HTMLEmbedElements representing the An HTMLCollection.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/plugins)\n     */\n    readonly plugins: HTMLCollectionOf<HTMLEmbedElement>;\n    /**\n     * The **`Document.readyState`** property describes the loading state of the document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/readyState)\n     */\n    readonly readyState: DocumentReadyState;\n    /**\n     * The **`Document.referrer`** property returns the URI of the page that linked to this page.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/referrer)\n     */\n    readonly referrer: string;\n    /**\n     * **`Document.rootElement`** returns the Element that is the root element of the document if it is an documents.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/rootElement)\n     */\n    readonly rootElement: SVGSVGElement | null;\n    /**\n     * The **`scripts`** property of the Document interface returns a list of the script elements in the document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/scripts)\n     */\n    readonly scripts: HTMLCollectionOf<HTMLScriptElement>;\n    /**\n     * The **`scrollingElement`** read-only property of the scrolls the document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/scrollingElement)\n     */\n    readonly scrollingElement: Element | null;\n    /**\n     * The `timeline` readonly property of the Document interface represents the default timeline of the current document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/timeline)\n     */\n    readonly timeline: DocumentTimeline;\n    /**\n     * The **`document.title`** property gets or sets the current title of the document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/title)\n     */\n    title: string;\n    /**\n     * The **`Document.visibilityState`** read-only property returns the visibility of the document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/visibilityState)\n     */\n    readonly visibilityState: DocumentVisibilityState;\n    /**\n     * The **`Document.vlinkColor`** property gets/sets the color of links that the user has visited in the document.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/vlinkColor)\n     */\n    vlinkColor: string;\n    /**\n     * **`Document.adoptNode()`** transfers a node/dom from another Document into the method's document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/adoptNode)\n     */\n    adoptNode<T extends Node>(node: T): T;\n    /** @deprecated */\n    captureEvents(): void;\n    /**\n     * The **`caretPositionFromPoint()`** method of the Document interface returns a CaretPosition object, containing the DOM node, along with the caret and caret's character offset within that node.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/caretPositionFromPoint)\n     */\n    caretPositionFromPoint(x: number, y: number, options?: CaretPositionFromPointOptions): CaretPosition | null;\n    /** @deprecated */\n    caretRangeFromPoint(x: number, y: number): Range | null;\n    /**\n     * The **`Document.clear()`** method does nothing, but doesn't raise any error.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/clear)\n     */\n    clear(): void;\n    /**\n     * The **`Document.close()`** method finishes writing to a document, opened with Document.open().\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/close)\n     */\n    close(): void;\n    /**\n     * The **`Document.createAttribute()`** method creates a new attribute node, and returns it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createAttribute)\n     */\n    createAttribute(localName: string): Attr;\n    /**\n     * The **`Document.createAttributeNS()`** method creates a new attribute node with the specified namespace URI and qualified name, and returns it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createAttributeNS)\n     */\n    createAttributeNS(namespace: string | null, qualifiedName: string): Attr;\n    /**\n     * **`createCDATASection()`** creates a new CDATA section node, and returns it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createCDATASection)\n     */\n    createCDATASection(data: string): CDATASection;\n    /**\n     * **`createComment()`** creates a new comment node, and returns it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createComment)\n     */\n    createComment(data: string): Comment;\n    /**\n     * Creates a new empty DocumentFragment into which DOM nodes can be added to build an offscreen DOM tree.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createDocumentFragment)\n     */\n    createDocumentFragment(): DocumentFragment;\n    /**\n     * In an HTML document, the **`document.createElement()`** method creates the HTML element specified by `localName`, or an HTMLUnknownElement if `localName` isn't recognized.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createElement)\n     */\n    createElement<K extends keyof HTMLElementTagNameMap>(tagName: K, options?: ElementCreationOptions): HTMLElementTagNameMap[K];\n    /** @deprecated */\n    createElement<K extends keyof HTMLElementDeprecatedTagNameMap>(tagName: K, options?: ElementCreationOptions): HTMLElementDeprecatedTagNameMap[K];\n    createElement(tagName: string, options?: ElementCreationOptions): HTMLElement;\n    /**\n     * Creates an element with the specified namespace URI and qualified name.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createElementNS)\n     */\n    createElementNS(namespaceURI: \"http://www.w3.org/1999/xhtml\", qualifiedName: string): HTMLElement;\n    createElementNS<K extends keyof SVGElementTagNameMap>(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: K): SVGElementTagNameMap[K];\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: string): SVGElement;\n    createElementNS<K extends keyof MathMLElementTagNameMap>(namespaceURI: \"http://www.w3.org/1998/Math/MathML\", qualifiedName: K): MathMLElementTagNameMap[K];\n    createElementNS(namespaceURI: \"http://www.w3.org/1998/Math/MathML\", qualifiedName: string): MathMLElement;\n    createElementNS(namespaceURI: string | null, qualifiedName: string, options?: ElementCreationOptions): Element;\n    createElementNS(namespace: string | null, qualifiedName: string, options?: string | ElementCreationOptions): Element;\n    /**\n     * Creates an event of the type specified.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createEvent)\n     */\n    createEvent(eventInterface: \"AnimationEvent\"): AnimationEvent;\n    createEvent(eventInterface: \"AnimationPlaybackEvent\"): AnimationPlaybackEvent;\n    createEvent(eventInterface: \"AudioProcessingEvent\"): AudioProcessingEvent;\n    createEvent(eventInterface: \"BeforeUnloadEvent\"): BeforeUnloadEvent;\n    createEvent(eventInterface: \"BlobEvent\"): BlobEvent;\n    createEvent(eventInterface: \"ClipboardEvent\"): ClipboardEvent;\n    createEvent(eventInterface: \"CloseEvent\"): CloseEvent;\n    createEvent(eventInterface: \"CompositionEvent\"): CompositionEvent;\n    createEvent(eventInterface: \"ContentVisibilityAutoStateChangeEvent\"): ContentVisibilityAutoStateChangeEvent;\n    createEvent(eventInterface: \"CookieChangeEvent\"): CookieChangeEvent;\n    createEvent(eventInterface: \"CustomEvent\"): CustomEvent;\n    createEvent(eventInterface: \"DeviceMotionEvent\"): DeviceMotionEvent;\n    createEvent(eventInterface: \"DeviceOrientationEvent\"): DeviceOrientationEvent;\n    createEvent(eventInterface: \"DragEvent\"): DragEvent;\n    createEvent(eventInterface: \"ErrorEvent\"): ErrorEvent;\n    createEvent(eventInterface: \"Event\"): Event;\n    createEvent(eventInterface: \"Events\"): Event;\n    createEvent(eventInterface: \"FocusEvent\"): FocusEvent;\n    createEvent(eventInterface: \"FontFaceSetLoadEvent\"): FontFaceSetLoadEvent;\n    createEvent(eventInterface: \"FormDataEvent\"): FormDataEvent;\n    createEvent(eventInterface: \"GamepadEvent\"): GamepadEvent;\n    createEvent(eventInterface: \"HashChangeEvent\"): HashChangeEvent;\n    createEvent(eventInterface: \"IDBVersionChangeEvent\"): IDBVersionChangeEvent;\n    createEvent(eventInterface: \"InputEvent\"): InputEvent;\n    createEvent(eventInterface: \"KeyboardEvent\"): KeyboardEvent;\n    createEvent(eventInterface: \"MIDIConnectionEvent\"): MIDIConnectionEvent;\n    createEvent(eventInterface: \"MIDIMessageEvent\"): MIDIMessageEvent;\n    createEvent(eventInterface: \"MediaEncryptedEvent\"): MediaEncryptedEvent;\n    createEvent(eventInterface: \"MediaKeyMessageEvent\"): MediaKeyMessageEvent;\n    createEvent(eventInterface: \"MediaQueryListEvent\"): MediaQueryListEvent;\n    createEvent(eventInterface: \"MediaStreamTrackEvent\"): MediaStreamTrackEvent;\n    createEvent(eventInterface: \"MessageEvent\"): MessageEvent;\n    createEvent(eventInterface: \"MouseEvent\"): MouseEvent;\n    createEvent(eventInterface: \"MouseEvents\"): MouseEvent;\n    createEvent(eventInterface: \"OfflineAudioCompletionEvent\"): OfflineAudioCompletionEvent;\n    createEvent(eventInterface: \"PageRevealEvent\"): PageRevealEvent;\n    createEvent(eventInterface: \"PageSwapEvent\"): PageSwapEvent;\n    createEvent(eventInterface: \"PageTransitionEvent\"): PageTransitionEvent;\n    createEvent(eventInterface: \"PaymentMethodChangeEvent\"): PaymentMethodChangeEvent;\n    createEvent(eventInterface: \"PaymentRequestUpdateEvent\"): PaymentRequestUpdateEvent;\n    createEvent(eventInterface: \"PictureInPictureEvent\"): PictureInPictureEvent;\n    createEvent(eventInterface: \"PointerEvent\"): PointerEvent;\n    createEvent(eventInterface: \"PopStateEvent\"): PopStateEvent;\n    createEvent(eventInterface: \"ProgressEvent\"): ProgressEvent;\n    createEvent(eventInterface: \"PromiseRejectionEvent\"): PromiseRejectionEvent;\n    createEvent(eventInterface: \"RTCDTMFToneChangeEvent\"): RTCDTMFToneChangeEvent;\n    createEvent(eventInterface: \"RTCDataChannelEvent\"): RTCDataChannelEvent;\n    createEvent(eventInterface: \"RTCErrorEvent\"): RTCErrorEvent;\n    createEvent(eventInterface: \"RTCPeerConnectionIceErrorEvent\"): RTCPeerConnectionIceErrorEvent;\n    createEvent(eventInterface: \"RTCPeerConnectionIceEvent\"): RTCPeerConnectionIceEvent;\n    createEvent(eventInterface: \"RTCTrackEvent\"): RTCTrackEvent;\n    createEvent(eventInterface: \"SecurityPolicyViolationEvent\"): SecurityPolicyViolationEvent;\n    createEvent(eventInterface: \"SpeechSynthesisErrorEvent\"): SpeechSynthesisErrorEvent;\n    createEvent(eventInterface: \"SpeechSynthesisEvent\"): SpeechSynthesisEvent;\n    createEvent(eventInterface: \"StorageEvent\"): StorageEvent;\n    createEvent(eventInterface: \"SubmitEvent\"): SubmitEvent;\n    createEvent(eventInterface: \"TextEvent\"): TextEvent;\n    createEvent(eventInterface: \"ToggleEvent\"): ToggleEvent;\n    createEvent(eventInterface: \"TouchEvent\"): TouchEvent;\n    createEvent(eventInterface: \"TrackEvent\"): TrackEvent;\n    createEvent(eventInterface: \"TransitionEvent\"): TransitionEvent;\n    createEvent(eventInterface: \"UIEvent\"): UIEvent;\n    createEvent(eventInterface: \"UIEvents\"): UIEvent;\n    createEvent(eventInterface: \"WebGLContextEvent\"): WebGLContextEvent;\n    createEvent(eventInterface: \"WheelEvent\"): WheelEvent;\n    createEvent(eventInterface: string): Event;\n    /**\n     * The **`Document.createNodeIterator()`** method returns a new `NodeIterator` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createNodeIterator)\n     */\n    createNodeIterator(root: Node, whatToShow?: number, filter?: NodeFilter | null): NodeIterator;\n    /**\n     * `createProcessingInstruction()` generates a new processing instruction node and returns it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createProcessingInstruction)\n     */\n    createProcessingInstruction(target: string, data: string): ProcessingInstruction;\n    /**\n     * The **`Document.createRange()`** method returns a new ```js-nolint createRange() ``` None.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createRange)\n     */\n    createRange(): Range;\n    /**\n     * Creates a new Text node.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createTextNode)\n     */\n    createTextNode(data: string): Text;\n    /**\n     * The **`Document.createTreeWalker()`** creator method returns a newly created TreeWalker object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/createTreeWalker)\n     */\n    createTreeWalker(root: Node, whatToShow?: number, filter?: NodeFilter | null): TreeWalker;\n    /**\n     * The **`execCommand`** method implements multiple different commands.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/execCommand)\n     */\n    execCommand(commandId: string, showUI?: boolean, value?: string): boolean;\n    /**\n     * The Document method **`exitFullscreen()`** requests that the element on this document which is currently being presented in fullscreen mode be taken out of fullscreen mode, restoring the previous state of the screen.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/exitFullscreen)\n     */\n    exitFullscreen(): Promise<void>;\n    /**\n     * The **`exitPictureInPicture()`** method of the Document interface requests that a video contained in this document, which is currently floating, be taken out of picture-in-picture mode, restoring the previous state of the screen.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/exitPictureInPicture)\n     */\n    exitPictureInPicture(): Promise<void>;\n    /**\n     * The **`exitPointerLock()`** method of the Document interface asynchronously releases a pointer lock previously requested through Element.requestPointerLock.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/exitPointerLock)\n     */\n    exitPointerLock(): void;\n    getElementById(elementId: string): HTMLElement | null;\n    /**\n     * The **`getElementsByClassName`** method of of all child elements which have all of the given class name(s).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/getElementsByClassName)\n     */\n    getElementsByClassName(classNames: string): HTMLCollectionOf<Element>;\n    /**\n     * The **`getElementsByName()`** method of the Document object returns a NodeList Collection of elements with a given `name` attribute in the document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/getElementsByName)\n     */\n    getElementsByName(elementName: string): NodeListOf<HTMLElement>;\n    /**\n     * The **`getElementsByTagName`** method of The complete document is searched, including the root node.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/getElementsByTagName)\n     */\n    getElementsByTagName<K extends keyof HTMLElementTagNameMap>(qualifiedName: K): HTMLCollectionOf<HTMLElementTagNameMap[K]>;\n    getElementsByTagName<K extends keyof SVGElementTagNameMap>(qualifiedName: K): HTMLCollectionOf<SVGElementTagNameMap[K]>;\n    getElementsByTagName<K extends keyof MathMLElementTagNameMap>(qualifiedName: K): HTMLCollectionOf<MathMLElementTagNameMap[K]>;\n    /** @deprecated */\n    getElementsByTagName<K extends keyof HTMLElementDeprecatedTagNameMap>(qualifiedName: K): HTMLCollectionOf<HTMLElementDeprecatedTagNameMap[K]>;\n    getElementsByTagName(qualifiedName: string): HTMLCollectionOf<Element>;\n    /**\n     * Returns a list of elements with the given tag name belonging to the given namespace.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/getElementsByTagNameNS)\n     */\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/1999/xhtml\", localName: string): HTMLCollectionOf<HTMLElement>;\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/2000/svg\", localName: string): HTMLCollectionOf<SVGElement>;\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/1998/Math/MathML\", localName: string): HTMLCollectionOf<MathMLElement>;\n    getElementsByTagNameNS(namespace: string | null, localName: string): HTMLCollectionOf<Element>;\n    /**\n     * The **`getSelection()`** method of the Document interface returns the Selection object associated with this document, representing the range of text selected by the user, or the current position of the caret.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/getSelection)\n     */\n    getSelection(): Selection | null;\n    /**\n     * The **`hasFocus()`** method of the Document interface returns a boolean value indicating whether the document or any element inside the document has focus.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/hasFocus)\n     */\n    hasFocus(): boolean;\n    /**\n     * The **`hasStorageAccess()`** method of the Document interface returns a Promise that resolves with a boolean value indicating whether the document has access to third-party, unpartitioned cookies.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/hasStorageAccess)\n     */\n    hasStorageAccess(): Promise<boolean>;\n    /**\n     * The Document object's **`importNode()`** method creates a copy of a inserted into the current document later.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/importNode)\n     */\n    importNode<T extends Node>(node: T, options?: boolean | ImportNodeOptions): T;\n    /**\n     * The **`Document.open()`** method opens a document for This does come with some side effects.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/open)\n     */\n    open(unused1?: string, unused2?: string): Document;\n    open(url: string | URL, name: string, features: string): WindowProxy | null;\n    /**\n     * The **`Document.queryCommandEnabled()`** method reports whether or not the specified editor command is enabled by the browser.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/queryCommandEnabled)\n     */\n    queryCommandEnabled(commandId: string): boolean;\n    /** @deprecated */\n    queryCommandIndeterm(commandId: string): boolean;\n    /**\n     * The **`queryCommandState()`** method will tell you if the current selection has a certain Document.execCommand() command applied.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/queryCommandState)\n     */\n    queryCommandState(commandId: string): boolean;\n    /**\n     * The **`Document.queryCommandSupported()`** method reports whether or not the specified editor command is supported by the browser.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/queryCommandSupported)\n     */\n    queryCommandSupported(commandId: string): boolean;\n    /** @deprecated */\n    queryCommandValue(commandId: string): string;\n    /** @deprecated */\n    releaseEvents(): void;\n    /**\n     * The **`requestStorageAccess()`** method of the Document interface allows content loaded in a third-party context (i.e., embedded in an iframe) to request access to third-party cookies and unpartitioned state.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/requestStorageAccess)\n     */\n    requestStorageAccess(): Promise<void>;\n    /**\n     * The **`startViewTransition()`** method of the Document interface starts a new same-document (SPA) view transition and returns a ViewTransition object to represent it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/startViewTransition)\n     */\n    startViewTransition(callbackOptions?: ViewTransitionUpdateCallback | StartViewTransitionOptions): ViewTransition;\n    /**\n     * The **`write()`** method of the Document interface writes text in one or more TrustedHTML or string parameters to a document stream opened by document.open().\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/write)\n     */\n    write(...text: string[]): void;\n    /**\n     * The **`writeln()`** method of the Document interface writes text in one or more TrustedHTML or string parameters to a document stream opened by document.open(), followed by a newline character.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/writeln)\n     */\n    writeln(...text: string[]): void;\n    /** [MDN Reference](https://developer.mozilla.org/en-US/docs/Web/API/Node/textContent) */\n    get textContent(): null;\n    addEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: Document, ev: DocumentEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: Document, ev: DocumentEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var Document: {\n    prototype: Document;\n    new(): Document;\n    /**\n     * The **`parseHTMLUnsafe()`** static method of the Document object is used to parse an HTML input, optionally filtering unwanted HTML elements and attributes, in order to create a new Document instance.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/parseHTMLUnsafe_static)\n     */\n    parseHTMLUnsafe(html: string): Document;\n};\n\n/**\n * The **`DocumentFragment`** interface represents a minimal document object that has no parent.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DocumentFragment)\n */\ninterface DocumentFragment extends Node, NonElementParentNode, ParentNode {\n    readonly ownerDocument: Document;\n    getElementById(elementId: string): HTMLElement | null;\n    /** [MDN Reference](https://developer.mozilla.org/en-US/docs/Web/API/Node/textContent) */\n    get textContent(): string;\n    set textContent(value: string | null);\n}\n\ndeclare var DocumentFragment: {\n    prototype: DocumentFragment;\n    new(): DocumentFragment;\n};\n\ninterface DocumentOrShadowRoot {\n    /**\n     * Returns the deepest element in the document through which or to which key events are being routed. This is, roughly speaking, the focused element in the document.\n     *\n     * For the purposes of this API, when a child browsing context is focused, its container is focused in the parent browsing context. For example, if the user moves the focus to a text control in an iframe, the iframe is the element returned by the activeElement API in the iframe's node document.\n     *\n     * Similarly, when the focused element is in a different node tree than documentOrShadowRoot, the element returned will be the host that's located in the same node tree as documentOrShadowRoot if documentOrShadowRoot is a shadow-including inclusive ancestor of the focused element, and null if not.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/activeElement)\n     */\n    readonly activeElement: Element | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/adoptedStyleSheets) */\n    adoptedStyleSheets: CSSStyleSheet[];\n    /**\n     * Returns document's fullscreen element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fullscreenElement)\n     */\n    readonly fullscreenElement: Element | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/pictureInPictureElement) */\n    readonly pictureInPictureElement: Element | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/pointerLockElement) */\n    readonly pointerLockElement: Element | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/styleSheets) */\n    readonly styleSheets: StyleSheetList;\n    elementFromPoint(x: number, y: number): Element | null;\n    elementsFromPoint(x: number, y: number): Element[];\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/getAnimations) */\n    getAnimations(): Animation[];\n}\n\n/**\n * The **`DocumentTimeline`** interface of the Web Animations API represents animation timelines, including the default document timeline (accessed via Document.timeline).\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DocumentTimeline)\n */\ninterface DocumentTimeline extends AnimationTimeline {\n}\n\ndeclare var DocumentTimeline: {\n    prototype: DocumentTimeline;\n    new(options?: DocumentTimelineOptions): DocumentTimeline;\n};\n\n/**\n * The **`DocumentType`** interface represents a Node containing a doctype.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DocumentType)\n */\ninterface DocumentType extends Node, ChildNode {\n    /**\n     * The read-only **`name`** property of the DocumentType returns the type of the document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DocumentType/name)\n     */\n    readonly name: string;\n    readonly ownerDocument: Document;\n    /**\n     * The read-only **`publicId`** property of the DocumentType returns a formal identifier of the document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DocumentType/publicId)\n     */\n    readonly publicId: string;\n    /**\n     * The read-only **`systemId`** property of the DocumentType returns the URL of the associated DTD.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DocumentType/systemId)\n     */\n    readonly systemId: string;\n    /** [MDN Reference](https://developer.mozilla.org/en-US/docs/Web/API/Node/textContent) */\n    get textContent(): null;\n}\n\ndeclare var DocumentType: {\n    prototype: DocumentType;\n    new(): DocumentType;\n};\n\n/**\n * The **`DragEvent`** interface is a DOM event that represents a drag and drop interaction.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DragEvent)\n */\ninterface DragEvent extends MouseEvent {\n    /**\n     * The **`DragEvent.dataTransfer`** read-only property holds the drag operation's data (as a DataTransfer object).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DragEvent/dataTransfer)\n     */\n    readonly dataTransfer: DataTransfer | null;\n}\n\ndeclare var DragEvent: {\n    prototype: DragEvent;\n    new(type: string, eventInitDict?: DragEventInit): DragEvent;\n};\n\n/**\n * The `DynamicsCompressorNode` interface provides a compression effect, which lowers the volume of the loudest parts of the signal in order to help prevent clipping and distortion that can occur when multiple sounds are played and multiplexed together at once.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DynamicsCompressorNode)\n */\ninterface DynamicsCompressorNode extends AudioNode {\n    /**\n     * The `attack` property of the DynamicsCompressorNode interface is a k-rate AudioParam representing the amount of time, in seconds, required to reduce the gain by 10 dB.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DynamicsCompressorNode/attack)\n     */\n    readonly attack: AudioParam;\n    /**\n     * The `knee` property of the DynamicsCompressorNode interface is a k-rate AudioParam containing a decibel value representing the range above the threshold where the curve smoothly transitions to the compressed portion.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DynamicsCompressorNode/knee)\n     */\n    readonly knee: AudioParam;\n    /**\n     * The `ratio` property of the DynamicsCompressorNode interface Is a k-rate AudioParam representing the amount of change, in dB, needed in the input for a 1 dB change in the output.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DynamicsCompressorNode/ratio)\n     */\n    readonly ratio: AudioParam;\n    /**\n     * The **`reduction`** read-only property of the DynamicsCompressorNode interface is a float representing the amount of gain reduction currently applied by the compressor to the signal.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DynamicsCompressorNode/reduction)\n     */\n    readonly reduction: number;\n    /**\n     * The `release` property of the DynamicsCompressorNode interface Is a k-rate AudioParam representing the amount of time, in seconds, required to increase the gain by 10 dB.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DynamicsCompressorNode/release)\n     */\n    readonly release: AudioParam;\n    /**\n     * The `threshold` property of the DynamicsCompressorNode interface is a k-rate AudioParam representing the decibel value above which the compression will start taking effect.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/DynamicsCompressorNode/threshold)\n     */\n    readonly threshold: AudioParam;\n}\n\ndeclare var DynamicsCompressorNode: {\n    prototype: DynamicsCompressorNode;\n    new(context: BaseAudioContext, options?: DynamicsCompressorOptions): DynamicsCompressorNode;\n};\n\n/**\n * The **`EXT_blend_minmax`** extension is part of the WebGL API and extends blending capabilities by adding two new blend equations: the minimum or maximum color components of the source and destination colors.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_blend_minmax)\n */\ninterface EXT_blend_minmax {\n    readonly MIN_EXT: 0x8007;\n    readonly MAX_EXT: 0x8008;\n}\n\n/**\n * The **`EXT_color_buffer_float`** extension is part of WebGL and adds the ability to render a variety of floating point formats.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_color_buffer_float)\n */\ninterface EXT_color_buffer_float {\n}\n\n/**\n * The **`EXT_color_buffer_half_float`** extension is part of the WebGL API and adds the ability to render to 16-bit floating-point color buffers.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_color_buffer_half_float)\n */\ninterface EXT_color_buffer_half_float {\n    readonly RGBA16F_EXT: 0x881A;\n    readonly RGB16F_EXT: 0x881B;\n    readonly FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT: 0x8211;\n    readonly UNSIGNED_NORMALIZED_EXT: 0x8C17;\n}\n\n/**\n * The WebGL API's `EXT_float_blend` extension allows blending and draw buffers with 32-bit floating-point components.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_float_blend)\n */\ninterface EXT_float_blend {\n}\n\n/**\n * The **`EXT_frag_depth`** extension is part of the WebGL API and enables to set a depth value of a fragment from within the fragment shader.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_frag_depth)\n */\ninterface EXT_frag_depth {\n}\n\n/**\n * The **`EXT_sRGB`** extension is part of the WebGL API and adds sRGB support to textures and framebuffer objects.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_sRGB)\n */\ninterface EXT_sRGB {\n    readonly SRGB_EXT: 0x8C40;\n    readonly SRGB_ALPHA_EXT: 0x8C42;\n    readonly SRGB8_ALPHA8_EXT: 0x8C43;\n    readonly FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT: 0x8210;\n}\n\n/**\n * The **`EXT_shader_texture_lod`** extension is part of the WebGL API and adds additional texture functions to the OpenGL ES Shading Language which provide the shader writer with explicit control of LOD (Level of detail).\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_shader_texture_lod)\n */\ninterface EXT_shader_texture_lod {\n}\n\n/**\n * The `EXT_texture_compression_bptc` extension is part of the WebGL API and exposes 4 BPTC compressed texture formats.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_texture_compression_bptc)\n */\ninterface EXT_texture_compression_bptc {\n    readonly COMPRESSED_RGBA_BPTC_UNORM_EXT: 0x8E8C;\n    readonly COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT: 0x8E8D;\n    readonly COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT: 0x8E8E;\n    readonly COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT: 0x8E8F;\n}\n\n/**\n * The `EXT_texture_compression_rgtc` extension is part of the WebGL API and exposes 4 RGTC compressed texture formats.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_texture_compression_rgtc)\n */\ninterface EXT_texture_compression_rgtc {\n    readonly COMPRESSED_RED_RGTC1_EXT: 0x8DBB;\n    readonly COMPRESSED_SIGNED_RED_RGTC1_EXT: 0x8DBC;\n    readonly COMPRESSED_RED_GREEN_RGTC2_EXT: 0x8DBD;\n    readonly COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT: 0x8DBE;\n}\n\n/**\n * The **`EXT_texture_filter_anisotropic`** extension is part of the WebGL API and exposes two constants for anisotropic filtering (AF).\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_texture_filter_anisotropic)\n */\ninterface EXT_texture_filter_anisotropic {\n    readonly TEXTURE_MAX_ANISOTROPY_EXT: 0x84FE;\n    readonly MAX_TEXTURE_MAX_ANISOTROPY_EXT: 0x84FF;\n}\n\n/**\n * The **`EXT_texture_norm16`** extension is part of the WebGL API and provides a set of new 16-bit signed normalized and unsigned normalized formats (fixed-point texture, renderbuffer and texture buffer).\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EXT_texture_norm16)\n */\ninterface EXT_texture_norm16 {\n    readonly R16_EXT: 0x822A;\n    readonly RG16_EXT: 0x822C;\n    readonly RGB16_EXT: 0x8054;\n    readonly RGBA16_EXT: 0x805B;\n    readonly R16_SNORM_EXT: 0x8F98;\n    readonly RG16_SNORM_EXT: 0x8F99;\n    readonly RGB16_SNORM_EXT: 0x8F9A;\n    readonly RGBA16_SNORM_EXT: 0x8F9B;\n}\n\ninterface ElementEventMap {\n    \"fullscreenchange\": Event;\n    \"fullscreenerror\": Event;\n}\n\n/**\n * **`Element`** is the most general base class from which all element objects (i.e., objects that represent elements) in a Document inherit.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element)\n */\ninterface Element extends Node, ARIAMixin, Animatable, ChildNode, NonDocumentTypeChildNode, ParentNode, Slottable {\n    /**\n     * The **`Element.attributes`** property returns a live collection of all attribute nodes registered to the specified node.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/attributes)\n     */\n    readonly attributes: NamedNodeMap;\n    /**\n     * The **`Element.classList`** is a read-only property that returns a live DOMTokenList collection of the `class` attributes of the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/classList)\n     */\n    get classList(): DOMTokenList;\n    set classList(value: string);\n    /**\n     * The **`className`** property of the of the specified element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/className)\n     */\n    className: string;\n    /**\n     * The **`clientHeight`** read-only property of the Element interface is zero for elements with no CSS or inline layout boxes; otherwise, it's the inner height of an element in pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/clientHeight)\n     */\n    readonly clientHeight: number;\n    /**\n     * The **`clientLeft`** read-only property of the Element interface returns the width of the left border of an element in pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/clientLeft)\n     */\n    readonly clientLeft: number;\n    /**\n     * The **`clientTop`** read-only property of the Element interface returns the width of the top border of an element in pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/clientTop)\n     */\n    readonly clientTop: number;\n    /**\n     * The **`clientWidth`** read-only property of the Element interface is zero for inline elements and elements with no CSS; otherwise, it's the inner width of an element in pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/clientWidth)\n     */\n    readonly clientWidth: number;\n    /**\n     * The **`currentCSSZoom`** read-only property of the Element interface provides the 'effective' CSS `zoom` of an element, taking into account the zoom applied to the element and all its parent elements.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/currentCSSZoom)\n     */\n    readonly currentCSSZoom: number;\n    /**\n     * The **`id`** property of the Element interface represents the element's identifier, reflecting the **`id`** global attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/id)\n     */\n    id: string;\n    /**\n     * The **`innerHTML`** property of the Element interface gets or sets the HTML or XML markup contained within the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/innerHTML)\n     */\n    innerHTML: string;\n    /**\n     * The **`Element.localName`** read-only property returns the local part of the qualified name of an element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/localName)\n     */\n    readonly localName: string;\n    /**\n     * The **`Element.namespaceURI`** read-only property returns the namespace URI of the element, or `null` if the element is not in a namespace.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/namespaceURI)\n     */\n    readonly namespaceURI: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/fullscreenchange_event) */\n    onfullscreenchange: ((this: Element, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/fullscreenerror_event) */\n    onfullscreenerror: ((this: Element, ev: Event) => any) | null;\n    /**\n     * The **`outerHTML`** attribute of the Element DOM interface gets the serialized HTML fragment describing the element including its descendants.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/outerHTML)\n     */\n    outerHTML: string;\n    readonly ownerDocument: Document;\n    /**\n     * The **`part`** property of the Element interface represents the part identifier(s) of the element (i.e., set using the `part` attribute), returned as a DOMTokenList.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/part)\n     */\n    get part(): DOMTokenList;\n    set part(value: string);\n    /**\n     * The **`Element.prefix`** read-only property returns the namespace prefix of the specified element, or `null` if no prefix is specified.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/prefix)\n     */\n    readonly prefix: string | null;\n    /**\n     * The **`scrollHeight`** read-only property of the Element interface is a measurement of the height of an element's content, including content not visible on the screen due to overflow.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scrollHeight)\n     */\n    readonly scrollHeight: number;\n    /**\n     * The **`scrollLeft`** property of the Element interface gets or sets the number of pixels by which an element's content is scrolled from its left edge.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scrollLeft)\n     */\n    scrollLeft: number;\n    /**\n     * The **`scrollTop`** property of the Element interface gets or sets the number of pixels by which an element's content is scrolled from its top edge.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scrollTop)\n     */\n    scrollTop: number;\n    /**\n     * The **`scrollWidth`** read-only property of the Element interface is a measurement of the width of an element's content, including content not visible on the screen due to overflow.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scrollWidth)\n     */\n    readonly scrollWidth: number;\n    /**\n     * The `Element.shadowRoot` read-only property represents the shadow root hosted by the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/shadowRoot)\n     */\n    readonly shadowRoot: ShadowRoot | null;\n    /**\n     * The **`slot`** property of the Element interface returns the name of the shadow DOM slot the element is inserted in.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/slot)\n     */\n    slot: string;\n    /**\n     * The **`tagName`** read-only property of the Element interface returns the tag name of the element on which it's called.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/tagName)\n     */\n    readonly tagName: string;\n    /**\n     * The **`Element.attachShadow()`** method attaches a shadow DOM tree to the specified element and returns a reference to its ShadowRoot.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/attachShadow)\n     */\n    attachShadow(init: ShadowRootInit): ShadowRoot;\n    /**\n     * The **`checkVisibility()`** method of the Element interface checks whether the element is visible.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/checkVisibility)\n     */\n    checkVisibility(options?: CheckVisibilityOptions): boolean;\n    /**\n     * The **`closest()`** method of the Element interface traverses the element and its parents (heading toward the document root) until it finds a node that matches the specified CSS selector.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/closest)\n     */\n    closest<K extends keyof HTMLElementTagNameMap>(selector: K): HTMLElementTagNameMap[K] | null;\n    closest<K extends keyof SVGElementTagNameMap>(selector: K): SVGElementTagNameMap[K] | null;\n    closest<K extends keyof MathMLElementTagNameMap>(selector: K): MathMLElementTagNameMap[K] | null;\n    closest<E extends Element = Element>(selectors: string): E | null;\n    /**\n     * The **`computedStyleMap()`** method of the Element interface returns a StylePropertyMapReadOnly interface which provides a read-only representation of a CSS declaration block that is an alternative to CSSStyleDeclaration.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/computedStyleMap)\n     */\n    computedStyleMap(): StylePropertyMapReadOnly;\n    /**\n     * The **`getAttribute()`** method of the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getAttribute)\n     */\n    getAttribute(qualifiedName: string): string | null;\n    /**\n     * The **`getAttributeNS()`** method of the Element interface returns the string value of the attribute with the specified namespace and name.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getAttributeNS)\n     */\n    getAttributeNS(namespace: string | null, localName: string): string | null;\n    /**\n     * The **`getAttributeNames()`** method of the array.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getAttributeNames)\n     */\n    getAttributeNames(): string[];\n    /**\n     * Returns the specified attribute of the specified element, as an Attr node.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getAttributeNode)\n     */\n    getAttributeNode(qualifiedName: string): Attr | null;\n    /**\n     * The **`getAttributeNodeNS()`** method of the Element interface returns the namespaced Attr node of an element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getAttributeNodeNS)\n     */\n    getAttributeNodeNS(namespace: string | null, localName: string): Attr | null;\n    /**\n     * The **`Element.getBoundingClientRect()`** method returns a position relative to the viewport.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getBoundingClientRect)\n     */\n    getBoundingClientRect(): DOMRect;\n    /**\n     * The **`getClientRects()`** method of the Element interface returns a collection of DOMRect objects that indicate the bounding rectangles for each CSS border box in a client.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getClientRects)\n     */\n    getClientRects(): DOMRectList;\n    /**\n     * The Element method **`getElementsByClassName()`** returns a live specified class name or names.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getElementsByClassName)\n     */\n    getElementsByClassName(classNames: string): HTMLCollectionOf<Element>;\n    /**\n     * The **`Element.getElementsByTagName()`** method returns a live All descendants of the specified element are searched, but not the element itself.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getElementsByTagName)\n     */\n    getElementsByTagName<K extends keyof HTMLElementTagNameMap>(qualifiedName: K): HTMLCollectionOf<HTMLElementTagNameMap[K]>;\n    getElementsByTagName<K extends keyof SVGElementTagNameMap>(qualifiedName: K): HTMLCollectionOf<SVGElementTagNameMap[K]>;\n    getElementsByTagName<K extends keyof MathMLElementTagNameMap>(qualifiedName: K): HTMLCollectionOf<MathMLElementTagNameMap[K]>;\n    /** @deprecated */\n    getElementsByTagName<K extends keyof HTMLElementDeprecatedTagNameMap>(qualifiedName: K): HTMLCollectionOf<HTMLElementDeprecatedTagNameMap[K]>;\n    getElementsByTagName(qualifiedName: string): HTMLCollectionOf<Element>;\n    /**\n     * The **`Element.getElementsByTagNameNS()`** method returns a live HTMLCollection of elements with the given tag name belonging to the given namespace.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getElementsByTagNameNS)\n     */\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/1999/xhtml\", localName: string): HTMLCollectionOf<HTMLElement>;\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/2000/svg\", localName: string): HTMLCollectionOf<SVGElement>;\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/1998/Math/MathML\", localName: string): HTMLCollectionOf<MathMLElement>;\n    getElementsByTagNameNS(namespace: string | null, localName: string): HTMLCollectionOf<Element>;\n    /**\n     * The **`getHTML()`** method of the Element interface is used to serialize an element's DOM to an HTML string.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/getHTML)\n     */\n    getHTML(options?: GetHTMLOptions): string;\n    /**\n     * The **`Element.hasAttribute()`** method returns a **Boolean** value indicating whether the specified element has the specified attribute or not.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/hasAttribute)\n     */\n    hasAttribute(qualifiedName: string): boolean;\n    /**\n     * The **`hasAttributeNS()`** method of the Element interface returns a boolean value indicating whether the current element has the specified attribute with the specified namespace.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/hasAttributeNS)\n     */\n    hasAttributeNS(namespace: string | null, localName: string): boolean;\n    /**\n     * The **`hasAttributes()`** method of the Element interface returns a boolean value indicating whether the current element has any attributes or not.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/hasAttributes)\n     */\n    hasAttributes(): boolean;\n    /**\n     * The **`hasPointerCapture()`** method of the pointer capture for the pointer identified by the given pointer ID.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/hasPointerCapture)\n     */\n    hasPointerCapture(pointerId: number): boolean;\n    /**\n     * The **`insertAdjacentElement()`** method of the relative to the element it is invoked upon.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/insertAdjacentElement)\n     */\n    insertAdjacentElement(where: InsertPosition, element: Element): Element | null;\n    /**\n     * The **`insertAdjacentHTML()`** method of the the resulting nodes into the DOM tree at a specified position.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/insertAdjacentHTML)\n     */\n    insertAdjacentHTML(position: InsertPosition, string: string): void;\n    /**\n     * The **`insertAdjacentText()`** method of the Element interface, given a relative position and a string, inserts a new text node at the given position relative to the element it is called from.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/insertAdjacentText)\n     */\n    insertAdjacentText(where: InsertPosition, data: string): void;\n    /**\n     * The **`matches()`** method of the Element interface tests whether the element would be selected by the specified CSS selector.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/matches)\n     */\n    matches(selectors: string): boolean;\n    /**\n     * The **`releasePointerCapture()`** method of the previously set for a specific (PointerEvent) _pointer_.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/releasePointerCapture)\n     */\n    releasePointerCapture(pointerId: number): void;\n    /**\n     * The Element method **`removeAttribute()`** removes the attribute with the specified name from the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/removeAttribute)\n     */\n    removeAttribute(qualifiedName: string): void;\n    /**\n     * The **`removeAttributeNS()`** method of the If you are working with HTML and you don't need to specify the requested attribute as being part of a specific namespace, use the Element.removeAttribute() method instead.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/removeAttributeNS)\n     */\n    removeAttributeNS(namespace: string | null, localName: string): void;\n    /**\n     * The **`removeAttributeNode()`** method of the Element interface removes the specified Attr node from the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/removeAttributeNode)\n     */\n    removeAttributeNode(attr: Attr): Attr;\n    /**\n     * The **`Element.requestFullscreen()`** method issues an asynchronous request to make the element be displayed in fullscreen mode.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/requestFullscreen)\n     */\n    requestFullscreen(options?: FullscreenOptions): Promise<void>;\n    /**\n     * The **`requestPointerLock()`** method of the Element interface lets you asynchronously ask for the pointer to be locked on the given element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/requestPointerLock)\n     */\n    requestPointerLock(options?: PointerLockOptions): Promise<void>;\n    /**\n     * The **`scroll()`** method of the Element interface scrolls the element to a particular set of coordinates inside a given element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scroll)\n     */\n    scroll(options?: ScrollToOptions): void;\n    scroll(x: number, y: number): void;\n    /**\n     * The **`scrollBy()`** method of the Element interface scrolls an element by the given amount.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scrollBy)\n     */\n    scrollBy(options?: ScrollToOptions): void;\n    scrollBy(x: number, y: number): void;\n    /**\n     * The Element interface's **`scrollIntoView()`** method scrolls the element's ancestor containers such that the element on which `scrollIntoView()` is called is visible to the user.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scrollIntoView)\n     */\n    scrollIntoView(arg?: boolean | ScrollIntoViewOptions): void;\n    /**\n     * The **`scrollTo()`** method of the Element interface scrolls to a particular set of coordinates inside a given element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/scrollTo)\n     */\n    scrollTo(options?: ScrollToOptions): void;\n    scrollTo(x: number, y: number): void;\n    /**\n     * The **`setAttribute()`** method of the Element interface sets the value of an attribute on the specified element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/setAttribute)\n     */\n    setAttribute(qualifiedName: string, value: string): void;\n    /**\n     * `setAttributeNS` adds a new attribute or changes the value of an attribute with the given namespace and name.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/setAttributeNS)\n     */\n    setAttributeNS(namespace: string | null, qualifiedName: string, value: string): void;\n    /**\n     * The **`setAttributeNode()`** method of the Element interface adds a new Attr node to the specified element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/setAttributeNode)\n     */\n    setAttributeNode(attr: Attr): Attr | null;\n    /**\n     * The **`setAttributeNodeNS()`** method of the Element interface adds a new namespaced Attr node to an element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/setAttributeNodeNS)\n     */\n    setAttributeNodeNS(attr: Attr): Attr | null;\n    /**\n     * The **`setHTMLUnsafe()`** method of the Element interface is used to parse a string of HTML into a DocumentFragment, optionally filtering out unwanted elements and attributes, and those that don't belong in the context, and then using it to replace the element's subtree in the DOM.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/setHTMLUnsafe)\n     */\n    setHTMLUnsafe(html: string): void;\n    /**\n     * The **`setPointerCapture()`** method of the _capture target_ of future pointer events.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/setPointerCapture)\n     */\n    setPointerCapture(pointerId: number): void;\n    /**\n     * The **`toggleAttribute()`** method of the present and adding it if it is not present) on the given element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/toggleAttribute)\n     */\n    toggleAttribute(qualifiedName: string, force?: boolean): boolean;\n    /**\n     * @deprecated This is a legacy alias of `matches`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/matches)\n     */\n    webkitMatchesSelector(selectors: string): boolean;\n    /** [MDN Reference](https://developer.mozilla.org/en-US/docs/Web/API/Node/textContent) */\n    get textContent(): string;\n    set textContent(value: string | null);\n    addEventListener<K extends keyof ElementEventMap>(type: K, listener: (this: Element, ev: ElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof ElementEventMap>(type: K, listener: (this: Element, ev: ElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var Element: {\n    prototype: Element;\n    new(): Element;\n};\n\ninterface ElementCSSInlineStyle {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/attributeStyleMap) */\n    readonly attributeStyleMap: StylePropertyMap;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/style) */\n    get style(): CSSStyleDeclaration;\n    set style(cssText: string);\n}\n\ninterface ElementContentEditable {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/contentEditable) */\n    contentEditable: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/enterKeyHint) */\n    enterKeyHint: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/inputMode) */\n    inputMode: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/isContentEditable) */\n    readonly isContentEditable: boolean;\n}\n\n/**\n * The **`ElementInternals`** interface of the Document Object Model gives web developers a way to allow custom elements to fully participate in HTML forms.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals)\n */\ninterface ElementInternals extends ARIAMixin {\n    /**\n     * The **`form`** read-only property of the ElementInternals interface returns the HTMLFormElement associated with this element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/form)\n     */\n    readonly form: HTMLFormElement | null;\n    /**\n     * The **`labels`** read-only property of the ElementInternals interface returns the labels associated with the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/labels)\n     */\n    readonly labels: NodeList;\n    /**\n     * The **`shadowRoot`** read-only property of the ElementInternals interface returns the ShadowRoot for this element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/shadowRoot)\n     */\n    readonly shadowRoot: ShadowRoot | null;\n    /**\n     * The **`states`** read-only property of the ElementInternals interface returns a CustomStateSet representing the possible states of the custom element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/states)\n     */\n    readonly states: CustomStateSet;\n    /**\n     * The **`validationMessage`** read-only property of the ElementInternals interface returns the validation message for the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/validationMessage)\n     */\n    readonly validationMessage: string;\n    /**\n     * The **`validity`** read-only property of the ElementInternals interface returns a ValidityState object which represents the different validity states the element can be in, with respect to constraint validation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/validity)\n     */\n    readonly validity: ValidityState;\n    /**\n     * The **`willValidate`** read-only property of the ElementInternals interface returns `true` if the element is a submittable element that is a candidate for constraint validation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/willValidate)\n     */\n    readonly willValidate: boolean;\n    /**\n     * The **`checkValidity()`** method of the ElementInternals interface checks if the element meets any constraint validation rules applied to it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/checkValidity)\n     */\n    checkValidity(): boolean;\n    /**\n     * The **`reportValidity()`** method of the ElementInternals interface checks if the element meets any constraint validation rules applied to it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/reportValidity)\n     */\n    reportValidity(): boolean;\n    /**\n     * The **`setFormValue()`** method of the ElementInternals interface sets the element's submission value and state, communicating these to the user agent.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/setFormValue)\n     */\n    setFormValue(value: File | string | FormData | null, state?: File | string | FormData | null): void;\n    /**\n     * The **`setValidity()`** method of the ElementInternals interface sets the validity of the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ElementInternals/setValidity)\n     */\n    setValidity(flags?: ValidityStateFlags, message?: string, anchor?: HTMLElement): void;\n}\n\ndeclare var ElementInternals: {\n    prototype: ElementInternals;\n    new(): ElementInternals;\n};\n\n/**\n * The **`EncodedAudioChunk`** interface of the WebCodecs API represents a chunk of encoded audio data.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedAudioChunk)\n */\ninterface EncodedAudioChunk {\n    /**\n     * The **`byteLength`** read-only property of the EncodedAudioChunk interface returns the length in bytes of the encoded audio data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedAudioChunk/byteLength)\n     */\n    readonly byteLength: number;\n    /**\n     * The **`duration`** read-only property of the EncodedAudioChunk interface returns an integer indicating the duration of the audio in microseconds.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedAudioChunk/duration)\n     */\n    readonly duration: number | null;\n    /**\n     * The **`timestamp`** read-only property of the EncodedAudioChunk interface returns an integer indicating the timestamp of the audio in microseconds.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedAudioChunk/timestamp)\n     */\n    readonly timestamp: number;\n    /**\n     * The **`type`** read-only property of the EncodedAudioChunk interface returns a value indicating whether the audio chunk is a key chunk, which does not relying on other frames for decoding.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedAudioChunk/type)\n     */\n    readonly type: EncodedAudioChunkType;\n    /**\n     * The **`copyTo()`** method of the EncodedAudioChunk interface copies the encoded chunk of audio data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedAudioChunk/copyTo)\n     */\n    copyTo(destination: AllowSharedBufferSource): void;\n}\n\ndeclare var EncodedAudioChunk: {\n    prototype: EncodedAudioChunk;\n    new(init: EncodedAudioChunkInit): EncodedAudioChunk;\n};\n\n/**\n * The **`EncodedVideoChunk`** interface of the WebCodecs API represents a chunk of encoded video data.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedVideoChunk)\n */\ninterface EncodedVideoChunk {\n    /**\n     * The **`byteLength`** read-only property of the EncodedVideoChunk interface returns the length in bytes of the encoded video data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedVideoChunk/byteLength)\n     */\n    readonly byteLength: number;\n    /**\n     * The **`duration`** read-only property of the EncodedVideoChunk interface returns an integer indicating the duration of the video in microseconds.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedVideoChunk/duration)\n     */\n    readonly duration: number | null;\n    /**\n     * The **`timestamp`** read-only property of the EncodedVideoChunk interface returns an integer indicating the timestamp of the video in microseconds.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedVideoChunk/timestamp)\n     */\n    readonly timestamp: number;\n    /**\n     * The **`type`** read-only property of the EncodedVideoChunk interface returns a value indicating whether the video chunk is a key chunk, which does not rely on other frames for decoding.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedVideoChunk/type)\n     */\n    readonly type: EncodedVideoChunkType;\n    /**\n     * The **`copyTo()`** method of the EncodedVideoChunk interface copies the encoded chunk of video data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EncodedVideoChunk/copyTo)\n     */\n    copyTo(destination: AllowSharedBufferSource): void;\n}\n\ndeclare var EncodedVideoChunk: {\n    prototype: EncodedVideoChunk;\n    new(init: EncodedVideoChunkInit): EncodedVideoChunk;\n};\n\n/**\n * The **`ErrorEvent`** interface represents events providing information related to errors in scripts or in files.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ErrorEvent)\n */\ninterface ErrorEvent extends Event {\n    /**\n     * The **`colno`** read-only property of the ErrorEvent interface returns an integer containing the column number of the script file on which the error occurred.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ErrorEvent/colno)\n     */\n    readonly colno: number;\n    /**\n     * The **`error`** read-only property of the ErrorEvent interface returns a JavaScript value, such as an Error or DOMException, representing the error associated with this event.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ErrorEvent/error)\n     */\n    readonly error: any;\n    /**\n     * The **`filename`** read-only property of the ErrorEvent interface returns a string containing the name of the script file in which the error occurred.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ErrorEvent/filename)\n     */\n    readonly filename: string;\n    /**\n     * The **`lineno`** read-only property of the ErrorEvent interface returns an integer containing the line number of the script file on which the error occurred.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ErrorEvent/lineno)\n     */\n    readonly lineno: number;\n    /**\n     * The **`message`** read-only property of the ErrorEvent interface returns a string containing a human-readable error message describing the problem.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ErrorEvent/message)\n     */\n    readonly message: string;\n}\n\ndeclare var ErrorEvent: {\n    prototype: ErrorEvent;\n    new(type: string, eventInitDict?: ErrorEventInit): ErrorEvent;\n};\n\n/**\n * The **`Event`** interface represents an event which takes place on an `EventTarget`.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event)\n */\ninterface Event {\n    /**\n     * The **`bubbles`** read-only property of the Event interface indicates whether the event bubbles up through the DOM tree or not.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/bubbles)\n     */\n    readonly bubbles: boolean;\n    /**\n     * The **`cancelBubble`** property of the Event interface is deprecated.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/cancelBubble)\n     */\n    cancelBubble: boolean;\n    /**\n     * The **`cancelable`** read-only property of the Event interface indicates whether the event can be canceled, and therefore prevented as if the event never happened.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/cancelable)\n     */\n    readonly cancelable: boolean;\n    /**\n     * The read-only **`composed`** property of the or not the event will propagate across the shadow DOM boundary into the standard DOM.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/composed)\n     */\n    readonly composed: boolean;\n    /**\n     * The **`currentTarget`** read-only property of the Event interface identifies the element to which the event handler has been attached.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/currentTarget)\n     */\n    readonly currentTarget: EventTarget | null;\n    /**\n     * The **`defaultPrevented`** read-only property of the Event interface returns a boolean value indicating whether or not the call to Event.preventDefault() canceled the event.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/defaultPrevented)\n     */\n    readonly defaultPrevented: boolean;\n    /**\n     * The **`eventPhase`** read-only property of the being evaluated.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/eventPhase)\n     */\n    readonly eventPhase: number;\n    /**\n     * The **`isTrusted`** read-only property of the when the event was generated by the user agent (including via user actions and programmatic methods such as HTMLElement.focus()), and `false` when the event was dispatched via The only exception is the `click` event, which initializes the `isTrusted` property to `false` in user agents.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/isTrusted)\n     */\n    readonly isTrusted: boolean;\n    /**\n     * The Event property **`returnValue`** indicates whether the default action for this event has been prevented or not.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/returnValue)\n     */\n    returnValue: boolean;\n    /**\n     * The deprecated **`Event.srcElement`** is an alias for the Event.target property.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/srcElement)\n     */\n    readonly srcElement: EventTarget | null;\n    /**\n     * The read-only **`target`** property of the dispatched.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/target)\n     */\n    readonly target: EventTarget | null;\n    /**\n     * The **`timeStamp`** read-only property of the Event interface returns the time (in milliseconds) at which the event was created.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/timeStamp)\n     */\n    readonly timeStamp: DOMHighResTimeStamp;\n    /**\n     * The **`type`** read-only property of the Event interface returns a string containing the event's type.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/type)\n     */\n    readonly type: string;\n    /**\n     * The **`composedPath()`** method of the Event interface returns the event's path which is an array of the objects on which listeners will be invoked.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/composedPath)\n     */\n    composedPath(): EventTarget[];\n    /**\n     * The **`Event.initEvent()`** method is used to initialize the value of an event created using Document.createEvent().\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/initEvent)\n     */\n    initEvent(type: string, bubbles?: boolean, cancelable?: boolean): void;\n    /**\n     * The **`preventDefault()`** method of the Event interface tells the user agent that if the event does not get explicitly handled, its default action should not be taken as it normally would be.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/preventDefault)\n     */\n    preventDefault(): void;\n    /**\n     * The **`stopImmediatePropagation()`** method of the If several listeners are attached to the same element for the same event type, they are called in the order in which they were added.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/stopImmediatePropagation)\n     */\n    stopImmediatePropagation(): void;\n    /**\n     * The **`stopPropagation()`** method of the Event interface prevents further propagation of the current event in the capturing and bubbling phases.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Event/stopPropagation)\n     */\n    stopPropagation(): void;\n    readonly NONE: 0;\n    readonly CAPTURING_PHASE: 1;\n    readonly AT_TARGET: 2;\n    readonly BUBBLING_PHASE: 3;\n}\n\ndeclare var Event: {\n    prototype: Event;\n    new(type: string, eventInitDict?: EventInit): Event;\n    readonly NONE: 0;\n    readonly CAPTURING_PHASE: 1;\n    readonly AT_TARGET: 2;\n    readonly BUBBLING_PHASE: 3;\n};\n\n/**\n * The **`EventCounts`** interface of the Performance API provides the number of events that have been dispatched for each event type.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventCounts)\n */\ninterface EventCounts {\n    forEach(callbackfn: (value: number, key: string, parent: EventCounts) => void, thisArg?: any): void;\n}\n\ndeclare var EventCounts: {\n    prototype: EventCounts;\n    new(): EventCounts;\n};\n\ninterface EventListener {\n    (evt: Event): void;\n}\n\ninterface EventListenerObject {\n    handleEvent(object: Event): void;\n}\n\ninterface EventSourceEventMap {\n    \"error\": Event;\n    \"message\": MessageEvent;\n    \"open\": Event;\n}\n\n/**\n * The **`EventSource`** interface is web content's interface to server-sent events.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventSource)\n */\ninterface EventSource extends EventTarget {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventSource/error_event) */\n    onerror: ((this: EventSource, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventSource/message_event) */\n    onmessage: ((this: EventSource, ev: MessageEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventSource/open_event) */\n    onopen: ((this: EventSource, ev: Event) => any) | null;\n    /**\n     * The **`readyState`** read-only property of the connection.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventSource/readyState)\n     */\n    readonly readyState: number;\n    /**\n     * The **`url`** read-only property of the URL of the source.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventSource/url)\n     */\n    readonly url: string;\n    /**\n     * The **`withCredentials`** read-only property of the the `EventSource` object was instantiated with CORS credentials set.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventSource/withCredentials)\n     */\n    readonly withCredentials: boolean;\n    /**\n     * The **`close()`** method of the EventSource interface closes the connection, if one is made, and sets the ```js-nolint close() ``` None.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventSource/close)\n     */\n    close(): void;\n    readonly CONNECTING: 0;\n    readonly OPEN: 1;\n    readonly CLOSED: 2;\n    addEventListener<K extends keyof EventSourceEventMap>(type: K, listener: (this: EventSource, ev: EventSourceEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: (this: EventSource, event: MessageEvent) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof EventSourceEventMap>(type: K, listener: (this: EventSource, ev: EventSourceEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: (this: EventSource, event: MessageEvent) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var EventSource: {\n    prototype: EventSource;\n    new(url: string | URL, eventSourceInitDict?: EventSourceInit): EventSource;\n    readonly CONNECTING: 0;\n    readonly OPEN: 1;\n    readonly CLOSED: 2;\n};\n\n/**\n * The **`EventTarget`** interface is implemented by objects that can receive events and may have listeners for them.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventTarget)\n */\ninterface EventTarget {\n    /**\n     * The **`addEventListener()`** method of the EventTarget interface sets up a function that will be called whenever the specified event is delivered to the target.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventTarget/addEventListener)\n     */\n    addEventListener(type: string, callback: EventListenerOrEventListenerObject | null, options?: AddEventListenerOptions | boolean): void;\n    /**\n     * The **`dispatchEvent()`** method of the EventTarget sends an Event to the object, (synchronously) invoking the affected event listeners in the appropriate order.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventTarget/dispatchEvent)\n     */\n    dispatchEvent(event: Event): boolean;\n    /**\n     * The **`removeEventListener()`** method of the EventTarget interface removes an event listener previously registered with EventTarget.addEventListener() from the target.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/EventTarget/removeEventListener)\n     */\n    removeEventListener(type: string, callback: EventListenerOrEventListenerObject | null, options?: EventListenerOptions | boolean): void;\n}\n\ndeclare var EventTarget: {\n    prototype: EventTarget;\n    new(): EventTarget;\n};\n\n/** @deprecated */\ninterface External {\n    /** @deprecated */\n    AddSearchProvider(): void;\n    /** @deprecated */\n    IsSearchProviderInstalled(): void;\n}\n\n/** @deprecated */\ndeclare var External: {\n    prototype: External;\n    new(): External;\n};\n\n/**\n * The **`File`** interface provides information about files and allows JavaScript in a web page to access their content.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/File)\n */\ninterface File extends Blob {\n    /**\n     * The **`lastModified`** read-only property of the File interface provides the last modified date of the file as the number of milliseconds since the Unix epoch (January 1, 1970 at midnight).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/File/lastModified)\n     */\n    readonly lastModified: number;\n    /**\n     * The **`name`** read-only property of the File interface returns the name of the file represented by a File object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/File/name)\n     */\n    readonly name: string;\n    /**\n     * The **`webkitRelativePath`** read-only property of the File interface contains a string which specifies the file's path relative to the directory selected by the user in an input element with its `webkitdirectory` attribute set.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/File/webkitRelativePath)\n     */\n    readonly webkitRelativePath: string;\n}\n\ndeclare var File: {\n    prototype: File;\n    new(fileBits: BlobPart[], fileName: string, options?: FilePropertyBag): File;\n};\n\n/**\n * The **`FileList`** interface represents an object of this type returned by the `files` property of the HTML input element; this lets you access the list of files selected with the `<input type='file'>` element.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileList)\n */\ninterface FileList {\n    /**\n     * The **`length`** read-only property of the FileList interface returns the number of files in the `FileList`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileList/length)\n     */\n    readonly length: number;\n    /**\n     * The **`item()`** method of the FileList interface returns a File object representing the file at the specified index in the file list.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileList/item)\n     */\n    item(index: number): File | null;\n    [index: number]: File;\n}\n\ndeclare var FileList: {\n    prototype: FileList;\n    new(): FileList;\n};\n\ninterface FileReaderEventMap {\n    \"abort\": ProgressEvent<FileReader>;\n    \"error\": ProgressEvent<FileReader>;\n    \"load\": ProgressEvent<FileReader>;\n    \"loadend\": ProgressEvent<FileReader>;\n    \"loadstart\": ProgressEvent<FileReader>;\n    \"progress\": ProgressEvent<FileReader>;\n}\n\n/**\n * The **`FileReader`** interface lets web applications asynchronously read the contents of files (or raw data buffers) stored on the user's computer, using File or Blob objects to specify the file or data to read.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader)\n */\ninterface FileReader extends EventTarget {\n    /**\n     * The **`error`** read-only property of the FileReader interface returns the error that occurred while reading the file.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/error)\n     */\n    readonly error: DOMException | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/abort_event) */\n    onabort: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/error_event) */\n    onerror: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/load_event) */\n    onload: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/loadend_event) */\n    onloadend: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/loadstart_event) */\n    onloadstart: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/progress_event) */\n    onprogress: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    /**\n     * The **`readyState`** read-only property of the FileReader interface provides the current state of the reading operation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/readyState)\n     */\n    readonly readyState: typeof FileReader.EMPTY | typeof FileReader.LOADING | typeof FileReader.DONE;\n    /**\n     * The **`result`** read-only property of the FileReader interface returns the file's contents.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/result)\n     */\n    readonly result: string | ArrayBuffer | null;\n    /**\n     * The **`abort()`** method of the FileReader interface aborts the read operation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/abort)\n     */\n    abort(): void;\n    /**\n     * The **`readAsArrayBuffer()`** method of the FileReader interface is used to start reading the contents of a specified Blob or File.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/readAsArrayBuffer)\n     */\n    readAsArrayBuffer(blob: Blob): void;\n    /**\n     * The **`readAsBinaryString()`** method of the FileReader interface is used to start reading the contents of the specified Blob or File.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/readAsBinaryString)\n     */\n    readAsBinaryString(blob: Blob): void;\n    /**\n     * The **`readAsDataURL()`** method of the FileReader interface is used to read the contents of the specified file's data as a base64 encoded string.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/readAsDataURL)\n     */\n    readAsDataURL(blob: Blob): void;\n    /**\n     * The **`readAsText()`** method of the FileReader interface is used to read the contents of the specified Blob or File.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileReader/readAsText)\n     */\n    readAsText(blob: Blob, encoding?: string): void;\n    readonly EMPTY: 0;\n    readonly LOADING: 1;\n    readonly DONE: 2;\n    addEventListener<K extends keyof FileReaderEventMap>(type: K, listener: (this: FileReader, ev: FileReaderEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof FileReaderEventMap>(type: K, listener: (this: FileReader, ev: FileReaderEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var FileReader: {\n    prototype: FileReader;\n    new(): FileReader;\n    readonly EMPTY: 0;\n    readonly LOADING: 1;\n    readonly DONE: 2;\n};\n\n/**\n * The File and Directory Entries API interface **`FileSystem`** is used to represent a file system.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystem)\n */\ninterface FileSystem {\n    /**\n     * The read-only **`name`** property of the string is unique among all file systems currently exposed by the File and Directory Entries API.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystem/name)\n     */\n    readonly name: string;\n    /**\n     * The read-only **`root`** property of the object representing the root directory of the file system, for use with the File and Directory Entries API.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystem/root)\n     */\n    readonly root: FileSystemDirectoryEntry;\n}\n\ndeclare var FileSystem: {\n    prototype: FileSystem;\n    new(): FileSystem;\n};\n\n/**\n * The **`FileSystemDirectoryEntry`** interface of the File and Directory Entries API represents a directory in a file system.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryEntry)\n */\ninterface FileSystemDirectoryEntry extends FileSystemEntry {\n    /**\n     * The FileSystemDirectoryEntry interface's method **`createReader()`** returns a the directory.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryEntry/createReader)\n     */\n    createReader(): FileSystemDirectoryReader;\n    /**\n     * The FileSystemDirectoryEntry interface's method **`getDirectory()`** returns a somewhere within the directory subtree rooted at the directory on which it's called.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryEntry/getDirectory)\n     */\n    getDirectory(path?: string | null, options?: FileSystemFlags, successCallback?: FileSystemEntryCallback, errorCallback?: ErrorCallback): void;\n    /**\n     * The FileSystemDirectoryEntry interface's method **`getFile()`** returns a within the directory subtree rooted at the directory on which it's called.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryEntry/getFile)\n     */\n    getFile(path?: string | null, options?: FileSystemFlags, successCallback?: FileSystemEntryCallback, errorCallback?: ErrorCallback): void;\n}\n\ndeclare var FileSystemDirectoryEntry: {\n    prototype: FileSystemDirectoryEntry;\n    new(): FileSystemDirectoryEntry;\n};\n\n/**\n * The **`FileSystemDirectoryHandle`** interface of the File System API provides a handle to a file system directory.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryHandle)\n */\ninterface FileSystemDirectoryHandle extends FileSystemHandle {\n    readonly kind: \"directory\";\n    /**\n     * The **`getDirectoryHandle()`** method of the within the directory handle on which the method is called.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryHandle/getDirectoryHandle)\n     */\n    getDirectoryHandle(name: string, options?: FileSystemGetDirectoryOptions): Promise<FileSystemDirectoryHandle>;\n    /**\n     * The **`getFileHandle()`** method of the directory the method is called.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryHandle/getFileHandle)\n     */\n    getFileHandle(name: string, options?: FileSystemGetFileOptions): Promise<FileSystemFileHandle>;\n    /**\n     * The **`removeEntry()`** method of the directory handle contains a file or directory called the name specified.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryHandle/removeEntry)\n     */\n    removeEntry(name: string, options?: FileSystemRemoveOptions): Promise<void>;\n    /**\n     * The **`resolve()`** method of the directory names from the parent handle to the specified child entry, with the name of the child entry as the last array item.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryHandle/resolve)\n     */\n    resolve(possibleDescendant: FileSystemHandle): Promise<string[] | null>;\n}\n\ndeclare var FileSystemDirectoryHandle: {\n    prototype: FileSystemDirectoryHandle;\n    new(): FileSystemDirectoryHandle;\n};\n\n/**\n * The `FileSystemDirectoryReader` interface of the File and Directory Entries API lets you access the FileSystemFileEntry-based objects (generally FileSystemFileEntry or FileSystemDirectoryEntry) representing each entry in a directory.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryReader)\n */\ninterface FileSystemDirectoryReader {\n    /**\n     * The FileSystemDirectoryReader interface's **`readEntries()`** method retrieves the directory entries within the directory being read and delivers them in an array to a provided callback function.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemDirectoryReader/readEntries)\n     */\n    readEntries(successCallback: FileSystemEntriesCallback, errorCallback?: ErrorCallback): void;\n}\n\ndeclare var FileSystemDirectoryReader: {\n    prototype: FileSystemDirectoryReader;\n    new(): FileSystemDirectoryReader;\n};\n\n/**\n * The **`FileSystemEntry`** interface of the File and Directory Entries API represents a single entry in a file system.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemEntry)\n */\ninterface FileSystemEntry {\n    /**\n     * The read-only **`filesystem`** property of the FileSystemEntry interface contains a resides.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemEntry/filesystem)\n     */\n    readonly filesystem: FileSystem;\n    /**\n     * The read-only **`fullPath`** property of the FileSystemEntry interface returns a string specifying the full, absolute path from the file system's root to the file represented by the entry.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemEntry/fullPath)\n     */\n    readonly fullPath: string;\n    /**\n     * The read-only **`isDirectory`** property of the FileSystemEntry interface is `true` if the entry represents a directory (meaning it's a FileSystemDirectoryEntry) and `false` if it's not.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemEntry/isDirectory)\n     */\n    readonly isDirectory: boolean;\n    /**\n     * The read-only **`isFile`** property of the FileSystemEntry interface is `true` if the entry represents a file (meaning it's a FileSystemFileEntry) and `false` if it's not.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemEntry/isFile)\n     */\n    readonly isFile: boolean;\n    /**\n     * The read-only **`name`** property of the FileSystemEntry interface returns a string specifying the entry's name; this is the entry within its parent directory (the last component of the path as indicated by the FileSystemEntry.fullPath property).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemEntry/name)\n     */\n    readonly name: string;\n    /**\n     * The FileSystemEntry interface's method **`getParent()`** obtains a ```js-nolint getParent(successCallback, errorCallback) getParent(successCallback) ``` - `successCallback` - : A function which is called when the parent directory entry has been retrieved.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemEntry/getParent)\n     */\n    getParent(successCallback?: FileSystemEntryCallback, errorCallback?: ErrorCallback): void;\n}\n\ndeclare var FileSystemEntry: {\n    prototype: FileSystemEntry;\n    new(): FileSystemEntry;\n};\n\n/**\n * The **`FileSystemFileEntry`** interface of the File and Directory Entries API represents a file in a file system.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemFileEntry)\n */\ninterface FileSystemFileEntry extends FileSystemEntry {\n    /**\n     * The FileSystemFileEntry interface's method **`file()`** returns a the directory entry.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemFileEntry/file)\n     */\n    file(successCallback: FileCallback, errorCallback?: ErrorCallback): void;\n}\n\ndeclare var FileSystemFileEntry: {\n    prototype: FileSystemFileEntry;\n    new(): FileSystemFileEntry;\n};\n\n/**\n * The **`FileSystemFileHandle`** interface of the File System API represents a handle to a file system entry.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemFileHandle)\n */\ninterface FileSystemFileHandle extends FileSystemHandle {\n    readonly kind: \"file\";\n    /**\n     * The **`createWritable()`** method of the FileSystemFileHandle interface creates a FileSystemWritableFileStream that can be used to write to a file.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemFileHandle/createWritable)\n     */\n    createWritable(options?: FileSystemCreateWritableOptions): Promise<FileSystemWritableFileStream>;\n    /**\n     * The **`getFile()`** method of the If the file on disk changes or is removed after this method is called, the returned ```js-nolint getFile() ``` None.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemFileHandle/getFile)\n     */\n    getFile(): Promise<File>;\n}\n\ndeclare var FileSystemFileHandle: {\n    prototype: FileSystemFileHandle;\n    new(): FileSystemFileHandle;\n};\n\n/**\n * The **`FileSystemHandle`** interface of the File System API is an object which represents a file or directory entry.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemHandle)\n */\ninterface FileSystemHandle {\n    /**\n     * The **`kind`** read-only property of the `'file'` if the associated entry is a file or `'directory'`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemHandle/kind)\n     */\n    readonly kind: FileSystemHandleKind;\n    /**\n     * The **`name`** read-only property of the handle.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemHandle/name)\n     */\n    readonly name: string;\n    /**\n     * The **`isSameEntry()`** method of the ```js-nolint isSameEntry(fileSystemHandle) ``` - FileSystemHandle - : The `FileSystemHandle` to match against the handle on which the method is invoked.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemHandle/isSameEntry)\n     */\n    isSameEntry(other: FileSystemHandle): Promise<boolean>;\n}\n\ndeclare var FileSystemHandle: {\n    prototype: FileSystemHandle;\n    new(): FileSystemHandle;\n};\n\n/**\n * The **`FileSystemWritableFileStream`** interface of the File System API is a WritableStream object with additional convenience methods, which operates on a single file on disk.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemWritableFileStream)\n */\ninterface FileSystemWritableFileStream extends WritableStream {\n    /**\n     * The **`seek()`** method of the FileSystemWritableFileStream interface updates the current file cursor offset to the position (in bytes) specified when calling the method.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemWritableFileStream/seek)\n     */\n    seek(position: number): Promise<void>;\n    /**\n     * The **`truncate()`** method of the FileSystemWritableFileStream interface resizes the file associated with the stream to the specified size in bytes.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemWritableFileStream/truncate)\n     */\n    truncate(size: number): Promise<void>;\n    /**\n     * The **`write()`** method of the FileSystemWritableFileStream interface writes content into the file the method is called on, at the current file cursor offset.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FileSystemWritableFileStream/write)\n     */\n    write(data: FileSystemWriteChunkType): Promise<void>;\n}\n\ndeclare var FileSystemWritableFileStream: {\n    prototype: FileSystemWritableFileStream;\n    new(): FileSystemWritableFileStream;\n};\n\n/**\n * The **`FocusEvent`** interface represents focus-related events, including Element/focus_event, Element/blur_event, Element/focusin_event, and Element/focusout_event.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FocusEvent)\n */\ninterface FocusEvent extends UIEvent {\n    /**\n     * The **`relatedTarget`** read-only property of the FocusEvent interface is the secondary target, depending on the type of event: <table class='no-markdown'> <thead> <tr> <th scope='col'>Event name</th> <th scope='col'><code>target</code></th> <th scope='col'><code>relatedTarget</code></th> </tr> </thead> <tbody> <tr> <td>Element/blur_event</td> <td>The EventTarget losing focus</td> <td>The EventTarget receiving focus (if any).</td> </tr> <tr> <td>Element/focus_event</td> <td>The EventTarget receiving focus</td> <td>The EventTarget losing focus (if any)</td> </tr> <tr> <td>Element/focusin_event</td> <td>The EventTarget receiving focus</td> <td>The EventTarget losing focus (if any)</td> </tr> <tr> <td>Element/focusout_event</td> <td>The EventTarget losing focus</td> <td>The EventTarget receiving focus (if any)</td> </tr> </tbody> </table> Note that many elements can't have focus, which is a common reason for `relatedTarget` to be `null`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FocusEvent/relatedTarget)\n     */\n    readonly relatedTarget: EventTarget | null;\n}\n\ndeclare var FocusEvent: {\n    prototype: FocusEvent;\n    new(type: string, eventInitDict?: FocusEventInit): FocusEvent;\n};\n\n/**\n * The **`FontFace`** interface of the CSS Font Loading API represents a single usable font face.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace)\n */\ninterface FontFace {\n    /**\n     * The **`ascentOverride`** property of the FontFace interface returns and sets the ascent metric for the font, the height above the baseline that CSS uses to lay out line boxes in an inline formatting context.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/ascentOverride)\n     */\n    ascentOverride: string;\n    /**\n     * The **`descentOverride`** property of the FontFace interface returns and sets the value of the @font-face/descent-override descriptor.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/descentOverride)\n     */\n    descentOverride: string;\n    /**\n     * The **`display`** property of the FontFace interface determines how a font face is displayed based on whether and when it is downloaded and ready to use.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/display)\n     */\n    display: FontDisplay;\n    /**\n     * The **`FontFace.family`** property allows the author to get or set the font family of a FontFace object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/family)\n     */\n    family: string;\n    /**\n     * The **`featureSettings`** property of the FontFace interface retrieves or sets infrequently used font features that are not available from a font's variant properties.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/featureSettings)\n     */\n    featureSettings: string;\n    /**\n     * The **`lineGapOverride`** property of the FontFace interface returns and sets the value of the @font-face/line-gap-override descriptor.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/lineGapOverride)\n     */\n    lineGapOverride: string;\n    /**\n     * The **`loaded`** read-only property of the FontFace interface returns a Promise that resolves with the current `FontFace` object when the font specified in the object's constructor is done loading or rejects with a `SyntaxError`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/loaded)\n     */\n    readonly loaded: Promise<FontFace>;\n    /**\n     * The **`status`** read-only property of the FontFace interface returns an enumerated value indicating the status of the font, one of `'unloaded'`, `'loading'`, `'loaded'`, or `'error'`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/status)\n     */\n    readonly status: FontFaceLoadStatus;\n    /**\n     * The **`stretch`** property of the FontFace interface retrieves or sets how the font stretches.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/stretch)\n     */\n    stretch: string;\n    /**\n     * The **`style`** property of the FontFace interface retrieves or sets the font's style.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/style)\n     */\n    style: string;\n    /**\n     * The **`unicodeRange`** property of the FontFace interface retrieves or sets the range of unicode code points encompassing the font.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/unicodeRange)\n     */\n    unicodeRange: string;\n    /**\n     * The **`weight`** property of the FontFace interface retrieves or sets the weight of the font.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/weight)\n     */\n    weight: string;\n    /**\n     * The **`load()`** method of the FontFace interface requests and loads a font whose `source` was specified as a URL.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFace/load)\n     */\n    load(): Promise<FontFace>;\n}\n\ndeclare var FontFace: {\n    prototype: FontFace;\n    new(family: string, source: string | BufferSource, descriptors?: FontFaceDescriptors): FontFace;\n};\n\ninterface FontFaceSetEventMap {\n    \"loading\": FontFaceSetLoadEvent;\n    \"loadingdone\": FontFaceSetLoadEvent;\n    \"loadingerror\": FontFaceSetLoadEvent;\n}\n\n/**\n * The **`FontFaceSet`** interface of the CSS Font Loading API manages the loading of font-faces and querying of their download status.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet)\n */\ninterface FontFaceSet extends EventTarget {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/loading_event) */\n    onloading: ((this: FontFaceSet, ev: FontFaceSetLoadEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/loadingdone_event) */\n    onloadingdone: ((this: FontFaceSet, ev: FontFaceSetLoadEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/loadingerror_event) */\n    onloadingerror: ((this: FontFaceSet, ev: FontFaceSetLoadEvent) => any) | null;\n    /**\n     * The `ready` read-only property of the FontFaceSet interface returns a Promise that resolves to the given FontFaceSet.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/ready)\n     */\n    readonly ready: Promise<FontFaceSet>;\n    /**\n     * The **`status`** read-only property of the FontFaceSet interface returns the loading state of the fonts in the set.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/status)\n     */\n    readonly status: FontFaceSetLoadStatus;\n    /**\n     * The `check()` method of the FontFaceSet returns `true` if you can render some text using the given font specification without attempting to use any fonts in this `FontFaceSet` that are not yet fully loaded.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/check)\n     */\n    check(font: string, text?: string): boolean;\n    /**\n     * The `load()` method of the FontFaceSet forces all the fonts given in parameters to be loaded.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSet/load)\n     */\n    load(font: string, text?: string): Promise<FontFace[]>;\n    forEach(callbackfn: (value: FontFace, key: FontFace, parent: FontFaceSet) => void, thisArg?: any): void;\n    addEventListener<K extends keyof FontFaceSetEventMap>(type: K, listener: (this: FontFaceSet, ev: FontFaceSetEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof FontFaceSetEventMap>(type: K, listener: (this: FontFaceSet, ev: FontFaceSetEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var FontFaceSet: {\n    prototype: FontFaceSet;\n    new(): FontFaceSet;\n};\n\n/**\n * The **`FontFaceSetLoadEvent`** interface of the CSS Font Loading API represents events fired at a FontFaceSet after it starts loading font faces.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSetLoadEvent)\n */\ninterface FontFaceSetLoadEvent extends Event {\n    /**\n     * The **`fontfaces`** read-only property of the An array of FontFace instance.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FontFaceSetLoadEvent/fontfaces)\n     */\n    readonly fontfaces: ReadonlyArray<FontFace>;\n}\n\ndeclare var FontFaceSetLoadEvent: {\n    prototype: FontFaceSetLoadEvent;\n    new(type: string, eventInitDict?: FontFaceSetLoadEventInit): FontFaceSetLoadEvent;\n};\n\ninterface FontFaceSource {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/fonts) */\n    readonly fonts: FontFaceSet;\n}\n\n/**\n * The **`FormData`** interface provides a way to construct a set of key/value pairs representing form fields and their values, which can be sent using the Window/fetch, XMLHttpRequest.send() or navigator.sendBeacon() methods.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormData)\n */\ninterface FormData {\n    /**\n     * The **`append()`** method of the FormData interface appends a new value onto an existing key inside a `FormData` object, or adds the key if it does not already exist.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormData/append)\n     */\n    append(name: string, value: string | Blob): void;\n    append(name: string, value: string): void;\n    append(name: string, blobValue: Blob, filename?: string): void;\n    /**\n     * The **`delete()`** method of the FormData interface deletes a key and its value(s) from a `FormData` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormData/delete)\n     */\n    delete(name: string): void;\n    /**\n     * The **`get()`** method of the FormData interface returns the first value associated with a given key from within a `FormData` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormData/get)\n     */\n    get(name: string): FormDataEntryValue | null;\n    /**\n     * The **`getAll()`** method of the FormData interface returns all the values associated with a given key from within a `FormData` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormData/getAll)\n     */\n    getAll(name: string): FormDataEntryValue[];\n    /**\n     * The **`has()`** method of the FormData interface returns whether a `FormData` object contains a certain key.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormData/has)\n     */\n    has(name: string): boolean;\n    /**\n     * The **`set()`** method of the FormData interface sets a new value for an existing key inside a `FormData` object, or adds the key/value if it does not already exist.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormData/set)\n     */\n    set(name: string, value: string | Blob): void;\n    set(name: string, value: string): void;\n    set(name: string, blobValue: Blob, filename?: string): void;\n    forEach(callbackfn: (value: FormDataEntryValue, key: string, parent: FormData) => void, thisArg?: any): void;\n}\n\ndeclare var FormData: {\n    prototype: FormData;\n    new(form?: HTMLFormElement, submitter?: HTMLElement | null): FormData;\n};\n\n/**\n * The **`FormDataEvent`** interface represents a `formdata` event — such an event is fired on an HTMLFormElement object after the entry list representing the form's data is constructed.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormDataEvent)\n */\ninterface FormDataEvent extends Event {\n    /**\n     * The `formData` read-only property of the FormDataEvent interface contains the FormData object representing the data contained in the form when the event was fired.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FormDataEvent/formData)\n     */\n    readonly formData: FormData;\n}\n\ndeclare var FormDataEvent: {\n    prototype: FormDataEvent;\n    new(type: string, eventInitDict: FormDataEventInit): FormDataEvent;\n};\n\n/**\n * The **`FragmentDirective`** interface is an object exposed to allow code to check whether or not a browser supports text fragments.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/FragmentDirective)\n */\ninterface FragmentDirective {\n}\n\ndeclare var FragmentDirective: {\n    prototype: FragmentDirective;\n    new(): FragmentDirective;\n};\n\n/**\n * The **`GPUError`** interface of the WebGPU API is the base interface for errors surfaced by GPUDevice.popErrorScope and the GPUDevice.uncapturederror_event event.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUError)\n */\ninterface GPUError {\n    /**\n     * The **`message`** read-only property of the A string.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GPUError/message)\n     */\n    readonly message: string;\n}\n\n/**\n * The `GainNode` interface represents a change in volume.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GainNode)\n */\ninterface GainNode extends AudioNode {\n    /**\n     * The `gain` property of the GainNode interface is an a-rate AudioParam representing the amount of gain to apply.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GainNode/gain)\n     */\n    readonly gain: AudioParam;\n}\n\ndeclare var GainNode: {\n    prototype: GainNode;\n    new(context: BaseAudioContext, options?: GainOptions): GainNode;\n};\n\n/**\n * The **`Gamepad`** interface of the Gamepad API defines an individual gamepad or other controller, allowing access to information such as button presses, axis positions, and id.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad)\n */\ninterface Gamepad {\n    /**\n     * The **`Gamepad.axes`** property of the Gamepad interface returns an array representing the controls with axes present on the device (e.g., analog thumb sticks).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/axes)\n     */\n    readonly axes: ReadonlyArray<number>;\n    /**\n     * The **`buttons`** property of the Gamepad interface returns an array of GamepadButton objects representing the buttons present on the device.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/buttons)\n     */\n    readonly buttons: ReadonlyArray<GamepadButton>;\n    /**\n     * The **`Gamepad.connected`** property of the still connected to the system.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/connected)\n     */\n    readonly connected: boolean;\n    /**\n     * The **`Gamepad.id`** property of the Gamepad interface returns a string containing some information about the controller.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/id)\n     */\n    readonly id: string;\n    /**\n     * The **`Gamepad.index`** property of the Gamepad interface returns an integer that is auto-incremented to be unique for each device currently connected to the system.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/index)\n     */\n    readonly index: number;\n    /**\n     * The **`Gamepad.mapping`** property of the remapped the controls on the device to a known layout.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/mapping)\n     */\n    readonly mapping: GamepadMappingType;\n    /**\n     * The **`Gamepad.timestamp`** property of the representing the last time the data for this gamepad was updated.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/timestamp)\n     */\n    readonly timestamp: DOMHighResTimeStamp;\n    /**\n     * The **`vibrationActuator`** read-only property of the Gamepad interface returns a GamepadHapticActuator object, which represents haptic feedback hardware available on the controller.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Gamepad/vibrationActuator)\n     */\n    readonly vibrationActuator: GamepadHapticActuator;\n}\n\ndeclare var Gamepad: {\n    prototype: Gamepad;\n    new(): Gamepad;\n};\n\n/**\n * The **`GamepadButton`** interface defines an individual button of a gamepad or other controller, allowing access to the current state of different types of buttons available on the control device.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadButton)\n */\ninterface GamepadButton {\n    /**\n     * The **`GamepadButton.pressed`** property of the the button is currently pressed (`true`) or unpressed (`false`).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadButton/pressed)\n     */\n    readonly pressed: boolean;\n    /**\n     * The **`touched`** property of the a button capable of detecting touch is currently touched (`true`) or not touched (`false`).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadButton/touched)\n     */\n    readonly touched: boolean;\n    /**\n     * The **`GamepadButton.value`** property of the current state of analog buttons on many modern gamepads, such as the triggers.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadButton/value)\n     */\n    readonly value: number;\n}\n\ndeclare var GamepadButton: {\n    prototype: GamepadButton;\n    new(): GamepadButton;\n};\n\n/**\n * The GamepadEvent interface of the Gamepad API contains references to gamepads connected to the system, which is what the gamepad events Window.gamepadconnected_event and Window.gamepaddisconnected_event are fired in response to.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadEvent)\n */\ninterface GamepadEvent extends Event {\n    /**\n     * The **`GamepadEvent.gamepad`** property of the **GamepadEvent interface** returns a Gamepad object, providing access to the associated gamepad data for fired A Gamepad object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadEvent/gamepad)\n     */\n    readonly gamepad: Gamepad;\n}\n\ndeclare var GamepadEvent: {\n    prototype: GamepadEvent;\n    new(type: string, eventInitDict: GamepadEventInit): GamepadEvent;\n};\n\n/**\n * The **`GamepadHapticActuator`** interface of the Gamepad API represents hardware in the controller designed to provide haptic feedback to the user (if available), most commonly vibration hardware.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadHapticActuator)\n */\ninterface GamepadHapticActuator {\n    /**\n     * The **`playEffect()`** method of the GamepadHapticActuator interface causes the hardware to play a specific vibration effect.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadHapticActuator/playEffect)\n     */\n    playEffect(type: GamepadHapticEffectType, params?: GamepadEffectParameters): Promise<GamepadHapticsResult>;\n    /**\n     * The **`reset()`** method of the GamepadHapticActuator interface stops the hardware from playing an active vibration effect.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GamepadHapticActuator/reset)\n     */\n    reset(): Promise<GamepadHapticsResult>;\n}\n\ndeclare var GamepadHapticActuator: {\n    prototype: GamepadHapticActuator;\n    new(): GamepadHapticActuator;\n};\n\ninterface GenericTransformStream {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CompressionStream/readable) */\n    readonly readable: ReadableStream;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/CompressionStream/writable) */\n    readonly writable: WritableStream;\n}\n\n/**\n * The **`Geolocation`** interface represents an object able to obtain the position of the device programmatically.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Geolocation)\n */\ninterface Geolocation {\n    /**\n     * The **`clearWatch()`** method of the Geolocation interface is used to unregister location/error monitoring handlers previously installed using Geolocation.watchPosition().\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Geolocation/clearWatch)\n     */\n    clearWatch(watchId: number): void;\n    /**\n     * The **`getCurrentPosition()`** method of the Geolocation interface is used to get the current position of the device.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Geolocation/getCurrentPosition)\n     */\n    getCurrentPosition(successCallback: PositionCallback, errorCallback?: PositionErrorCallback | null, options?: PositionOptions): void;\n    /**\n     * The **`watchPosition()`** method of the Geolocation interface is used to register a handler function that will be called automatically each time the position of the device changes.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Geolocation/watchPosition)\n     */\n    watchPosition(successCallback: PositionCallback, errorCallback?: PositionErrorCallback | null, options?: PositionOptions): number;\n}\n\ndeclare var Geolocation: {\n    prototype: Geolocation;\n    new(): Geolocation;\n};\n\n/**\n * The **`GeolocationCoordinates`** interface represents the position and altitude of the device on Earth, as well as the accuracy with which these properties are calculated.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates)\n */\ninterface GeolocationCoordinates {\n    /**\n     * The **`accuracy`** read-only property of the GeolocationCoordinates interface is a strictly positive `double` representing the accuracy, with a 95% confidence level, of the GeolocationCoordinates.latitude and GeolocationCoordinates.longitude properties expressed in meters.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates/accuracy)\n     */\n    readonly accuracy: number;\n    /**\n     * The **`altitude`** read-only property of the GeolocationCoordinates interface is a `double` representing the altitude of the position in meters above the WGS84 ellipsoid (which defines the nominal sea level surface).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates/altitude)\n     */\n    readonly altitude: number | null;\n    /**\n     * The **`altitudeAccuracy`** read-only property of the GeolocationCoordinates interface is a strictly positive `double` representing the accuracy, with a 95% confidence level, of the `altitude` expressed in meters.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates/altitudeAccuracy)\n     */\n    readonly altitudeAccuracy: number | null;\n    /**\n     * The **`heading`** read-only property of the GeolocationCoordinates interface is a `double` representing the direction in which the device is traveling.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates/heading)\n     */\n    readonly heading: number | null;\n    /**\n     * The **`latitude`** read-only property of the GeolocationCoordinates interface is a `double` representing the latitude of the position in decimal degrees.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates/latitude)\n     */\n    readonly latitude: number;\n    /**\n     * The **`longitude`** read-only property of the GeolocationCoordinates interface is a number which represents the longitude of a geographical position, specified in decimal degrees.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates/longitude)\n     */\n    readonly longitude: number;\n    /**\n     * The **`speed`** read-only property of the GeolocationCoordinates interface is a `double` representing the velocity of the device in meters per second.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates/speed)\n     */\n    readonly speed: number | null;\n    /**\n     * The **`toJSON()`** method of the GeolocationCoordinates interface is a Serialization; it returns a JSON representation of the GeolocationCoordinates object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationCoordinates/toJSON)\n     */\n    toJSON(): any;\n}\n\ndeclare var GeolocationCoordinates: {\n    prototype: GeolocationCoordinates;\n    new(): GeolocationCoordinates;\n};\n\n/**\n * The **`GeolocationPosition`** interface represents the position of the concerned device at a given time.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationPosition)\n */\ninterface GeolocationPosition {\n    /**\n     * The **`coords`** read-only property of the GeolocationPosition interface returns a GeolocationCoordinates object representing a geographic position.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationPosition/coords)\n     */\n    readonly coords: GeolocationCoordinates;\n    /**\n     * The **`timestamp`** read-only property of the GeolocationPosition interface represents the date and time that the position was acquired by the device.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationPosition/timestamp)\n     */\n    readonly timestamp: EpochTimeStamp;\n    /**\n     * The **`toJSON()`** method of the GeolocationPosition interface is a Serialization; it returns a JSON representation of the GeolocationPosition object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationPosition/toJSON)\n     */\n    toJSON(): any;\n}\n\ndeclare var GeolocationPosition: {\n    prototype: GeolocationPosition;\n    new(): GeolocationPosition;\n};\n\n/**\n * The **`GeolocationPositionError`** interface represents the reason of an error occurring when using the geolocating device.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationPositionError)\n */\ninterface GeolocationPositionError {\n    /**\n     * The **`code`** read-only property of the GeolocationPositionError interface is an `unsigned short` representing the error code.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationPositionError/code)\n     */\n    readonly code: number;\n    /**\n     * The **`message`** read-only property of the GeolocationPositionError interface returns a human-readable string describing the details of the error.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/GeolocationPositionError/message)\n     */\n    readonly message: string;\n    readonly PERMISSION_DENIED: 1;\n    readonly POSITION_UNAVAILABLE: 2;\n    readonly TIMEOUT: 3;\n}\n\ndeclare var GeolocationPositionError: {\n    prototype: GeolocationPositionError;\n    new(): GeolocationPositionError;\n    readonly PERMISSION_DENIED: 1;\n    readonly POSITION_UNAVAILABLE: 2;\n    readonly TIMEOUT: 3;\n};\n\ninterface GlobalEventHandlersEventMap {\n    \"abort\": UIEvent;\n    \"animationcancel\": AnimationEvent;\n    \"animationend\": AnimationEvent;\n    \"animationiteration\": AnimationEvent;\n    \"animationstart\": AnimationEvent;\n    \"auxclick\": PointerEvent;\n    \"beforeinput\": InputEvent;\n    \"beforematch\": Event;\n    \"beforetoggle\": ToggleEvent;\n    \"blur\": FocusEvent;\n    \"cancel\": Event;\n    \"canplay\": Event;\n    \"canplaythrough\": Event;\n    \"change\": Event;\n    \"click\": PointerEvent;\n    \"close\": Event;\n    \"compositionend\": CompositionEvent;\n    \"compositionstart\": CompositionEvent;\n    \"compositionupdate\": CompositionEvent;\n    \"contextlost\": Event;\n    \"contextmenu\": PointerEvent;\n    \"contextrestored\": Event;\n    \"copy\": ClipboardEvent;\n    \"cuechange\": Event;\n    \"cut\": ClipboardEvent;\n    \"dblclick\": MouseEvent;\n    \"drag\": DragEvent;\n    \"dragend\": DragEvent;\n    \"dragenter\": DragEvent;\n    \"dragleave\": DragEvent;\n    \"dragover\": DragEvent;\n    \"dragstart\": DragEvent;\n    \"drop\": DragEvent;\n    \"durationchange\": Event;\n    \"emptied\": Event;\n    \"ended\": Event;\n    \"error\": ErrorEvent;\n    \"focus\": FocusEvent;\n    \"focusin\": FocusEvent;\n    \"focusout\": FocusEvent;\n    \"formdata\": FormDataEvent;\n    \"gotpointercapture\": PointerEvent;\n    \"input\": Event;\n    \"invalid\": Event;\n    \"keydown\": KeyboardEvent;\n    \"keypress\": KeyboardEvent;\n    \"keyup\": KeyboardEvent;\n    \"load\": Event;\n    \"loadeddata\": Event;\n    \"loadedmetadata\": Event;\n    \"loadstart\": Event;\n    \"lostpointercapture\": PointerEvent;\n    \"mousedown\": MouseEvent;\n    \"mouseenter\": MouseEvent;\n    \"mouseleave\": MouseEvent;\n    \"mousemove\": MouseEvent;\n    \"mouseout\": MouseEvent;\n    \"mouseover\": MouseEvent;\n    \"mouseup\": MouseEvent;\n    \"paste\": ClipboardEvent;\n    \"pause\": Event;\n    \"play\": Event;\n    \"playing\": Event;\n    \"pointercancel\": PointerEvent;\n    \"pointerdown\": PointerEvent;\n    \"pointerenter\": PointerEvent;\n    \"pointerleave\": PointerEvent;\n    \"pointermove\": PointerEvent;\n    \"pointerout\": PointerEvent;\n    \"pointerover\": PointerEvent;\n    \"pointerrawupdate\": Event;\n    \"pointerup\": PointerEvent;\n    \"progress\": ProgressEvent;\n    \"ratechange\": Event;\n    \"reset\": Event;\n    \"resize\": UIEvent;\n    \"scroll\": Event;\n    \"scrollend\": Event;\n    \"securitypolicyviolation\": SecurityPolicyViolationEvent;\n    \"seeked\": Event;\n    \"seeking\": Event;\n    \"select\": Event;\n    \"selectionchange\": Event;\n    \"selectstart\": Event;\n    \"slotchange\": Event;\n    \"stalled\": Event;\n    \"submit\": SubmitEvent;\n    \"suspend\": Event;\n    \"timeupdate\": Event;\n    \"toggle\": ToggleEvent;\n    \"touchcancel\": TouchEvent;\n    \"touchend\": TouchEvent;\n    \"touchmove\": TouchEvent;\n    \"touchstart\": TouchEvent;\n    \"transitioncancel\": TransitionEvent;\n    \"transitionend\": TransitionEvent;\n    \"transitionrun\": TransitionEvent;\n    \"transitionstart\": TransitionEvent;\n    \"volumechange\": Event;\n    \"waiting\": Event;\n    \"webkitanimationend\": Event;\n    \"webkitanimationiteration\": Event;\n    \"webkitanimationstart\": Event;\n    \"webkittransitionend\": Event;\n    \"wheel\": WheelEvent;\n}\n\ninterface GlobalEventHandlers {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/abort_event) */\n    onabort: ((this: GlobalEventHandlers, ev: UIEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/animationcancel_event) */\n    onanimationcancel: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/animationend_event) */\n    onanimationend: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/animationiteration_event) */\n    onanimationiteration: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/animationstart_event) */\n    onanimationstart: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/auxclick_event) */\n    onauxclick: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/beforeinput_event) */\n    onbeforeinput: ((this: GlobalEventHandlers, ev: InputEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/beforematch_event) */\n    onbeforematch: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/beforetoggle_event) */\n    onbeforetoggle: ((this: GlobalEventHandlers, ev: ToggleEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/blur_event) */\n    onblur: ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement/cancel_event) */\n    oncancel: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/canplay_event) */\n    oncanplay: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/canplaythrough_event) */\n    oncanplaythrough: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/change_event) */\n    onchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/click_event) */\n    onclick: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement/close_event) */\n    onclose: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/contextlost_event) */\n    oncontextlost: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/contextmenu_event) */\n    oncontextmenu: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/contextrestored_event) */\n    oncontextrestored: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/copy_event) */\n    oncopy: ((this: GlobalEventHandlers, ev: ClipboardEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement/cuechange_event) */\n    oncuechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/cut_event) */\n    oncut: ((this: GlobalEventHandlers, ev: ClipboardEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/dblclick_event) */\n    ondblclick: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/drag_event) */\n    ondrag: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/dragend_event) */\n    ondragend: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/dragenter_event) */\n    ondragenter: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/dragleave_event) */\n    ondragleave: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/dragover_event) */\n    ondragover: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/dragstart_event) */\n    ondragstart: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/drop_event) */\n    ondrop: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/durationchange_event) */\n    ondurationchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/emptied_event) */\n    onemptied: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/ended_event) */\n    onended: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/error_event) */\n    onerror: OnErrorEventHandler;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/focus_event) */\n    onfocus: ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/formdata_event) */\n    onformdata: ((this: GlobalEventHandlers, ev: FormDataEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/gotpointercapture_event) */\n    ongotpointercapture: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/input_event) */\n    oninput: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/invalid_event) */\n    oninvalid: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/keydown_event) */\n    onkeydown: ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null;\n    /**\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/keypress_event)\n     */\n    onkeypress: ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/keyup_event) */\n    onkeyup: ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/load_event) */\n    onload: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/loadeddata_event) */\n    onloadeddata: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/loadedmetadata_event) */\n    onloadedmetadata: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/loadstart_event) */\n    onloadstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/lostpointercapture_event) */\n    onlostpointercapture: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/mousedown_event) */\n    onmousedown: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/mouseenter_event) */\n    onmouseenter: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/mouseleave_event) */\n    onmouseleave: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/mousemove_event) */\n    onmousemove: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/mouseout_event) */\n    onmouseout: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/mouseover_event) */\n    onmouseover: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/mouseup_event) */\n    onmouseup: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/paste_event) */\n    onpaste: ((this: GlobalEventHandlers, ev: ClipboardEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/pause_event) */\n    onpause: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/play_event) */\n    onplay: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/playing_event) */\n    onplaying: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointercancel_event) */\n    onpointercancel: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointerdown_event) */\n    onpointerdown: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointerenter_event) */\n    onpointerenter: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointerleave_event) */\n    onpointerleave: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointermove_event) */\n    onpointermove: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointerout_event) */\n    onpointerout: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointerover_event) */\n    onpointerover: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /**\n     * Available only in secure contexts.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointerrawupdate_event)\n     */\n    onpointerrawupdate: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/pointerup_event) */\n    onpointerup: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/progress_event) */\n    onprogress: ((this: GlobalEventHandlers, ev: ProgressEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/ratechange_event) */\n    onratechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/reset_event) */\n    onreset: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/resize_event) */\n    onresize: ((this: GlobalEventHandlers, ev: UIEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/scroll_event) */\n    onscroll: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/scrollend_event) */\n    onscrollend: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/securitypolicyviolation_event) */\n    onsecuritypolicyviolation: ((this: GlobalEventHandlers, ev: SecurityPolicyViolationEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/seeked_event) */\n    onseeked: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/seeking_event) */\n    onseeking: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/select_event) */\n    onselect: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Document/selectionchange_event) */\n    onselectionchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Node/selectstart_event) */\n    onselectstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSlotElement/slotchange_event) */\n    onslotchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/stalled_event) */\n    onstalled: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/submit_event) */\n    onsubmit: ((this: GlobalEventHandlers, ev: SubmitEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/suspend_event) */\n    onsuspend: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/timeupdate_event) */\n    ontimeupdate: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/toggle_event) */\n    ontoggle: ((this: GlobalEventHandlers, ev: ToggleEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/touchcancel_event) */\n    ontouchcancel?: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/touchend_event) */\n    ontouchend?: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/touchmove_event) */\n    ontouchmove?: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/touchstart_event) */\n    ontouchstart?: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/transitioncancel_event) */\n    ontransitioncancel: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/transitionend_event) */\n    ontransitionend: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/transitionrun_event) */\n    ontransitionrun: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/transitionstart_event) */\n    ontransitionstart: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/volumechange_event) */\n    onvolumechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/waiting_event) */\n    onwaiting: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * @deprecated This is a legacy alias of `onanimationend`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/animationend_event)\n     */\n    onwebkitanimationend: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * @deprecated This is a legacy alias of `onanimationiteration`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/animationiteration_event)\n     */\n    onwebkitanimationiteration: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * @deprecated This is a legacy alias of `onanimationstart`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/animationstart_event)\n     */\n    onwebkitanimationstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * @deprecated This is a legacy alias of `ontransitionend`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/transitionend_event)\n     */\n    onwebkittransitionend: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/Element/wheel_event) */\n    onwheel: ((this: GlobalEventHandlers, ev: WheelEvent) => any) | null;\n    addEventListener<K extends keyof GlobalEventHandlersEventMap>(type: K, listener: (this: GlobalEventHandlers, ev: GlobalEventHandlersEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof GlobalEventHandlersEventMap>(type: K, listener: (this: GlobalEventHandlers, ev: GlobalEventHandlersEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/**\n * The **`HTMLAllCollection`** interface represents a collection of _all_ of the document's elements, accessible by index (like an array) and by the element's `id`.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAllCollection)\n */\ninterface HTMLAllCollection {\n    /**\n     * The **`HTMLAllCollection.length`** property returns the number of items in this HTMLAllCollection.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAllCollection/length)\n     */\n    readonly length: number;\n    /**\n     * The **`item()`** method of the HTMLAllCollection interface returns the element located at the specified offset into the collection, or the element with the specified value for its `id` or `name` attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAllCollection/item)\n     */\n    item(nameOrIndex?: string): HTMLCollection | Element | null;\n    /**\n     * The **`namedItem()`** method of the HTMLAllCollection interface returns the first Element in the collection whose `id` or `name` attribute matches the specified name, or `null` if no element matches.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAllCollection/namedItem)\n     */\n    namedItem(name: string): HTMLCollection | Element | null;\n    [index: number]: Element;\n}\n\ndeclare var HTMLAllCollection: {\n    prototype: HTMLAllCollection;\n    new(): HTMLAllCollection;\n};\n\n/**\n * The **`HTMLAnchorElement`** interface represents hyperlink elements and provides special properties and methods (beyond those of the regular HTMLElement object interface that they inherit from) for manipulating the layout and presentation of such elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement)\n */\ninterface HTMLAnchorElement extends HTMLElement, HTMLHyperlinkElementUtils {\n    /** @deprecated */\n    charset: string;\n    /** @deprecated */\n    coords: string;\n    /**\n     * The **`HTMLAnchorElement.download`** property is a string indicating that the linked resource is intended to be downloaded rather than displayed in the browser.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/download)\n     */\n    download: string;\n    /**\n     * The **`hreflang`** property of the HTMLAnchorElement interface is a string that is the language of the linked resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/hreflang)\n     */\n    hreflang: string;\n    /** @deprecated */\n    name: string;\n    /**\n     * The **`ping`** property of the HTMLAnchorElement interface is a space-separated list of URLs.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/ping)\n     */\n    ping: string;\n    /**\n     * The **`HTMLAnchorElement.referrerPolicy`** property reflect the HTML `referrerpolicy` attribute of the A string; one of the following: - `no-referrer` - : The Referer header will be omitted entirely.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/referrerPolicy)\n     */\n    referrerPolicy: string;\n    /**\n     * The **`HTMLAnchorElement.rel`** property reflects the `rel` attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/rel)\n     */\n    rel: string;\n    /**\n     * The **`HTMLAnchorElement.relList`** read-only property reflects the `rel` attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/relList)\n     */\n    get relList(): DOMTokenList;\n    set relList(value: string);\n    /** @deprecated */\n    rev: string;\n    /** @deprecated */\n    shape: string;\n    /**\n     * The **`target`** property of the HTMLAnchorElement interface is a string that indicates where to display the linked resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/target)\n     */\n    target: string;\n    /**\n     * The **`text`** property of the HTMLAnchorElement represents the text inside the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/text)\n     */\n    text: string;\n    /**\n     * The **`type`** property of the HTMLAnchorElement interface is a string that indicates the MIME type of the linked resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/type)\n     */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAnchorElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAnchorElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLAnchorElement: {\n    prototype: HTMLAnchorElement;\n    new(): HTMLAnchorElement;\n};\n\n/**\n * The **`HTMLAreaElement`** interface provides special properties and methods (beyond those of the regular object HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of area elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement)\n */\ninterface HTMLAreaElement extends HTMLElement, HTMLHyperlinkElementUtils {\n    /**\n     * The **`alt`** property of the HTMLAreaElement interface specifies the text of the hyperlink, defining the textual label for an image map's link.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/alt)\n     */\n    alt: string;\n    /**\n     * The **`coords`** property of the HTMLAreaElement interface specifies the coordinates of the element's shape as a list of floating-point numbers.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/coords)\n     */\n    coords: string;\n    /**\n     * The **`download`** property of the HTMLAreaElement interface is a string indicating that the linked resource is intended to be downloaded rather than displayed in the browser.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/download)\n     */\n    download: string;\n    /** @deprecated */\n    noHref: boolean;\n    /**\n     * The **`ping`** property of the HTMLAreaElement interface is a space-separated list of URLs.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/ping)\n     */\n    ping: string;\n    /**\n     * The **`HTMLAreaElement.referrerPolicy`** property reflect the HTML `referrerpolicy` attribute of the resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/referrerPolicy)\n     */\n    referrerPolicy: string;\n    /**\n     * The **`HTMLAreaElement.rel`** property reflects the `rel` attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/rel)\n     */\n    rel: string;\n    /**\n     * The **`HTMLAreaElement.relList`** read-only property reflects the `rel` attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/relList)\n     */\n    get relList(): DOMTokenList;\n    set relList(value: string);\n    /**\n     * The **`shape`** property of the HTMLAreaElement interface specifies the shape of an image map area.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/shape)\n     */\n    shape: string;\n    /**\n     * The **`target`** property of the HTMLAreaElement interface is a string that indicates where to display the linked resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAreaElement/target)\n     */\n    target: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAreaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAreaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLAreaElement: {\n    prototype: HTMLAreaElement;\n    new(): HTMLAreaElement;\n};\n\n/**\n * The **`HTMLAudioElement`** interface provides access to the properties of audio elements, as well as methods to manipulate them.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAudioElement)\n */\ninterface HTMLAudioElement extends HTMLMediaElement {\n    addEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLAudioElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLAudioElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLAudioElement: {\n    prototype: HTMLAudioElement;\n    new(): HTMLAudioElement;\n};\n\n/**\n * The **`HTMLBRElement`** interface represents an HTML line break element (br).\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBRElement)\n */\ninterface HTMLBRElement extends HTMLElement {\n    /** @deprecated */\n    clear: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBRElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBRElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLBRElement: {\n    prototype: HTMLBRElement;\n    new(): HTMLBRElement;\n};\n\n/**\n * The **`HTMLBaseElement`** interface contains the base URI for a document.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBaseElement)\n */\ninterface HTMLBaseElement extends HTMLElement {\n    /**\n     * The **`href`** property of the HTMLBaseElement interface contains a string that is the URL to use as the base for relative URLs.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBaseElement/href)\n     */\n    href: string;\n    /**\n     * The `target` property of the HTMLBaseElement interface is a string that represents the default target tab to show the resulting output for hyperlinks and form elements.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBaseElement/target)\n     */\n    target: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBaseElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBaseElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLBaseElement: {\n    prototype: HTMLBaseElement;\n    new(): HTMLBaseElement;\n};\n\ninterface HTMLBodyElementEventMap extends HTMLElementEventMap, WindowEventHandlersEventMap {\n}\n\n/**\n * The **`HTMLBodyElement`** interface provides special properties (beyond those inherited from the regular HTMLElement interface) for manipulating body elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLBodyElement)\n */\ninterface HTMLBodyElement extends HTMLElement, WindowEventHandlers {\n    /** @deprecated */\n    aLink: string;\n    /** @deprecated */\n    background: string;\n    /** @deprecated */\n    bgColor: string;\n    /** @deprecated */\n    link: string;\n    /** @deprecated */\n    text: string;\n    /** @deprecated */\n    vLink: string;\n    addEventListener<K extends keyof HTMLBodyElementEventMap>(type: K, listener: (this: HTMLBodyElement, ev: HTMLBodyElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLBodyElementEventMap>(type: K, listener: (this: HTMLBodyElement, ev: HTMLBodyElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLBodyElement: {\n    prototype: HTMLBodyElement;\n    new(): HTMLBodyElement;\n};\n\n/**\n * The **`HTMLButtonElement`** interface provides properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating button elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement)\n */\ninterface HTMLButtonElement extends HTMLElement, PopoverInvokerElement {\n    /**\n     * The **`HTMLButtonElement.disabled`** property indicates whether the control is disabled, meaning that it does not accept any clicks.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/disabled)\n     */\n    disabled: boolean;\n    /**\n     * The **`form`** read-only property of the HTMLButtonElement interface returns an HTMLFormElement object that owns this button, or `null` if this button is not owned by any form.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/form)\n     */\n    readonly form: HTMLFormElement | null;\n    /**\n     * The **`formAction`** property of the HTMLButtonElement interface is the URL of the program that is executed on the server when the form that owns this control is submitted.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/formAction)\n     */\n    formAction: string;\n    /**\n     * The **`formEnctype`** property of the HTMLButtonElement interface is the MIME_type of the content sent to the server when the form is submitted.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/formEnctype)\n     */\n    formEnctype: string;\n    /**\n     * The **`formMethod`** property of the HTMLButtonElement interface is the HTTP method used to submit the form if the button element is the control that submits the form.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/formMethod)\n     */\n    formMethod: string;\n    /**\n     * The **`formNoValidate`** property of the HTMLButtonElement interface is a boolean value indicating if the form will bypass constraint validation when submitted via the button.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/formNoValidate)\n     */\n    formNoValidate: boolean;\n    /**\n     * The **`formTarget`** property of the HTMLButtonElement interface is the tab, window, or iframe where the response of the submitted form is to be displayed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/formTarget)\n     */\n    formTarget: string;\n    /**\n     * The **`HTMLButtonElement.labels`** read-only property returns a A NodeList containing the `<label>` elements associated with the `<button>` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/labels)\n     */\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    /**\n     * The **`name`** property of the HTMLButtonElement interface indicates the name of the button element or the empty string if the element has no name.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/name)\n     */\n    name: string;\n    /**\n     * The **`type`** property of the HTMLButtonElement interface is a string that indicates the behavior type of the button element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/type)\n     */\n    type: \"submit\" | \"reset\" | \"button\";\n    /**\n     * The **`validationMessage`** read-only property of the HTMLButtonElement interface returns a string representing a localized message that describes the validation constraints that the button control does not satisfy (if any).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/validationMessage)\n     */\n    readonly validationMessage: string;\n    /**\n     * The **`validity`** read-only property of the HTMLButtonElement interface returns a ValidityState object that represents the validity states this element is in.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/validity)\n     */\n    readonly validity: ValidityState;\n    /**\n     * The **`value`** property of the HTMLButtonElement interface represents the value of the button element as a string, or the empty string if no value is set.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/value)\n     */\n    value: string;\n    /**\n     * The **`willValidate`** read-only property of the HTMLButtonElement interface indicates whether the button element is a candidate for constraint validation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/willValidate)\n     */\n    readonly willValidate: boolean;\n    /**\n     * The **`checkValidity()`** method of the HTMLButtonElement interface returns a boolean value which indicates if the element meets any constraint validation rules applied to it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/checkValidity)\n     */\n    checkValidity(): boolean;\n    /**\n     * The **`reportValidity()`** method of the HTMLButtonElement interface performs the same validity checking steps as the HTMLButtonElement.checkValidity method.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/reportValidity)\n     */\n    reportValidity(): boolean;\n    /**\n     * The **`setCustomValidity()`** method of the HTMLButtonElement interface sets the custom validity message for the button element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLButtonElement/setCustomValidity)\n     */\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLButtonElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLButtonElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLButtonElement: {\n    prototype: HTMLButtonElement;\n    new(): HTMLButtonElement;\n};\n\n/**\n * The **`HTMLCanvasElement`** interface provides properties and methods for manipulating the layout and presentation of canvas elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement)\n */\ninterface HTMLCanvasElement extends HTMLElement {\n    /**\n     * The **`HTMLCanvasElement.height`** property is a positive `integer` reflecting the `height` HTML attribute of the canvas element interpreted in CSS pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/height)\n     */\n    height: number;\n    /**\n     * The **`HTMLCanvasElement.width`** property is a positive `integer` reflecting the `width` HTML attribute of the canvas element interpreted in CSS pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/width)\n     */\n    width: number;\n    /**\n     * The **`captureStream()`** method of the HTMLCanvasElement interface returns a MediaStream which includes a CanvasCaptureMediaStreamTrack containing a real-time video capture of the canvas's contents.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/captureStream)\n     */\n    captureStream(frameRequestRate?: number): MediaStream;\n    /**\n     * The **`HTMLCanvasElement.getContext()`** method returns a drawing context on the canvas, or `null` if the context identifier is not supported, or the canvas has already been set to a different context mode.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/getContext)\n     */\n    getContext(contextId: \"2d\", options?: CanvasRenderingContext2DSettings): CanvasRenderingContext2D | null;\n    getContext(contextId: \"bitmaprenderer\", options?: ImageBitmapRenderingContextSettings): ImageBitmapRenderingContext | null;\n    getContext(contextId: \"webgl\", options?: WebGLContextAttributes): WebGLRenderingContext | null;\n    getContext(contextId: \"webgl2\", options?: WebGLContextAttributes): WebGL2RenderingContext | null;\n    getContext(contextId: string, options?: any): RenderingContext | null;\n    /**\n     * The **`HTMLCanvasElement.toBlob()`** method creates a Blob object representing the image contained in the canvas.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/toBlob)\n     */\n    toBlob(callback: BlobCallback, type?: string, quality?: number): void;\n    /**\n     * The **`HTMLCanvasElement.toDataURL()`** method returns a data URL containing a representation of the image in the format specified by the `type` parameter.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/toDataURL)\n     */\n    toDataURL(type?: string, quality?: number): string;\n    /**\n     * The **`HTMLCanvasElement.transferControlToOffscreen()`** method transfers control to an OffscreenCanvas object, either on the main thread or on a worker.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCanvasElement/transferControlToOffscreen)\n     */\n    transferControlToOffscreen(): OffscreenCanvas;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLCanvasElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLCanvasElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLCanvasElement: {\n    prototype: HTMLCanvasElement;\n    new(): HTMLCanvasElement;\n};\n\n/**\n * The **`HTMLCollection`** interface represents a generic collection (array-like object similar to Functions/arguments) of elements (in document order) and offers methods and properties for selecting from the list.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCollection)\n */\ninterface HTMLCollectionBase {\n    /**\n     * The **`HTMLCollection.length`** property returns the number of items in a HTMLCollection.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCollection/length)\n     */\n    readonly length: number;\n    /**\n     * The HTMLCollection method `item()` returns the element located at the specified offset into the collection.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCollection/item)\n     */\n    item(index: number): Element | null;\n    [index: number]: Element;\n}\n\ninterface HTMLCollection extends HTMLCollectionBase {\n    /**\n     * The **`namedItem()`** method of the HTMLCollection interface returns the first Element in the collection whose `id` or `name` attribute match the specified name, or `null` if no element matches.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLCollection/namedItem)\n     */\n    namedItem(name: string): Element | null;\n}\n\ndeclare var HTMLCollection: {\n    prototype: HTMLCollection;\n    new(): HTMLCollection;\n};\n\ninterface HTMLCollectionOf<T extends Element> extends HTMLCollectionBase {\n    item(index: number): T | null;\n    namedItem(name: string): T | null;\n    [index: number]: T;\n}\n\n/**\n * The **`HTMLDListElement`** interface provides special properties (beyond those of the regular HTMLElement interface it also has available to it by inheritance) for manipulating definition list (dl) elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDListElement)\n */\ninterface HTMLDListElement extends HTMLElement {\n    /** @deprecated */\n    compact: boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDListElement: {\n    prototype: HTMLDListElement;\n    new(): HTMLDListElement;\n};\n\n/**\n * The **`HTMLDataElement`** interface provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating data elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDataElement)\n */\ninterface HTMLDataElement extends HTMLElement {\n    /**\n     * The **`value`** property of the HTMLDataElement interface returns a string reflecting the `value` HTML attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDataElement/value)\n     */\n    value: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDataElement: {\n    prototype: HTMLDataElement;\n    new(): HTMLDataElement;\n};\n\n/**\n * The **`HTMLDataListElement`** interface provides special properties (beyond the HTMLElement object interface it also has available to it by inheritance) to manipulate datalist elements and their content.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDataListElement)\n */\ninterface HTMLDataListElement extends HTMLElement {\n    /**\n     * The **`options`** read-only property of the HTMLDataListElement interface returns an HTMLCollection of HTMLOptionElement elements contained in a datalist.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDataListElement/options)\n     */\n    readonly options: HTMLCollectionOf<HTMLOptionElement>;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDataListElement: {\n    prototype: HTMLDataListElement;\n    new(): HTMLDataListElement;\n};\n\n/**\n * The **`HTMLDetailsElement`** interface provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating details elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDetailsElement)\n */\ninterface HTMLDetailsElement extends HTMLElement {\n    /**\n     * The **`name`** property of the HTMLDetailsElement interface reflects the `name` attribute of details elements.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDetailsElement/name)\n     */\n    name: string;\n    /**\n     * The **`open`** property of the `open` HTML attribute, indicating whether the details's contents (not counting the summary) is to be shown to the user.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDetailsElement/open)\n     */\n    open: boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDetailsElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDetailsElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDetailsElement: {\n    prototype: HTMLDetailsElement;\n    new(): HTMLDetailsElement;\n};\n\n/**\n * The **`HTMLDialogElement`** interface provides methods to manipulate dialog elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement)\n */\ninterface HTMLDialogElement extends HTMLElement {\n    /**\n     * The **`open`** property of the `open` HTML attribute, indicating whether the dialog is available for interaction.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement/open)\n     */\n    open: boolean;\n    /**\n     * The **`returnValue`** property of the HTMLDialogElement interface is a string representing the return value for a dialog element when it's closed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement/returnValue)\n     */\n    returnValue: string;\n    /**\n     * The **`close()`** method of the HTMLDialogElement interface closes the dialog.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement/close)\n     */\n    close(returnValue?: string): void;\n    /**\n     * The **`requestClose()`** method of the HTMLDialogElement interface requests to close the dialog.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement/requestClose)\n     */\n    requestClose(returnValue?: string): void;\n    /**\n     * The **`show()`** method of the HTMLDialogElement interface displays the dialog modelessly, i.e., still allowing interaction with content outside of the dialog.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement/show)\n     */\n    show(): void;\n    /**\n     * The **`showModal()`** method of the of any other dialogs that might be present.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDialogElement/showModal)\n     */\n    showModal(): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDialogElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDialogElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDialogElement: {\n    prototype: HTMLDialogElement;\n    new(): HTMLDialogElement;\n};\n\n/** @deprecated */\ninterface HTMLDirectoryElement extends HTMLElement {\n    /** @deprecated */\n    compact: boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDirectoryElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDirectoryElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** @deprecated */\ndeclare var HTMLDirectoryElement: {\n    prototype: HTMLDirectoryElement;\n    new(): HTMLDirectoryElement;\n};\n\n/**\n * The **`HTMLDivElement`** interface provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating div elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLDivElement)\n */\ninterface HTMLDivElement extends HTMLElement {\n    /** @deprecated */\n    align: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDivElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDivElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDivElement: {\n    prototype: HTMLDivElement;\n    new(): HTMLDivElement;\n};\n\ninterface HTMLDocument extends Document {\n    addEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: HTMLDocument, ev: DocumentEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: HTMLDocument, ev: DocumentEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDocument: {\n    prototype: HTMLDocument;\n    new(): HTMLDocument;\n};\n\ninterface HTMLElementEventMap extends ElementEventMap, GlobalEventHandlersEventMap {\n}\n\n/**\n * The **`HTMLElement`** interface represents any HTML element.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement)\n */\ninterface HTMLElement extends Element, ElementCSSInlineStyle, ElementContentEditable, GlobalEventHandlers, HTMLOrSVGElement {\n    /**\n     * The **`HTMLElement.accessKey`** property sets the keystroke which a user can press to jump to a given element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/accessKey)\n     */\n    accessKey: string;\n    /**\n     * The **`HTMLElement.accessKeyLabel`** read-only property returns a string containing the element's browser-assigned access key (if any); otherwise it returns an empty string.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/accessKeyLabel)\n     */\n    readonly accessKeyLabel: string;\n    /**\n     * The **`autocapitalize`** property of the HTMLElement interface represents the element's capitalization behavior for user input.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/autocapitalize)\n     */\n    autocapitalize: string;\n    /**\n     * The **`autocorrect`** property of the HTMLElement interface controls whether or not autocorrection of editable text is enabled for spelling and/or punctuation errors.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/autocorrect)\n     */\n    autocorrect: boolean;\n    /**\n     * The **`HTMLElement.dir`** property indicates the text writing directionality of the content of the current element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/dir)\n     */\n    dir: string;\n    /**\n     * The **`draggable`** property of the HTMLElement interface gets and sets a Boolean primitive indicating if the element is draggable.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/draggable)\n     */\n    draggable: boolean;\n    /**\n     * The HTMLElement property **`hidden`** reflects the value of the element's `hidden` attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/hidden)\n     */\n    hidden: boolean;\n    /**\n     * The HTMLElement property **`inert`** reflects the value of the element's `inert` attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/inert)\n     */\n    inert: boolean;\n    /**\n     * The **`innerText`** property of the HTMLElement interface represents the rendered text content of a node and its descendants.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/innerText)\n     */\n    innerText: string;\n    /**\n     * The **`lang`** property of the HTMLElement interface indicates the base language of an element's attribute values and text content, in the form of a MISSING: RFC(5646, 'BCP 47 language identifier tag')].\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/lang)\n     */\n    lang: string;\n    /**\n     * The **`offsetHeight`** read-only property of the HTMLElement interface returns the height of an element, including vertical padding and borders, as an integer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/offsetHeight)\n     */\n    readonly offsetHeight: number;\n    /**\n     * The **`offsetLeft`** read-only property of the HTMLElement interface returns the number of pixels that the _upper left corner_ of the current element is offset to the left within the HTMLElement.offsetParent node.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/offsetLeft)\n     */\n    readonly offsetLeft: number;\n    /**\n     * The **`HTMLElement.offsetParent`** read-only property returns a reference to the element which is the closest (nearest in the containment hierarchy) positioned ancestor element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/offsetParent)\n     */\n    readonly offsetParent: Element | null;\n    /**\n     * The **`offsetTop`** read-only property of the HTMLElement interface returns the distance from the outer border of the current element (including its margin) to the top padding edge of the HTMLelement.offsetParent, the _closest positioned_ ancestor element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/offsetTop)\n     */\n    readonly offsetTop: number;\n    /**\n     * The **`offsetWidth`** read-only property of the HTMLElement interface returns the layout width of an element as an integer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/offsetWidth)\n     */\n    readonly offsetWidth: number;\n    /**\n     * The **`outerText`** property of the HTMLElement interface returns the same value as HTMLElement.innerText.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/outerText)\n     */\n    outerText: string;\n    /**\n     * The **`popover`** property of the HTMLElement interface gets and sets an element's popover state via JavaScript (`'auto'`, `'hint'`, or `'manual'`), and can be used for feature detection.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/popover)\n     */\n    popover: string | null;\n    /**\n     * The **`spellcheck`** property of the HTMLElement interface represents a boolean value that controls the spell-checking hint.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/spellcheck)\n     */\n    spellcheck: boolean;\n    /**\n     * The **`HTMLElement.title`** property represents the title of the element: the text usually displayed in a 'tooltip' popup when the mouse is over the node.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/title)\n     */\n    title: string;\n    /**\n     * The **`translate`** property of the HTMLElement interface indicates whether an element's attribute values and the values of its Text node children are to be translated when the page is localized, or whether to leave them unchanged.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/translate)\n     */\n    translate: boolean;\n    /**\n     * The **`writingSuggestions`** property of the HTMLElement interface is a string indicating if browser-provided writing suggestions should be enabled under the scope of the element or not.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/writingSuggestions)\n     */\n    writingSuggestions: string;\n    /**\n     * The **`HTMLElement.attachInternals()`** method returns an ElementInternals object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/attachInternals)\n     */\n    attachInternals(): ElementInternals;\n    /**\n     * The **`HTMLElement.click()`** method simulates a mouse click on an element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/click)\n     */\n    click(): void;\n    /**\n     * The **`hidePopover()`** method of the HTMLElement interface hides a popover element (i.e., one that has a valid `popover` attribute) by removing it from the top layer and styling it with `display: none`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/hidePopover)\n     */\n    hidePopover(): void;\n    /**\n     * The **`showPopover()`** method of the HTMLElement interface shows a Popover_API element (i.e., one that has a valid `popover` attribute) by adding it to the top layer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/showPopover)\n     */\n    showPopover(): void;\n    /**\n     * The **`togglePopover()`** method of the HTMLElement interface toggles a Popover_API element (i.e., one that has a valid `popover` attribute) between the hidden and showing states.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/togglePopover)\n     */\n    togglePopover(options?: boolean): boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLElement: {\n    prototype: HTMLElement;\n    new(): HTMLElement;\n};\n\n/**\n * The **`HTMLEmbedElement`** interface provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating embed elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLEmbedElement)\n */\ninterface HTMLEmbedElement extends HTMLElement {\n    /** @deprecated */\n    align: string;\n    /**\n     * The **`height`** property of the HTMLEmbedElement interface returns a string that reflects the `height` attribute of the embed element, indicating the displayed height of the resource in CSS pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLEmbedElement/height)\n     */\n    height: string;\n    /** @deprecated */\n    name: string;\n    /**\n     * The **`src`** property of the HTMLEmbedElement interface returns a string that indicates the URL of the resource being embedded.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLEmbedElement/src)\n     */\n    src: string;\n    /**\n     * The **`type`** property of the HTMLEmbedElement interface returns a string that reflects the `type` attribute of the embed element, indicating the MIME type of the resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLEmbedElement/type)\n     */\n    type: string;\n    /**\n     * The **`width`** property of the HTMLEmbedElement interface returns a string that reflects the `width` attribute of the embed element, indicating the displayed width of the resource in CSS pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLEmbedElement/width)\n     */\n    width: string;\n    /**\n     * The **`getSVGDocument()`** method of the HTMLEmbedElement interface returns the Document object of the embedded SVG.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLEmbedElement/getSVGDocument)\n     */\n    getSVGDocument(): Document | null;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLEmbedElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLEmbedElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLEmbedElement: {\n    prototype: HTMLEmbedElement;\n    new(): HTMLEmbedElement;\n};\n\n/**\n * The **`HTMLFieldSetElement`** interface provides special properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of fieldset elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement)\n */\ninterface HTMLFieldSetElement extends HTMLElement {\n    /**\n     * The **`disabled`** property of the HTMLFieldSetElement interface is a boolean value that reflects the fieldset element's `disabled` attribute, which indicates whether the control is disabled.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/disabled)\n     */\n    disabled: boolean;\n    /**\n     * The **`elements`** read-only property of the HTMLFieldSetElement interface returns an HTMLCollection object containing all form control elements (button, fieldset, input, object, output, select, and textarea) that are descendants of this field set.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/elements)\n     */\n    readonly elements: HTMLCollection;\n    /**\n     * The **`form`** read-only property of the HTMLFieldSetElement interface returns an HTMLFormElement object that owns this fieldset, or `null` if this fieldset is not owned by any form.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/form)\n     */\n    readonly form: HTMLFormElement | null;\n    /**\n     * The **`name`** property of the HTMLFieldSetElement interface indicates the name of the fieldset element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/name)\n     */\n    name: string;\n    /**\n     * The **`type`** read-only property of the HTMLFieldSetElement interface returns the string `'fieldset'`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/type)\n     */\n    readonly type: string;\n    /**\n     * The **`validationMessage`** read-only property of the HTMLFieldSetElement interface returns a string representing a localized message that describes the validation constraints that the fieldset control does not satisfy (if any).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/validationMessage)\n     */\n    readonly validationMessage: string;\n    /**\n     * The **`validity`** read-only property of the HTMLFieldSetElement interface returns a ValidityState object that represents the validity states this element is in.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/validity)\n     */\n    readonly validity: ValidityState;\n    /**\n     * The **`willValidate`** read-only property of the HTMLFieldSetElement interface returns `false`, because fieldset elements are not candidates for constraint validation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/willValidate)\n     */\n    readonly willValidate: boolean;\n    /**\n     * The **`checkValidity()`** method of the HTMLFieldSetElement interface checks if the element is valid, but always returns true because fieldset elements are never candidates for constraint validation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/checkValidity)\n     */\n    checkValidity(): boolean;\n    /**\n     * The **`reportValidity()`** method of the HTMLFieldSetElement interface performs the same validity checking steps as the HTMLFieldSetElement.checkValidity method.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/reportValidity)\n     */\n    reportValidity(): boolean;\n    /**\n     * The **`setCustomValidity()`** method of the HTMLFieldSetElement interface sets the custom validity message for the fieldset element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFieldSetElement/setCustomValidity)\n     */\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFieldSetElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFieldSetElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLFieldSetElement: {\n    prototype: HTMLFieldSetElement;\n    new(): HTMLFieldSetElement;\n};\n\n/**\n * Implements the document object model (DOM) representation of the font element.\n * @deprecated\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFontElement)\n */\ninterface HTMLFontElement extends HTMLElement {\n    /**\n     * The obsolete **`HTMLFontElement.color`** property is a string that reflects the `color` HTML attribute, containing either a named color or a color specified in the hexadecimal #RRGGBB format.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFontElement/color)\n     */\n    color: string;\n    /**\n     * The obsolete **`HTMLFontElement.face`** property is a string that reflects the `face` HTML attribute, containing a comma-separated list of one or more font names.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFontElement/face)\n     */\n    face: string;\n    /**\n     * The obsolete **`HTMLFontElement.size`** property is a string that reflects the `size` HTML attribute.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFontElement/size)\n     */\n    size: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFontElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFontElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** @deprecated */\ndeclare var HTMLFontElement: {\n    prototype: HTMLFontElement;\n    new(): HTMLFontElement;\n};\n\n/**\n * The **`HTMLFormControlsCollection`** interface represents a _collection_ of HTML _form control elements_, returned by the HTMLFormElement interface's HTMLFormElement.elements property.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormControlsCollection)\n */\ninterface HTMLFormControlsCollection extends HTMLCollectionBase {\n    /**\n     * The **`HTMLFormControlsCollection.namedItem()`** method returns the RadioNodeList or the Element in the collection whose `name` or `id` match the specified name, or `null` if no node matches.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormControlsCollection/namedItem)\n     */\n    namedItem(name: string): RadioNodeList | Element | null;\n}\n\ndeclare var HTMLFormControlsCollection: {\n    prototype: HTMLFormControlsCollection;\n    new(): HTMLFormControlsCollection;\n};\n\n/**\n * The **`HTMLFormElement`** interface represents a form element in the DOM.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement)\n */\ninterface HTMLFormElement extends HTMLElement {\n    /**\n     * The **`HTMLFormElement.acceptCharset`** property represents the character encoding for the given form element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/acceptCharset)\n     */\n    acceptCharset: string;\n    /**\n     * The **`HTMLFormElement.action`** property represents the action of the form element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/action)\n     */\n    action: string;\n    /**\n     * The **`autocomplete`** property of the HTMLFormElement interface indicates whether the value of the form's controls can be automatically completed by the browser.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/autocomplete)\n     */\n    autocomplete: AutoFillBase;\n    /**\n     * The HTMLFormElement property **`elements`** returns an the form element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/elements)\n     */\n    readonly elements: HTMLFormControlsCollection;\n    /**\n     * The **`HTMLFormElement.encoding`** property is an alternative name for the HTMLFormElement.enctype element on the DOM HTMLFormElement object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/encoding)\n     */\n    encoding: string;\n    /**\n     * The **`HTMLFormElement.enctype`** property is the MIME_type of content that is used to submit the form to the server.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/enctype)\n     */\n    enctype: string;\n    /**\n     * The **`HTMLFormElement.length`** read-only property returns the number of controls in the form element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/length)\n     */\n    readonly length: number;\n    /**\n     * The **`HTMLFormElement.method`** property represents the Unless explicitly specified, the default method is 'get'.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/method)\n     */\n    method: string;\n    /**\n     * The **`HTMLFormElement.name`** property represents the name of the current form element as a string.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/name)\n     */\n    name: string;\n    /**\n     * The **`noValidate`** property of the HTMLFormElement interface is a boolean value indicating if the form will bypass constraint validation when submitted.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/noValidate)\n     */\n    noValidate: boolean;\n    /**\n     * The **`rel`** property of the HTMLFormElement interface reflects the `rel` attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/rel)\n     */\n    rel: string;\n    /**\n     * The **`relList`** read-only property of the HTMLFormElement interface reflects the `rel` attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/relList)\n     */\n    get relList(): DOMTokenList;\n    set relList(value: string);\n    /**\n     * The **`target`** property of the HTMLFormElement interface represents the target of the form's action (i.e., the frame in which to render its output).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/target)\n     */\n    target: string;\n    /**\n     * The **`checkValidity()`** method of the HTMLFormElement interface returns a boolean value which indicates if all associated controls meet any constraint validation rules applied to them.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/checkValidity)\n     */\n    checkValidity(): boolean;\n    /**\n     * The **`reportValidity()`** method of the HTMLFormElement interface performs the same validity checking steps as the HTMLFormElement.checkValidity method.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/reportValidity)\n     */\n    reportValidity(): boolean;\n    /**\n     * The HTMLFormElement method **`requestSubmit()`** requests that the form be submitted using a specific submit button.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/requestSubmit)\n     */\n    requestSubmit(submitter?: HTMLElement | null): void;\n    /**\n     * The **`HTMLFormElement.reset()`** method restores a form element's default values.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/reset)\n     */\n    reset(): void;\n    /**\n     * The **`HTMLFormElement.submit()`** method submits a given This method is similar, but not identical to, activating a form's submit - No HTMLFormElement/submit_event event is raised.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFormElement/submit)\n     */\n    submit(): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFormElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFormElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n    [index: number]: Element;\n    [name: string]: any;\n}\n\ndeclare var HTMLFormElement: {\n    prototype: HTMLFormElement;\n    new(): HTMLFormElement;\n};\n\n/** @deprecated */\ninterface HTMLFrameElement extends HTMLElement {\n    /** @deprecated */\n    readonly contentDocument: Document | null;\n    /** @deprecated */\n    readonly contentWindow: WindowProxy | null;\n    /** @deprecated */\n    frameBorder: string;\n    /** @deprecated */\n    longDesc: string;\n    /** @deprecated */\n    marginHeight: string;\n    /** @deprecated */\n    marginWidth: string;\n    /** @deprecated */\n    name: string;\n    /** @deprecated */\n    noResize: boolean;\n    /** @deprecated */\n    scrolling: string;\n    /** @deprecated */\n    src: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFrameElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFrameElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** @deprecated */\ndeclare var HTMLFrameElement: {\n    prototype: HTMLFrameElement;\n    new(): HTMLFrameElement;\n};\n\ninterface HTMLFrameSetElementEventMap extends HTMLElementEventMap, WindowEventHandlersEventMap {\n}\n\n/**\n * The **`HTMLFrameSetElement`** interface provides special properties (beyond those of the regular HTMLElement interface they also inherit) for manipulating frameset elements.\n * @deprecated\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLFrameSetElement)\n */\ninterface HTMLFrameSetElement extends HTMLElement, WindowEventHandlers {\n    /** @deprecated */\n    cols: string;\n    /** @deprecated */\n    rows: string;\n    addEventListener<K extends keyof HTMLFrameSetElementEventMap>(type: K, listener: (this: HTMLFrameSetElement, ev: HTMLFrameSetElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLFrameSetElementEventMap>(type: K, listener: (this: HTMLFrameSetElement, ev: HTMLFrameSetElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** @deprecated */\ndeclare var HTMLFrameSetElement: {\n    prototype: HTMLFrameSetElement;\n    new(): HTMLFrameSetElement;\n};\n\n/**\n * The **`HTMLHRElement`** interface provides special properties (beyond those of the HTMLElement interface it also has available to it by inheritance) for manipulating hr elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLHRElement)\n */\ninterface HTMLHRElement extends HTMLElement {\n    /** @deprecated */\n    align: string;\n    /** @deprecated */\n    color: string;\n    /** @deprecated */\n    noShade: boolean;\n    /** @deprecated */\n    size: string;\n    /** @deprecated */\n    width: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHRElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHRElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLHRElement: {\n    prototype: HTMLHRElement;\n    new(): HTMLHRElement;\n};\n\n/**\n * The **`HTMLHeadElement`** interface contains the descriptive information, or metadata, for a document.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLHeadElement)\n */\ninterface HTMLHeadElement extends HTMLElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLHeadElement: {\n    prototype: HTMLHeadElement;\n    new(): HTMLHeadElement;\n};\n\n/**\n * The **`HTMLHeadingElement`** interface represents the different heading elements, `<h1>` through `<h6>`.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLHeadingElement)\n */\ninterface HTMLHeadingElement extends HTMLElement {\n    /** @deprecated */\n    align: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadingElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadingElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLHeadingElement: {\n    prototype: HTMLHeadingElement;\n    new(): HTMLHeadingElement;\n};\n\n/**\n * The **`HTMLHtmlElement`** interface serves as the root node for a given HTML document.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLHtmlElement)\n */\ninterface HTMLHtmlElement extends HTMLElement {\n    /**\n     * Returns version information about the document type definition (DTD) of a document.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLHtmlElement/version)\n     */\n    version: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHtmlElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHtmlElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLHtmlElement: {\n    prototype: HTMLHtmlElement;\n    new(): HTMLHtmlElement;\n};\n\ninterface HTMLHyperlinkElementUtils {\n    /**\n     * Returns the hyperlink's URL's fragment (includes leading \"#\" if non-empty).\n     *\n     * Can be set, to change the URL's fragment (ignores leading \"#\").\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/hash)\n     */\n    hash: string;\n    /**\n     * Returns the hyperlink's URL's host and port (if different from the default port for the scheme).\n     *\n     * Can be set, to change the URL's host and port.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/host)\n     */\n    host: string;\n    /**\n     * Returns the hyperlink's URL's host.\n     *\n     * Can be set, to change the URL's host.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/hostname)\n     */\n    hostname: string;\n    /**\n     * Returns the hyperlink's URL.\n     *\n     * Can be set, to change the URL.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/href)\n     */\n    href: string;\n    toString(): string;\n    /**\n     * Returns the hyperlink's URL's origin.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/origin)\n     */\n    readonly origin: string;\n    /**\n     * Returns the hyperlink's URL's password.\n     *\n     * Can be set, to change the URL's password.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/password)\n     */\n    password: string;\n    /**\n     * Returns the hyperlink's URL's path.\n     *\n     * Can be set, to change the URL's path.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/pathname)\n     */\n    pathname: string;\n    /**\n     * Returns the hyperlink's URL's port.\n     *\n     * Can be set, to change the URL's port.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/port)\n     */\n    port: string;\n    /**\n     * Returns the hyperlink's URL's scheme.\n     *\n     * Can be set, to change the URL's scheme.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/protocol)\n     */\n    protocol: string;\n    /**\n     * Returns the hyperlink's URL's query (includes leading \"?\" if non-empty).\n     *\n     * Can be set, to change the URL's query (ignores leading \"?\").\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/search)\n     */\n    search: string;\n    /**\n     * Returns the hyperlink's URL's username.\n     *\n     * Can be set, to change the URL's username.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLAnchorElement/username)\n     */\n    username: string;\n}\n\n/**\n * The **`HTMLIFrameElement`** interface provides special properties and methods (beyond those of the HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of inline frame elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement)\n */\ninterface HTMLIFrameElement extends HTMLElement {\n    /** @deprecated */\n    align: string;\n    /**\n     * The **`allow`** property of the HTMLIFrameElement interface indicates the Permissions Policy specified for this `<iframe>` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/allow)\n     */\n    allow: string;\n    /**\n     * The **`allowFullscreen`** property of the HTMLIFrameElement interface is a boolean value that reflects the `allowfullscreen` attribute of the iframe element, indicating whether to allow the iframe's contents to use Element.requestFullscreen.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/allowFullscreen)\n     */\n    allowFullscreen: boolean;\n    /**\n     * If the iframe and the iframe's parent document are Same Origin, returns a `Document` (that is, the active document in the inline frame's nested browsing context), else returns `null`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/contentDocument)\n     */\n    readonly contentDocument: Document | null;\n    /**\n     * The **`contentWindow`** property returns the Window object of an HTMLIFrameElement.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/contentWindow)\n     */\n    readonly contentWindow: WindowProxy | null;\n    /** @deprecated */\n    frameBorder: string;\n    /**\n     * The **`height`** property of the HTMLIFrameElement interface returns a string that reflects the `height` attribute of the iframe element, indicating the height of the frame in CSS pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/height)\n     */\n    height: string;\n    /**\n     * The **`loading`** property of the HTMLIFrameElement interface is a string that provides a hint to the user agent indicating whether the iframe should be loaded immediately on page load, or only when it is needed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/loading)\n     */\n    loading: \"eager\" | \"lazy\";\n    /** @deprecated */\n    longDesc: string;\n    /** @deprecated */\n    marginHeight: string;\n    /** @deprecated */\n    marginWidth: string;\n    /**\n     * The **`name`** property of the HTMLIFrameElement interface is a string value that reflects the `name` attribute of the iframe element, indicating the specific name of the `<iframe>` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/name)\n     */\n    name: string;\n    /**\n     * The **`HTMLIFrameElement.referrerPolicy`** property reflects the HTML `referrerpolicy` attribute of the resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/referrerPolicy)\n     */\n    referrerPolicy: ReferrerPolicy;\n    /**\n     * The **`sandbox`** read-only property of the HTMLIFrameElement interface returns a DOMTokenList indicating extra restrictions on the behavior of the nested content.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/sandbox)\n     */\n    get sandbox(): DOMTokenList;\n    set sandbox(value: string);\n    /** @deprecated */\n    scrolling: string;\n    /**\n     * The **`HTMLIFrameElement.src`** A string that reflects the `src` HTML attribute, containing the address of the content to be embedded.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/src)\n     */\n    src: string;\n    /**\n     * The **`srcdoc`** property of the HTMLIFrameElement specifies the content of the page.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/srcdoc)\n     */\n    srcdoc: string;\n    /**\n     * The **`width`** property of the HTMLIFrameElement interface returns a string that reflects the `width` attribute of the iframe element, indicating the width of the frame in CSS pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/width)\n     */\n    width: string;\n    /**\n     * The **`getSVGDocument()`** method of the HTMLIFrameElement interface returns the Document object of the embedded SVG.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLIFrameElement/getSVGDocument)\n     */\n    getSVGDocument(): Document | null;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLIFrameElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLIFrameElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLIFrameElement: {\n    prototype: HTMLIFrameElement;\n    new(): HTMLIFrameElement;\n};\n\n/**\n * The **`HTMLImageElement`** interface represents an HTML img element, providing the properties and methods used to manipulate image elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement)\n */\ninterface HTMLImageElement extends HTMLElement {\n    /**\n     * The _obsolete_ **`align`** property of the HTMLImageElement interface is a string which indicates how to position the image relative to its container.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/align)\n     */\n    align: string;\n    /**\n     * The HTMLImageElement property **`alt`** provides fallback (alternate) text to display when the image specified by the img element is not loaded.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/alt)\n     */\n    alt: string;\n    /**\n     * The obsolete HTMLImageElement property **`border`** specifies the number of pixels thick the border surrounding the image should be.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/border)\n     */\n    border: string;\n    /**\n     * The read-only HTMLImageElement interface's **`complete`** attribute is a Boolean value which indicates whether or not the image has completely loaded.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/complete)\n     */\n    readonly complete: boolean;\n    /**\n     * The HTMLImageElement interface's **`crossOrigin`** attribute is a string which specifies the Cross-Origin Resource Sharing (CORS) setting to use when retrieving the image.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/crossOrigin)\n     */\n    crossOrigin: string | null;\n    /**\n     * The read-only HTMLImageElement property **`currentSrc`** indicates the URL of the image which is currently presented in the img element it represents.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/currentSrc)\n     */\n    readonly currentSrc: string;\n    /**\n     * The **`decoding`** property of the HTMLImageElement interface provides a hint to the browser as to how it should decode the image.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/decoding)\n     */\n    decoding: \"async\" | \"sync\" | \"auto\";\n    /**\n     * The **`fetchPriority`** property of the HTMLImageElement interface represents a hint to the browser indicating how it should prioritize fetching a particular image relative to other images.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/fetchPriority)\n     */\n    fetchPriority: \"high\" | \"low\" | \"auto\";\n    /**\n     * The **`height`** property of the drawn, in CSS pixel if the image is being drawn or rendered to any visual medium such as the screen or a printer; otherwise, it's the natural, pixel density corrected height of the image.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/height)\n     */\n    height: number;\n    /**\n     * The _obsolete_ **`hspace`** property of the space to leave empty on the left and right sides of the img element when laying out the page.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/hspace)\n     */\n    hspace: number;\n    /**\n     * The HTMLImageElement property **`isMap`** is a Boolean value which indicates that the image is to be used by a server-side image map.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/isMap)\n     */\n    isMap: boolean;\n    /**\n     * The HTMLImageElement property **`loading`** is a string whose value provides a hint to the user agent on how to handle the loading of the image which is currently outside the window's visual viewport.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/loading)\n     */\n    loading: \"eager\" | \"lazy\";\n    /**\n     * The _deprecated_ property **`longDesc`** on the HTMLImageElement interface specifies the URL of a text or HTML file which contains a long-form description of the image.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/longDesc)\n     */\n    longDesc: string;\n    /** @deprecated */\n    lowsrc: string;\n    /**\n     * The HTMLImageElement interface's _deprecated_ **`name`** property specifies a name for the element.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/name)\n     */\n    name: string;\n    /**\n     * The HTMLImageElement interface's **`naturalHeight`** property is a read-only value which returns the intrinsic (natural), density-corrected height of the image in This is the height the image is if drawn with nothing constraining its height; if you don't specify a height for the image, or place the image inside a container that either limits or expressly specifies the image height, it will be rendered this tall.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/naturalHeight)\n     */\n    readonly naturalHeight: number;\n    /**\n     * The HTMLImageElement interface's read-only **`naturalWidth`** property returns the intrinsic (natural), density-corrected width of the image in CSS pixel.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/naturalWidth)\n     */\n    readonly naturalWidth: number;\n    /**\n     * The **`HTMLImageElement.referrerPolicy`** property reflects the HTML `referrerpolicy` attribute of the resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/referrerPolicy)\n     */\n    referrerPolicy: string;\n    /**\n     * The HTMLImageElement property **`sizes`** allows you to specify the layout width of the image for each of a list of media conditions.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/sizes)\n     */\n    sizes: string;\n    /**\n     * The HTMLImageElement property **`src`**, which reflects the HTML `src` attribute, specifies the image to display in the img element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/src)\n     */\n    src: string;\n    /**\n     * The HTMLImageElement property **`srcset`** is a string which identifies one or more **image candidate strings**, separated using commas (`,`) each specifying image resources to use under given circumstances.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/srcset)\n     */\n    srcset: string;\n    /**\n     * The **`useMap`** property on the providing the name of the client-side image map to apply to the image.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/useMap)\n     */\n    useMap: string;\n    /**\n     * The _obsolete_ **`vspace`** property of the to leave empty on the top and bottom of the img element when laying out the page.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/vspace)\n     */\n    vspace: number;\n    /**\n     * The **`width`** property of the drawn in CSS pixel if it's being drawn or rendered to any visual medium such as a screen or printer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/width)\n     */\n    width: number;\n    /**\n     * The read-only HTMLImageElement property **`x`** indicates the x-coordinate of the origin.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/x)\n     */\n    readonly x: number;\n    /**\n     * The read-only HTMLImageElement property **`y`** indicates the y-coordinate of the origin.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/y)\n     */\n    readonly y: number;\n    /**\n     * The **`decode()`** method of the HTMLImageElement interface returns a it to the DOM.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLImageElement/decode)\n     */\n    decode(): Promise<void>;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLImageElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLImageElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLImageElement: {\n    prototype: HTMLImageElement;\n    new(): HTMLImageElement;\n};\n\n/**\n * The **`HTMLInputElement`** interface provides special properties and methods for manipulating the options, layout, and presentation of input elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement)\n */\ninterface HTMLInputElement extends HTMLElement, PopoverInvokerElement {\n    /**\n     * The **`accept`** property of the HTMLInputElement interface reflects the input element's `accept` attribute, generally a comma-separated list of unique file type specifiers providing a hint for the expected file type for an `<input>` of type `file`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/accept)\n     */\n    accept: string;\n    /** @deprecated */\n    align: string;\n    /**\n     * The **`alt`** property of the HTMLInputElement interface defines the textual label for the button for users and user agents who cannot use the image.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/alt)\n     */\n    alt: string;\n    /**\n     * The **`autocomplete`** property of the HTMLInputElement interface indicates whether the value of the control can be automatically completed by the browser.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/autocomplete)\n     */\n    autocomplete: AutoFill;\n    /**\n     * The **`capture`** property of the HTMLInputElement interface reflects the input element's `capture` attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/capture)\n     */\n    capture: string;\n    /**\n     * The **`checked`** property of the HTMLInputElement interface specifies the current checkedness of the element; that is, whether the form control is checked or not.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/checked)\n     */\n    checked: boolean;\n    /**\n     * The **`defaultChecked`** property of the HTMLInputElement interface specifies the default checkedness state of the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/defaultChecked)\n     */\n    defaultChecked: boolean;\n    /**\n     * The **`defaultValue`** property of the HTMLInputElement interface indicates the original (or default) value of the input element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/defaultValue)\n     */\n    defaultValue: string;\n    /**\n     * The **`dirName`** property of the HTMLInputElement interface is the directionality of the element and enables the submission of that value.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/dirName)\n     */\n    dirName: string;\n    /**\n     * The **`HTMLInputElement.disabled`** property is a boolean value that reflects the `disabled` HTML attribute, which indicates whether the control is disabled.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/disabled)\n     */\n    disabled: boolean;\n    /**\n     * The **`HTMLInputElement.files`** property allows you to access the FileList selected with the `<input type='file'>` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/files)\n     */\n    files: FileList | null;\n    /**\n     * The **`form`** read-only property of the HTMLInputElement interface returns an HTMLFormElement object that owns this input, or `null` if this input is not owned by any form.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/form)\n     */\n    readonly form: HTMLFormElement | null;\n    /**\n     * The **`formAction`** property of the HTMLInputElement interface is the URL of the program that is executed on the server when the form that owns this control is submitted.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/formAction)\n     */\n    formAction: string;\n    /**\n     * The **`formEnctype`** property of the HTMLInputElement interface is the MIME_type of the content sent to the server when the `<input>` with the `formEnctype` is the method of form submission.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/formEnctype)\n     */\n    formEnctype: string;\n    /**\n     * The **`formMethod`** property of the HTMLInputElement interface is the HTTP method used to submit the form if the input element is the control that submits the form.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/formMethod)\n     */\n    formMethod: string;\n    /**\n     * The **`formNoValidate`** property of the HTMLInputElement interface is a boolean value indicating if the form will bypass constraint validation when submitted via the input.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/formNoValidate)\n     */\n    formNoValidate: boolean;\n    /**\n     * The **`formTarget`** property of the HTMLInputElement interface is the tab, window, or iframe where the response of the submitted form is to be displayed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/formTarget)\n     */\n    formTarget: string;\n    /**\n     * The **`height`** property of the HTMLInputElement interface specifies the height of a control.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/height)\n     */\n    height: number;\n    /**\n     * The **`indeterminate`** property of the HTMLInputElement interface returns a boolean value that indicates whether the checkbox is in the _indeterminate_ state.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/indeterminate)\n     */\n    indeterminate: boolean;\n    /**\n     * The **`HTMLInputElement.labels`** read-only property returns a type `hidden`, the property returns `null`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/labels)\n     */\n    readonly labels: NodeListOf<HTMLLabelElement> | null;\n    /**\n     * The **`list`** read-only property of the HTMLInputElement interface returns the HTMLDataListElement pointed to by the `list` attribute of the element, or `null` if the `list` attribute is not defined or the `list` attribute's value is not associated with any `<datalist>` in the same tree.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/list)\n     */\n    readonly list: HTMLDataListElement | null;\n    /**\n     * The **`max`** property of the HTMLInputElement interface reflects the input element's `max` attribute, which generally defines the maximum valid value for a numeric or date-time input.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/max)\n     */\n    max: string;\n    /**\n     * The **`maxLength`** property of the HTMLInputElement interface indicates the maximum number of characters (in UTF-16 code units) allowed to be entered for the value of the input element, and the maximum number of characters allowed for the value to be valid.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/maxLength)\n     */\n    maxLength: number;\n    /**\n     * The **`min`** property of the HTMLInputElement interface reflects the input element's `min` attribute, which generally defines the minimum valid value for a numeric or date-time input.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/min)\n     */\n    min: string;\n    /**\n     * The **`minLength`** property of the HTMLInputElement interface indicates the minimum number of characters (in UTF-16 code units) required for the value of the input element to be valid.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/minLength)\n     */\n    minLength: number;\n    /**\n     * The **`HTMLInputElement.multiple`** property indicates if an input can have more than one value.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/multiple)\n     */\n    multiple: boolean;\n    /**\n     * The **`name`** property of the HTMLInputElement interface indicates the name of the input element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/name)\n     */\n    name: string;\n    /**\n     * The **`pattern`** property of the HTMLInputElement interface represents a regular expression a non-null input value should match.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/pattern)\n     */\n    pattern: string;\n    /**\n     * The **`placeholder`** property of the HTMLInputElement interface represents a hint to the user of what can be entered in the control.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/placeholder)\n     */\n    placeholder: string;\n    /**\n     * The **`readOnly`** property of the HTMLInputElement interface indicates that the user cannot modify the value of the input.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/readOnly)\n     */\n    readOnly: boolean;\n    /**\n     * The **`required`** property of the HTMLInputElement interface specifies that the user must fill in a value before submitting a form.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/required)\n     */\n    required: boolean;\n    /**\n     * The **`selectionDirection`** property of the HTMLInputElement interface is a string that indicates the direction in which the user is selecting the text.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/selectionDirection)\n     */\n    selectionDirection: \"forward\" | \"backward\" | \"none\" | null;\n    /**\n     * The **`selectionEnd`** property of the HTMLInputElement interface is a number that represents the end index of the selected text.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/selectionEnd)\n     */\n    selectionEnd: number | null;\n    /**\n     * The **`selectionStart`** property of the HTMLInputElement interface is a number that represents the beginning index of the selected text.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/selectionStart)\n     */\n    selectionStart: number | null;\n    /**\n     * The **`size`** property of the HTMLInputElement interface defines the number of visible characters displayed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/size)\n     */\n    size: number;\n    /**\n     * The **`src`** property of the HTMLInputElement interface specifies the source of an image to display as the graphical submit button.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/src)\n     */\n    src: string;\n    /**\n     * The **`step`** property of the HTMLInputElement interface indicates the step by which numeric or date-time input elements can change.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/step)\n     */\n    step: string;\n    /**\n     * The **`type`** property of the HTMLInputElement interface indicates the kind of data allowed in the input element, for example a number, a date, or an email.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/type)\n     */\n    type: string;\n    /** @deprecated */\n    useMap: string;\n    /**\n     * The **`validationMessage`** read-only property of the HTMLInputElement interface returns a string representing a localized message that describes the validation constraints that the input control does not satisfy (if any).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/validationMessage)\n     */\n    readonly validationMessage: string;\n    /**\n     * The **`validity`** read-only property of the HTMLInputElement interface returns a ValidityState object that represents the validity states this element is in.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/validity)\n     */\n    readonly validity: ValidityState;\n    /**\n     * The **`value`** property of the HTMLInputElement interface represents the current value of the input element as a string.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/value)\n     */\n    value: string;\n    /**\n     * The **`valueAsDate`** property of the HTMLInputElement interface represents the current value of the input element as a Date, or `null` if conversion is not possible.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/valueAsDate)\n     */\n    valueAsDate: Date | null;\n    /**\n     * The **`valueAsNumber`** property of the HTMLInputElement interface represents the current value of the input element as a number or `NaN` if converting to a numeric value is not possible.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/valueAsNumber)\n     */\n    valueAsNumber: number;\n    /**\n     * The read-only **`webkitEntries`** property of the HTMLInputElement interface contains an array of file system entries (as objects based on FileSystemEntry) representing files and/or directories selected by the user using an input element of type `file`, but only if that selection was made using drag-and-drop: selecting a file in the dialog will leave the property empty.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/webkitEntries)\n     */\n    readonly webkitEntries: ReadonlyArray<FileSystemEntry>;\n    /**\n     * The **`HTMLInputElement.webkitdirectory`** is a property that reflects the `webkitdirectory` HTML attribute and indicates that the input element should let the user select directories instead of files.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/webkitdirectory)\n     */\n    webkitdirectory: boolean;\n    /**\n     * The **`width`** property of the HTMLInputElement interface specifies the width of a control.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/width)\n     */\n    width: number;\n    /**\n     * The **`willValidate`** read-only property of the HTMLInputElement interface indicates whether the input element is a candidate for constraint validation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/willValidate)\n     */\n    readonly willValidate: boolean;\n    /**\n     * The **`checkValidity()`** method of the HTMLInputElement interface returns a boolean value which indicates if the element meets any constraint validation rules applied to it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/checkValidity)\n     */\n    checkValidity(): boolean;\n    /**\n     * The **`reportValidity()`** method of the HTMLInputElement interface performs the same validity checking steps as the HTMLInputElement.checkValidity method.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/reportValidity)\n     */\n    reportValidity(): boolean;\n    /**\n     * The **`HTMLInputElement.select()`** method selects all the text in a textarea element or in an input element that includes a text field.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/select)\n     */\n    select(): void;\n    /**\n     * The **`HTMLInputElement.setCustomValidity()`** method sets a custom validity message for the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/setCustomValidity)\n     */\n    setCustomValidity(error: string): void;\n    /**\n     * The **`HTMLInputElement.setRangeText()`** method replaces a range of text in an input or textarea element with a new string.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/setRangeText)\n     */\n    setRangeText(replacement: string): void;\n    setRangeText(replacement: string, start: number, end: number, selectionMode?: SelectionMode): void;\n    /**\n     * The **`HTMLInputElement.setSelectionRange()`** method sets the start and end positions of the current text selection in an input or textarea element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/setSelectionRange)\n     */\n    setSelectionRange(start: number | null, end: number | null, direction?: \"forward\" | \"backward\" | \"none\"): void;\n    /**\n     * The **`HTMLInputElement.showPicker()`** method displays the browser picker for an `input` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/showPicker)\n     */\n    showPicker(): void;\n    /**\n     * The **`HTMLInputElement.stepDown()`** method decrements the value of a numeric type of input element by the value of the `step` attribute or up to `n` multiples of the step attribute if a number is passed as the parameter.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/stepDown)\n     */\n    stepDown(n?: number): void;\n    /**\n     * The **`HTMLInputElement.stepUp()`** method increments the value of a numeric type of input element by the value of the `step` attribute, or the default `step` value if the step attribute is not explicitly set.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLInputElement/stepUp)\n     */\n    stepUp(n?: number): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLInputElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLInputElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLInputElement: {\n    prototype: HTMLInputElement;\n    new(): HTMLInputElement;\n};\n\n/**\n * The **`HTMLLIElement`** interface exposes specific properties and methods (beyond those defined by regular HTMLElement interface it also has available to it by inheritance) for manipulating list elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLIElement)\n */\ninterface HTMLLIElement extends HTMLElement {\n    /** @deprecated */\n    type: string;\n    /**\n     * The **`value`** property of the HTMLLIElement interface indicates the ordinal position of the _list element_ inside a given ol.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLIElement/value)\n     */\n    value: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLIElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLIElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLLIElement: {\n    prototype: HTMLLIElement;\n    new(): HTMLLIElement;\n};\n\n/**\n * The **`HTMLLabelElement`** interface gives access to properties specific to label elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLabelElement)\n */\ninterface HTMLLabelElement extends HTMLElement {\n    /**\n     * The read-only **`HTMLLabelElement.control`** property returns a reference to the control (in the form of an object of type HTMLElement or one of its derivatives) with which the label element is associated, or `null` if the label isn't associated with a control.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLabelElement/control)\n     */\n    readonly control: HTMLElement | null;\n    /**\n     * The **`form`** read-only property of the HTMLLabelElement interface returns an HTMLFormElement object that owns the HTMLLabelElement.control associated with this label, or `null` if this label is not associated with a control owned by a form.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLabelElement/form)\n     */\n    readonly form: HTMLFormElement | null;\n    /**\n     * The **`HTMLLabelElement.htmlFor`** property reflects the value of the `for` content property.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLabelElement/htmlFor)\n     */\n    htmlFor: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLabelElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLabelElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLLabelElement: {\n    prototype: HTMLLabelElement;\n    new(): HTMLLabelElement;\n};\n\n/**\n * The **`HTMLLegendElement`** is an interface allowing to access properties of the legend elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLegendElement)\n */\ninterface HTMLLegendElement extends HTMLElement {\n    /** @deprecated */\n    align: string;\n    /**\n     * The **`form`** read-only property of the HTMLLegendElement interface returns an HTMLFormElement object that owns the HTMLFieldSetElement associated with this legend, or `null` if this legend is not associated with a fieldset owned by a form.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLegendElement/form)\n     */\n    readonly form: HTMLFormElement | null;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLegendElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLegendElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLLegendElement: {\n    prototype: HTMLLegendElement;\n    new(): HTMLLegendElement;\n};\n\n/**\n * The **`HTMLLinkElement`** interface represents reference information for external resources and the relationship of those resources to a document and vice versa (corresponds to `<link>` element; not to be confused with `<a>`, which is represented by `HTMLAnchorElement`).\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement)\n */\ninterface HTMLLinkElement extends HTMLElement, LinkStyle {\n    /**\n     * The **`as`** property of the HTMLLinkElement interface returns a string representing the type of content to be preloaded by a link element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/as)\n     */\n    as: string;\n    /**\n     * The **`blocking`** property of the HTMLLinkElement interface is a string indicating that certain operations should be blocked on the fetching of an external resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/blocking)\n     */\n    get blocking(): DOMTokenList;\n    set blocking(value: string);\n    /** @deprecated */\n    charset: string;\n    /**\n     * The **`crossOrigin`** property of the HTMLLinkElement interface specifies the Cross-Origin Resource Sharing (CORS) setting to use when retrieving the resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/crossOrigin)\n     */\n    crossOrigin: string | null;\n    /**\n     * The **`disabled`** property of the HTMLLinkElement interface is a boolean value that represents whether the link is disabled.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/disabled)\n     */\n    disabled: boolean;\n    /**\n     * The **`fetchPriority`** property of the HTMLLinkElement interface represents a hint to the browser indicating how it should prioritize fetching a particular resource relative to other resources of the same type.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/fetchPriority)\n     */\n    fetchPriority: \"high\" | \"low\" | \"auto\";\n    /**\n     * The **`href`** property of the HTMLLinkElement interface contains a string that is the URL associated with the link.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/href)\n     */\n    href: string;\n    /**\n     * The **`hreflang`** property of the HTMLLinkElement interface is used to indicate the language and the geographical targeting of a page.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/hreflang)\n     */\n    hreflang: string;\n    /**\n     * The **`imageSizes`** property of the HTMLLinkElement interface indicates the size and conditions for the preloaded images defined by the HTMLLinkElement.imageSrcset property.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/imageSizes)\n     */\n    imageSizes: string;\n    /**\n     * The **`imageSrcset`** property of the HTMLLinkElement interface is a string which identifies one or more comma-separated **image candidate strings**.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/imageSrcset)\n     */\n    imageSrcset: string;\n    /**\n     * The **`integrity`** property of the HTMLLinkElement interface is a string containing inline metadata that a browser can use to verify that a fetched resource has been delivered without unexpected manipulation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/integrity)\n     */\n    integrity: string;\n    /**\n     * The **`media`** property of the HTMLLinkElement interface is a string representing a list of one or more media formats to which the resource applies.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/media)\n     */\n    media: string;\n    /**\n     * The **`referrerPolicy`** property of the HTMLLinkElement interface reflects the HTML `referrerpolicy` attribute of the resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/referrerPolicy)\n     */\n    referrerPolicy: string;\n    /**\n     * The **`rel`** property of the HTMLLinkElement interface reflects the `rel` attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/rel)\n     */\n    rel: string;\n    /**\n     * The **`relList`** read-only property of the HTMLLinkElement interface reflects the `rel` attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/relList)\n     */\n    get relList(): DOMTokenList;\n    set relList(value: string);\n    /** @deprecated */\n    rev: string;\n    /**\n     * The **`sizes`** read-only property of the HTMLLinkElement interfaces defines the sizes of the icons for visual media contained in the resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/sizes)\n     */\n    get sizes(): DOMTokenList;\n    set sizes(value: string);\n    /** @deprecated */\n    target: string;\n    /**\n     * The **`type`** property of the HTMLLinkElement interface is a string that reflects the MIME type of the linked resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/type)\n     */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLinkElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLinkElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLLinkElement: {\n    prototype: HTMLLinkElement;\n    new(): HTMLLinkElement;\n};\n\n/**\n * The **`HTMLMapElement`** interface provides special properties and methods (beyond those of the regular object HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of map elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMapElement)\n */\ninterface HTMLMapElement extends HTMLElement {\n    /**\n     * The **`areas`** read-only property of the HTMLMapElement interface returns a collection of area elements associated with the map element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMapElement/areas)\n     */\n    readonly areas: HTMLCollection;\n    /**\n     * The **`name`** property of the HTMLMapElement represents the unique name `<map>` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMapElement/name)\n     */\n    name: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMapElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMapElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLMapElement: {\n    prototype: HTMLMapElement;\n    new(): HTMLMapElement;\n};\n\n/**\n * The **`HTMLMarqueeElement`** interface provides methods to manipulate marquee elements.\n * @deprecated\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMarqueeElement)\n */\ninterface HTMLMarqueeElement extends HTMLElement {\n    /** @deprecated */\n    behavior: string;\n    /** @deprecated */\n    bgColor: string;\n    /** @deprecated */\n    direction: string;\n    /** @deprecated */\n    height: string;\n    /** @deprecated */\n    hspace: number;\n    /** @deprecated */\n    loop: number;\n    /** @deprecated */\n    scrollAmount: number;\n    /** @deprecated */\n    scrollDelay: number;\n    /** @deprecated */\n    trueSpeed: boolean;\n    /** @deprecated */\n    vspace: number;\n    /** @deprecated */\n    width: string;\n    /** @deprecated */\n    start(): void;\n    /** @deprecated */\n    stop(): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMarqueeElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMarqueeElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** @deprecated */\ndeclare var HTMLMarqueeElement: {\n    prototype: HTMLMarqueeElement;\n    new(): HTMLMarqueeElement;\n};\n\ninterface HTMLMediaElementEventMap extends HTMLElementEventMap {\n    \"encrypted\": MediaEncryptedEvent;\n    \"waitingforkey\": Event;\n}\n\n/**\n * The **`HTMLMediaElement`** interface adds to HTMLElement the properties and methods needed to support basic media-related capabilities that are common to audio and video.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement)\n */\ninterface HTMLMediaElement extends HTMLElement {\n    /**\n     * The **`HTMLMediaElement.autoplay`** property reflects the `autoplay` HTML attribute, indicating whether playback should automatically begin as soon as enough media is available to do so without interruption.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/autoplay)\n     */\n    autoplay: boolean;\n    /**\n     * The **`buffered`** read-only property of HTMLMediaElement objects returns a new static normalized `TimeRanges` object that represents the ranges of the media resource, if any, that the user agent has buffered at the moment the `buffered` property is accessed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/buffered)\n     */\n    readonly buffered: TimeRanges;\n    /**\n     * The **`HTMLMediaElement.controls`** property reflects the `controls` HTML attribute, which controls whether user interface controls for playing the media item will be displayed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/controls)\n     */\n    controls: boolean;\n    /**\n     * The **`HTMLMediaElement.crossOrigin`** property is the CORS setting for this media element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/crossOrigin)\n     */\n    crossOrigin: string | null;\n    /**\n     * The **`HTMLMediaElement.currentSrc`** property contains the absolute URL of the chosen media resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/currentSrc)\n     */\n    readonly currentSrc: string;\n    /**\n     * The HTMLMediaElement interface's **`currentTime`** property specifies the current playback time in seconds.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/currentTime)\n     */\n    currentTime: number;\n    /**\n     * The **`HTMLMediaElement.defaultMuted`** property reflects the `muted` HTML attribute, which indicates whether the media element's audio output should be muted by default.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/defaultMuted)\n     */\n    defaultMuted: boolean;\n    /**\n     * The **`HTMLMediaElement.defaultPlaybackRate`** property indicates the default playback rate for the media.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/defaultPlaybackRate)\n     */\n    defaultPlaybackRate: number;\n    /**\n     * The **`disableRemotePlayback`** property of the HTMLMediaElement interface determines whether the media element is allowed to have a remote playback UI.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/disableRemotePlayback)\n     */\n    disableRemotePlayback: boolean;\n    /**\n     * The _read-only_ HTMLMediaElement property **`duration`** indicates the length of the element's media in seconds.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/duration)\n     */\n    readonly duration: number;\n    /**\n     * The **`HTMLMediaElement.ended`** property indicates whether the media element has ended playback.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/ended)\n     */\n    readonly ended: boolean;\n    /**\n     * The **`HTMLMediaElement.error`** property is the there has not been an error.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/error)\n     */\n    readonly error: MediaError | null;\n    /**\n     * The **`HTMLMediaElement.loop`** property reflects the `loop` HTML attribute, which controls whether the media element should start over when it reaches the end.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/loop)\n     */\n    loop: boolean;\n    /**\n     * The read-only **`HTMLMediaElement.mediaKeys`** property returns a MediaKeys object, that is a set of keys that the element can use for decryption of media data during playback.\n     * Available only in secure contexts.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/mediaKeys)\n     */\n    readonly mediaKeys: MediaKeys | null;\n    /**\n     * The **`HTMLMediaElement.muted`** property indicates whether the media element is muted.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/muted)\n     */\n    muted: boolean;\n    /**\n     * The **`HTMLMediaElement.networkState`** property indicates the current state of the fetching of media over the network.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/networkState)\n     */\n    readonly networkState: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/encrypted_event) */\n    onencrypted: ((this: HTMLMediaElement, ev: MediaEncryptedEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/waitingforkey_event) */\n    onwaitingforkey: ((this: HTMLMediaElement, ev: Event) => any) | null;\n    /**\n     * The read-only **`HTMLMediaElement.paused`** property tells whether the media element is paused.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/paused)\n     */\n    readonly paused: boolean;\n    /**\n     * The **`HTMLMediaElement.playbackRate`** property sets the rate at which the media is being played back.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/playbackRate)\n     */\n    playbackRate: number;\n    /**\n     * The **`played`** read-only property of the HTMLMediaElement interface indicates the time ranges the resource, an audio or video media file, has played.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/played)\n     */\n    readonly played: TimeRanges;\n    /**\n     * The **`preload`** property of the HTMLMediaElement interface is a string that provides a hint to the browser about what the author thinks will lead to the best user experience.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/preload)\n     */\n    preload: \"none\" | \"metadata\" | \"auto\" | \"\";\n    /**\n     * The **`HTMLMediaElement.preservesPitch`** property determines whether or not the browser should adjust the pitch of the audio to compensate for changes to the playback rate made by setting HTMLMediaElement.playbackRate.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/preservesPitch)\n     */\n    preservesPitch: boolean;\n    /**\n     * The **`HTMLMediaElement.readyState`** property indicates the readiness state of the media.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/readyState)\n     */\n    readonly readyState: number;\n    /**\n     * The **`remote`** read-only property of the HTMLMediaElement interface returns the RemotePlayback object associated with the media element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/remote)\n     */\n    readonly remote: RemotePlayback;\n    /**\n     * The **`seekable`** read-only property of HTMLMediaElement objects returns a new static normalized `TimeRanges` object that represents the ranges of the media resource, if any, that the user agent is able to seek to at the time `seekable` property is accessed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/seekable)\n     */\n    readonly seekable: TimeRanges;\n    /**\n     * The **`seeking`** read-only property of the HTMLMediaElement interface is a Boolean indicating whether the resource, the audio or video, is in the process of seeking to a new position.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/seeking)\n     */\n    readonly seeking: boolean;\n    /**\n     * The **`sinkId`** read-only property of the HTMLMediaElement interface returns a string that is the unique ID of the device to be used for playing audio output.\n     * Available only in secure contexts.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/sinkId)\n     */\n    readonly sinkId: string;\n    /**\n     * The **`HTMLMediaElement.src`** property reflects the value of the HTML media element's `src` attribute, which indicates the URL of a media resource to use in the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/src)\n     */\n    src: string;\n    /**\n     * The **`srcObject`** property of the the source of the media associated with the HTMLMediaElement, or `null` if not assigned.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/srcObject)\n     */\n    srcObject: MediaProvider | null;\n    /**\n     * The read-only **`textTracks`** property on HTMLMediaElement objects returns a objects representing the media element's text tracks, in the same order as in the list of text tracks.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/textTracks)\n     */\n    readonly textTracks: TextTrackList;\n    /**\n     * The **`HTMLMediaElement.volume`** property sets the volume at which the media will be played.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/volume)\n     */\n    volume: number;\n    /**\n     * The **`addTextTrack()`** method of the HTMLMediaElement interface creates a new TextTrack object and adds it to the media element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/addTextTrack)\n     */\n    addTextTrack(kind: TextTrackKind, label?: string, language?: string): TextTrack;\n    /**\n     * The HTMLMediaElement method **`canPlayType()`** reports how likely it is that the current browser will be able to play media of a given MIME type.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/canPlayType)\n     */\n    canPlayType(type: string): CanPlayTypeResult;\n    /**\n     * The **`HTMLMediaElement.fastSeek()`** method quickly seeks the media to the new time with precision tradeoff.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/fastSeek)\n     */\n    fastSeek(time: number): void;\n    /**\n     * The HTMLMediaElement method **`load()`** resets the media element to its initial state and begins the process of selecting a media source and loading the media in preparation for playback to begin at the beginning.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/load)\n     */\n    load(): void;\n    /**\n     * The **`HTMLMediaElement.pause()`** method will pause playback of the media, if the media is already in a paused state this method will have no effect.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/pause)\n     */\n    pause(): void;\n    /**\n     * The HTMLMediaElement **`play()`** method attempts to begin playback of the media.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/play)\n     */\n    play(): Promise<void>;\n    /**\n     * The **`setMediaKeys()`** method of the HTMLMediaElement interface sets the MediaKeys that will be used to decrypt media during playback.\n     * Available only in secure contexts.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/setMediaKeys)\n     */\n    setMediaKeys(mediaKeys: MediaKeys | null): Promise<void>;\n    /**\n     * The **`setSinkId()`** method of the HTMLMediaElement interface sets the ID of the audio device to use for output and returns a Promise.\n     * Available only in secure contexts.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMediaElement/setSinkId)\n     */\n    setSinkId(sinkId: string): Promise<void>;\n    readonly NETWORK_EMPTY: 0;\n    readonly NETWORK_IDLE: 1;\n    readonly NETWORK_LOADING: 2;\n    readonly NETWORK_NO_SOURCE: 3;\n    readonly HAVE_NOTHING: 0;\n    readonly HAVE_METADATA: 1;\n    readonly HAVE_CURRENT_DATA: 2;\n    readonly HAVE_FUTURE_DATA: 3;\n    readonly HAVE_ENOUGH_DATA: 4;\n    addEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLMediaElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLMediaElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLMediaElement: {\n    prototype: HTMLMediaElement;\n    new(): HTMLMediaElement;\n    readonly NETWORK_EMPTY: 0;\n    readonly NETWORK_IDLE: 1;\n    readonly NETWORK_LOADING: 2;\n    readonly NETWORK_NO_SOURCE: 3;\n    readonly HAVE_NOTHING: 0;\n    readonly HAVE_METADATA: 1;\n    readonly HAVE_CURRENT_DATA: 2;\n    readonly HAVE_FUTURE_DATA: 3;\n    readonly HAVE_ENOUGH_DATA: 4;\n};\n\n/**\n * The **`HTMLMenuElement`** interface provides additional properties (beyond those inherited from the HTMLElement interface) for manipulating a menu element.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMenuElement)\n */\ninterface HTMLMenuElement extends HTMLElement {\n    /** @deprecated */\n    compact: boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMenuElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMenuElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLMenuElement: {\n    prototype: HTMLMenuElement;\n    new(): HTMLMenuElement;\n};\n\n/**\n * The **`HTMLMetaElement`** interface contains descriptive metadata about a document provided in HTML as `<meta>` elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMetaElement)\n */\ninterface HTMLMetaElement extends HTMLElement {\n    /**\n     * The **`HTMLMetaElement.content`** property gets or sets the `content` attribute of pragma directives and named meta data in conjunction with HTMLMetaElement.name or HTMLMetaElement.httpEquiv.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMetaElement/content)\n     */\n    content: string;\n    /**\n     * The **`HTMLMetaElement.httpEquiv`** property gets or sets the pragma directive or an HTTP response header name for the HTMLMetaElement.content attribute.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMetaElement/httpEquiv)\n     */\n    httpEquiv: string;\n    /**\n     * The **`HTMLMetaElement.media`** property enables specifying the media for `theme-color` metadata.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMetaElement/media)\n     */\n    media: string;\n    /**\n     * The **`HTMLMetaElement.name`** property is used in combination with HTMLMetaElement.content to define the name-value pairs for the metadata of a document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMetaElement/name)\n     */\n    name: string;\n    /**\n     * The **`HTMLMetaElement.scheme`** property defines the scheme of the value in the HTMLMetaElement.content attribute.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMetaElement/scheme)\n     */\n    scheme: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMetaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMetaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLMetaElement: {\n    prototype: HTMLMetaElement;\n    new(): HTMLMetaElement;\n};\n\n/**\n * The HTML meter elements expose the **`HTMLMeterElement`** interface, which provides special properties and methods (beyond the HTMLElement object interface they also have available to them by inheritance) for manipulating the layout and presentation of meter elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMeterElement)\n */\ninterface HTMLMeterElement extends HTMLElement {\n    /**\n     * The **`high`** property of the HTMLMeterElement interface represents the high boundary of the meter element as a floating-point number.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMeterElement/high)\n     */\n    high: number;\n    /**\n     * The **`HTMLMeterElement.labels`** read-only property returns a A NodeList containing the `<label>` elements associated with the `<meter>` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMeterElement/labels)\n     */\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    /**\n     * The **`low`** property of the HTMLMeterElement interface represents the low boundary of the meter element as a floating-point number.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMeterElement/low)\n     */\n    low: number;\n    /**\n     * The **`max`** property of the HTMLMeterElement interface represents the maximum value of the meter element as a floating-point number.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMeterElement/max)\n     */\n    max: number;\n    /**\n     * The **`min`** property of the HTMLMeterElement interface represents the minimum value of the meter element as a floating-point number.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMeterElement/min)\n     */\n    min: number;\n    /**\n     * The **`optimum`** property of the HTMLMeterElement interface represents the optimum boundary of the meter element as a floating-point number.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMeterElement/optimum)\n     */\n    optimum: number;\n    /**\n     * The **`value`** property of the HTMLMeterElement interface represents the current value of the meter element as a floating-point number.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLMeterElement/value)\n     */\n    value: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMeterElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMeterElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLMeterElement: {\n    prototype: HTMLMeterElement;\n    new(): HTMLMeterElement;\n};\n\n/**\n * The **`HTMLModElement`** interface provides special properties (beyond the regular methods and properties available through the HTMLElement interface they also have available to them by inheritance) for manipulating modification elements, that is del and ins.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLModElement)\n */\ninterface HTMLModElement extends HTMLElement {\n    /**\n     * The **`cite`** property of the HTMLModElement interface indicates the URL of the resource explaining the modification.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLModElement/cite)\n     */\n    cite: string;\n    /**\n     * The **`dateTime`** property of the HTMLModElement interface is a string containing a machine-readable date with an optional time value.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLModElement/dateTime)\n     */\n    dateTime: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLModElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLModElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLModElement: {\n    prototype: HTMLModElement;\n    new(): HTMLModElement;\n};\n\n/**\n * The **`HTMLOListElement`** interface provides special properties (beyond those defined on the regular HTMLElement interface it also has available to it by inheritance) for manipulating ordered list elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOListElement)\n */\ninterface HTMLOListElement extends HTMLElement {\n    /** @deprecated */\n    compact: boolean;\n    /**\n     * The **`reversed`** property of the HTMLOListElement interface indicates order of a list.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOListElement/reversed)\n     */\n    reversed: boolean;\n    /**\n     * The **`start`** property of the HTMLOListElement interface indicates starting value of the ordered list, with default value of 1.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOListElement/start)\n     */\n    start: number;\n    /**\n     * The **`type`** property of the HTMLOListElement interface indicates the kind of marker to be used to display ordered list.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOListElement/type)\n     */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLOListElement: {\n    prototype: HTMLOListElement;\n    new(): HTMLOListElement;\n};\n\n/**\n * The **`HTMLObjectElement`** interface provides special properties and methods (beyond those on the HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of object element, representing external resources.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement)\n */\ninterface HTMLObjectElement extends HTMLElement {\n    /** @deprecated */\n    align: string;\n    /** @deprecated */\n    archive: string;\n    /** @deprecated */\n    border: string;\n    /** @deprecated */\n    code: string;\n    /** @deprecated */\n    codeBase: string;\n    /** @deprecated */\n    codeType: string;\n    /**\n     * The **`contentDocument`** read-only property of the HTMLObjectElement interface Returns a Document representing the active document of the object element's nested browsing context, if any; otherwise null.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/contentDocument)\n     */\n    readonly contentDocument: Document | null;\n    /**\n     * The **`contentWindow`** read-only property of the HTMLObjectElement interface returns a WindowProxy representing the window proxy of the object element's nested browsing context, if any; otherwise null.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/contentWindow)\n     */\n    readonly contentWindow: WindowProxy | null;\n    /**\n     * The **`data`** property of the reflects the `data` HTML attribute, specifying the address of a resource's data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/data)\n     */\n    data: string;\n    /** @deprecated */\n    declare: boolean;\n    /**\n     * The **`form`** read-only property of the HTMLObjectElement interface returns an HTMLFormElement object that owns this object, or `null` if this object element is not owned by any form.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/form)\n     */\n    readonly form: HTMLFormElement | null;\n    /**\n     * The **`height`** property of the reflects the `height` HTML attribute, specifying the displayed height of the resource in CSS pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/height)\n     */\n    height: string;\n    /** @deprecated */\n    hspace: number;\n    /**\n     * The **`name`** property of the reflects the `name` HTML attribute, specifying the name of the browsing context.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/name)\n     */\n    name: string;\n    /** @deprecated */\n    standby: string;\n    /**\n     * The **`type`** property of the reflects the `type` HTML attribute, specifying the MIME type of the resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/type)\n     */\n    type: string;\n    /**\n     * The **`useMap`** property of the reflects the `usemap` HTML attribute, specifying a A string.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/useMap)\n     */\n    useMap: string;\n    /**\n     * The **`validationMessage`** read-only property of the HTMLObjectElement interface returns a string representing a localized message that describes the validation constraints that the control does not satisfy (if any).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/validationMessage)\n     */\n    readonly validationMessage: string;\n    /**\n     * The **`validity`** read-only property of the HTMLObjectElement interface returns a ValidityState object that represents the validity states this element is in.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/validity)\n     */\n    readonly validity: ValidityState;\n    /** @deprecated */\n    vspace: number;\n    /**\n     * The **`width`** property of the reflects the `width` HTML attribute, specifying the displayed width of the resource in CSS pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/width)\n     */\n    width: string;\n    /**\n     * The **`willValidate`** read-only property of the HTMLObjectElement interface returns `false`, because object elements are not candidates for constraint validation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/willValidate)\n     */\n    readonly willValidate: boolean;\n    /**\n     * The **`checkValidity()`** method of the HTMLObjectElement interface checks if the element is valid, but always returns true because object elements are never candidates for constraint validation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/checkValidity)\n     */\n    checkValidity(): boolean;\n    /**\n     * The **`getSVGDocument()`** method of the HTMLObjectElement interface returns the Document object of the embedded SVG.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/getSVGDocument)\n     */\n    getSVGDocument(): Document | null;\n    /**\n     * The **`reportValidity()`** method of the HTMLObjectElement interface performs the same validity checking steps as the HTMLObjectElement.checkValidity method.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/reportValidity)\n     */\n    reportValidity(): boolean;\n    /**\n     * The **`setCustomValidity()`** method of the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLObjectElement/setCustomValidity)\n     */\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLObjectElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLObjectElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLObjectElement: {\n    prototype: HTMLObjectElement;\n    new(): HTMLObjectElement;\n};\n\n/**\n * The **`HTMLOptGroupElement`** interface provides special properties and methods (beyond the regular HTMLElement object interface they also have available to them by inheritance) for manipulating the layout and presentation of optgroup elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptGroupElement)\n */\ninterface HTMLOptGroupElement extends HTMLElement {\n    /**\n     * The **`disabled`** property of the HTMLOptGroupElement interface is a boolean value that reflects the optgroup element's `disabled` attribute, which indicates whether the control is disabled.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptGroupElement/disabled)\n     */\n    disabled: boolean;\n    /**\n     * The **`label`** property of the HTMLOptGroupElement interface is a string value that reflects the optgroup element's `label` attribute, which provides a textual label to the group of options.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptGroupElement/label)\n     */\n    label: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptGroupElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptGroupElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLOptGroupElement: {\n    prototype: HTMLOptGroupElement;\n    new(): HTMLOptGroupElement;\n};\n\n/**\n * The **`HTMLOptionElement`** interface represents option elements and inherits all properties and methods of the HTMLElement interface.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement)\n */\ninterface HTMLOptionElement extends HTMLElement {\n    /**\n     * The **`defaultSelected`** property of the HTMLOptionElement interface specifies the default selected state of the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement/defaultSelected)\n     */\n    defaultSelected: boolean;\n    /**\n     * The **`disabled`** property of the HTMLOptionElement is a boolean value that indicates whether the option element is unavailable to be selected.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement/disabled)\n     */\n    disabled: boolean;\n    /**\n     * The **`form`** read-only property of the HTMLOptionElement interface returns an HTMLFormElement object that owns the HTMLSelectElement associated with this option, or `null` if this option is not associated with a select owned by a form.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement/form)\n     */\n    readonly form: HTMLFormElement | null;\n    /**\n     * The read-only **`index`** property of the HTMLOptionElement interface specifies the 0-based index of the element; that is, the position of the option within the list of options it belongs to, in tree-order, as an integer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement/index)\n     */\n    readonly index: number;\n    /**\n     * The **`label`** property of the HTMLOptionElement represents the text displayed for an option in a select element or as part of a list of suggestions in a datalist element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement/label)\n     */\n    label: string;\n    /**\n     * The **`selected`** property of the HTMLOptionElement interface specifies the current selectedness of the element; that is, whether the option is selected or not.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement/selected)\n     */\n    selected: boolean;\n    /**\n     * The **`text`** property of the HTMLOptionElement represents the text inside the option element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement/text)\n     */\n    text: string;\n    /**\n     * The **`value`** property of the HTMLOptionElement interface represents the value of the option element as a string, or the empty string if no value is set.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionElement/value)\n     */\n    value: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLOptionElement: {\n    prototype: HTMLOptionElement;\n    new(): HTMLOptionElement;\n};\n\n/**\n * The **`HTMLOptionsCollection`** interface represents a collection of `<option>` HTML elements (in document order) and offers methods and properties for selecting from the list as well as optionally altering its items.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionsCollection)\n */\ninterface HTMLOptionsCollection extends HTMLCollectionOf<HTMLOptionElement> {\n    /**\n     * The **`length`** property of the HTMLOptionsCollection interface returns the number of option elements in the collection.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionsCollection/length)\n     */\n    length: number;\n    /**\n     * The **`selectedIndex`** property of the HTMLOptionsCollection interface is the numeric index of the first selected option element, if any, or `−1` if no `<option>` is selected.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionsCollection/selectedIndex)\n     */\n    selectedIndex: number;\n    /**\n     * The **`add()`** method of the HTMLOptionsCollection interface adds an HTMLOptionElement or HTMLOptGroupElement to this `HTMLOptionsCollection`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionsCollection/add)\n     */\n    add(element: HTMLOptionElement | HTMLOptGroupElement, before?: HTMLElement | number | null): void;\n    /**\n     * The **`remove()`** method of the HTMLOptionsCollection interface removes the option element specified by the index from this collection.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOptionsCollection/remove)\n     */\n    remove(index: number): void;\n}\n\ndeclare var HTMLOptionsCollection: {\n    prototype: HTMLOptionsCollection;\n    new(): HTMLOptionsCollection;\n};\n\ninterface HTMLOrSVGElement {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/autofocus) */\n    autofocus: boolean;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/dataset) */\n    readonly dataset: DOMStringMap;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/nonce) */\n    nonce?: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/tabIndex) */\n    tabIndex: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/blur) */\n    blur(): void;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLElement/focus) */\n    focus(options?: FocusOptions): void;\n}\n\n/**\n * The **`HTMLOutputElement`** interface provides properties and methods (beyond those inherited from HTMLElement) for manipulating the layout and presentation of output elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement)\n */\ninterface HTMLOutputElement extends HTMLElement {\n    /**\n     * The **`defaultValue`** property of the HTMLOutputElement interface represents the default text content of this output element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/defaultValue)\n     */\n    defaultValue: string;\n    /**\n     * The **`form`** read-only property of the HTMLOutputElement interface returns an HTMLFormElement object that owns this output, or `null` if this output is not owned by any form.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/form)\n     */\n    readonly form: HTMLFormElement | null;\n    /**\n     * The **`htmlFor`** property of the HTMLOutputElement interface is a string containing a space-separated list of other elements' `id`s, indicating that those elements contributed input values to (or otherwise affected) the calculation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/htmlFor)\n     */\n    get htmlFor(): DOMTokenList;\n    set htmlFor(value: string);\n    /**\n     * The **`HTMLOutputElement.labels`** read-only property returns a A NodeList containing the `<label>` elements associated with the `<output>` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/labels)\n     */\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    /**\n     * The **`name`** property of the HTMLOutputElement interface indicates the name of the output element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/name)\n     */\n    name: string;\n    /**\n     * The **`type`** read-only property of the HTMLOutputElement interface returns the string `'output'`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/type)\n     */\n    readonly type: string;\n    /**\n     * The **`validationMessage`** read-only property of the HTMLOutputElement interface returns a string representing a localized message that describes the validation constraints that the output control does not satisfy (if any).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/validationMessage)\n     */\n    readonly validationMessage: string;\n    /**\n     * The **`validity`** read-only property of the HTMLOutputElement interface returns a ValidityState object that represents the validity states this element is in.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/validity)\n     */\n    readonly validity: ValidityState;\n    /**\n     * The **`value`** property of the HTMLOutputElement interface represents the value of the output element as a string, or the empty string if no value is set.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/value)\n     */\n    value: string;\n    /**\n     * The **`willValidate`** read-only property of the HTMLOutputElement interface returns `false`, because output elements are not candidates for constraint validation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/willValidate)\n     */\n    readonly willValidate: boolean;\n    /**\n     * The **`checkValidity()`** method of the HTMLOutputElement interface checks if the element is valid, but always returns true because output elements are never candidates for constraint validation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/checkValidity)\n     */\n    checkValidity(): boolean;\n    /**\n     * The **`reportValidity()`** method of the HTMLOutputElement interface performs the same validity checking steps as the HTMLOutputElement.checkValidity method.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/reportValidity)\n     */\n    reportValidity(): boolean;\n    /**\n     * The **`setCustomValidity()`** method of the HTMLOutputElement interface sets the custom validity message for the output element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLOutputElement/setCustomValidity)\n     */\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOutputElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOutputElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLOutputElement: {\n    prototype: HTMLOutputElement;\n    new(): HTMLOutputElement;\n};\n\n/**\n * The **`HTMLParagraphElement`** interface provides special properties (beyond those of the regular HTMLElement object interface it inherits) for manipulating p elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLParagraphElement)\n */\ninterface HTMLParagraphElement extends HTMLElement {\n    /** @deprecated */\n    align: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParagraphElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParagraphElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLParagraphElement: {\n    prototype: HTMLParagraphElement;\n    new(): HTMLParagraphElement;\n};\n\n/**\n * The **`HTMLParamElement`** interface provides special properties (beyond those of the regular HTMLElement object interface it inherits) for manipulating param elements, representing a pair of a key and a value that acts as a parameter for an object element.\n * @deprecated\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLParamElement)\n */\ninterface HTMLParamElement extends HTMLElement {\n    /** @deprecated */\n    name: string;\n    /** @deprecated */\n    type: string;\n    /** @deprecated */\n    value: string;\n    /** @deprecated */\n    valueType: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParamElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParamElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/** @deprecated */\ndeclare var HTMLParamElement: {\n    prototype: HTMLParamElement;\n    new(): HTMLParamElement;\n};\n\n/**\n * The **`HTMLPictureElement`** interface represents a picture HTML element.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLPictureElement)\n */\ninterface HTMLPictureElement extends HTMLElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPictureElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPictureElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLPictureElement: {\n    prototype: HTMLPictureElement;\n    new(): HTMLPictureElement;\n};\n\n/**\n * The **`HTMLPreElement`** interface exposes specific properties and methods (beyond those of the HTMLElement interface it also has available to it by inheritance) for manipulating a block of preformatted text (pre).\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLPreElement)\n */\ninterface HTMLPreElement extends HTMLElement {\n    /** @deprecated */\n    width: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPreElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPreElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLPreElement: {\n    prototype: HTMLPreElement;\n    new(): HTMLPreElement;\n};\n\n/**\n * The **`HTMLProgressElement`** interface provides special properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of progress elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLProgressElement)\n */\ninterface HTMLProgressElement extends HTMLElement {\n    /**\n     * The **`HTMLProgressElement.labels`** read-only property returns a NodeList of the label elements associated with the A NodeList containing the `<label>` elements associated with the `<progress>` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLProgressElement/labels)\n     */\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    /**\n     * The **`max`** property of the HTMLProgressElement interface represents the upper bound of the progress element's range.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLProgressElement/max)\n     */\n    max: number;\n    /**\n     * The **`position`** read-only property of the HTMLProgressElement interface returns current progress of the progress element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLProgressElement/position)\n     */\n    readonly position: number;\n    /**\n     * The **`value`** property of the HTMLProgressElement interface represents the current progress of the progress element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLProgressElement/value)\n     */\n    value: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLProgressElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLProgressElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLProgressElement: {\n    prototype: HTMLProgressElement;\n    new(): HTMLProgressElement;\n};\n\n/**\n * The **`HTMLQuoteElement`** interface provides special properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating quoting elements, like blockquote and q, but not the cite element.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLQuoteElement)\n */\ninterface HTMLQuoteElement extends HTMLElement {\n    /**\n     * The **`cite`** property of the HTMLQuoteElement interface indicates the URL for the source of the quotation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLQuoteElement/cite)\n     */\n    cite: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLQuoteElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLQuoteElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLQuoteElement: {\n    prototype: HTMLQuoteElement;\n    new(): HTMLQuoteElement;\n};\n\n/**\n * HTML script elements expose the **`HTMLScriptElement`** interface, which provides special properties and methods for manipulating the behavior and execution of `<script>` elements (beyond the inherited HTMLElement interface).\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement)\n */\ninterface HTMLScriptElement extends HTMLElement {\n    /**\n     * The **`async`** property of the HTMLScriptElement interface is a boolean value that controls how the script should be executed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement/async)\n     */\n    async: boolean;\n    /**\n     * The **`blocking`** property of the HTMLScriptElement interface is a string indicating that certain operations should be blocked on the fetching of the script.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement/blocking)\n     */\n    get blocking(): DOMTokenList;\n    set blocking(value: string);\n    /** @deprecated */\n    charset: string;\n    /**\n     * The **`crossOrigin`** property of the HTMLScriptElement interface reflects the CORS settings for the script element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement/crossOrigin)\n     */\n    crossOrigin: string | null;\n    /**\n     * The **`defer`** property of the HTMLScriptElement interface is a boolean value that controls how the script should be executed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement/defer)\n     */\n    defer: boolean;\n    /** @deprecated */\n    event: string;\n    /**\n     * The **`fetchPriority`** property of the HTMLScriptElement interface represents a hint to the browser indicating how it should prioritize fetching an external script relative to other external scripts.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement/fetchPriority)\n     */\n    fetchPriority: \"high\" | \"low\" | \"auto\";\n    /** @deprecated */\n    htmlFor: string;\n    /**\n     * The **`integrity`** property of the HTMLScriptElement interface is a string that contains inline metadata that a browser can use to verify that a fetched resource has been delivered without unexpected manipulation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement/integrity)\n     */\n    integrity: string;\n    /**\n     * The **`noModule`** property of the HTMLScriptElement interface is a boolean value that indicates whether the script should be executed in browsers that support ES modules.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement/noModule)\n     */\n    noModule: boolean;\n    /**\n     * The **`referrerPolicy`** property of the `referrerpolicy` of the script element, which defines how the referrer is set when fetching the script and any scripts it imports.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement/referrerPolicy)\n     */\n    referrerPolicy: string;\n    /**\n     * The **`src`** property of the HTMLScriptElement interface is a string representing the URL of an external script; this can be used as an alternative to embedding a script directly within a document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement/src)\n     */\n    src: string;\n    /**\n     * The **`text`** property of the HTMLScriptElement interface is a string that reflects the text content inside the script element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement/text)\n     */\n    text: string;\n    /**\n     * The **`type`** property of the HTMLScriptElement interface is a string that reflects the type of the script.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement/type)\n     */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLScriptElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLScriptElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLScriptElement: {\n    prototype: HTMLScriptElement;\n    new(): HTMLScriptElement;\n    /**\n     * The **`supports()`** static method of the HTMLScriptElement interface provides a simple and consistent method to feature-detect what types of scripts are supported by the user agent.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLScriptElement/supports_static)\n     */\n    supports(type: string): boolean;\n};\n\n/**\n * The **`HTMLSelectElement`** interface represents a select HTML Element.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement)\n */\ninterface HTMLSelectElement extends HTMLElement {\n    /**\n     * The **`autocomplete`** property of the HTMLSelectElement interface indicates whether the value of the control can be automatically completed by the browser.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/autocomplete)\n     */\n    autocomplete: AutoFill;\n    /**\n     * The **`HTMLSelectElement.disabled`** property is a boolean value that reflects the `disabled` HTML attribute, which indicates whether the control is disabled.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/disabled)\n     */\n    disabled: boolean;\n    /**\n     * The **`form`** read-only property of the HTMLSelectElement interface returns an HTMLFormElement object that owns this select, or `null` if this select is not owned by any form.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/form)\n     */\n    readonly form: HTMLFormElement | null;\n    /**\n     * The **`HTMLSelectElement.labels`** read-only property returns a A NodeList containing the `<label>` elements associated with the `<select>` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/labels)\n     */\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    /**\n     * The **`length`** property of the HTMLSelectElement interface specifies the number of option elements in the select element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/length)\n     */\n    length: number;\n    /**\n     * The **`multiple`** property of the HTMLSelectElement interface specifies that the user may select more than one option from the list of options.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/multiple)\n     */\n    multiple: boolean;\n    /**\n     * The **`name`** property of the HTMLSelectElement interface indicates the name of the select element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/name)\n     */\n    name: string;\n    /**\n     * The **`HTMLSelectElement.options`** read-only property returns a HTMLOptionsCollection of the option elements contained by the select element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/options)\n     */\n    readonly options: HTMLOptionsCollection;\n    /**\n     * The **`required`** property of the HTMLSelectElement interface specifies that the user must select an option with a non-empty string value before submitting a form.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/required)\n     */\n    required: boolean;\n    /**\n     * The **`selectedIndex`** property of the HTMLSelectElement interface is the numeric index of the first selected option element in a select element, if any, or `−1` if no `<option>` is selected.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/selectedIndex)\n     */\n    selectedIndex: number;\n    /**\n     * The **read-only** HTMLSelectElement property **`selectedOptions`** contains a list of the element that are currently selected.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/selectedOptions)\n     */\n    readonly selectedOptions: HTMLCollectionOf<HTMLOptionElement>;\n    /**\n     * The **`size`** property of the HTMLSelectElement interface specifies the number of options, or rows, that should be visible at one time.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/size)\n     */\n    size: number;\n    /**\n     * The **`HTMLSelectElement.type`** read-only property returns the form control's `type`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/type)\n     */\n    readonly type: \"select-one\" | \"select-multiple\";\n    /**\n     * The **`validationMessage`** read-only property of the HTMLSelectElement interface returns a string representing a localized message that describes the validation constraints that the select control does not satisfy (if any).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/validationMessage)\n     */\n    readonly validationMessage: string;\n    /**\n     * The **`validity`** read-only property of the HTMLSelectElement interface returns a ValidityState object that represents the validity states this element is in.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/validity)\n     */\n    readonly validity: ValidityState;\n    /**\n     * The **`HTMLSelectElement.value`** property contains the value of the first selected option element associated with this select element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/value)\n     */\n    value: string;\n    /**\n     * The **`willValidate`** read-only property of the HTMLSelectElement interface indicates whether the select element is a candidate for constraint validation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/willValidate)\n     */\n    readonly willValidate: boolean;\n    /**\n     * The **`HTMLSelectElement.add()`** method adds an element to the collection of `option` elements for this `select` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/add)\n     */\n    add(element: HTMLOptionElement | HTMLOptGroupElement, before?: HTMLElement | number | null): void;\n    /**\n     * The **`checkValidity()`** method of the HTMLSelectElement interface returns a boolean value which indicates if the element meets any constraint validation rules applied to it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/checkValidity)\n     */\n    checkValidity(): boolean;\n    /**\n     * The **`HTMLSelectElement.item()`** method returns the position in the options list corresponds to the index given in the parameter, or `null` if there are none.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/item)\n     */\n    item(index: number): HTMLOptionElement | null;\n    /**\n     * The **`HTMLSelectElement.namedItem()`** method returns the whose `name` or `id` match the specified name, or `null` if no option matches.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/namedItem)\n     */\n    namedItem(name: string): HTMLOptionElement | null;\n    /**\n     * The **`HTMLSelectElement.remove()`** method removes the element at the specified index from the options collection for this select element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/remove)\n     */\n    remove(): void;\n    remove(index: number): void;\n    /**\n     * The **`reportValidity()`** method of the HTMLSelectElement interface performs the same validity checking steps as the HTMLSelectElement.checkValidity method.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/reportValidity)\n     */\n    reportValidity(): boolean;\n    /**\n     * The **`HTMLSelectElement.setCustomValidity()`** method sets the custom validity message for the selection element to the specified message.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/setCustomValidity)\n     */\n    setCustomValidity(error: string): void;\n    /**\n     * The **`HTMLSelectElement.showPicker()`** method displays the browser picker for a `select` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSelectElement/showPicker)\n     */\n    showPicker(): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSelectElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSelectElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n    [name: number]: HTMLOptionElement | HTMLOptGroupElement;\n}\n\ndeclare var HTMLSelectElement: {\n    prototype: HTMLSelectElement;\n    new(): HTMLSelectElement;\n};\n\n/**\n * The **`HTMLSlotElement`** interface of the Shadow DOM API enables access to the name and assigned nodes of an HTML slot element.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSlotElement)\n */\ninterface HTMLSlotElement extends HTMLElement {\n    /**\n     * The **`name`** property of the HTMLSlotElement interface returns or sets the slot name.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSlotElement/name)\n     */\n    name: string;\n    /**\n     * The **`assign()`** method of the HTMLSlotElement interface sets the slot's _manually assigned nodes_ to an ordered set of slottables.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSlotElement/assign)\n     */\n    assign(...nodes: (Element | Text)[]): void;\n    /**\n     * The **`assignedElements()`** method of the HTMLSlotElement interface returns a sequence of the elements assigned to this slot (and no other nodes).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSlotElement/assignedElements)\n     */\n    assignedElements(options?: AssignedNodesOptions): Element[];\n    /**\n     * The **`assignedNodes()`** method of the HTMLSlotElement interface returns a sequence of the nodes assigned to this slot.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSlotElement/assignedNodes)\n     */\n    assignedNodes(options?: AssignedNodesOptions): Node[];\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSlotElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSlotElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLSlotElement: {\n    prototype: HTMLSlotElement;\n    new(): HTMLSlotElement;\n};\n\n/**\n * The **`HTMLSourceElement`** interface provides special properties (beyond the regular HTMLElement object interface it also has available to it by inheritance) for manipulating source elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSourceElement)\n */\ninterface HTMLSourceElement extends HTMLElement {\n    /**\n     * The **`height`** property of the HTMLSourceElement interface is a non-negative number indicating the height of the image resource in CSS pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSourceElement/height)\n     */\n    height: number;\n    /**\n     * The **`media`** property of the HTMLSourceElement interface is a string representing the intended destination medium for the resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSourceElement/media)\n     */\n    media: string;\n    /**\n     * The **`sizes`** property of the HTMLSourceElement interface is a string representing a list of one or more sizes, representing sizes between breakpoints, to which the resource applies.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSourceElement/sizes)\n     */\n    sizes: string;\n    /**\n     * The **`src`** property of the HTMLSourceElement interface is a string indicating the URL of a media resource to use as the source for the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSourceElement/src)\n     */\n    src: string;\n    /**\n     * The **`srcset`** property of the HTMLSourceElement interface is a string containing a comma-separated list of candidate images.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSourceElement/srcset)\n     */\n    srcset: string;\n    /**\n     * The **`type`** property of the HTMLSourceElement interface is a string representing the MIME type of the media resource.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSourceElement/type)\n     */\n    type: string;\n    /**\n     * The **`width`** property of the HTMLSourceElement interface is a non-negative number indicating the width of the image resource in CSS pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSourceElement/width)\n     */\n    width: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSourceElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSourceElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLSourceElement: {\n    prototype: HTMLSourceElement;\n    new(): HTMLSourceElement;\n};\n\n/**\n * The **`HTMLSpanElement`** interface represents a span element and derives from the HTMLElement interface, but without implementing any additional properties or methods.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLSpanElement)\n */\ninterface HTMLSpanElement extends HTMLElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSpanElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSpanElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLSpanElement: {\n    prototype: HTMLSpanElement;\n    new(): HTMLSpanElement;\n};\n\n/**\n * The **`HTMLStyleElement`** interface represents a style element.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLStyleElement)\n */\ninterface HTMLStyleElement extends HTMLElement, LinkStyle {\n    /**\n     * The **`blocking`** property of the HTMLStyleElement interface is a string indicating that certain operations should be blocked on the fetching of critical subresources.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLStyleElement/blocking)\n     */\n    get blocking(): DOMTokenList;\n    set blocking(value: string);\n    /**\n     * The **`HTMLStyleElement.disabled`** property can be used to get and set whether the stylesheet is disabled (`true`) or not (`false`).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLStyleElement/disabled)\n     */\n    disabled: boolean;\n    /**\n     * The **`HTMLStyleElement.media`** property specifies the intended destination medium for style information.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLStyleElement/media)\n     */\n    media: string;\n    /**\n     * The **`HTMLStyleElement.type`** property returns the type of the current style.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLStyleElement/type)\n     */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLStyleElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLStyleElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLStyleElement: {\n    prototype: HTMLStyleElement;\n    new(): HTMLStyleElement;\n};\n\n/**\n * The **`HTMLTableCaptionElement`** interface provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating table caption elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCaptionElement)\n */\ninterface HTMLTableCaptionElement extends HTMLElement {\n    /**\n     * The **`align`** property of the HTMLTableCaptionElement interface is a string indicating how to horizontally align text in the caption table element.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCaptionElement/align)\n     */\n    align: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCaptionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCaptionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableCaptionElement: {\n    prototype: HTMLTableCaptionElement;\n    new(): HTMLTableCaptionElement;\n};\n\n/**\n * The **`HTMLTableCellElement`** interface provides special properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of table cells, either header cells (th) or data cells (td), in an HTML document.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement)\n */\ninterface HTMLTableCellElement extends HTMLElement {\n    /**\n     * The **`abbr`** property of the HTMLTableCellElement interface indicates an abbreviation associated with the cell.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/abbr)\n     */\n    abbr: string;\n    /**\n     * The **`align`** property of the HTMLTableCellElement interface is a string indicating how to horizontally align text in the th or td table cell.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/align)\n     */\n    align: string;\n    /** @deprecated */\n    axis: string;\n    /**\n     * The **`HTMLTableCellElement.bgColor`** property is used to set the background color of a cell or get the value of the obsolete `bgColor` attribute, if present.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/bgColor)\n     */\n    bgColor: string;\n    /**\n     * The **`cellIndex`** read-only property of the HTMLTableCellElement interface represents the position of a cell within its row (tr).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/cellIndex)\n     */\n    readonly cellIndex: number;\n    /**\n     * The **`ch`** property of the HTMLTableCellElement interface does nothing.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/ch)\n     */\n    ch: string;\n    /**\n     * The **`chOff`** property of the HTMLTableCellElement interface does nothing.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/chOff)\n     */\n    chOff: string;\n    /**\n     * The **`colSpan`** read-only property of the HTMLTableCellElement interface represents the number of columns this cell must span; this lets the cell occupy space across multiple columns of the table.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/colSpan)\n     */\n    colSpan: number;\n    /**\n     * The **`headers`** property of the HTMLTableCellElement interface contains a list of IDs of th elements that are _headers_ for this specific cell.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/headers)\n     */\n    headers: string;\n    /** @deprecated */\n    height: string;\n    /**\n     * The **`noWrap`** property of the HTMLTableCellElement interface returns a Boolean value indicating if the text of the cell may be wrapped on several lines or not.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/noWrap)\n     */\n    noWrap: boolean;\n    /**\n     * The **`rowSpan`** read-only property of the HTMLTableCellElement interface represents the number of rows this cell must span; this lets the cell occupy space across multiple rows of the table.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/rowSpan)\n     */\n    rowSpan: number;\n    /**\n     * The **`scope`** property of the HTMLTableCellElement interface indicates the scope of a th cell.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/scope)\n     */\n    scope: string;\n    /**\n     * The **`vAlign`** property of the HTMLTableCellElement interface is a string indicating how to vertically align text in a th or td table cell.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableCellElement/vAlign)\n     */\n    vAlign: string;\n    /** @deprecated */\n    width: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableCellElement: {\n    prototype: HTMLTableCellElement;\n    new(): HTMLTableCellElement;\n};\n\n/**\n * The **`HTMLTableColElement`** interface provides properties for manipulating single or grouped table column elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableColElement)\n */\ninterface HTMLTableColElement extends HTMLElement {\n    /**\n     * The **`align`** property of the HTMLTableColElement interface is a string indicating how to horizontally align text in a table col column element.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableColElement/align)\n     */\n    align: string;\n    /**\n     * The **`ch`** property of the HTMLTableColElement interface does nothing.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableColElement/ch)\n     */\n    ch: string;\n    /**\n     * The **`chOff`** property of the HTMLTableColElement interface does nothing.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableColElement/chOff)\n     */\n    chOff: string;\n    /**\n     * The **`span`** read-only property of the HTMLTableColElement interface represents the number of columns this col or colgroup must span; this lets the column occupy space across multiple columns of the table.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableColElement/span)\n     */\n    span: number;\n    /**\n     * The **`vAlign`** property of the HTMLTableColElement interface is a string indicating how to vertically align text in a table col column element.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableColElement/vAlign)\n     */\n    vAlign: string;\n    /** @deprecated */\n    width: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableColElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableColElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableColElement: {\n    prototype: HTMLTableColElement;\n    new(): HTMLTableColElement;\n};\n\n/** @deprecated prefer HTMLTableCellElement */\ninterface HTMLTableDataCellElement extends HTMLTableCellElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableDataCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableDataCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/**\n * The **`HTMLTableElement`** interface provides special properties and methods (beyond the regular HTMLElement object interface it also has available to it by inheritance) for manipulating the layout and presentation of tables in an HTML document.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement)\n */\ninterface HTMLTableElement extends HTMLElement {\n    /**\n     * The **`HTMLTableElement.align`** property represents the alignment of the table.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/align)\n     */\n    align: string;\n    /**\n     * The **`bgcolor`** property of the HTMLTableElement represents the background color of the table.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/bgColor)\n     */\n    bgColor: string;\n    /**\n     * The **`HTMLTableElement.border`** property represents the border width of the table element.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/border)\n     */\n    border: string;\n    /**\n     * The **`HTMLTableElement.caption`** property represents the table caption.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/caption)\n     */\n    caption: HTMLTableCaptionElement | null;\n    /**\n     * The **`HTMLTableElement.cellPadding`** property represents the padding around the individual cells of the table.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/cellPadding)\n     */\n    cellPadding: string;\n    /**\n     * While you should instead use the CSS interface's **`cellSpacing`** property represents the spacing around the individual th and td elements representing a table's cells.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/cellSpacing)\n     */\n    cellSpacing: string;\n    /**\n     * The HTMLTableElement interface's **`frame`** property is a string that indicates which of the table's exterior borders should be drawn.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/frame)\n     */\n    frame: string;\n    /**\n     * The read-only HTMLTableElement property **`rows`** returns a live contained within any thead, tfoot, and Although the property itself is read-only, the returned object is live and allows the modification of its content.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/rows)\n     */\n    readonly rows: HTMLCollectionOf<HTMLTableRowElement>;\n    /**\n     * The **`HTMLTableElement.rules`** property indicates which cell borders to render in the table.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/rules)\n     */\n    rules: string;\n    /**\n     * The **`HTMLTableElement.summary`** property represents the table description.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/summary)\n     */\n    summary: string;\n    /**\n     * The **`HTMLTableElement.tBodies`** read-only property returns a live HTMLCollection of the bodies in a table.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/tBodies)\n     */\n    readonly tBodies: HTMLCollectionOf<HTMLTableSectionElement>;\n    /**\n     * The **`HTMLTableElement.tFoot`** property represents the `null` if there is no such element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/tFoot)\n     */\n    tFoot: HTMLTableSectionElement | null;\n    /**\n     * The **`HTMLTableElement.tHead`** represents the `null` if there is no such element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/tHead)\n     */\n    tHead: HTMLTableSectionElement | null;\n    /**\n     * The **`HTMLTableElement.width`** property represents the desired width of the table.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/width)\n     */\n    width: string;\n    /**\n     * The **`HTMLTableElement.createCaption()`** method returns the If no `<caption>` element exists on the table, this method creates it, and then returns it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/createCaption)\n     */\n    createCaption(): HTMLTableCaptionElement;\n    /**\n     * The **`createTBody()`** method of ```js-nolint createTBody() ``` None.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/createTBody)\n     */\n    createTBody(): HTMLTableSectionElement;\n    /**\n     * The **`createTFoot()`** method of associated with a given table.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/createTFoot)\n     */\n    createTFoot(): HTMLTableSectionElement;\n    /**\n     * The **`createTHead()`** method of associated with a given table.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/createTHead)\n     */\n    createTHead(): HTMLTableSectionElement;\n    /**\n     * The **`HTMLTableElement.deleteCaption()`** method removes the `<caption>` element associated with the table, this method does nothing.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/deleteCaption)\n     */\n    deleteCaption(): void;\n    /**\n     * The **`HTMLTableElement.deleteRow()`** method removes a specific row (tr) from a given table.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/deleteRow)\n     */\n    deleteRow(index: number): void;\n    /**\n     * The **`HTMLTableElement.deleteTFoot()`** method removes the ```js-nolint deleteTFoot() ``` None.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/deleteTFoot)\n     */\n    deleteTFoot(): void;\n    /**\n     * The **`HTMLTableElement.deleteTHead()`** removes the ```js-nolint deleteTHead() ``` None.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/deleteTHead)\n     */\n    deleteTHead(): void;\n    /**\n     * The **`insertRow()`** method of the HTMLTableElement interface inserts a new row (tr) in a given table, and returns a reference to the new row.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableElement/insertRow)\n     */\n    insertRow(index?: number): HTMLTableRowElement;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableElement: {\n    prototype: HTMLTableElement;\n    new(): HTMLTableElement;\n};\n\n/** @deprecated prefer HTMLTableCellElement */\ninterface HTMLTableHeaderCellElement extends HTMLTableCellElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableHeaderCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableHeaderCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\n/**\n * The **`HTMLTableRowElement`** interface provides special properties and methods (beyond the HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of rows in an HTML table.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement)\n */\ninterface HTMLTableRowElement extends HTMLElement {\n    /**\n     * The **`align`** property of the HTMLTableRowElement interface is a string indicating how to horizontally align text in the tr table row.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/align)\n     */\n    align: string;\n    /**\n     * The **`HTMLTableRowElement.bgColor`** property is used to set the background color of a row or retrieve the value of the obsolete `bgColor` attribute, if present.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/bgColor)\n     */\n    bgColor: string;\n    /**\n     * The **`cells`** read-only property of the HTMLTableRowElement interface returns a live HTMLCollection containing the cells in the row.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/cells)\n     */\n    readonly cells: HTMLCollectionOf<HTMLTableCellElement>;\n    /**\n     * The **`ch`** property of the HTMLTableRowElement interface does nothing.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/ch)\n     */\n    ch: string;\n    /**\n     * The **`chOff`** property of the HTMLTableRowElement interface does nothing.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/chOff)\n     */\n    chOff: string;\n    /**\n     * The **`rowIndex`** read-only property of the HTMLTableRowElement interface represents the position of a row within the whole table.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/rowIndex)\n     */\n    readonly rowIndex: number;\n    /**\n     * The **`sectionRowIndex`** read-only property of the HTMLTableRowElement interface represents the position of a row within the current section (thead, tbody, or tfoot).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/sectionRowIndex)\n     */\n    readonly sectionRowIndex: number;\n    /**\n     * The **`vAlign`** property of the HTMLTableRowElement interface is a string indicating how to vertically align text in a tr table row.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/vAlign)\n     */\n    vAlign: string;\n    /**\n     * The **`deleteCell()`** method of the HTMLTableRowElement interface removes a specific row cell from a given tr.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/deleteCell)\n     */\n    deleteCell(index: number): void;\n    /**\n     * The **`insertCell()`** method of the HTMLTableRowElement interface inserts a new cell (td) into a table row (tr) and returns a reference to the cell.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableRowElement/insertCell)\n     */\n    insertCell(index?: number): HTMLTableCellElement;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableRowElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableRowElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableRowElement: {\n    prototype: HTMLTableRowElement;\n    new(): HTMLTableRowElement;\n};\n\n/**\n * The **`HTMLTableSectionElement`** interface provides special properties and methods (beyond the HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of sections, that is headers, footers and bodies (thead, tfoot, and tbody, respectively) in an HTML table.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableSectionElement)\n */\ninterface HTMLTableSectionElement extends HTMLElement {\n    /**\n     * The **`align`** property of the HTMLTableSectionElement interface is a string indicating how to horizontally align text in a thead, tbody or tfoot table section.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableSectionElement/align)\n     */\n    align: string;\n    /**\n     * The **`ch`** property of the HTMLTableSectionElement interface does nothing.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableSectionElement/ch)\n     */\n    ch: string;\n    /**\n     * The **`chOff`** property of the HTMLTableSectionElement interface does nothing.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableSectionElement/chOff)\n     */\n    chOff: string;\n    /**\n     * The **`rows`** read-only property of the HTMLTableSectionElement interface returns a live HTMLCollection containing the rows in the section.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableSectionElement/rows)\n     */\n    readonly rows: HTMLCollectionOf<HTMLTableRowElement>;\n    /**\n     * The **`vAlign`** property of the HTMLTableSectionElement interface is a string indicating how to vertically align text in a thead, tbody or tfoot table section.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableSectionElement/vAlign)\n     */\n    vAlign: string;\n    /**\n     * The **`deleteRow()`** method of the HTMLTableSectionElement interface removes a specific row (tr) from a given section.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableSectionElement/deleteRow)\n     */\n    deleteRow(index: number): void;\n    /**\n     * The **`insertRow()`** method of the HTMLTableSectionElement interface inserts a new row (tr) in the given table sectioning element (thead, tfoot, or ```js-nolint insertRow() insertRow(index) ``` - `index` [MISSING: optional_inline] - : The row index of the new row.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTableSectionElement/insertRow)\n     */\n    insertRow(index?: number): HTMLTableRowElement;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableSectionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableSectionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableSectionElement: {\n    prototype: HTMLTableSectionElement;\n    new(): HTMLTableSectionElement;\n};\n\n/**\n * The **`HTMLTemplateElement`** interface enables access to the contents of an HTML template element.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTemplateElement)\n */\ninterface HTMLTemplateElement extends HTMLElement {\n    /**\n     * The **`HTMLTemplateElement.content`** property returns a `<template>` element's template contents (a A DocumentFragment.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTemplateElement/content)\n     */\n    readonly content: DocumentFragment;\n    /**\n     * The **`shadowRootClonable`** property reflects the value of the `shadowrootclonable` attribute of the associated `<template>` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTemplateElement/shadowRootClonable)\n     */\n    shadowRootClonable: boolean;\n    /**\n     * The **`shadowRootDelegatesFocus`** property of the HTMLTemplateElement interface reflects the value of the `shadowrootdelegatesfocus` attribute of the associated `<template>` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTemplateElement/shadowRootDelegatesFocus)\n     */\n    shadowRootDelegatesFocus: boolean;\n    /**\n     * The **`shadowRootMode`** property of the HTMLTemplateElement interface reflects the value of the `shadowrootmode` attribute of the associated `<template>` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTemplateElement/shadowRootMode)\n     */\n    shadowRootMode: string;\n    /**\n     * The **`shadowRootSerializable`** property reflects the value of the `shadowrootserializable` attribute of the associated `<template>` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTemplateElement/shadowRootSerializable)\n     */\n    shadowRootSerializable: boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTemplateElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTemplateElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTemplateElement: {\n    prototype: HTMLTemplateElement;\n    new(): HTMLTemplateElement;\n};\n\n/**\n * The **`HTMLTextAreaElement`** interface provides properties and methods for manipulating the layout and presentation of textarea elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement)\n */\ninterface HTMLTextAreaElement extends HTMLElement {\n    /**\n     * The **`autocomplete`** property of the HTMLTextAreaElement interface indicates whether the value of the control can be automatically completed by the browser.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/autocomplete)\n     */\n    autocomplete: AutoFill;\n    /**\n     * The **`cols`** property of the HTMLTextAreaElement interface is a positive integer representing the visible width of the multi-line text control, in average character widths.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/cols)\n     */\n    cols: number;\n    /**\n     * The **`defaultValue`** property of the HTMLTextAreaElement interface represents the default text content of this text area.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/defaultValue)\n     */\n    defaultValue: string;\n    /**\n     * The **`dirName`** property of the HTMLTextAreaElement interface is the directionality of the element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/dirName)\n     */\n    dirName: string;\n    /**\n     * The **`disabled`** property of the HTMLTextAreaElement interface indicates whether this multi-line text control is disabled and cannot be interacted with.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/disabled)\n     */\n    disabled: boolean;\n    /**\n     * The **`form`** read-only property of the HTMLTextAreaElement interface returns an HTMLFormElement object that owns this textarea, or `null` if this textarea is not owned by any form.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/form)\n     */\n    readonly form: HTMLFormElement | null;\n    /**\n     * The **`HTMLTextAreaElement.labels`** read-only property returns a NodeList of the label elements associated with the A NodeList containing the `<label>` elements associated with the `<textArea>` element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/labels)\n     */\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    /**\n     * The **`maxLength`** property of the HTMLTextAreaElement interface indicates the maximum number of characters (in UTF-16 code units) allowed to be entered for the value of the textarea element, and the maximum number of characters allowed for the value to be valid.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/maxLength)\n     */\n    maxLength: number;\n    /**\n     * The **`minLength`** property of the HTMLTextAreaElement interface indicates the minimum number of characters (in UTF-16 code units) required for the value of the textarea element to be valid.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/minLength)\n     */\n    minLength: number;\n    /**\n     * The **`name`** property of the HTMLTextAreaElement interface indicates the name of the textarea element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/name)\n     */\n    name: string;\n    /**\n     * The **`placeholder`** property of the HTMLTextAreaElement interface represents a hint to the user of what can be entered in the control.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/placeholder)\n     */\n    placeholder: string;\n    /**\n     * The **`readOnly`** property of the HTMLTextAreaElement interface indicates that the user cannot modify the value of the control.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/readOnly)\n     */\n    readOnly: boolean;\n    /**\n     * The **`required`** property of the HTMLTextAreaElement interface specifies that the user must fill in a value before submitting a form.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/required)\n     */\n    required: boolean;\n    /**\n     * The **`rows`** property of the HTMLTextAreaElement interface is a positive integer representing the visible text lines of the text control.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/rows)\n     */\n    rows: number;\n    /**\n     * <!-- --> The **`selectionDirection`** property of the HTMLTextAreaElement interface specifies the current direction of the selection.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/selectionDirection)\n     */\n    selectionDirection: \"forward\" | \"backward\" | \"none\";\n    /**\n     * The **`selectionEnd`** property of the HTMLTextAreaElement interface specifies the end position of the current text selection in a textarea element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/selectionEnd)\n     */\n    selectionEnd: number;\n    /**\n     * The **`selectionStart`** property of the HTMLTextAreaElement interface specifies the start position of the current text selection in a textarea element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/selectionStart)\n     */\n    selectionStart: number;\n    /**\n     * The **`textLength`** read-only property of the HTMLTextAreaElement interface is a non-negative integer representing the number of characters, in UTF-16 code units, of the textarea element's value.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/textLength)\n     */\n    readonly textLength: number;\n    /**\n     * The **`type`** read-only property of the HTMLTextAreaElement interface returns the string `'textarea'`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/type)\n     */\n    readonly type: string;\n    /**\n     * The **`validationMessage`** read-only property of the HTMLTextAreaElement interface returns a string representing a localized message that describes the validation constraints that the textarea control does not satisfy (if any).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/validationMessage)\n     */\n    readonly validationMessage: string;\n    /**\n     * The **`validity`** read-only property of the HTMLTextAreaElement interface returns a ValidityState object that represents the validity states this element is in.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/validity)\n     */\n    readonly validity: ValidityState;\n    /**\n     * The **`value`** property of the HTMLTextAreaElement interface represents the value of the textarea element as a string, which is an empty string if the widget contains no content.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/value)\n     */\n    value: string;\n    /**\n     * The **`willValidate`** read-only property of the HTMLTextAreaElement interface indicates whether the textarea element is a candidate for constraint validation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/willValidate)\n     */\n    readonly willValidate: boolean;\n    /**\n     * The **`wrap`** property of the HTMLTextAreaElement interface indicates how the control should wrap the value for form submission.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/wrap)\n     */\n    wrap: string;\n    /**\n     * The **`checkValidity()`** method of the HTMLTextAreaElement interface returns a boolean value which indicates if the element meets any constraint validation rules applied to it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/checkValidity)\n     */\n    checkValidity(): boolean;\n    /**\n     * The **`reportValidity()`** method of the HTMLTextAreaElement interface performs the same validity checking steps as the HTMLTextAreaElement.checkValidity method.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/reportValidity)\n     */\n    reportValidity(): boolean;\n    /**\n     * The **`select()`** method of the HTMLTextAreaElement interface selects the entire contents of the textarea element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/select)\n     */\n    select(): void;\n    /**\n     * The **`setCustomValidity()`** method of the HTMLTextAreaElement interface sets the custom validity message for the textarea element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/setCustomValidity)\n     */\n    setCustomValidity(error: string): void;\n    /**\n     * The **`setRangeText()`** method of the HTMLTextAreaElement interface replaces a range of text in a textarea element with new text passed as the argument.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/setRangeText)\n     */\n    setRangeText(replacement: string): void;\n    setRangeText(replacement: string, start: number, end: number, selectionMode?: SelectionMode): void;\n    /**\n     * The **`setSelectionRange()`** method of the HTMLTextAreaElement interface sets the start and end positions of the current text selection, and optionally the direction, in a textarea element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTextAreaElement/setSelectionRange)\n     */\n    setSelectionRange(start: number | null, end: number | null, direction?: \"forward\" | \"backward\" | \"none\"): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTextAreaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTextAreaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTextAreaElement: {\n    prototype: HTMLTextAreaElement;\n    new(): HTMLTextAreaElement;\n};\n\n/**\n * The **`HTMLTimeElement`** interface provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating time elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTimeElement)\n */\ninterface HTMLTimeElement extends HTMLElement {\n    /**\n     * The **`dateTime`** property of the HTMLTimeElement interface is a string that reflects the `datetime` HTML attribute, containing a machine-readable form of the element's date and time value.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTimeElement/dateTime)\n     */\n    dateTime: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTimeElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTimeElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTimeElement: {\n    prototype: HTMLTimeElement;\n    new(): HTMLTimeElement;\n};\n\n/**\n * The **`HTMLTitleElement`** interface is implemented by a document's title.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTitleElement)\n */\ninterface HTMLTitleElement extends HTMLElement {\n    /**\n     * The **`text`** property of the HTMLTitleElement interface represents the child text content of the document's title as a string.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTitleElement/text)\n     */\n    text: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTitleElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTitleElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTitleElement: {\n    prototype: HTMLTitleElement;\n    new(): HTMLTitleElement;\n};\n\n/**\n * The **`HTMLTrackElement`** interface represents an HTML track element within the DOM.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement)\n */\ninterface HTMLTrackElement extends HTMLElement {\n    /**\n     * The **`default`** property of the HTMLTrackElement interface represents whether the track will be enabled if the user's preferences do not indicate that another track would be more appropriate.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement/default)\n     */\n    default: boolean;\n    /**\n     * The **`kind`** property of the HTMLTrackElement interface represents the type of track, or how the text track is meant to be used.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement/kind)\n     */\n    kind: string;\n    /**\n     * The **`label`** property of the HTMLTrackElement represents the user-readable title displayed when listing subtitle, caption, and audio descriptions for a track.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement/label)\n     */\n    label: string;\n    /**\n     * The **`readyState`** read-only property of the HTMLTrackElement interface returns a number representing the track element's text track readiness state: 0.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement/readyState)\n     */\n    readonly readyState: number;\n    /**\n     * The **`src`** property of the HTMLTrackElement interface reflects the value of the track element's `src` attribute, which indicates the URL of the text track's data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement/src)\n     */\n    src: string;\n    /**\n     * The **`srclang`** property of the HTMLTrackElement interface reflects the value of the track element's `srclang` attribute or the empty string if not defined.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement/srclang)\n     */\n    srclang: string;\n    /**\n     * The **`track`** read-only property of the HTMLTrackElement interface returns a TextTrack object corresponding to the text track of the track element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLTrackElement/track)\n     */\n    readonly track: TextTrack;\n    readonly NONE: 0;\n    readonly LOADING: 1;\n    readonly LOADED: 2;\n    readonly ERROR: 3;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTrackElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTrackElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTrackElement: {\n    prototype: HTMLTrackElement;\n    new(): HTMLTrackElement;\n    readonly NONE: 0;\n    readonly LOADING: 1;\n    readonly LOADED: 2;\n    readonly ERROR: 3;\n};\n\n/**\n * The **`HTMLUListElement`** interface provides special properties (beyond those defined on the regular HTMLElement interface it also has available to it by inheritance) for manipulating unordered list (ul) elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLUListElement)\n */\ninterface HTMLUListElement extends HTMLElement {\n    /** @deprecated */\n    compact: boolean;\n    /** @deprecated */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLUListElement: {\n    prototype: HTMLUListElement;\n    new(): HTMLUListElement;\n};\n\n/**\n * The **`HTMLUnknownElement`** interface represents an invalid HTML element and derives from the HTMLElement interface, but without implementing any additional properties or methods.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLUnknownElement)\n */\ninterface HTMLUnknownElement extends HTMLElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUnknownElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUnknownElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLUnknownElement: {\n    prototype: HTMLUnknownElement;\n    new(): HTMLUnknownElement;\n};\n\ninterface HTMLVideoElementEventMap extends HTMLMediaElementEventMap {\n    \"enterpictureinpicture\": PictureInPictureEvent;\n    \"leavepictureinpicture\": PictureInPictureEvent;\n}\n\n/**\n * Implemented by the video element, the **`HTMLVideoElement`** interface provides special properties and methods for manipulating video objects.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement)\n */\ninterface HTMLVideoElement extends HTMLMediaElement {\n    /**\n     * The HTMLVideoElement **`disablePictureInPicture`** property reflects the HTML attribute indicating whether the picture-in-picture feature is disabled for the current element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/disablePictureInPicture)\n     */\n    disablePictureInPicture: boolean;\n    /**\n     * The **`height`** property of the HTMLVideoElement interface returns an integer that reflects the `height` attribute of the video element, specifying the displayed height of the resource in CSS pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/height)\n     */\n    height: number;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/enterpictureinpicture_event) */\n    onenterpictureinpicture: ((this: HTMLVideoElement, ev: PictureInPictureEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/leavepictureinpicture_event) */\n    onleavepictureinpicture: ((this: HTMLVideoElement, ev: PictureInPictureEvent) => any) | null;\n    playsInline: boolean;\n    /**\n     * The **`poster`** property of the HTMLVideoElement interface is a string that reflects the URL for an image to be shown while no video data is available.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/poster)\n     */\n    poster: string;\n    /**\n     * The HTMLVideoElement interface's read-only **`videoHeight`** property indicates the intrinsic height of the video, expressed in CSS pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/videoHeight)\n     */\n    readonly videoHeight: number;\n    /**\n     * The HTMLVideoElement interface's read-only **`videoWidth`** property indicates the intrinsic width of the video, expressed in CSS pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/videoWidth)\n     */\n    readonly videoWidth: number;\n    /**\n     * The **`width`** property of the HTMLVideoElement interface returns an integer that reflects the `width` attribute of the video element, specifying the displayed width of the resource in CSS pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/width)\n     */\n    width: number;\n    /**\n     * The **`cancelVideoFrameCallback()`** method of the HTMLVideoElement interface cancels a previously-registered video frame callback.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/cancelVideoFrameCallback)\n     */\n    cancelVideoFrameCallback(handle: number): void;\n    /**\n     * The **HTMLVideoElement** method **`getVideoPlaybackQuality()`** creates and returns a frames have been lost.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/getVideoPlaybackQuality)\n     */\n    getVideoPlaybackQuality(): VideoPlaybackQuality;\n    /**\n     * The **HTMLVideoElement** method **`requestPictureInPicture()`** issues an asynchronous request to display the video in picture-in-picture mode.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/requestPictureInPicture)\n     */\n    requestPictureInPicture(): Promise<PictureInPictureWindow>;\n    /**\n     * The **`requestVideoFrameCallback()`** method of the HTMLVideoElement interface registers a callback function that runs when a new video frame is sent to the compositor.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement/requestVideoFrameCallback)\n     */\n    requestVideoFrameCallback(callback: VideoFrameRequestCallback): number;\n    addEventListener<K extends keyof HTMLVideoElementEventMap>(type: K, listener: (this: HTMLVideoElement, ev: HTMLVideoElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLVideoElementEventMap>(type: K, listener: (this: HTMLVideoElement, ev: HTMLVideoElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLVideoElement: {\n    prototype: HTMLVideoElement;\n    new(): HTMLVideoElement;\n};\n\n/**\n * The **`HashChangeEvent`** interface represents events that fire when the fragment identifier of the URL has changed.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HashChangeEvent)\n */\ninterface HashChangeEvent extends Event {\n    /**\n     * The **`newURL`** read-only property of the navigating.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HashChangeEvent/newURL)\n     */\n    readonly newURL: string;\n    /**\n     * The **`oldURL`** read-only property of the was navigated.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HashChangeEvent/oldURL)\n     */\n    readonly oldURL: string;\n}\n\ndeclare var HashChangeEvent: {\n    prototype: HashChangeEvent;\n    new(type: string, eventInitDict?: HashChangeEventInit): HashChangeEvent;\n};\n\n/**\n * The **`Headers`** interface of the Fetch API allows you to perform various actions on HTTP request and response headers.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Headers)\n */\ninterface Headers {\n    /**\n     * The **`append()`** method of the Headers interface appends a new value onto an existing header inside a `Headers` object, or adds the header if it does not already exist.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Headers/append)\n     */\n    append(name: string, value: string): void;\n    /**\n     * The **`delete()`** method of the Headers interface deletes a header from the current `Headers` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Headers/delete)\n     */\n    delete(name: string): void;\n    /**\n     * The **`get()`** method of the Headers interface returns a byte string of all the values of a header within a `Headers` object with a given name.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Headers/get)\n     */\n    get(name: string): string | null;\n    /**\n     * The **`getSetCookie()`** method of the Headers interface returns an array containing the values of all Set-Cookie headers associated with a response.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Headers/getSetCookie)\n     */\n    getSetCookie(): string[];\n    /**\n     * The **`has()`** method of the Headers interface returns a boolean stating whether a `Headers` object contains a certain header.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Headers/has)\n     */\n    has(name: string): boolean;\n    /**\n     * The **`set()`** method of the Headers interface sets a new value for an existing header inside a `Headers` object, or adds the header if it does not already exist.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Headers/set)\n     */\n    set(name: string, value: string): void;\n    forEach(callbackfn: (value: string, key: string, parent: Headers) => void, thisArg?: any): void;\n}\n\ndeclare var Headers: {\n    prototype: Headers;\n    new(init?: HeadersInit): Headers;\n};\n\n/**\n * The **`Highlight`** interface of the CSS Custom Highlight API is used to represent a collection of Range instances to be styled using the API.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Highlight)\n */\ninterface Highlight {\n    /**\n     * It is possible to create Range objects that overlap in a document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Highlight/priority)\n     */\n    priority: number;\n    /**\n     * The `type` property of the Highlight interface is an enumerated String used to specify the meaning of the highlight.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Highlight/type)\n     */\n    type: HighlightType;\n    forEach(callbackfn: (value: AbstractRange, key: AbstractRange, parent: Highlight) => void, thisArg?: any): void;\n}\n\ndeclare var Highlight: {\n    prototype: Highlight;\n    new(...initialRanges: AbstractRange[]): Highlight;\n};\n\n/**\n * The **`HighlightRegistry`** interface of the CSS Custom Highlight API is used to register Highlight objects to be styled using the API.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/HighlightRegistry)\n */\ninterface HighlightRegistry {\n    forEach(callbackfn: (value: Highlight, key: string, parent: HighlightRegistry) => void, thisArg?: any): void;\n}\n\ndeclare var HighlightRegistry: {\n    prototype: HighlightRegistry;\n    new(): HighlightRegistry;\n};\n\n/**\n * The **`History`** interface of the History API allows manipulation of the browser _session history_, that is the pages visited in the tab or frame that the current page is loaded in.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/History)\n */\ninterface History {\n    /**\n     * The **`length`** read-only property of the History interface returns an integer representing the number of entries in the session history, including the currently loaded page.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/History/length)\n     */\n    readonly length: number;\n    /**\n     * The **`scrollRestoration`** property of the History interface allows web applications to explicitly set default scroll restoration behavior on history navigation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/History/scrollRestoration)\n     */\n    scrollRestoration: ScrollRestoration;\n    /**\n     * The **`state`** read-only property of the History interface returns a value representing the state at the top of the history stack.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/History/state)\n     */\n    readonly state: any;\n    /**\n     * The **`back()`** method of the History interface causes the browser to move back one page in the session history.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/History/back)\n     */\n    back(): void;\n    /**\n     * The **`forward()`** method of the History interface causes the browser to move forward one page in the session history.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/History/forward)\n     */\n    forward(): void;\n    /**\n     * The **`go()`** method of the History interface loads a specific page from the session history.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/History/go)\n     */\n    go(delta?: number): void;\n    /**\n     * The **`pushState()`** method of the History interface adds an entry to the browser's session history stack.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/History/pushState)\n     */\n    pushState(data: any, unused: string, url?: string | URL | null): void;\n    /**\n     * The **`replaceState()`** method of the History interface modifies the current history entry, replacing it with the state object and URL passed in the method parameters.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/History/replaceState)\n     */\n    replaceState(data: any, unused: string, url?: string | URL | null): void;\n}\n\ndeclare var History: {\n    prototype: History;\n    new(): History;\n};\n\n/**\n * The **`IDBCursor`** interface of the IndexedDB API represents a cursor for traversing or iterating over multiple records in a database.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor)\n */\ninterface IDBCursor {\n    /**\n     * The **`direction`** read-only property of the direction of traversal of the cursor (set using section below for possible values.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/direction)\n     */\n    readonly direction: IDBCursorDirection;\n    /**\n     * The **`key`** read-only property of the position.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/key)\n     */\n    readonly key: IDBValidKey;\n    /**\n     * The **`primaryKey`** read-only property of the cursor is currently being iterated or has iterated outside its range, this is set to undefined.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/primaryKey)\n     */\n    readonly primaryKey: IDBValidKey;\n    /**\n     * The **`request`** read-only property of the IDBCursor interface returns the IDBRequest used to obtain the cursor.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/request)\n     */\n    readonly request: IDBRequest;\n    /**\n     * The **`source`** read-only property of the null or throws an exception, even if the cursor is currently being iterated, has iterated past its end, or its transaction is not active.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/source)\n     */\n    readonly source: IDBObjectStore | IDBIndex;\n    /**\n     * The **`advance()`** method of the IDBCursor interface sets the number of times a cursor should move its position forward.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/advance)\n     */\n    advance(count: number): void;\n    /**\n     * The **`continue()`** method of the IDBCursor interface advances the cursor to the next position along its direction, to the item whose key matches the optional key parameter.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/continue)\n     */\n    continue(key?: IDBValidKey): void;\n    /**\n     * The **`continuePrimaryKey()`** method of the matches the key parameter as well as whose primary key matches the primary key parameter.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/continuePrimaryKey)\n     */\n    continuePrimaryKey(key: IDBValidKey, primaryKey: IDBValidKey): void;\n    /**\n     * The **`delete()`** method of the IDBCursor interface returns an IDBRequest object, and, in a separate thread, deletes the record at the cursor's position, without changing the cursor's position.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/delete)\n     */\n    delete(): IDBRequest<undefined>;\n    /**\n     * The **`update()`** method of the IDBCursor interface returns an IDBRequest object, and, in a separate thread, updates the value at the current position of the cursor in the object store.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursor/update)\n     */\n    update(value: any): IDBRequest<IDBValidKey>;\n}\n\ndeclare var IDBCursor: {\n    prototype: IDBCursor;\n    new(): IDBCursor;\n};\n\n/**\n * The **`IDBCursorWithValue`** interface of the IndexedDB API represents a cursor for traversing or iterating over multiple records in a database.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursorWithValue)\n */\ninterface IDBCursorWithValue extends IDBCursor {\n    /**\n     * The **`value`** read-only property of the whatever that is.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBCursorWithValue/value)\n     */\n    readonly value: any;\n}\n\ndeclare var IDBCursorWithValue: {\n    prototype: IDBCursorWithValue;\n    new(): IDBCursorWithValue;\n};\n\ninterface IDBDatabaseEventMap {\n    \"abort\": Event;\n    \"close\": Event;\n    \"error\": Event;\n    \"versionchange\": IDBVersionChangeEvent;\n}\n\n/**\n * The **`IDBDatabase`** interface of the IndexedDB API provides a connection to a database; you can use an `IDBDatabase` object to open a transaction on your database then create, manipulate, and delete objects (data) in that database.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase)\n */\ninterface IDBDatabase extends EventTarget {\n    /**\n     * The **`name`** read-only property of the `IDBDatabase` interface is a string that contains the name of the connected database.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/name)\n     */\n    readonly name: string;\n    /**\n     * The **`objectStoreNames`** read-only property of the list of the names of the object stores currently in the connected database.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/objectStoreNames)\n     */\n    readonly objectStoreNames: DOMStringList;\n    onabort: ((this: IDBDatabase, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/close_event) */\n    onclose: ((this: IDBDatabase, ev: Event) => any) | null;\n    onerror: ((this: IDBDatabase, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/versionchange_event) */\n    onversionchange: ((this: IDBDatabase, ev: IDBVersionChangeEvent) => any) | null;\n    /**\n     * The **`version`** property of the IDBDatabase interface is a 64-bit integer that contains the version of the connected database.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/version)\n     */\n    readonly version: number;\n    /**\n     * The **`close()`** method of the IDBDatabase interface returns immediately and closes the connection in a separate thread.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/close)\n     */\n    close(): void;\n    /**\n     * The **`createObjectStore()`** method of the The method takes the name of the store as well as a parameter object that lets you define important optional properties.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/createObjectStore)\n     */\n    createObjectStore(name: string, options?: IDBObjectStoreParameters): IDBObjectStore;\n    /**\n     * The **`deleteObjectStore()`** method of the the connected database, along with any indexes that reference it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/deleteObjectStore)\n     */\n    deleteObjectStore(name: string): void;\n    /**\n     * The **`transaction`** method of the IDBDatabase interface immediately returns a transaction object (IDBTransaction) containing the IDBTransaction.objectStore method, which you can use to access your object store.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBDatabase/transaction)\n     */\n    transaction(storeNames: string | string[], mode?: IDBTransactionMode, options?: IDBTransactionOptions): IDBTransaction;\n    addEventListener<K extends keyof IDBDatabaseEventMap>(type: K, listener: (this: IDBDatabase, ev: IDBDatabaseEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof IDBDatabaseEventMap>(type: K, listener: (this: IDBDatabase, ev: IDBDatabaseEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var IDBDatabase: {\n    prototype: IDBDatabase;\n    new(): IDBDatabase;\n};\n\n/**\n * The **`IDBFactory`** interface of the IndexedDB API lets applications asynchronously access the indexed databases.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBFactory)\n */\ninterface IDBFactory {\n    /**\n     * The **`cmp()`** method of the IDBFactory interface compares two values as keys to determine equality and ordering for IndexedDB operations, such as storing and iterating.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBFactory/cmp)\n     */\n    cmp(first: any, second: any): number;\n    /**\n     * The **`databases`** method of the IDBFactory interface returns a Promise that fulfills with an array of objects containing the name and version of all the available databases.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBFactory/databases)\n     */\n    databases(): Promise<IDBDatabaseInfo[]>;\n    /**\n     * The **`deleteDatabase()`** method of the returns an IDBOpenDBRequest object immediately, and performs the deletion operation asynchronously.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBFactory/deleteDatabase)\n     */\n    deleteDatabase(name: string): IDBOpenDBRequest;\n    /**\n     * The **`open()`** method of the IDBFactory interface requests opening a connection to a database.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBFactory/open)\n     */\n    open(name: string, version?: number): IDBOpenDBRequest;\n}\n\ndeclare var IDBFactory: {\n    prototype: IDBFactory;\n    new(): IDBFactory;\n};\n\n/**\n * `IDBIndex` interface of the IndexedDB API provides asynchronous access to an index in a database.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex)\n */\ninterface IDBIndex {\n    /**\n     * The **`keyPath`** property of the IDBIndex interface returns the key path of the current index.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/keyPath)\n     */\n    readonly keyPath: string | string[];\n    /**\n     * The **`multiEntry`** read-only property of the behaves when the result of evaluating the index's key path yields an array.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/multiEntry)\n     */\n    readonly multiEntry: boolean;\n    /**\n     * The **`name`** property of the IDBIndex interface contains a string which names the index.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/name)\n     */\n    name: string;\n    /**\n     * The **`objectStore`** property of the IDBIndex interface returns the object store referenced by the current index.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/objectStore)\n     */\n    readonly objectStore: IDBObjectStore;\n    /**\n     * The **`unique`** read-only property returns a boolean that states whether the index allows duplicate keys.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/unique)\n     */\n    readonly unique: boolean;\n    /**\n     * The **`count()`** method of the IDBIndex interface returns an IDBRequest object, and in a separate thread, returns the number of records within a key range.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/count)\n     */\n    count(query?: IDBValidKey | IDBKeyRange): IDBRequest<number>;\n    /**\n     * The **`get()`** method of the IDBIndex interface returns an IDBRequest object, and, in a separate thread, finds either the value in the referenced object store that corresponds to the given key or the first corresponding value, if `key` is set to an If a value is found, then a structured clone of it is created and set as the `result` of the request object: this returns the record the key is associated with.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/get)\n     */\n    get(query: IDBValidKey | IDBKeyRange): IDBRequest<any>;\n    /**\n     * The **`getAll()`** method of the IDBIndex interface retrieves all objects that are inside the index.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/getAll)\n     */\n    getAll(query?: IDBValidKey | IDBKeyRange | null, count?: number): IDBRequest<any[]>;\n    /**\n     * The **`getAllKeys()`** method of the IDBIndex interface asynchronously retrieves the primary keys of all objects inside the index, setting them as the `result` of the request object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/getAllKeys)\n     */\n    getAllKeys(query?: IDBValidKey | IDBKeyRange | null, count?: number): IDBRequest<IDBValidKey[]>;\n    /**\n     * The **`getKey()`** method of the IDBIndex interface returns an IDBRequest object, and, in a separate thread, finds either the primary key that corresponds to the given key in this index or the first corresponding primary key, if `key` is set to an If a primary key is found, it is set as the `result` of the request object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/getKey)\n     */\n    getKey(query: IDBValidKey | IDBKeyRange): IDBRequest<IDBValidKey | undefined>;\n    /**\n     * The **`openCursor()`** method of the IDBIndex interface returns an IDBRequest object, and, in a separate thread, creates a cursor over the specified key range.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/openCursor)\n     */\n    openCursor(query?: IDBValidKey | IDBKeyRange | null, direction?: IDBCursorDirection): IDBRequest<IDBCursorWithValue | null>;\n    /**\n     * The **`openKeyCursor()`** method of the a separate thread, creates a cursor over the specified key range, as arranged by this index.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBIndex/openKeyCursor)\n     */\n    openKeyCursor(query?: IDBValidKey | IDBKeyRange | null, direction?: IDBCursorDirection): IDBRequest<IDBCursor | null>;\n}\n\ndeclare var IDBIndex: {\n    prototype: IDBIndex;\n    new(): IDBIndex;\n};\n\n/**\n * The **`IDBKeyRange`** interface of the IndexedDB API represents a continuous interval over some data type that is used for keys.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange)\n */\ninterface IDBKeyRange {\n    /**\n     * The **`lower`** read-only property of the The lower bound of the key range (can be any type.) The following example illustrates how you'd use a key range.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/lower)\n     */\n    readonly lower: any;\n    /**\n     * The **`lowerOpen`** read-only property of the lower-bound value is included in the key range.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/lowerOpen)\n     */\n    readonly lowerOpen: boolean;\n    /**\n     * The **`upper`** read-only property of the The upper bound of the key range (can be any type.) The following example illustrates how you'd use a key range.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/upper)\n     */\n    readonly upper: any;\n    /**\n     * The **`upperOpen`** read-only property of the upper-bound value is included in the key range.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/upperOpen)\n     */\n    readonly upperOpen: boolean;\n    /**\n     * The `includes()` method of the IDBKeyRange interface returns a boolean indicating whether a specified key is inside the key range.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/includes)\n     */\n    includes(key: any): boolean;\n}\n\ndeclare var IDBKeyRange: {\n    prototype: IDBKeyRange;\n    new(): IDBKeyRange;\n    /**\n     * The **`bound()`** static method of the IDBKeyRange interface creates a new key range with the specified upper and lower bounds.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/bound_static)\n     */\n    bound(lower: any, upper: any, lowerOpen?: boolean, upperOpen?: boolean): IDBKeyRange;\n    /**\n     * The **`lowerBound()`** static method of the By default, it includes the lower endpoint value and is closed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/lowerBound_static)\n     */\n    lowerBound(lower: any, open?: boolean): IDBKeyRange;\n    /**\n     * The **`only()`** static method of the IDBKeyRange interface creates a new key range containing a single value.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/only_static)\n     */\n    only(value: any): IDBKeyRange;\n    /**\n     * The **`upperBound()`** static method of the it includes the upper endpoint value and is closed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBKeyRange/upperBound_static)\n     */\n    upperBound(upper: any, open?: boolean): IDBKeyRange;\n};\n\n/**\n * The **`IDBObjectStore`** interface of the IndexedDB API represents an object store in a database.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore)\n */\ninterface IDBObjectStore {\n    /**\n     * The **`autoIncrement`** read-only property of the for this object store.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/autoIncrement)\n     */\n    readonly autoIncrement: boolean;\n    /**\n     * The **`indexNames`** read-only property of the in this object store.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/indexNames)\n     */\n    readonly indexNames: DOMStringList;\n    /**\n     * The **`keyPath`** read-only property of the If this property is null, the application must provide a key for each modification operation.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/keyPath)\n     */\n    readonly keyPath: string | string[] | null;\n    /**\n     * The **`name`** property of the IDBObjectStore interface indicates the name of this object store.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/name)\n     */\n    name: string;\n    /**\n     * The **`transaction`** read-only property of the object store belongs.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/transaction)\n     */\n    readonly transaction: IDBTransaction;\n    /**\n     * The **`add()`** method of the IDBObjectStore interface returns an IDBRequest object, and, in a separate thread, creates a structured clone of the value, and stores the cloned value in the object store.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/add)\n     */\n    add(value: any, key?: IDBValidKey): IDBRequest<IDBValidKey>;\n    /**\n     * The **`clear()`** method of the IDBObjectStore interface creates and immediately returns an IDBRequest object, and clears this object store in a separate thread.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/clear)\n     */\n    clear(): IDBRequest<undefined>;\n    /**\n     * The **`count()`** method of the IDBObjectStore interface returns an IDBRequest object, and, in a separate thread, returns the total number of records that match the provided key or of records in the store.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/count)\n     */\n    count(query?: IDBValidKey | IDBKeyRange): IDBRequest<number>;\n    /**\n     * The **`createIndex()`** method of the field/column defining a new data point for each database record to contain.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/createIndex)\n     */\n    createIndex(name: string, keyPath: string | string[], options?: IDBIndexParameters): IDBIndex;\n    /**\n     * The **`delete()`** method of the and, in a separate thread, deletes the specified record or records.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/delete)\n     */\n    delete(query: IDBValidKey | IDBKeyRange): IDBRequest<undefined>;\n    /**\n     * The **`deleteIndex()`** method of the the connected database, used during a version upgrade.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/deleteIndex)\n     */\n    deleteIndex(name: string): void;\n    /**\n     * The **`get()`** method of the IDBObjectStore interface returns an IDBRequest object, and, in a separate thread, returns the object selected by the specified key.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/get)\n     */\n    get(query: IDBValidKey | IDBKeyRange): IDBRequest<any>;\n    /**\n     * The **`getAll()`** method of the containing all objects in the object store matching the specified parameter or all objects in the store if no parameters are given.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/getAll)\n     */\n    getAll(query?: IDBValidKey | IDBKeyRange | null, count?: number): IDBRequest<any[]>;\n    /**\n     * The `getAllKeys()` method of the IDBObjectStore interface returns an IDBRequest object retrieves record keys for all objects in the object store matching the specified parameter or all objects in the store if no parameters are given.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/getAllKeys)\n     */\n    getAllKeys(query?: IDBValidKey | IDBKeyRange | null, count?: number): IDBRequest<IDBValidKey[]>;\n    /**\n     * The **`getKey()`** method of the and, in a separate thread, returns the key selected by the specified query.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/getKey)\n     */\n    getKey(query: IDBValidKey | IDBKeyRange): IDBRequest<IDBValidKey | undefined>;\n    /**\n     * The **`index()`** method of the IDBObjectStore interface opens a named index in the current object store, after which it can be used to, for example, return a series of records sorted by that index using a cursor.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/index)\n     */\n    index(name: string): IDBIndex;\n    /**\n     * The **`openCursor()`** method of the and, in a separate thread, returns a new IDBCursorWithValue object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/openCursor)\n     */\n    openCursor(query?: IDBValidKey | IDBKeyRange | null, direction?: IDBCursorDirection): IDBRequest<IDBCursorWithValue | null>;\n    /**\n     * The **`openKeyCursor()`** method of the whose result will be set to an IDBCursor that can be used to iterate through matching results.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/openKeyCursor)\n     */\n    openKeyCursor(query?: IDBValidKey | IDBKeyRange | null, direction?: IDBCursorDirection): IDBRequest<IDBCursor | null>;\n    /**\n     * The **`put()`** method of the IDBObjectStore interface updates a given record in a database, or inserts a new record if the given item does not already exist.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBObjectStore/put)\n     */\n    put(value: any, key?: IDBValidKey): IDBRequest<IDBValidKey>;\n}\n\ndeclare var IDBObjectStore: {\n    prototype: IDBObjectStore;\n    new(): IDBObjectStore;\n};\n\ninterface IDBOpenDBRequestEventMap extends IDBRequestEventMap {\n    \"blocked\": IDBVersionChangeEvent;\n    \"upgradeneeded\": IDBVersionChangeEvent;\n}\n\n/**\n * The **`IDBOpenDBRequest`** interface of the IndexedDB API provides access to the results of requests to open or delete databases (performed using IDBFactory.open and IDBFactory.deleteDatabase), using specific event handler attributes.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBOpenDBRequest)\n */\ninterface IDBOpenDBRequest extends IDBRequest<IDBDatabase> {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBOpenDBRequest/blocked_event) */\n    onblocked: ((this: IDBOpenDBRequest, ev: IDBVersionChangeEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBOpenDBRequest/upgradeneeded_event) */\n    onupgradeneeded: ((this: IDBOpenDBRequest, ev: IDBVersionChangeEvent) => any) | null;\n    addEventListener<K extends keyof IDBOpenDBRequestEventMap>(type: K, listener: (this: IDBOpenDBRequest, ev: IDBOpenDBRequestEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof IDBOpenDBRequestEventMap>(type: K, listener: (this: IDBOpenDBRequest, ev: IDBOpenDBRequestEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var IDBOpenDBRequest: {\n    prototype: IDBOpenDBRequest;\n    new(): IDBOpenDBRequest;\n};\n\ninterface IDBRequestEventMap {\n    \"error\": Event;\n    \"success\": Event;\n}\n\n/**\n * The **`IDBRequest`** interface of the IndexedDB API provides access to results of asynchronous requests to databases and database objects using event handler attributes.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBRequest)\n */\ninterface IDBRequest<T = any> extends EventTarget {\n    /**\n     * The **`error`** read-only property of the request.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBRequest/error)\n     */\n    readonly error: DOMException | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBRequest/error_event) */\n    onerror: ((this: IDBRequest<T>, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBRequest/success_event) */\n    onsuccess: ((this: IDBRequest<T>, ev: Event) => any) | null;\n    /**\n     * The **`readyState`** read-only property of the Every request starts in the `pending` state.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBRequest/readyState)\n     */\n    readonly readyState: IDBRequestReadyState;\n    /**\n     * The **`result`** read-only property of the any - `InvalidStateError` DOMException - : Thrown when attempting to access the property if the request is not completed, and therefore the result is not available.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBRequest/result)\n     */\n    readonly result: T;\n    /**\n     * The **`source`** read-only property of the Index or an object store.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBRequest/source)\n     */\n    readonly source: IDBObjectStore | IDBIndex | IDBCursor;\n    /**\n     * The **`transaction`** read-only property of the IDBRequest interface returns the transaction for the request, that is, the transaction the request is being made inside.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBRequest/transaction)\n     */\n    readonly transaction: IDBTransaction | null;\n    addEventListener<K extends keyof IDBRequestEventMap>(type: K, listener: (this: IDBRequest<T>, ev: IDBRequestEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof IDBRequestEventMap>(type: K, listener: (this: IDBRequest<T>, ev: IDBRequestEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var IDBRequest: {\n    prototype: IDBRequest;\n    new(): IDBRequest;\n};\n\ninterface IDBTransactionEventMap {\n    \"abort\": Event;\n    \"complete\": Event;\n    \"error\": Event;\n}\n\n/**\n * The **`IDBTransaction`** interface of the IndexedDB API provides a static, asynchronous transaction on a database using event handler attributes.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction)\n */\ninterface IDBTransaction extends EventTarget {\n    /**\n     * The **`db`** read-only property of the IDBTransaction interface returns the database connection with which this transaction is associated.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/db)\n     */\n    readonly db: IDBDatabase;\n    /**\n     * The **`durability`** read-only property of the IDBTransaction interface returns the durability hint the transaction was created with.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/durability)\n     */\n    readonly durability: IDBTransactionDurability;\n    /**\n     * The **`IDBTransaction.error`** property of the IDBTransaction interface returns the type of error when there is an unsuccessful transaction.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/error)\n     */\n    readonly error: DOMException | null;\n    /**\n     * The **`mode`** read-only property of the data in the object stores in the scope of the transaction (i.e., is the mode to be read-only, or do you want to write to the object stores?) The default value is `readonly`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/mode)\n     */\n    readonly mode: IDBTransactionMode;\n    /**\n     * The **`objectStoreNames`** read-only property of the of IDBObjectStore objects.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/objectStoreNames)\n     */\n    readonly objectStoreNames: DOMStringList;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/abort_event) */\n    onabort: ((this: IDBTransaction, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/complete_event) */\n    oncomplete: ((this: IDBTransaction, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/error_event) */\n    onerror: ((this: IDBTransaction, ev: Event) => any) | null;\n    /**\n     * The **`abort()`** method of the IDBTransaction interface rolls back all the changes to objects in the database associated with this transaction.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/abort)\n     */\n    abort(): void;\n    /**\n     * The **`commit()`** method of the IDBTransaction interface commits the transaction if it is called on an active transaction.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/commit)\n     */\n    commit(): void;\n    /**\n     * The **`objectStore()`** method of the added to the scope of this transaction.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBTransaction/objectStore)\n     */\n    objectStore(name: string): IDBObjectStore;\n    addEventListener<K extends keyof IDBTransactionEventMap>(type: K, listener: (this: IDBTransaction, ev: IDBTransactionEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof IDBTransactionEventMap>(type: K, listener: (this: IDBTransaction, ev: IDBTransactionEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var IDBTransaction: {\n    prototype: IDBTransaction;\n    new(): IDBTransaction;\n};\n\n/**\n * The **`IDBVersionChangeEvent`** interface of the IndexedDB API indicates that the version of the database has changed, as the result of an IDBOpenDBRequest.upgradeneeded_event event handler function.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBVersionChangeEvent)\n */\ninterface IDBVersionChangeEvent extends Event {\n    /**\n     * The **`newVersion`** read-only property of the database.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBVersionChangeEvent/newVersion)\n     */\n    readonly newVersion: number | null;\n    /**\n     * The **`oldVersion`** read-only property of the database.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IDBVersionChangeEvent/oldVersion)\n     */\n    readonly oldVersion: number;\n}\n\ndeclare var IDBVersionChangeEvent: {\n    prototype: IDBVersionChangeEvent;\n    new(type: string, eventInitDict?: IDBVersionChangeEventInit): IDBVersionChangeEvent;\n};\n\n/**\n * The **`IIRFilterNode`** interface of the Web Audio API is a AudioNode processor which implements a general **infinite impulse response** (IIR) filter; this type of filter can be used to implement tone control devices and graphic equalizers as well.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IIRFilterNode)\n */\ninterface IIRFilterNode extends AudioNode {\n    /**\n     * The `getFrequencyResponse()` method of the IIRFilterNode interface takes the current filtering algorithm's settings and calculates the frequency response for frequencies specified in a specified array of frequencies.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IIRFilterNode/getFrequencyResponse)\n     */\n    getFrequencyResponse(frequencyHz: Float32Array<ArrayBuffer>, magResponse: Float32Array<ArrayBuffer>, phaseResponse: Float32Array<ArrayBuffer>): void;\n}\n\ndeclare var IIRFilterNode: {\n    prototype: IIRFilterNode;\n    new(context: BaseAudioContext, options: IIRFilterOptions): IIRFilterNode;\n};\n\n/**\n * The `IdleDeadline` interface is used as the data type of the input parameter to idle callbacks established by calling Window.requestIdleCallback().\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IdleDeadline)\n */\ninterface IdleDeadline {\n    /**\n     * The read-only **`didTimeout`** property on the **IdleDeadline** interface is a Boolean value which indicates whether or not the idle callback is being invoked because the timeout interval specified when Window.requestIdleCallback() was called has expired.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IdleDeadline/didTimeout)\n     */\n    readonly didTimeout: boolean;\n    /**\n     * The **`timeRemaining()`** method on the IdleDeadline interface returns the estimated number of milliseconds remaining in the current idle period.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IdleDeadline/timeRemaining)\n     */\n    timeRemaining(): DOMHighResTimeStamp;\n}\n\ndeclare var IdleDeadline: {\n    prototype: IdleDeadline;\n    new(): IdleDeadline;\n};\n\n/**\n * The **`ImageBitmap`** interface represents a bitmap image which can be drawn to a canvas without undue latency.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageBitmap)\n */\ninterface ImageBitmap {\n    /**\n     * The **`ImageBitmap.height`** read-only property returns the ImageBitmap object's height in CSS pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageBitmap/height)\n     */\n    readonly height: number;\n    /**\n     * The **`ImageBitmap.width`** read-only property returns the ImageBitmap object's width in CSS pixels.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageBitmap/width)\n     */\n    readonly width: number;\n    /**\n     * The **`ImageBitmap.close()`** method disposes of all graphical resources associated with an `ImageBitmap`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageBitmap/close)\n     */\n    close(): void;\n}\n\ndeclare var ImageBitmap: {\n    prototype: ImageBitmap;\n    new(): ImageBitmap;\n};\n\n/**\n * The **`ImageBitmapRenderingContext`** interface is a canvas rendering context that provides the functionality to replace the canvas's contents with the given ImageBitmap.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageBitmapRenderingContext)\n */\ninterface ImageBitmapRenderingContext {\n    /**\n     * The **`ImageBitmapRenderingContext.canvas`** property, part of the Canvas API, is a read-only reference to the A HTMLCanvasElement or OffscreenCanvas object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageBitmapRenderingContext/canvas)\n     */\n    readonly canvas: HTMLCanvasElement | OffscreenCanvas;\n    /**\n     * The **`ImageBitmapRenderingContext.transferFromImageBitmap()`** method displays the given ImageBitmap in the canvas associated with this rendering context.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageBitmapRenderingContext/transferFromImageBitmap)\n     */\n    transferFromImageBitmap(bitmap: ImageBitmap | null): void;\n}\n\ndeclare var ImageBitmapRenderingContext: {\n    prototype: ImageBitmapRenderingContext;\n    new(): ImageBitmapRenderingContext;\n};\n\n/**\n * The **`ImageCapture`** interface of the MediaStream Image Capture API provides methods to enable the capture of images or photos from a camera or other photographic device.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageCapture)\n */\ninterface ImageCapture {\n    /**\n     * The **`track`** read-only property of the A MediaStreamTrack object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageCapture/track)\n     */\n    readonly track: MediaStreamTrack;\n    /**\n     * The **`getPhotoCapabilities()`** method of the ImageCapture interface returns a Promise that resolves with an object containing the ranges of available configuration options.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageCapture/getPhotoCapabilities)\n     */\n    getPhotoCapabilities(): Promise<PhotoCapabilities>;\n    /**\n     * The **`getPhotoSettings()`** method of the ImageCapture interface returns a Promise that resolves with an object containing the current photo configuration settings.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageCapture/getPhotoSettings)\n     */\n    getPhotoSettings(): Promise<PhotoSettings>;\n    /**\n     * The **`takePhoto()`** method of the device sourcing a MediaStreamTrack and returns a Promise that resolves with a Blob containing the data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageCapture/takePhoto)\n     */\n    takePhoto(photoSettings?: PhotoSettings): Promise<Blob>;\n}\n\ndeclare var ImageCapture: {\n    prototype: ImageCapture;\n    new(videoTrack: MediaStreamTrack): ImageCapture;\n};\n\n/**\n * The **`ImageData`** interface represents the underlying pixel data of an area of a canvas element.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageData)\n */\ninterface ImageData {\n    /**\n     * The read-only **`ImageData.colorSpace`** property is a string indicating the color space of the image data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageData/colorSpace)\n     */\n    readonly colorSpace: PredefinedColorSpace;\n    /**\n     * The readonly **`ImageData.data`** property returns a pixel data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageData/data)\n     */\n    readonly data: ImageDataArray;\n    /**\n     * The readonly **`ImageData.height`** property returns the number of rows in the ImageData object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageData/height)\n     */\n    readonly height: number;\n    /**\n     * The readonly **`ImageData.width`** property returns the number of pixels per row in the ImageData object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageData/width)\n     */\n    readonly width: number;\n}\n\ndeclare var ImageData: {\n    prototype: ImageData;\n    new(sw: number, sh: number, settings?: ImageDataSettings): ImageData;\n    new(data: ImageDataArray, sw: number, sh?: number, settings?: ImageDataSettings): ImageData;\n};\n\n/**\n * The **`ImageDecoder`** interface of the WebCodecs API provides a way to unpack and decode encoded image data.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageDecoder)\n */\ninterface ImageDecoder {\n    /**\n     * The **`complete`** read-only property of the ImageDecoder interface returns true if encoded data has completed buffering.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageDecoder/complete)\n     */\n    readonly complete: boolean;\n    /**\n     * The **`completed`** read-only property of the ImageDecoder interface returns a promise that resolves once encoded data has finished buffering.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageDecoder/completed)\n     */\n    readonly completed: Promise<void>;\n    /**\n     * The **`tracks`** read-only property of the ImageDecoder interface returns a list of the tracks in the encoded image data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageDecoder/tracks)\n     */\n    readonly tracks: ImageTrackList;\n    /**\n     * The **`type`** read-only property of the ImageDecoder interface reflects the MIME type configured during construction.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageDecoder/type)\n     */\n    readonly type: string;\n    /**\n     * The **`close()`** method of the ImageDecoder interface ends all pending work and releases system resources.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageDecoder/close)\n     */\n    close(): void;\n    /**\n     * The **`decode()`** method of the ImageDecoder interface enqueues a control message to decode the frame of an image.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageDecoder/decode)\n     */\n    decode(options?: ImageDecodeOptions): Promise<ImageDecodeResult>;\n    /**\n     * The **`reset()`** method of the ImageDecoder interface aborts all pending `decode()` operations; rejecting all pending promises.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageDecoder/reset)\n     */\n    reset(): void;\n}\n\ndeclare var ImageDecoder: {\n    prototype: ImageDecoder;\n    new(init: ImageDecoderInit): ImageDecoder;\n    /**\n     * The **`ImageDecoder.isTypeSupported()`** static method checks if a given MIME type can be decoded by the user agent.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageDecoder/isTypeSupported_static)\n     */\n    isTypeSupported(type: string): Promise<boolean>;\n};\n\n/**\n * The **`ImageTrack`** interface of the WebCodecs API represents an individual image track.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageTrack)\n */\ninterface ImageTrack {\n    /**\n     * The **`animated`** property of the ImageTrack interface returns `true` if the track is animated and therefore has multiple frames.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageTrack/animated)\n     */\n    readonly animated: boolean;\n    /**\n     * The **`frameCount`** property of the ImageTrack interface returns the number of frames in the track.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageTrack/frameCount)\n     */\n    readonly frameCount: number;\n    /**\n     * The **`repetitionCount`** property of the ImageTrack interface returns the number of repetitions of this track.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageTrack/repetitionCount)\n     */\n    readonly repetitionCount: number;\n    /**\n     * The **`selected`** property of the ImageTrack interface returns `true` if the track is selected for decoding.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageTrack/selected)\n     */\n    selected: boolean;\n}\n\ndeclare var ImageTrack: {\n    prototype: ImageTrack;\n    new(): ImageTrack;\n};\n\n/**\n * The **`ImageTrackList`** interface of the WebCodecs API represents a list of image tracks.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageTrackList)\n */\ninterface ImageTrackList {\n    /**\n     * The **`length`** property of the ImageTrackList interface returns the length of the `ImageTrackList`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageTrackList/length)\n     */\n    readonly length: number;\n    /**\n     * The **`ready`** property of the ImageTrackList interface returns a Promise that resolves when the `ImageTrackList` is populated with ImageTrack.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageTrackList/ready)\n     */\n    readonly ready: Promise<void>;\n    /**\n     * The **`selectedIndex`** property of the ImageTrackList interface returns the `index` of the selected track.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageTrackList/selectedIndex)\n     */\n    readonly selectedIndex: number;\n    /**\n     * The **`selectedTrack`** property of the ImageTrackList interface returns an ImageTrack object representing the currently selected track.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/ImageTrackList/selectedTrack)\n     */\n    readonly selectedTrack: ImageTrack | null;\n    [index: number]: ImageTrack;\n}\n\ndeclare var ImageTrackList: {\n    prototype: ImageTrackList;\n    new(): ImageTrackList;\n};\n\ninterface ImportMeta {\n    url: string;\n    resolve(specifier: string): string;\n}\n\n/**\n * The **`InputDeviceInfo`** interface of the Media Capture and Streams API gives access to the capabilities of the input device that it represents.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/InputDeviceInfo)\n */\ninterface InputDeviceInfo extends MediaDeviceInfo {\n    /**\n     * The **`getCapabilities()`** method of the InputDeviceInfo interface returns a `MediaTrackCapabilities` object describing the primary audio or video track of the device's MediaStream.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/InputDeviceInfo/getCapabilities)\n     */\n    getCapabilities(): MediaTrackCapabilities;\n}\n\ndeclare var InputDeviceInfo: {\n    prototype: InputDeviceInfo;\n    new(): InputDeviceInfo;\n};\n\n/**\n * The **`InputEvent`** interface represents an event notifying the user of editable content changes.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/InputEvent)\n */\ninterface InputEvent extends UIEvent {\n    /**\n     * The **`data`** read-only property of the characters.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/InputEvent/data)\n     */\n    readonly data: string | null;\n    /**\n     * The **`dataTransfer`** read-only property of the containing information about richtext or plaintext data being added to or removed from editable content.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/InputEvent/dataTransfer)\n     */\n    readonly dataTransfer: DataTransfer | null;\n    /**\n     * The **`inputType`** read-only property of the Possible changes include for example inserting, deleting, and formatting text.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/InputEvent/inputType)\n     */\n    readonly inputType: string;\n    /**\n     * The **`InputEvent.isComposing`** read-only property returns a boolean value indicating if the event is fired after A boolean.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/InputEvent/isComposing)\n     */\n    readonly isComposing: boolean;\n    /**\n     * The **`getTargetRanges()`** method of the InputEvent interface returns an array of StaticRange objects that will be affected by a change to the DOM if the input event is not canceled.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/InputEvent/getTargetRanges)\n     */\n    getTargetRanges(): StaticRange[];\n}\n\ndeclare var InputEvent: {\n    prototype: InputEvent;\n    new(type: string, eventInitDict?: InputEventInit): InputEvent;\n};\n\n/**\n * The **`IntersectionObserver`** interface of the Intersection Observer API provides a way to asynchronously observe changes in the intersection of a target element with an ancestor element or with a top-level document's viewport.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserver)\n */\ninterface IntersectionObserver {\n    /**\n     * The IntersectionObserver interface's read-only **`root`** property identifies the Element or of the viewport for the element which is the observer's target.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserver/root)\n     */\n    readonly root: Element | Document | null;\n    /**\n     * The IntersectionObserver interface's read-only **`rootMargin`** property is a string with syntax similar to that of the CSS margin property.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserver/rootMargin)\n     */\n    readonly rootMargin: string;\n    /**\n     * The IntersectionObserver interface's read-only **`thresholds`** property returns the list of intersection thresholds that was specified when the observer was instantiated with only one threshold ratio was provided when instantiating the object, this will be an array containing that single value.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserver/thresholds)\n     */\n    readonly thresholds: ReadonlyArray<number>;\n    /**\n     * The IntersectionObserver method **`disconnect()`** stops watching all of its target elements for visibility changes.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserver/disconnect)\n     */\n    disconnect(): void;\n    /**\n     * The IntersectionObserver method **`observe()`** adds an element to the set of target elements being watched by the `IntersectionObserver`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserver/observe)\n     */\n    observe(target: Element): void;\n    /**\n     * The IntersectionObserver method **`takeRecords()`** returns an array of has experienced an intersection change since the last time the intersections were checked, either explicitly through a call to this method or implicitly by an automatic call to the observer's callback.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserver/takeRecords)\n     */\n    takeRecords(): IntersectionObserverEntry[];\n    /**\n     * The IntersectionObserver method **`unobserve()`** instructs the `IntersectionObserver` to stop observing the specified target element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserver/unobserve)\n     */\n    unobserve(target: Element): void;\n}\n\ndeclare var IntersectionObserver: {\n    prototype: IntersectionObserver;\n    new(callback: IntersectionObserverCallback, options?: IntersectionObserverInit): IntersectionObserver;\n};\n\n/**\n * The **`IntersectionObserverEntry`** interface of the Intersection Observer API describes the intersection between the target element and its root container at a specific moment of transition.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserverEntry)\n */\ninterface IntersectionObserverEntry {\n    /**\n     * The IntersectionObserverEntry interface's read-only **`boundingClientRect`** property returns a smallest rectangle that contains the entire target element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserverEntry/boundingClientRect)\n     */\n    readonly boundingClientRect: DOMRectReadOnly;\n    /**\n     * The IntersectionObserverEntry interface's read-only **`intersectionRatio`** property tells you how much of the target element is currently visible within the root's intersection ratio, as a value between 0.0 and 1.0.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserverEntry/intersectionRatio)\n     */\n    readonly intersectionRatio: number;\n    /**\n     * The IntersectionObserverEntry interface's read-only **`intersectionRect`** property is a contains the entire portion of the target element which is currently visible within the intersection root.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserverEntry/intersectionRect)\n     */\n    readonly intersectionRect: DOMRectReadOnly;\n    /**\n     * The IntersectionObserverEntry interface's read-only **`isIntersecting`** property is a Boolean value which is `true` if the target element intersects with the intersection observer's root.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserverEntry/isIntersecting)\n     */\n    readonly isIntersecting: boolean;\n    /**\n     * The IntersectionObserverEntry interface's read-only **`rootBounds`** property is a rectangle, offset by the IntersectionObserver.rootMargin if one is specified.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserverEntry/rootBounds)\n     */\n    readonly rootBounds: DOMRectReadOnly | null;\n    /**\n     * The IntersectionObserverEntry interface's read-only **`target`** property indicates which targeted root.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserverEntry/target)\n     */\n    readonly target: Element;\n    /**\n     * The IntersectionObserverEntry interface's read-only **`time`** property is a change occurred relative to the time at which the document was created.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/IntersectionObserverEntry/time)\n     */\n    readonly time: DOMHighResTimeStamp;\n}\n\ndeclare var IntersectionObserverEntry: {\n    prototype: IntersectionObserverEntry;\n    new(): IntersectionObserverEntry;\n};\n\n/**\n * The **`KHR_parallel_shader_compile`** extension is part of the WebGL API and enables a non-blocking poll operation, so that compile/link status availability (`COMPLETION_STATUS_KHR`) can be queried without potentially incurring stalls.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KHR_parallel_shader_compile)\n */\ninterface KHR_parallel_shader_compile {\n    readonly COMPLETION_STATUS_KHR: 0x91B1;\n}\n\n/**\n * **`KeyboardEvent`** objects describe a user interaction with the keyboard; each event describes a single interaction between the user and a key (or combination of a key with modifier keys) on the keyboard.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent)\n */\ninterface KeyboardEvent extends UIEvent {\n    /**\n     * The **`KeyboardEvent.altKey`** read-only property is a boolean value that indicates if the <kbd>alt</kbd> key (<kbd>Option</kbd> or <kbd>⌥</kbd> on macOS) was pressed (`true`) or not (`false`) when the event occurred.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/altKey)\n     */\n    readonly altKey: boolean;\n    /**\n     * The **`charCode`** read-only property of the pressed during a Element/keypress_event event.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/charCode)\n     */\n    readonly charCode: number;\n    /**\n     * The `KeyboardEvent.code` property represents a physical key on the keyboard (as opposed to the character generated by pressing the key).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/code)\n     */\n    readonly code: string;\n    /**\n     * The **`KeyboardEvent.ctrlKey`** read-only property returns a boolean value that indicates if the <kbd>control</kbd> key was pressed (`true`) or not (`false`) when the event occurred.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/ctrlKey)\n     */\n    readonly ctrlKey: boolean;\n    /**\n     * The **`KeyboardEvent.isComposing`** read-only property returns a boolean value indicating if the event is fired within a composition session, i.e., after Element/compositionstart_event and before Element/compositionend_event.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/isComposing)\n     */\n    readonly isComposing: boolean;\n    /**\n     * The KeyboardEvent interface's **`key`** read-only property returns the value of the key pressed by the user, taking into consideration the state of modifier keys such as <kbd>Shift</kbd> as well as the keyboard locale and layout.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/key)\n     */\n    readonly key: string;\n    /**\n     * The deprecated **`KeyboardEvent.keyCode`** read-only property represents a system and implementation dependent numerical code identifying the unmodified value of the pressed key.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/keyCode)\n     */\n    readonly keyCode: number;\n    /**\n     * The **`KeyboardEvent.location`** read-only property returns an `unsigned long` representing the location of the key on the keyboard or other input device.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/location)\n     */\n    readonly location: number;\n    /**\n     * The **`KeyboardEvent.metaKey`** read-only property returning a boolean value that indicates if the <kbd>Meta</kbd> key was pressed (`true`) or not (`false`) when the event occurred.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/metaKey)\n     */\n    readonly metaKey: boolean;\n    /**\n     * The **`repeat`** read-only property of the `true` if the given key is being held down such that it is automatically repeating.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/repeat)\n     */\n    readonly repeat: boolean;\n    /**\n     * The **`KeyboardEvent.shiftKey`** read-only property is a boolean value that indicates if the <kbd>shift</kbd> key was pressed (`true`) or not (`false`) when the event occurred.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/shiftKey)\n     */\n    readonly shiftKey: boolean;\n    /**\n     * The **`KeyboardEvent.getModifierState()`** method returns the current state of the specified modifier key: `true` if the modifier is active (that is the modifier key is pressed or locked), otherwise, `false`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/getModifierState)\n     */\n    getModifierState(keyArg: string): boolean;\n    /**\n     * The **`KeyboardEvent.initKeyboardEvent()`** method initializes the attributes of a keyboard event object.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyboardEvent/initKeyboardEvent)\n     */\n    initKeyboardEvent(typeArg: string, bubblesArg?: boolean, cancelableArg?: boolean, viewArg?: Window | null, keyArg?: string, locationArg?: number, ctrlKey?: boolean, altKey?: boolean, shiftKey?: boolean, metaKey?: boolean): void;\n    readonly DOM_KEY_LOCATION_STANDARD: 0x00;\n    readonly DOM_KEY_LOCATION_LEFT: 0x01;\n    readonly DOM_KEY_LOCATION_RIGHT: 0x02;\n    readonly DOM_KEY_LOCATION_NUMPAD: 0x03;\n}\n\ndeclare var KeyboardEvent: {\n    prototype: KeyboardEvent;\n    new(type: string, eventInitDict?: KeyboardEventInit): KeyboardEvent;\n    readonly DOM_KEY_LOCATION_STANDARD: 0x00;\n    readonly DOM_KEY_LOCATION_LEFT: 0x01;\n    readonly DOM_KEY_LOCATION_RIGHT: 0x02;\n    readonly DOM_KEY_LOCATION_NUMPAD: 0x03;\n};\n\n/**\n * The **`KeyframeEffect`** interface of the Web Animations API lets us create sets of animatable properties and values, called **keyframes.** These can then be played using the Animation.Animation constructor.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyframeEffect)\n */\ninterface KeyframeEffect extends AnimationEffect {\n    /**\n     * The **`composite`** property of a KeyframeEffect resolves how an element's animation impacts its underlying property values.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyframeEffect/composite)\n     */\n    composite: CompositeOperation;\n    /**\n     * The **`iterationComposite`** property of a KeyframeEffect resolves how the animation's property value changes accumulate or override each other upon each of the animation's iterations.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyframeEffect/iterationComposite)\n     */\n    iterationComposite: IterationCompositeOperation;\n    /**\n     * The **`pseudoElement`** property of a KeyframeEffect interface is a string representing the pseudo-element being animated.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyframeEffect/pseudoElement)\n     */\n    pseudoElement: string | null;\n    /**\n     * The **`target`** property of a KeyframeEffect interface represents the element or pseudo-element being animated.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyframeEffect/target)\n     */\n    target: Element | null;\n    /**\n     * The **`getKeyframes()`** method of a KeyframeEffect returns an Array of the computed keyframes that make up this animation along with their computed offsets.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyframeEffect/getKeyframes)\n     */\n    getKeyframes(): ComputedKeyframe[];\n    /**\n     * The **`setKeyframes()`** method of the KeyframeEffect interface replaces the keyframes that make up the affected `KeyframeEffect` with a new set of keyframes.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/KeyframeEffect/setKeyframes)\n     */\n    setKeyframes(keyframes: Keyframe[] | PropertyIndexedKeyframes | null): void;\n}\n\ndeclare var KeyframeEffect: {\n    prototype: KeyframeEffect;\n    new(target: Element | null, keyframes: Keyframe[] | PropertyIndexedKeyframes | null, options?: number | KeyframeEffectOptions): KeyframeEffect;\n    new(source: KeyframeEffect): KeyframeEffect;\n};\n\n/**\n * The `LargestContentfulPaint` interface provides timing information about the largest image or text paint before user input on a web page.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/LargestContentfulPaint)\n */\ninterface LargestContentfulPaint extends PerformanceEntry {\n    /**\n     * The **`element`** read-only property of the LargestContentfulPaint interface returns an object representing the Element that is the largest contentful paint.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/LargestContentfulPaint/element)\n     */\n    readonly element: Element | null;\n    /**\n     * The **`id`** read-only property of the LargestContentfulPaint interface returns the ID of the element that is the largest contentful paint.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/LargestContentfulPaint/id)\n     */\n    readonly id: string;\n    /**\n     * The **`loadTime`** read-only property of the LargestContentfulPaint interface returns the time that the element was loaded.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/LargestContentfulPaint/loadTime)\n     */\n    readonly loadTime: DOMHighResTimeStamp;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/LargestContentfulPaint/renderTime) */\n    readonly renderTime: DOMHighResTimeStamp;\n    /**\n     * The **`size`** read-only property of the LargestContentfulPaint interface returns the intrinsic size of the element that is the largest contentful paint.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/LargestContentfulPaint/size)\n     */\n    readonly size: number;\n    /**\n     * The **`url`** read-only property of the LargestContentfulPaint interface returns the request URL of the element, if the element is an image.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/LargestContentfulPaint/url)\n     */\n    readonly url: string;\n    /**\n     * The **`toJSON()`** method of the LargestContentfulPaint interface is a Serialization; it returns a JSON representation of the LargestContentfulPaint object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/LargestContentfulPaint/toJSON)\n     */\n    toJSON(): any;\n}\n\ndeclare var LargestContentfulPaint: {\n    prototype: LargestContentfulPaint;\n    new(): LargestContentfulPaint;\n};\n\ninterface LinkStyle {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/HTMLLinkElement/sheet) */\n    readonly sheet: CSSStyleSheet | null;\n}\n\n/**\n * The **`Location`** interface represents the location (URL) of the object it is linked to.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location)\n */\ninterface Location {\n    /**\n     * The **`ancestorOrigins`** read-only property of the Location interface is a static browsing contexts of the document associated with the given Location object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/ancestorOrigins)\n     */\n    readonly ancestorOrigins: DOMStringList;\n    /**\n     * The **`hash`** property of the Location interface is a string containing a `'#'` followed by the fragment identifier of the location URL.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/hash)\n     */\n    hash: string;\n    /**\n     * The **`host`** property of the Location interface is a string containing the host, which is the Location.hostname, and then, if the port of the URL is nonempty, a `':'`, followed by the Location.port of the URL.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/host)\n     */\n    host: string;\n    /**\n     * The **`hostname`** property of the Location interface is a string containing either the domain name or IP address of the location URL.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/hostname)\n     */\n    hostname: string;\n    /**\n     * The **`href`** property of the Location interface is a stringifier that returns a string containing the whole URL, and allows the href to be updated.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/href)\n     */\n    href: string;\n    toString(): string;\n    /**\n     * The **`origin`** read-only property of the Location interface returns a string containing the Unicode serialization of the origin of the location's URL.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/origin)\n     */\n    readonly origin: string;\n    /**\n     * The **`pathname`** property of the Location interface is a string containing the path of the URL for the location.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/pathname)\n     */\n    pathname: string;\n    /**\n     * The **`port`** property of the Location interface is a string containing the port number of the location's URL.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/port)\n     */\n    port: string;\n    /**\n     * The **`protocol`** property of the Location interface is a string containing the protocol or scheme of the location's URL, including the final `':'`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/protocol)\n     */\n    protocol: string;\n    /**\n     * The **`search`** property of the Location interface is a search string, also called a _query string_, that is a string containing a `'?'` followed by the parameters of the location's URL.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/search)\n     */\n    search: string;\n    /**\n     * The **`assign()`** method of the Location interface causes the window to load and display the document at the URL specified.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/assign)\n     */\n    assign(url: string | URL): void;\n    /**\n     * The **`reload()`** method of the Location interface reloads the current URL, like the Refresh button.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/reload)\n     */\n    reload(): void;\n    /**\n     * The **`replace()`** method of the Location interface replaces the current resource with the one at the provided URL.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Location/replace)\n     */\n    replace(url: string | URL): void;\n}\n\ndeclare var Location: {\n    prototype: Location;\n    new(): Location;\n};\n\n/**\n * The **`Lock`** interface of the Web Locks API provides the name and mode of a lock.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Lock)\n */\ninterface Lock {\n    /**\n     * The **`mode`** read-only property of the Lock interface returns the access mode passed to LockManager.request() when the lock was requested.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Lock/mode)\n     */\n    readonly mode: LockMode;\n    /**\n     * The **`name`** read-only property of the Lock interface returns the _name_ passed to The name of a lock is passed by script when the lock is requested.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/Lock/name)\n     */\n    readonly name: string;\n}\n\ndeclare var Lock: {\n    prototype: Lock;\n    new(): Lock;\n};\n\n/**\n * The **`LockManager`** interface of the Web Locks API provides methods for requesting a new Lock object and querying for an existing `Lock` object.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/LockManager)\n */\ninterface LockManager {\n    /**\n     * The **`query()`** method of the LockManager interface returns a Promise that resolves with an object containing information about held and pending locks.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/LockManager/query)\n     */\n    query(): Promise<LockManagerSnapshot>;\n    /**\n     * The **`request()`** method of the LockManager interface requests a Lock object with parameters specifying its name and characteristics.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/LockManager/request)\n     */\n    request<T>(name: string, callback: LockGrantedCallback<T>): Promise<T>;\n    request<T>(name: string, options: LockOptions, callback: LockGrantedCallback<T>): Promise<T>;\n}\n\ndeclare var LockManager: {\n    prototype: LockManager;\n    new(): LockManager;\n};\n\ninterface MIDIAccessEventMap {\n    \"statechange\": MIDIConnectionEvent;\n}\n\n/**\n * The **`MIDIAccess`** interface of the Web MIDI API provides methods for listing MIDI input and output devices, and obtaining access to those devices.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIAccess)\n */\ninterface MIDIAccess extends EventTarget {\n    /**\n     * The **`inputs`** read-only property of the MIDIAccess interface provides access to any available MIDI input ports.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIAccess/inputs)\n     */\n    readonly inputs: MIDIInputMap;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIAccess/statechange_event) */\n    onstatechange: ((this: MIDIAccess, ev: MIDIConnectionEvent) => any) | null;\n    /**\n     * The **`outputs`** read-only property of the MIDIAccess interface provides access to any available MIDI output ports.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIAccess/outputs)\n     */\n    readonly outputs: MIDIOutputMap;\n    /**\n     * The **`sysexEnabled`** read-only property of the MIDIAccess interface indicates whether system exclusive support is enabled on the current MIDIAccess instance.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIAccess/sysexEnabled)\n     */\n    readonly sysexEnabled: boolean;\n    addEventListener<K extends keyof MIDIAccessEventMap>(type: K, listener: (this: MIDIAccess, ev: MIDIAccessEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MIDIAccessEventMap>(type: K, listener: (this: MIDIAccess, ev: MIDIAccessEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MIDIAccess: {\n    prototype: MIDIAccess;\n    new(): MIDIAccess;\n};\n\n/**\n * The **`MIDIConnectionEvent`** interface of the Web MIDI API is the event passed to the MIDIAccess.statechange_event event of the MIDIAccess interface and the MIDIPort.statechange_event event of the MIDIPort interface.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIConnectionEvent)\n */\ninterface MIDIConnectionEvent extends Event {\n    /**\n     * The **`port`** read-only property of the MIDIConnectionEvent interface returns the port that has been disconnected or connected.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIConnectionEvent/port)\n     */\n    readonly port: MIDIPort | null;\n}\n\ndeclare var MIDIConnectionEvent: {\n    prototype: MIDIConnectionEvent;\n    new(type: string, eventInitDict?: MIDIConnectionEventInit): MIDIConnectionEvent;\n};\n\ninterface MIDIInputEventMap extends MIDIPortEventMap {\n    \"midimessage\": MIDIMessageEvent;\n}\n\n/**\n * The **`MIDIInput`** interface of the Web MIDI API receives messages from a MIDI input port.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIInput)\n */\ninterface MIDIInput extends MIDIPort {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIInput/midimessage_event) */\n    onmidimessage: ((this: MIDIInput, ev: MIDIMessageEvent) => any) | null;\n    addEventListener<K extends keyof MIDIInputEventMap>(type: K, listener: (this: MIDIInput, ev: MIDIInputEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MIDIInputEventMap>(type: K, listener: (this: MIDIInput, ev: MIDIInputEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MIDIInput: {\n    prototype: MIDIInput;\n    new(): MIDIInput;\n};\n\n/**\n * The **`MIDIInputMap`** read-only interface of the Web MIDI API provides the set of MIDI input ports that are currently available.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIInputMap)\n */\ninterface MIDIInputMap {\n    forEach(callbackfn: (value: MIDIInput, key: string, parent: MIDIInputMap) => void, thisArg?: any): void;\n}\n\ndeclare var MIDIInputMap: {\n    prototype: MIDIInputMap;\n    new(): MIDIInputMap;\n};\n\n/**\n * The **`MIDIMessageEvent`** interface of the Web MIDI API represents the event passed to the MIDIInput.midimessage_event event of the MIDIInput interface.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIMessageEvent)\n */\ninterface MIDIMessageEvent extends Event {\n    /**\n     * The **`data`** read-only property of the MIDIMessageEvent interface returns the MIDI data bytes of a single MIDI message.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIMessageEvent/data)\n     */\n    readonly data: Uint8Array<ArrayBuffer> | null;\n}\n\ndeclare var MIDIMessageEvent: {\n    prototype: MIDIMessageEvent;\n    new(type: string, eventInitDict?: MIDIMessageEventInit): MIDIMessageEvent;\n};\n\n/**\n * The **`MIDIOutput`** interface of the Web MIDI API provides methods to add messages to the queue of an output device, and to clear the queue of messages.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIOutput)\n */\ninterface MIDIOutput extends MIDIPort {\n    /**\n     * The **`send()`** method of the MIDIOutput interface queues messages for the corresponding MIDI port.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIOutput/send)\n     */\n    send(data: number[], timestamp?: DOMHighResTimeStamp): void;\n    addEventListener<K extends keyof MIDIPortEventMap>(type: K, listener: (this: MIDIOutput, ev: MIDIPortEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MIDIPortEventMap>(type: K, listener: (this: MIDIOutput, ev: MIDIPortEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MIDIOutput: {\n    prototype: MIDIOutput;\n    new(): MIDIOutput;\n};\n\n/**\n * The **`MIDIOutputMap`** read-only interface of the Web MIDI API provides the set of MIDI output ports that are currently available.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIOutputMap)\n */\ninterface MIDIOutputMap {\n    forEach(callbackfn: (value: MIDIOutput, key: string, parent: MIDIOutputMap) => void, thisArg?: any): void;\n}\n\ndeclare var MIDIOutputMap: {\n    prototype: MIDIOutputMap;\n    new(): MIDIOutputMap;\n};\n\ninterface MIDIPortEventMap {\n    \"statechange\": MIDIConnectionEvent;\n}\n\n/**\n * The **`MIDIPort`** interface of the Web MIDI API represents a MIDI input or output port.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort)\n */\ninterface MIDIPort extends EventTarget {\n    /**\n     * The **`connection`** read-only property of the MIDIPort interface returns the connection state of the port.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/connection)\n     */\n    readonly connection: MIDIPortConnectionState;\n    /**\n     * The **`id`** read-only property of the MIDIPort interface returns the unique ID of the port.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/id)\n     */\n    readonly id: string;\n    /**\n     * The **`manufacturer`** read-only property of the MIDIPort interface returns the manufacturer of the port.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/manufacturer)\n     */\n    readonly manufacturer: string | null;\n    /**\n     * The **`name`** read-only property of the MIDIPort interface returns the system name of the port.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/name)\n     */\n    readonly name: string | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/statechange_event) */\n    onstatechange: ((this: MIDIPort, ev: MIDIConnectionEvent) => any) | null;\n    /**\n     * The **`state`** read-only property of the MIDIPort interface returns the state of the port.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/state)\n     */\n    readonly state: MIDIPortDeviceState;\n    /**\n     * The **`type`** read-only property of the MIDIPort interface returns the type of the port, indicating whether this is an input or output MIDI port.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/type)\n     */\n    readonly type: MIDIPortType;\n    /**\n     * The **`version`** read-only property of the MIDIPort interface returns the version of the port.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/version)\n     */\n    readonly version: string | null;\n    /**\n     * The **`close()`** method of the MIDIPort interface makes the access to the MIDI device connected to this `MIDIPort` unavailable.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/close)\n     */\n    close(): Promise<MIDIPort>;\n    /**\n     * The **`open()`** method of the MIDIPort interface makes the MIDI device connected to this `MIDIPort` explicitly available.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MIDIPort/open)\n     */\n    open(): Promise<MIDIPort>;\n    addEventListener<K extends keyof MIDIPortEventMap>(type: K, listener: (this: MIDIPort, ev: MIDIPortEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MIDIPortEventMap>(type: K, listener: (this: MIDIPort, ev: MIDIPortEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MIDIPort: {\n    prototype: MIDIPort;\n    new(): MIDIPort;\n};\n\ninterface MathMLElementEventMap extends ElementEventMap, GlobalEventHandlersEventMap {\n}\n\n/**\n * The **`MathMLElement`** interface represents any MathML element.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MathMLElement)\n */\ninterface MathMLElement extends Element, ElementCSSInlineStyle, GlobalEventHandlers, HTMLOrSVGElement {\n    addEventListener<K extends keyof MathMLElementEventMap>(type: K, listener: (this: MathMLElement, ev: MathMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MathMLElementEventMap>(type: K, listener: (this: MathMLElement, ev: MathMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MathMLElement: {\n    prototype: MathMLElement;\n    new(): MathMLElement;\n};\n\n/**\n * The **`MediaCapabilities`** interface of the Media Capabilities API provides information about the decoding abilities of the device, system and browser.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaCapabilities)\n */\ninterface MediaCapabilities {\n    /**\n     * The **`decodingInfo()`** method of the MediaCapabilities interface returns a promise that fulfils with information about how well the user agent can decode/display media with a given configuration.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaCapabilities/decodingInfo)\n     */\n    decodingInfo(configuration: MediaDecodingConfiguration): Promise<MediaCapabilitiesDecodingInfo>;\n    /**\n     * The **`encodingInfo()`** method of the MediaCapabilities interface returns a promise that fulfills with the tested media configuration's capabilities for encoding media.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaCapabilities/encodingInfo)\n     */\n    encodingInfo(configuration: MediaEncodingConfiguration): Promise<MediaCapabilitiesEncodingInfo>;\n}\n\ndeclare var MediaCapabilities: {\n    prototype: MediaCapabilities;\n    new(): MediaCapabilities;\n};\n\n/**\n * The **`MediaDeviceInfo`** interface of the Media Capture and Streams API contains information that describes a single media input or output device.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDeviceInfo)\n */\ninterface MediaDeviceInfo {\n    /**\n     * The **`deviceId`** read-only property of the MediaDeviceInfo interface returns a string that is an identifier for the represented device and is persisted across sessions.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDeviceInfo/deviceId)\n     */\n    readonly deviceId: string;\n    /**\n     * The **`groupId`** read-only property of the MediaDeviceInfo interface returns a string that is a group identifier.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDeviceInfo/groupId)\n     */\n    readonly groupId: string;\n    /**\n     * The **`kind`** read-only property of the MediaDeviceInfo interface returns an enumerated value, that is either `'videoinput'`, `'audioinput'` or `'audiooutput'`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDeviceInfo/kind)\n     */\n    readonly kind: MediaDeviceKind;\n    /**\n     * The **`label`** read-only property of the MediaDeviceInfo interface returns a string describing this device (for example 'External USB Webcam').\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDeviceInfo/label)\n     */\n    readonly label: string;\n    /**\n     * The **`toJSON()`** method of the MediaDeviceInfo interface is a Serialization; it returns a JSON representation of the MediaDeviceInfo object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDeviceInfo/toJSON)\n     */\n    toJSON(): any;\n}\n\ndeclare var MediaDeviceInfo: {\n    prototype: MediaDeviceInfo;\n    new(): MediaDeviceInfo;\n};\n\ninterface MediaDevicesEventMap {\n    \"devicechange\": Event;\n}\n\n/**\n * The **`MediaDevices`** interface of the Media Capture and Streams API provides access to connected media input devices like cameras and microphones, as well as screen sharing.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDevices)\n */\ninterface MediaDevices extends EventTarget {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDevices/devicechange_event) */\n    ondevicechange: ((this: MediaDevices, ev: Event) => any) | null;\n    /**\n     * The **`enumerateDevices()`** method of the MediaDevices interface requests a list of the currently available media input and output devices, such as microphones, cameras, headsets, and so forth.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDevices/enumerateDevices)\n     */\n    enumerateDevices(): Promise<MediaDeviceInfo[]>;\n    /**\n     * The **`getDisplayMedia()`** method of the MediaDevices interface prompts the user to select and grant permission to capture the contents of a display or portion thereof (such as a window) as a MediaStream.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDevices/getDisplayMedia)\n     */\n    getDisplayMedia(options?: DisplayMediaStreamOptions): Promise<MediaStream>;\n    /**\n     * The **`getSupportedConstraints()`** method of the MediaDevices interface returns an object based on the MediaTrackSupportedConstraints dictionary, whose member fields each specify one of the constrainable properties the user agent understands.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDevices/getSupportedConstraints)\n     */\n    getSupportedConstraints(): MediaTrackSupportedConstraints;\n    /**\n     * The **`getUserMedia()`** method of the MediaDevices interface prompts the user for permission to use a media input which produces a MediaStream with tracks containing the requested types of media.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaDevices/getUserMedia)\n     */\n    getUserMedia(constraints?: MediaStreamConstraints): Promise<MediaStream>;\n    addEventListener<K extends keyof MediaDevicesEventMap>(type: K, listener: (this: MediaDevices, ev: MediaDevicesEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaDevicesEventMap>(type: K, listener: (this: MediaDevices, ev: MediaDevicesEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaDevices: {\n    prototype: MediaDevices;\n    new(): MediaDevices;\n};\n\n/**\n * The `MediaElementAudioSourceNode` interface represents an audio source consisting of an HTML audio or video element.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaElementAudioSourceNode)\n */\ninterface MediaElementAudioSourceNode extends AudioNode {\n    /**\n     * The MediaElementAudioSourceNode interface's read-only **`mediaElement`** property indicates the receiving audio.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaElementAudioSourceNode/mediaElement)\n     */\n    readonly mediaElement: HTMLMediaElement;\n}\n\ndeclare var MediaElementAudioSourceNode: {\n    prototype: MediaElementAudioSourceNode;\n    new(context: AudioContext, options: MediaElementAudioSourceOptions): MediaElementAudioSourceNode;\n};\n\n/**\n * The **`MediaEncryptedEvent`** interface of the Encrypted Media Extensions API contains the information associated with an HTMLMediaElement/encrypted_event event sent to a HTMLMediaElement when some initialization data is encountered in the media.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaEncryptedEvent)\n */\ninterface MediaEncryptedEvent extends Event {\n    /**\n     * The read-only **`initData`** property of the MediaKeyMessageEvent returns the initialization data contained in this event, if any.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaEncryptedEvent/initData)\n     */\n    readonly initData: ArrayBuffer | null;\n    /**\n     * The read-only **`initDataType`** property of the MediaKeyMessageEvent returns a case-sensitive string describing the type of the initialization data associated with this event.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaEncryptedEvent/initDataType)\n     */\n    readonly initDataType: string;\n}\n\ndeclare var MediaEncryptedEvent: {\n    prototype: MediaEncryptedEvent;\n    new(type: string, eventInitDict?: MediaEncryptedEventInit): MediaEncryptedEvent;\n};\n\n/**\n * The **`MediaError`** interface represents an error which occurred while handling media in an HTML media element based on HTMLMediaElement, such as audio or video.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaError)\n */\ninterface MediaError {\n    /**\n     * The read-only property **`MediaError.code`** returns a numeric value which represents the kind of error that occurred on a media element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaError/code)\n     */\n    readonly code: number;\n    /**\n     * The read-only property **`MediaError.message`** returns a human-readable string offering specific diagnostic details related to the error described by the `MediaError` object, or an empty string (`''`) if no diagnostic information can be determined or provided.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaError/message)\n     */\n    readonly message: string;\n    readonly MEDIA_ERR_ABORTED: 1;\n    readonly MEDIA_ERR_NETWORK: 2;\n    readonly MEDIA_ERR_DECODE: 3;\n    readonly MEDIA_ERR_SRC_NOT_SUPPORTED: 4;\n}\n\ndeclare var MediaError: {\n    prototype: MediaError;\n    new(): MediaError;\n    readonly MEDIA_ERR_ABORTED: 1;\n    readonly MEDIA_ERR_NETWORK: 2;\n    readonly MEDIA_ERR_DECODE: 3;\n    readonly MEDIA_ERR_SRC_NOT_SUPPORTED: 4;\n};\n\n/**\n * The **`MediaKeyMessageEvent`** interface of the Encrypted Media Extensions API contains the content and related data when the content decryption module generates a message for the session.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeyMessageEvent)\n */\ninterface MediaKeyMessageEvent extends Event {\n    /**\n     * The **`MediaKeyMessageEvent.message`** read-only property returns an ArrayBuffer with a message from the content decryption module.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeyMessageEvent/message)\n     */\n    readonly message: ArrayBuffer;\n    /**\n     * The **`MediaKeyMessageEvent.messageType`** read-only property indicates the type of message.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeyMessageEvent/messageType)\n     */\n    readonly messageType: MediaKeyMessageType;\n}\n\ndeclare var MediaKeyMessageEvent: {\n    prototype: MediaKeyMessageEvent;\n    new(type: string, eventInitDict: MediaKeyMessageEventInit): MediaKeyMessageEvent;\n};\n\ninterface MediaKeySessionEventMap {\n    \"keystatuseschange\": Event;\n    \"message\": MediaKeyMessageEvent;\n}\n\n/**\n * The **`MediaKeySession`** interface of the Encrypted Media Extensions API represents a context for message exchange with a content decryption module (CDM).\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession)\n */\ninterface MediaKeySession extends EventTarget {\n    /**\n     * The **`closed`** read-only property of the MediaKeySession interface returns a Promise signaling when a MediaKeySession closes.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/closed)\n     */\n    readonly closed: Promise<MediaKeySessionClosedReason>;\n    /**\n     * The **`expiration`** read-only property of the MediaKeySession interface returns the time after which the keys in the current session can no longer be used to decrypt media data, or NaN if no such time exists.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/expiration)\n     */\n    readonly expiration: number;\n    /**\n     * The **`keyStatuses`** read-only property of the MediaKeySession interface returns a reference to a read-only MediaKeyStatusMap of the current session's keys and their statuses.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/keyStatuses)\n     */\n    readonly keyStatuses: MediaKeyStatusMap;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/keystatuseschange_event) */\n    onkeystatuseschange: ((this: MediaKeySession, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/message_event) */\n    onmessage: ((this: MediaKeySession, ev: MediaKeyMessageEvent) => any) | null;\n    /**\n     * The **`sessionId`** read-only property of the MediaKeySession interface contains a unique string generated by the content decryption module (CDM) for the current media object and its associated keys or licenses.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/sessionId)\n     */\n    readonly sessionId: string;\n    /**\n     * The `close()` method of the MediaKeySession interface notifies that the current media session is no longer needed, and that the content decryption module should release any resources associated with this object and close it.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/close)\n     */\n    close(): Promise<void>;\n    /**\n     * The `generateRequest()` method of the MediaKeySession interface returns a Promise after generating a license request based on initialization data.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/generateRequest)\n     */\n    generateRequest(initDataType: string, initData: BufferSource): Promise<void>;\n    /**\n     * The `load()` method of the MediaKeySession interface returns a Promise that resolves to a boolean value after loading data for a specified session object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/load)\n     */\n    load(sessionId: string): Promise<boolean>;\n    /**\n     * The `remove()` method of the MediaKeySession interface returns a Promise after removing any session data associated with the current object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/remove)\n     */\n    remove(): Promise<void>;\n    /**\n     * The `update()` method of the MediaKeySession interface loads messages and licenses to the CDM, and then returns a Promise.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySession/update)\n     */\n    update(response: BufferSource): Promise<void>;\n    addEventListener<K extends keyof MediaKeySessionEventMap>(type: K, listener: (this: MediaKeySession, ev: MediaKeySessionEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaKeySessionEventMap>(type: K, listener: (this: MediaKeySession, ev: MediaKeySessionEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaKeySession: {\n    prototype: MediaKeySession;\n    new(): MediaKeySession;\n};\n\n/**\n * The **`MediaKeyStatusMap`** interface of the Encrypted Media Extensions API is a read-only map of media key statuses by key IDs.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeyStatusMap)\n */\ninterface MediaKeyStatusMap {\n    /**\n     * The **`size`** read-only property of the MediaKeyStatusMap interface returns the number of key/value paIrs in the status map.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeyStatusMap/size)\n     */\n    readonly size: number;\n    /**\n     * The **`get()`** method of the MediaKeyStatusMap interface returns the status value associated with the given key, or `undefined` if there is none.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeyStatusMap/get)\n     */\n    get(keyId: BufferSource): MediaKeyStatus | undefined;\n    /**\n     * The **`has()`** method of the whether a value has been associated with the given key.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeyStatusMap/has)\n     */\n    has(keyId: BufferSource): boolean;\n    forEach(callbackfn: (value: MediaKeyStatus, key: BufferSource, parent: MediaKeyStatusMap) => void, thisArg?: any): void;\n}\n\ndeclare var MediaKeyStatusMap: {\n    prototype: MediaKeyStatusMap;\n    new(): MediaKeyStatusMap;\n};\n\n/**\n * The **`MediaKeySystemAccess`** interface of the Encrypted Media Extensions API provides access to a Key System for decryption and/or a content protection provider.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySystemAccess)\n */\ninterface MediaKeySystemAccess {\n    /**\n     * The **`keySystem`** read-only property of the MediaKeySystemAccess interface returns a string identifying the key system being used.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySystemAccess/keySystem)\n     */\n    readonly keySystem: string;\n    /**\n     * The `MediaKeySystemAccess.createMediaKeys()` method returns a ```js-nolint createMediaKeys() ``` None.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySystemAccess/createMediaKeys)\n     */\n    createMediaKeys(): Promise<MediaKeys>;\n    /**\n     * The **`getConfiguration()`** method of the MediaKeySystemAccess interface returns an object with the supported combination of the following configuration options: - `initDataTypes` [MISSING: ReadOnlyInline] - : Returns a list of supported initialization data type names.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeySystemAccess/getConfiguration)\n     */\n    getConfiguration(): MediaKeySystemConfiguration;\n}\n\ndeclare var MediaKeySystemAccess: {\n    prototype: MediaKeySystemAccess;\n    new(): MediaKeySystemAccess;\n};\n\n/**\n * The **`MediaKeys`** interface of Encrypted Media Extensions API represents a set of keys that an associated HTMLMediaElement can use for decryption of media data during playback.\n * Available only in secure contexts.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeys)\n */\ninterface MediaKeys {\n    /**\n     * The `createSession()` method of the MediaKeys interface returns a new MediaKeySession object, which represents a context for message exchange with a content decryption module (CDM).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeys/createSession)\n     */\n    createSession(sessionType?: MediaKeySessionType): MediaKeySession;\n    /**\n     * The `getStatusForPolicy()` method of the MediaKeys interface is used to check whether the Content Decryption Module (CDM) would allow the presentation of encrypted media data using the keys, based on the specified policy requirements.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeys/getStatusForPolicy)\n     */\n    getStatusForPolicy(policy?: MediaKeysPolicy): Promise<MediaKeyStatus>;\n    /**\n     * The **`setServerCertificate()`** method of the MediaKeys interface provides a server certificate to be used to encrypt messages to the license server.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaKeys/setServerCertificate)\n     */\n    setServerCertificate(serverCertificate: BufferSource): Promise<boolean>;\n}\n\ndeclare var MediaKeys: {\n    prototype: MediaKeys;\n    new(): MediaKeys;\n};\n\n/**\n * The **`MediaList`** interface represents the media queries of a stylesheet, e.g., those set using a link element's `media` attribute.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaList)\n */\ninterface MediaList {\n    /**\n     * The read-only **`length`** property of the MediaList interface returns the number of media queries in the list.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaList/length)\n     */\n    readonly length: number;\n    /**\n     * The **`mediaText`** property of the MediaList interface is a stringifier that returns a string representing the `MediaList` as text, and also allows you to set a new `MediaList`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaList/mediaText)\n     */\n    mediaText: string;\n    toString(): string;\n    /**\n     * The `appendMedium()` method of the MediaList interface adds a media query to the list.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaList/appendMedium)\n     */\n    appendMedium(medium: string): void;\n    /**\n     * The `deleteMedium()` method of the MediaList interface removes from this `MediaList` the given media query.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaList/deleteMedium)\n     */\n    deleteMedium(medium: string): void;\n    /**\n     * The **`item()`** method of the MediaList interface returns the media query at the specified `index`, or `null` if the specified `index` doesn't exist.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaList/item)\n     */\n    item(index: number): string | null;\n    [index: number]: string;\n}\n\ndeclare var MediaList: {\n    prototype: MediaList;\n    new(): MediaList;\n};\n\n/**\n * The **`MediaMetadata`** interface of the Media Session API allows a web page to provide rich media metadata for display in a platform UI.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaMetadata)\n */\ninterface MediaMetadata {\n    /**\n     * The **`album`** property of the collection containing the media to be played.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaMetadata/album)\n     */\n    album: string;\n    /**\n     * The **`artist`** property of the creator, etc., of the media to be played.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaMetadata/artist)\n     */\n    artist: string;\n    /**\n     * The **`artwork`** property of the objects representing images associated with playing media.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaMetadata/artwork)\n     */\n    artwork: ReadonlyArray<MediaImage>;\n    /**\n     * The **`title`** property of the played.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaMetadata/title)\n     */\n    title: string;\n}\n\ndeclare var MediaMetadata: {\n    prototype: MediaMetadata;\n    new(init?: MediaMetadataInit): MediaMetadata;\n};\n\ninterface MediaQueryListEventMap {\n    \"change\": MediaQueryListEvent;\n}\n\n/**\n * A **`MediaQueryList`** object stores information on a media query applied to a document, with support for both immediate and event-driven matching against the state of the document.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryList)\n */\ninterface MediaQueryList extends EventTarget {\n    /**\n     * The **`matches`** read-only property of the `true` if the document currently matches the media query list, or `false` if not.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryList/matches)\n     */\n    readonly matches: boolean;\n    /**\n     * The **`media`** read-only property of the serialized media query.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryList/media)\n     */\n    readonly media: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryList/change_event) */\n    onchange: ((this: MediaQueryList, ev: MediaQueryListEvent) => any) | null;\n    /**\n     * The deprecated **`addListener()`** method of the `MediaQueryListener` that will run a custom callback function in response to the media query status changing.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryList/addListener)\n     */\n    addListener(callback: ((this: MediaQueryList, ev: MediaQueryListEvent) => any) | null): void;\n    /**\n     * The **`removeListener()`** method of the `MediaQueryListener`.\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryList/removeListener)\n     */\n    removeListener(callback: ((this: MediaQueryList, ev: MediaQueryListEvent) => any) | null): void;\n    addEventListener<K extends keyof MediaQueryListEventMap>(type: K, listener: (this: MediaQueryList, ev: MediaQueryListEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaQueryListEventMap>(type: K, listener: (this: MediaQueryList, ev: MediaQueryListEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaQueryList: {\n    prototype: MediaQueryList;\n    new(): MediaQueryList;\n};\n\n/**\n * The `MediaQueryListEvent` object stores information on the changes that have happened to a MediaQueryList object — instances are available as the event object on a function referenced by a MediaQueryList.change_event event.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryListEvent)\n */\ninterface MediaQueryListEvent extends Event {\n    /**\n     * The **`matches`** read-only property of the `true` if the document currently matches the media query list, or `false` if not.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryListEvent/matches)\n     */\n    readonly matches: boolean;\n    /**\n     * The **`media`** read-only property of the a serialized media query.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaQueryListEvent/media)\n     */\n    readonly media: string;\n}\n\ndeclare var MediaQueryListEvent: {\n    prototype: MediaQueryListEvent;\n    new(type: string, eventInitDict?: MediaQueryListEventInit): MediaQueryListEvent;\n};\n\ninterface MediaRecorderEventMap {\n    \"dataavailable\": BlobEvent;\n    \"error\": ErrorEvent;\n    \"pause\": Event;\n    \"resume\": Event;\n    \"start\": Event;\n    \"stop\": Event;\n}\n\n/**\n * The **`MediaRecorder`** interface of the MediaStream Recording API provides functionality to easily record media.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder)\n */\ninterface MediaRecorder extends EventTarget {\n    /**\n     * The **`audioBitsPerSecond`** read-only property of the MediaRecorder interface returns the audio encoding bit rate in use.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/audioBitsPerSecond)\n     */\n    readonly audioBitsPerSecond: number;\n    /**\n     * The **`mimeType`** read-only property of the MediaRecorder interface returns the MIME media type that was specified when creating the MediaRecorder object, or, if none was specified, which was chosen by the browser.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/mimeType)\n     */\n    readonly mimeType: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/dataavailable_event) */\n    ondataavailable: ((this: MediaRecorder, ev: BlobEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/error_event) */\n    onerror: ((this: MediaRecorder, ev: ErrorEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/pause_event) */\n    onpause: ((this: MediaRecorder, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/resume_event) */\n    onresume: ((this: MediaRecorder, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/start_event) */\n    onstart: ((this: MediaRecorder, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/stop_event) */\n    onstop: ((this: MediaRecorder, ev: Event) => any) | null;\n    /**\n     * The **`state`** read-only property of the MediaRecorder interface returns the current state of the current `MediaRecorder` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/state)\n     */\n    readonly state: RecordingState;\n    /**\n     * The **`stream`** read-only property of the MediaRecorder interface returns the stream that was passed into the MediaRecorder.MediaRecorder constructor when the `MediaRecorder` was created.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/stream)\n     */\n    readonly stream: MediaStream;\n    /**\n     * The **`videoBitsPerSecond`** read-only property of the MediaRecorder interface returns the video encoding bit rate in use.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/videoBitsPerSecond)\n     */\n    readonly videoBitsPerSecond: number;\n    /**\n     * The **`pause()`** method of the MediaRecorder interface is used to pause recording of media streams.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/pause)\n     */\n    pause(): void;\n    /**\n     * The **`requestData()`** method of the MediaRecorder interface is used to raise a MediaRecorder.dataavailable_event event containing a called.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/requestData)\n     */\n    requestData(): void;\n    /**\n     * The **`resume()`** method of the MediaRecorder interface is used to resume media recording when it has been previously paused.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/resume)\n     */\n    resume(): void;\n    /**\n     * The **`start()`** method of the MediaRecorder interface begins recording media into one or more Blob objects.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/start)\n     */\n    start(timeslice?: number): void;\n    /**\n     * The **`stop()`** method of the MediaRecorder interface is used to stop media capture.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/stop)\n     */\n    stop(): void;\n    addEventListener<K extends keyof MediaRecorderEventMap>(type: K, listener: (this: MediaRecorder, ev: MediaRecorderEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaRecorderEventMap>(type: K, listener: (this: MediaRecorder, ev: MediaRecorderEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaRecorder: {\n    prototype: MediaRecorder;\n    new(stream: MediaStream, options?: MediaRecorderOptions): MediaRecorder;\n    /**\n     * The **`isTypeSupported()`** static method of the MediaRecorder interface returns a Boolean which is `true` if the MIME media type specified is one the user agent should be able to successfully record.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaRecorder/isTypeSupported_static)\n     */\n    isTypeSupported(type: string): boolean;\n};\n\n/**\n * The **`MediaSession`** interface of the Media Session API allows a web page to provide custom behaviors for standard media playback interactions, and to report metadata that can be sent by the user agent to the device or operating system for presentation in standardized user interface elements.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSession)\n */\ninterface MediaSession {\n    /**\n     * The **`metadata`** property of the MediaSession interface contains a MediaMetadata object providing descriptive information about the currently playing media, or `null` if the metadata has not been set.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSession/metadata)\n     */\n    metadata: MediaMetadata | null;\n    /**\n     * The **`playbackState`** property of the playing or paused.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSession/playbackState)\n     */\n    playbackState: MediaSessionPlaybackState;\n    /**\n     * The **`setActionHandler()`** method of the MediaSession interface sets a handler for a media session action.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSession/setActionHandler)\n     */\n    setActionHandler(action: MediaSessionAction, handler: MediaSessionActionHandler | null): void;\n    /**\n     * The **`setCameraActive()`** method of the MediaSession interface is used to indicate to the user agent whether the user's camera is considered to be active.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSession/setCameraActive)\n     */\n    setCameraActive(active: boolean): Promise<void>;\n    /**\n     * The **`setMicrophoneActive()`** method of the MediaSession interface is used to indicate to the user agent whether the user's microphone is considered to be currently muted.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSession/setMicrophoneActive)\n     */\n    setMicrophoneActive(active: boolean): Promise<void>;\n    /**\n     * The **`setPositionState()`** method of the document's media playback position and speed for presentation by user's device in any kind of interface that provides details about ongoing media.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSession/setPositionState)\n     */\n    setPositionState(state?: MediaPositionState): void;\n}\n\ndeclare var MediaSession: {\n    prototype: MediaSession;\n    new(): MediaSession;\n};\n\ninterface MediaSourceEventMap {\n    \"sourceclose\": Event;\n    \"sourceended\": Event;\n    \"sourceopen\": Event;\n}\n\n/**\n * The **`MediaSource`** interface of the Media Source Extensions API represents a source of media data for an HTMLMediaElement object.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource)\n */\ninterface MediaSource extends EventTarget {\n    /**\n     * The **`activeSourceBuffers`** read-only property of the containing a subset of the SourceBuffer objects contained within providing the selected video track, enabled audio tracks, and shown/hidden text tracks.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/activeSourceBuffers)\n     */\n    readonly activeSourceBuffers: SourceBufferList;\n    /**\n     * The **`duration`** property of the MediaSource interface gets and sets the duration of the current media being presented.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/duration)\n     */\n    duration: number;\n    onsourceclose: ((this: MediaSource, ev: Event) => any) | null;\n    onsourceended: ((this: MediaSource, ev: Event) => any) | null;\n    onsourceopen: ((this: MediaSource, ev: Event) => any) | null;\n    /**\n     * The **`readyState`** read-only property of the current `MediaSource`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/readyState)\n     */\n    readonly readyState: ReadyState;\n    /**\n     * The **`sourceBuffers`** read-only property of the containing the list of SourceBuffer objects associated with this `MediaSource`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/sourceBuffers)\n     */\n    readonly sourceBuffers: SourceBufferList;\n    /**\n     * The **`addSourceBuffer()`** method of the given MIME type and adds it to the `MediaSource`'s `SourceBuffer` is also returned.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/addSourceBuffer)\n     */\n    addSourceBuffer(type: string): SourceBuffer;\n    /**\n     * The **`clearLiveSeekableRange()`** method of the to MediaSource.setLiveSeekableRange().\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/clearLiveSeekableRange)\n     */\n    clearLiveSeekableRange(): void;\n    /**\n     * The **`endOfStream()`** method of the ```js-nolint endOfStream() endOfStream(endOfStreamError) ``` - `endOfStreamError` MISSING: optional_inline] - : A string representing an error to throw when the end of the stream is reached.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/endOfStream)\n     */\n    endOfStream(error?: EndOfStreamError): void;\n    /**\n     * The **`removeSourceBuffer()`** method of the MediaSource interface removes the given SourceBuffer from the SourceBufferList associated with this `MediaSource` object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/removeSourceBuffer)\n     */\n    removeSourceBuffer(sourceBuffer: SourceBuffer): void;\n    /**\n     * The **`setLiveSeekableRange()`** method of the media element.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/setLiveSeekableRange)\n     */\n    setLiveSeekableRange(start: number, end: number): void;\n    addEventListener<K extends keyof MediaSourceEventMap>(type: K, listener: (this: MediaSource, ev: MediaSourceEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaSourceEventMap>(type: K, listener: (this: MediaSource, ev: MediaSourceEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaSource: {\n    prototype: MediaSource;\n    new(): MediaSource;\n    /**\n     * The **`canConstructInDedicatedWorker`** static property of the MediaSource interface returns `true` if `MediaSource` worker support is implemented, providing a low-latency feature detection mechanism.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/canConstructInDedicatedWorker_static)\n     */\n    readonly canConstructInDedicatedWorker: boolean;\n    /**\n     * The **`MediaSource.isTypeSupported()`** static method returns a boolean value which is `true` if the given MIME type and (optional) codec are _likely_ to be supported by the current user agent.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSource/isTypeSupported_static)\n     */\n    isTypeSupported(type: string): boolean;\n};\n\n/**\n * The **`MediaSourceHandle`** interface of the Media Source Extensions API is a proxy for a MediaSource that can be transferred from a dedicated worker back to the main thread and attached to a media element via its HTMLMediaElement.srcObject property.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaSourceHandle)\n */\ninterface MediaSourceHandle {\n}\n\ndeclare var MediaSourceHandle: {\n    prototype: MediaSourceHandle;\n    new(): MediaSourceHandle;\n};\n\ninterface MediaStreamEventMap {\n    \"addtrack\": MediaStreamTrackEvent;\n    \"removetrack\": MediaStreamTrackEvent;\n}\n\n/**\n * The **`MediaStream`** interface of the Media Capture and Streams API represents a stream of media content.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream)\n */\ninterface MediaStream extends EventTarget {\n    /**\n     * The **`active`** read-only property of the `true` if the stream is currently active; otherwise, it returns `false`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/active)\n     */\n    readonly active: boolean;\n    /**\n     * The **`id`** read-only property of the MediaStream interface is a string containing 36 characters denoting a unique identifier (GUID) for the object.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/id)\n     */\n    readonly id: string;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/addtrack_event) */\n    onaddtrack: ((this: MediaStream, ev: MediaStreamTrackEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/removetrack_event) */\n    onremovetrack: ((this: MediaStream, ev: MediaStreamTrackEvent) => any) | null;\n    /**\n     * The **`addTrack()`** method of the MediaStream interface adds a new track to the stream.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/addTrack)\n     */\n    addTrack(track: MediaStreamTrack): void;\n    /**\n     * The **`clone()`** method of the MediaStream interface creates a duplicate of the `MediaStream`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/clone)\n     */\n    clone(): MediaStream;\n    /**\n     * The **`getAudioTracks()`** method of the stream's track set where MediaStreamTrack.kind is `audio`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/getAudioTracks)\n     */\n    getAudioTracks(): MediaStreamTrack[];\n    /**\n     * The **`getTrackById()`** method of the MediaStream interface returns a MediaStreamTrack object representing the track with the specified ID string.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/getTrackById)\n     */\n    getTrackById(trackId: string): MediaStreamTrack | null;\n    /**\n     * The **`getTracks()`** method of the stream's track set, regardless of MediaStreamTrack.kind.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/getTracks)\n     */\n    getTracks(): MediaStreamTrack[];\n    /**\n     * The **`getVideoTracks()`** method of the ```js-nolint getVideoTracks() ``` None.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/getVideoTracks)\n     */\n    getVideoTracks(): MediaStreamTrack[];\n    /**\n     * The **`removeTrack()`** method of the MediaStream interface removes a ```js-nolint removeTrack(track) ``` - `track` - : A MediaStreamTrack that will be removed from the stream.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStream/removeTrack)\n     */\n    removeTrack(track: MediaStreamTrack): void;\n    addEventListener<K extends keyof MediaStreamEventMap>(type: K, listener: (this: MediaStream, ev: MediaStreamEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaStreamEventMap>(type: K, listener: (this: MediaStream, ev: MediaStreamEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaStream: {\n    prototype: MediaStream;\n    new(): MediaStream;\n    new(stream: MediaStream): MediaStream;\n    new(tracks: MediaStreamTrack[]): MediaStream;\n};\n\n/**\n * The `MediaStreamAudioDestinationNode` interface represents an audio destination consisting of a WebRTC MediaStream with a single `AudioMediaStreamTrack`, which can be used in a similar way to a `MediaStream` obtained from MediaDevices.getUserMedia.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamAudioDestinationNode)\n */\ninterface MediaStreamAudioDestinationNode extends AudioNode {\n    /**\n     * The `stream` property of the AudioContext interface represents a MediaStream containing a single audio MediaStreamTrack with the same number of channels as the node itself.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamAudioDestinationNode/stream)\n     */\n    readonly stream: MediaStream;\n}\n\ndeclare var MediaStreamAudioDestinationNode: {\n    prototype: MediaStreamAudioDestinationNode;\n    new(context: AudioContext, options?: AudioNodeOptions): MediaStreamAudioDestinationNode;\n};\n\n/**\n * The **`MediaStreamAudioSourceNode`** interface is a type of AudioNode which operates as an audio source whose media is received from a MediaStream obtained using the WebRTC or Media Capture and Streams APIs.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamAudioSourceNode)\n */\ninterface MediaStreamAudioSourceNode extends AudioNode {\n    /**\n     * The MediaStreamAudioSourceNode interface's read-only **`mediaStream`** property indicates the receiving audio.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamAudioSourceNode/mediaStream)\n     */\n    readonly mediaStream: MediaStream;\n}\n\ndeclare var MediaStreamAudioSourceNode: {\n    prototype: MediaStreamAudioSourceNode;\n    new(context: AudioContext, options: MediaStreamAudioSourceOptions): MediaStreamAudioSourceNode;\n};\n\ninterface MediaStreamTrackEventMap {\n    \"ended\": Event;\n    \"mute\": Event;\n    \"unmute\": Event;\n}\n\n/**\n * The **`MediaStreamTrack`** interface of the Media Capture and Streams API represents a single media track within a stream; typically, these are audio or video tracks, but other track types may exist as well.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack)\n */\ninterface MediaStreamTrack extends EventTarget {\n    /**\n     * The **`contentHint`** property of the MediaStreamTrack interface is a string that hints at the type of content the track contains.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/contentHint)\n     */\n    contentHint: string;\n    /**\n     * The **`enabled`** property of the `true` if the track is allowed to render the source stream or `false` if it is not.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/enabled)\n     */\n    enabled: boolean;\n    /**\n     * The **`id`** read-only property of the MediaStreamTrack interface returns a string containing a unique identifier (GUID) for the track, which is generated by the user agent.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/id)\n     */\n    readonly id: string;\n    /**\n     * The **`kind`** read-only property of the MediaStreamTrack interface returns a string set to `'audio'` if the track is an audio track and to `'video'` if it is a video track.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/kind)\n     */\n    readonly kind: string;\n    /**\n     * The **`label`** read-only property of the MediaStreamTrack interface returns a string containing a user agent-assigned label that identifies the track source, as in `'internal microphone'`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/label)\n     */\n    readonly label: string;\n    /**\n     * The **`muted`** read-only property of the indicating whether or not the track is currently unable to provide media output.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/muted)\n     */\n    readonly muted: boolean;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/ended_event) */\n    onended: ((this: MediaStreamTrack, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/mute_event) */\n    onmute: ((this: MediaStreamTrack, ev: Event) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/unmute_event) */\n    onunmute: ((this: MediaStreamTrack, ev: Event) => any) | null;\n    /**\n     * The **`readyState`** read-only property of the MediaStreamTrack interface returns an enumerated value giving the status of the track.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/readyState)\n     */\n    readonly readyState: MediaStreamTrackState;\n    /**\n     * The **`applyConstraints()`** method of the MediaStreamTrack interface applies a set of constraints to the track; these constraints let the website or app establish ideal values and acceptable ranges of values for the constrainable properties of the track, such as frame rate, dimensions, echo cancellation, and so forth.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/applyConstraints)\n     */\n    applyConstraints(constraints?: MediaTrackConstraints): Promise<void>;\n    /**\n     * The **`clone()`** method of the MediaStreamTrack interface creates a duplicate of the `MediaStreamTrack`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/clone)\n     */\n    clone(): MediaStreamTrack;\n    /**\n     * The **`getCapabilities()`** method of the MediaStreamTrack interface returns an object detailing the accepted values or value range for each constrainable property of the associated `MediaStreamTrack`, based upon the platform and user agent.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/getCapabilities)\n     */\n    getCapabilities(): MediaTrackCapabilities;\n    /**\n     * The **`getConstraints()`** method of the MediaStreamTrack interface returns a recently established for the track using a prior call to constraints indicate values and ranges of values that the website or application has specified are required or acceptable for the included constrainable properties.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/getConstraints)\n     */\n    getConstraints(): MediaTrackConstraints;\n    /**\n     * The **`getSettings()`** method of the object containing the current values of each of the constrainable properties for the current `MediaStreamTrack`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/getSettings)\n     */\n    getSettings(): MediaTrackSettings;\n    /**\n     * The **`stop()`** method of the MediaStreamTrack interface stops the track.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrack/stop)\n     */\n    stop(): void;\n    addEventListener<K extends keyof MediaStreamTrackEventMap>(type: K, listener: (this: MediaStreamTrack, ev: MediaStreamTrackEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaStreamTrackEventMap>(type: K, listener: (this: MediaStreamTrack, ev: MediaStreamTrackEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaStreamTrack: {\n    prototype: MediaStreamTrack;\n    new(): MediaStreamTrack;\n};\n\n/**\n * The **`MediaStreamTrackEvent`** interface of the Media Capture and Streams API represents events which indicate that a MediaStream has had tracks added to or removed from the stream through calls to Media Capture and Streams API methods.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrackEvent)\n */\ninterface MediaStreamTrackEvent extends Event {\n    /**\n     * The **`track`** read-only property of the MediaStreamTrackEvent interface returns the MediaStreamTrack associated with this event.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MediaStreamTrackEvent/track)\n     */\n    readonly track: MediaStreamTrack;\n}\n\ndeclare var MediaStreamTrackEvent: {\n    prototype: MediaStreamTrackEvent;\n    new(type: string, eventInitDict: MediaStreamTrackEventInit): MediaStreamTrackEvent;\n};\n\n/**\n * The **`MessageChannel`** interface of the Channel Messaging API allows us to create a new message channel and send data through it via its two MessagePort properties.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageChannel)\n */\ninterface MessageChannel {\n    /**\n     * The **`port1`** read-only property of the the port attached to the context that originated the channel.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageChannel/port1)\n     */\n    readonly port1: MessagePort;\n    /**\n     * The **`port2`** read-only property of the the port attached to the context at the other end of the channel, which the message is initially sent to.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageChannel/port2)\n     */\n    readonly port2: MessagePort;\n}\n\ndeclare var MessageChannel: {\n    prototype: MessageChannel;\n    new(): MessageChannel;\n};\n\n/**\n * The **`MessageEvent`** interface represents a message received by a target object.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageEvent)\n */\ninterface MessageEvent<T = any> extends Event {\n    /**\n     * The **`data`** read-only property of the The data sent by the message emitter; this can be any data type, depending on what originated this event.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageEvent/data)\n     */\n    readonly data: T;\n    /**\n     * The **`lastEventId`** read-only property of the unique ID for the event.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageEvent/lastEventId)\n     */\n    readonly lastEventId: string;\n    /**\n     * The **`origin`** read-only property of the origin of the message emitter.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageEvent/origin)\n     */\n    readonly origin: string;\n    /**\n     * The **`ports`** read-only property of the containing all MessagePort objects sent with the message, in order.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageEvent/ports)\n     */\n    readonly ports: ReadonlyArray<MessagePort>;\n    /**\n     * The **`source`** read-only property of the a WindowProxy, MessagePort, or a `MessageEventSource` (which can be a WindowProxy, message emitter.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessageEvent/source)\n     */\n    readonly source: MessageEventSource | null;\n    /** @deprecated */\n    initMessageEvent(type: string, bubbles?: boolean, cancelable?: boolean, data?: any, origin?: string, lastEventId?: string, source?: MessageEventSource | null, ports?: MessagePort[]): void;\n}\n\ndeclare var MessageEvent: {\n    prototype: MessageEvent;\n    new<T>(type: string, eventInitDict?: MessageEventInit<T>): MessageEvent<T>;\n};\n\ninterface MessageEventTargetEventMap {\n    \"message\": MessageEvent;\n    \"messageerror\": MessageEvent;\n}\n\ninterface MessageEventTarget<T> {\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DedicatedWorkerGlobalScope/message_event) */\n    onmessage: ((this: T, ev: MessageEvent) => any) | null;\n    /** [MDN Reference](https://developer.mozilla.org/docs/Web/API/DedicatedWorkerGlobalScope/messageerror_event) */\n    onmessageerror: ((this: T, ev: MessageEvent) => any) | null;\n    addEventListener<K extends keyof MessageEventTargetEventMap>(type: K, listener: (this: T, ev: MessageEventTargetEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MessageEventTargetEventMap>(type: K, listener: (this: T, ev: MessageEventTargetEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ninterface MessagePortEventMap extends MessageEventTargetEventMap {\n    \"message\": MessageEvent;\n    \"messageerror\": MessageEvent;\n}\n\n/**\n * The **`MessagePort`** interface of the Channel Messaging API represents one of the two ports of a MessageChannel, allowing messages to be sent from one port and listening out for them arriving at the other.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessagePort)\n */\ninterface MessagePort extends EventTarget, MessageEventTarget<MessagePort> {\n    /**\n     * The **`close()`** method of the MessagePort interface disconnects the port, so it is no longer active.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessagePort/close)\n     */\n    close(): void;\n    /**\n     * The **`postMessage()`** method of the transfers ownership of objects to other browsing contexts.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessagePort/postMessage)\n     */\n    postMessage(message: any, transfer: Transferable[]): void;\n    postMessage(message: any, options?: StructuredSerializeOptions): void;\n    /**\n     * The **`start()`** method of the MessagePort interface starts the sending of messages queued on the port.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MessagePort/start)\n     */\n    start(): void;\n    addEventListener<K extends keyof MessagePortEventMap>(type: K, listener: (this: MessagePort, ev: MessagePortEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MessagePortEventMap>(type: K, listener: (this: MessagePort, ev: MessagePortEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MessagePort: {\n    prototype: MessagePort;\n    new(): MessagePort;\n};\n\n/**\n * The **`MimeType`** interface provides contains information about a MIME type associated with a particular plugin.\n * @deprecated\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MimeType)\n */\ninterface MimeType {\n    /**\n     * Returns the MIME type's description.\n     * @deprecated\n     */\n    readonly description: string;\n    /**\n     * Returns the Plugin object that implements this MIME type.\n     * @deprecated\n     */\n    readonly enabledPlugin: Plugin;\n    /**\n     * Returns the MIME type's typical file extensions, in a comma-separated list.\n     * @deprecated\n     */\n    readonly suffixes: string;\n    /**\n     * Returns the MIME type.\n     * @deprecated\n     */\n    readonly type: string;\n}\n\n/** @deprecated */\ndeclare var MimeType: {\n    prototype: MimeType;\n    new(): MimeType;\n};\n\n/**\n * The **`MimeTypeArray`** interface returns an array of MimeType instances, each of which contains information about a supported browser plugins.\n * @deprecated\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MimeTypeArray)\n */\ninterface MimeTypeArray {\n    /** @deprecated */\n    readonly length: number;\n    /** @deprecated */\n    item(index: number): MimeType | null;\n    /** @deprecated */\n    namedItem(name: string): MimeType | null;\n    [index: number]: MimeType;\n}\n\n/** @deprecated */\ndeclare var MimeTypeArray: {\n    prototype: MimeTypeArray;\n    new(): MimeTypeArray;\n};\n\n/**\n * The **`MouseEvent`** interface represents events that occur due to the user interacting with a pointing device (such as a mouse).\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent)\n */\ninterface MouseEvent extends UIEvent {\n    /**\n     * The **`MouseEvent.altKey`** read-only property is a boolean value that indicates whether the <kbd>alt</kbd> key was pressed or not when a given mouse event occurs.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/altKey)\n     */\n    readonly altKey: boolean;\n    /**\n     * The **`MouseEvent.button`** read-only property indicates which button was pressed or released on the mouse to trigger the event.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/button)\n     */\n    readonly button: number;\n    /**\n     * The **`MouseEvent.buttons`** read-only property indicates which buttons are pressed on the mouse (or other input device) when a mouse event is triggered.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/buttons)\n     */\n    readonly buttons: number;\n    /**\n     * The **`clientX`** read-only property of the MouseEvent interface provides the horizontal coordinate within the application's viewport at which the event occurred (as opposed to the coordinate within the page).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/clientX)\n     */\n    readonly clientX: number;\n    /**\n     * The **`clientY`** read-only property of the MouseEvent interface provides the vertical coordinate within the application's viewport at which the event occurred (as opposed to the coordinate within the page).\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/clientY)\n     */\n    readonly clientY: number;\n    /**\n     * The **`MouseEvent.ctrlKey`** read-only property is a boolean value that indicates whether the <kbd>ctrl</kbd> key was pressed or not when a given mouse event occurs.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/ctrlKey)\n     */\n    readonly ctrlKey: boolean;\n    /**\n     * The **`MouseEvent.layerX`** read-only property returns the horizontal coordinate of the event relative to the current layer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/layerX)\n     */\n    readonly layerX: number;\n    /**\n     * The **`MouseEvent.layerY`** read-only property returns the vertical coordinate of the event relative to the current layer.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/layerY)\n     */\n    readonly layerY: number;\n    /**\n     * The **`MouseEvent.metaKey`** read-only property is a boolean value that indicates whether the <kbd>meta</kbd> key was pressed or not when a given mouse event occurs.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/metaKey)\n     */\n    readonly metaKey: boolean;\n    /**\n     * The **`movementX`** read-only property of the MouseEvent interface provides the difference in the X coordinate of the mouse pointer between the given event and the previous Element/mousemove_event event.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/movementX)\n     */\n    readonly movementX: number;\n    /**\n     * The **`movementY`** read-only property of the MouseEvent interface provides the difference in the Y coordinate of the mouse pointer between the given event and the previous Element/mousemove_event event.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/movementY)\n     */\n    readonly movementY: number;\n    /**\n     * The **`offsetX`** read-only property of the MouseEvent interface provides the offset in the X coordinate of the mouse pointer between that event and the padding edge of the target node.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/offsetX)\n     */\n    readonly offsetX: number;\n    /**\n     * The **`offsetY`** read-only property of the MouseEvent interface provides the offset in the Y coordinate of the mouse pointer between that event and the padding edge of the target node.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/offsetY)\n     */\n    readonly offsetY: number;\n    /**\n     * The **`pageX`** read-only property of the MouseEvent interface returns the X (horizontal) coordinate (in pixels) at which the mouse was clicked, relative to the left edge of the entire document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/pageX)\n     */\n    readonly pageX: number;\n    /**\n     * The **`pageY`** read-only property of the MouseEvent interface returns the Y (vertical) coordinate (in pixels) at which the mouse was clicked, relative to the top edge of the entire document.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/pageY)\n     */\n    readonly pageY: number;\n    /**\n     * The **`MouseEvent.relatedTarget`** read-only property is the secondary target for the mouse event, if there is one.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/relatedTarget)\n     */\n    readonly relatedTarget: EventTarget | null;\n    /**\n     * The **`screenX`** read-only property of the MouseEvent interface provides the horizontal coordinate (offset) of the mouse pointer in screen coordinates.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/screenX)\n     */\n    readonly screenX: number;\n    /**\n     * The **`screenY`** read-only property of the MouseEvent interface provides the vertical coordinate (offset) of the mouse pointer in screen coordinates.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/screenY)\n     */\n    readonly screenY: number;\n    /**\n     * The **`MouseEvent.shiftKey`** read-only property is a boolean value that indicates whether the <kbd>shift</kbd> key was pressed or not when a given mouse event occurs.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/shiftKey)\n     */\n    readonly shiftKey: boolean;\n    /**\n     * The **`MouseEvent.x`** property is an alias for the MouseEvent.clientX property.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/x)\n     */\n    readonly x: number;\n    /**\n     * The **`MouseEvent.y`** property is an alias for the MouseEvent.clientY property.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/y)\n     */\n    readonly y: number;\n    /**\n     * The **`MouseEvent.getModifierState()`** method returns the current state of the specified modifier key: `true` if the modifier is active (i.e., the modifier key is pressed or locked), otherwise, `false`.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/getModifierState)\n     */\n    getModifierState(keyArg: string): boolean;\n    /**\n     * The **`MouseEvent.initMouseEvent()`** method initializes the value of a mouse event once it's been created (normally using the Document.createEvent() method).\n     * @deprecated\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MouseEvent/initMouseEvent)\n     */\n    initMouseEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, detailArg: number, screenXArg: number, screenYArg: number, clientXArg: number, clientYArg: number, ctrlKeyArg: boolean, altKeyArg: boolean, shiftKeyArg: boolean, metaKeyArg: boolean, buttonArg: number, relatedTargetArg: EventTarget | null): void;\n}\n\ndeclare var MouseEvent: {\n    prototype: MouseEvent;\n    new(type: string, eventInitDict?: MouseEventInit): MouseEvent;\n};\n\n/**\n * The **`MutationObserver`** interface provides the ability to watch for changes being made to the DOM tree.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationObserver)\n */\ninterface MutationObserver {\n    /**\n     * The MutationObserver method **`disconnect()`** tells the observer to stop watching for mutations.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationObserver/disconnect)\n     */\n    disconnect(): void;\n    /**\n     * The MutationObserver method **`observe()`** configures the `MutationObserver` callback to begin receiving notifications of changes to the DOM that match the given options.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationObserver/observe)\n     */\n    observe(target: Node, options?: MutationObserverInit): void;\n    /**\n     * The MutationObserver method **`takeRecords()`** returns a list of all matching DOM changes that have been detected but not yet processed by the observer's callback function, leaving the mutation queue empty.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationObserver/takeRecords)\n     */\n    takeRecords(): MutationRecord[];\n}\n\ndeclare var MutationObserver: {\n    prototype: MutationObserver;\n    new(callback: MutationCallback): MutationObserver;\n};\n\n/**\n * The **`MutationRecord`** is a read-only interface that represents an individual DOM mutation observed by a MutationObserver.\n *\n * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord)\n */\ninterface MutationRecord {\n    /**\n     * The MutationRecord read-only property **`addedNodes`** is a NodeList of nodes added to a target node by a mutation observed with a MutationObserver.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/addedNodes)\n     */\n    readonly addedNodes: NodeList;\n    /**\n     * The MutationRecord read-only property **`attributeName`** contains the name of a changed attribute belonging to a node that is observed by a MutationObserver.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/attributeName)\n     */\n    readonly attributeName: string | null;\n    /**\n     * The MutationRecord read-only property **`attributeNamespace`** is the namespace of the mutated attribute in the MutationRecord observed by a MutationObserver.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/attributeNamespace)\n     */\n    readonly attributeNamespace: string | null;\n    /**\n     * The MutationRecord read-only property **`nextSibling`** is the next sibling of an added or removed child node of the `target` of a MutationObserver.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/nextSibling)\n     */\n    readonly nextSibling: Node | null;\n    /**\n     * The MutationRecord read-only property **`oldValue`** contains the character data or attribute value of an observed node before it was changed.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/oldValue)\n     */\n    readonly oldValue: string | null;\n    /**\n     * The MutationRecord read-only property **`previousSibling`** is the previous sibling of an added or removed child node of the `target` of a MutationObserver.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/previousSibling)\n     */\n    readonly previousSibling: Node | null;\n    /**\n     * The MutationRecord read-only property **`removedNodes`** is a NodeList of nodes removed from a target node by a mutation observed with a MutationObserver.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/removedNodes)\n     */\n    readonly removedNodes: NodeList;\n    /**\n     * The MutationRecord read-only property **`target`** is the target (i.e., the mutated/changed node) of a mutation observed with a MutationObserver.\n     *\n     * [MDN Reference](https://developer.mozilla.org/docs/Web/API/MutationRecord/target)\n     */\n    readonly target: Node;\n    /**\n     * The MutationRecord read-only property **`type`** is the typ