class h {
  constructor(t) {
    this.type = t;
  }
  validate(t) {
    return typeof t !== this.type ? { content: void 0, error: { message: `Expected ${this.type}, but got ${typeof t}` } } : { content: t, error: void 0 };
  }
}
const _ = new h("string");
function w() {
  return _;
}
const u = new h("number");
function b() {
  return u;
}
const g = new h("boolean");
function E() {
  return g;
}
const C = new h("object");
function k() {
  return C;
}
const p = new h("undefined");
function z() {
  return p;
}
function D() {
  return {
    validate(i) {
      return { content: i, error: void 0 };
    }
  };
}
function A(i) {
  return {
    validate(t) {
      if (typeof t != "object" || t === null)
        return { content: void 0, error: { message: "Expected object" } };
      const e = {};
      for (const n in i) {
        const s = i[n], { content: r, error: a } = s.validate(t[n]);
        if (a)
          return { content: void 0, error: { message: `Error in property ${n}: ${a.message}` } };
        e[n] = r;
      }
      return { content: e, error: void 0 };
    }
  };
}
function H(i) {
  return {
    validate(t) {
      if (!Array.isArray(t))
        return { content: void 0, error: { message: "Expected array" } };
      const e = [];
      for (let n = 0; n < t.length; n++) {
        const { content: s, error: r } = i.validate(t[n]);
        if (r)
          return { content: void 0, error: { message: `Error in element ${n}: ${r.message}` } };
        e.push(s);
      }
      return { content: e, error: void 0 };
    }
  };
}
function M(...i) {
  return {
    validate(t) {
      if (!Array.isArray(t))
        return { content: void 0, error: { message: "Expected array" } };
      if (t.length !== i.length)
        return { content: void 0, error: { message: `Expected tuple of length ${i.length}, but got ${t.length}` } };
      const e = [];
      for (let n = 0; n < i.length; n++) {
        const s = i[n], { content: r, error: a } = s.validate(t[n]);
        if (a)
          return { content: void 0, error: { message: `Error in element ${n}: ${a.message}` } };
        e.push(r);
      }
      return { content: e, error: void 0 };
    }
  };
}
function I(...i) {
  return {
    validate(t) {
      let e;
      for (const n of i) {
        const { content: s, error: r } = n.validate(t);
        if (!r)
          return { content: s, error: void 0 };
        e = r;
      }
      return { content: void 0, error: e };
    }
  };
}
class l {
  constructor(t, e) {
    if (this._ourWindow = t, this._theirWindow = e, this._lastDisposable = void 0, t === e)
      throw new Error("Cannot connect to self");
  }
  static toParent() {
    if (window.parent !== window)
      return new l(window, window.parent);
  }
  setMessageHandler(t) {
    if (this._lastDisposable)
      throw new Error("Cannot set multiple message handlers");
    const e = (n) => {
      if (n.source !== this._theirWindow)
        return;
      const s = n.data;
      t(s);
    };
    this._ourWindow.addEventListener("message", e), this._lastDisposable = {
      dispose: () => {
        this._ourWindow.removeEventListener("message", e);
      }
    };
  }
  sendMessage(t) {
    this._theirWindow.postMessage(t, "*");
  }
  dispose() {
    this._lastDisposable && this._lastDisposable.dispose();
  }
}
function S(i) {
  return i;
}
function o(i, t) {
  if (i === t)
    return !0;
  if (typeof i == "object" && i && typeof t == "object" && t) {
    if (Array.isArray(i) !== Array.isArray(t))
      return !1;
    if (Array.isArray(i) && Array.isArray(t)) {
      if (i.length !== t.length)
        return !1;
      for (let s = 0; s < i.length; s++)
        if (!o(i[s], t[s]))
          return !1;
      return !0;
    }
    const e = Object.keys(i), n = Object.keys(t);
    if (e.length !== n.length)
      return !1;
    for (const s of e)
      if (!o(i[s], t[s]))
        return !1;
    return !0;
  }
  return !1;
}
function x(i, t) {
  return i === void 0 ? void 0 : t(i);
}
function j(i, t, e) {
  const n = (e == null ? void 0 : e.connection) ?? x(l.toParent(), (r) => r);
  return n ? new v(
    i ?? D(),
    n,
    (r) => t(r)
  ) : void 0;
}
class v {
  /**
   * @internal
  */
  constructor(t, e, n) {
    this._validator = t, this._connection = e, this._handleContentDidChange = n, this.onDidConnect = new Promise((s) => this._onDidConnect = s), this._lastContent = void 0, this._shouldSendContentAfterInitialize = !1, this._initialized = !1, this._connection.setMessageHandler((s) => this._handleMessage(s)), this._connection.sendMessage({
      method: "initialized",
      version: "web-editor/0.9",
      contentType: "json",
      capabilities: {
        supportsTextEdits: !1
      }
    });
  }
  get isConnected() {
    return this._initialized;
  }
  get canExpectConnection() {
    return !1;
  }
  dispose() {
    this._connection.dispose();
  }
  updateContent(t) {
    if (this._initialized) {
      if (o(t, this._lastContent))
        return;
      this._lastContent = t, this._shouldSendContentAfterInitialize = !1, this._connection.sendMessage({
        method: "contentChanged",
        content: t
      });
    } else
      this._lastContent = t, this._shouldSendContentAfterInitialize = !0;
  }
  _handleMessage(t) {
    switch (t.method) {
      case "initialized": {
        if (!this._initialized) {
          this._initialized = !0;
          try {
            this._onDidConnect();
          } finally {
            this._shouldSendContentAfterInitialize && (this._shouldSendContentAfterInitialize = !1, this._connection.sendMessage({
              method: "contentChanged",
              content: this._lastContent
            }));
          }
        }
        return;
      }
      case "update": {
        const e = t.content;
        e !== void 0 && this._updateContentFromHost(e);
        return;
      }
    }
  }
  _updateContentFromHost(t) {
    const e = this._validator.validate(t);
    if (e.error) {
      console.error("Error in content from host", e.error.message);
      return;
    }
    o(e.content, this._lastContent) || (this._shouldSendContentAfterInitialize = !1, this._lastContent = e.content, this._handleContentDidChange(e.content));
  }
}
class d {
  constructor(t = {}) {
    this._listeners = /* @__PURE__ */ new Set(), this.event = (e) => {
      const n = { run: e };
      this._listeners.add(n), this._listeners.size === 1 && this._onDidChangeHasListeners && this._onDidChangeHasListeners(!0);
      let s = !1;
      const r = {
        dispose: () => {
          r.dispose = () => {
          }, !s && (s = !0, this._listeners.delete(n), this._listeners.size === 0 && this._onDidChangeHasListeners && this._onDidChangeHasListeners(!1));
        }
      };
      return r;
    }, this._onDidChangeHasListeners = t.onDidChangeHasListeners;
  }
  fire(t) {
    for (const e of this._listeners)
      e.run(t);
  }
}
class O {
  constructor(t) {
    this._onDidChangeTextContent = new d(), this.onDidChangeTextContent = this._onDidChangeTextContent.event, this._clientInitialized = !1, this._disposables = [], this._settingDataFromClient = !1, this._data = new T("{}", t.formatJson ?? !1), this._readOnly = t.readonly ?? !1, this._connection = t.connection, t.initialTextContent && this._data.setText(t.initialTextContent), this._disposables.push(this._connection), this._disposables.push(this._data.onDidChangeData((e) => {
      this._clientInitialized && !this._settingDataFromClient && this._connection.sendMessage({
        method: "update",
        content: this._data.getData()
      });
    })), this._disposables.push(this._data.onDidChangeText((e) => {
      this._onDidChangeTextContent.fire({ newTextContent: this._data.getText() });
    })), this.errorHandler = t.errorHandler ?? ((e, n) => console.error("Web Editor Host Error: " + e, n)), this._connection.setMessageHandler((e) => {
      switch (e.method) {
        case "initialized": {
          if (e.version !== "web-editor/0.9") {
            this.errorHandler(`Unsupported version "${e.version}"`, { kind: "unsupportedVersion", message: e });
            return;
          }
          this._clientInitialized = !1, this._data.setContentType(e.contentType ?? "text"), this._connection.sendMessage({
            method: "update",
            content: this._data.getData()
          }), this._connection.sendMessage({
            method: "initialized",
            version: "web-editor-host/0.9",
            capabilities: {
              supportsOptions: !1,
              supportsTextEdits: !1
            }
          }), this._clientInitialized = !0;
          break;
        }
        case "contentChanged": {
          if (this._readOnly) {
            this.errorHandler("Content is readonly", { kind: "contentIsReadonly", message: e });
            return;
          }
          try {
            this._settingDataFromClient = !0, this._data.setData(e.content);
          } finally {
            this._settingDataFromClient = !1;
          }
          break;
        }
        case "optionsChanged": {
          this.errorHandler("Options are not supported", { kind: "optionsNotSupported", message: e });
          break;
        }
        default: {
          this.errorHandler("Unknown message", { kind: "unknownMessage", message: e });
          break;
        }
      }
    });
  }
  setTextContent(t) {
    this._data.setText(t);
  }
  getTextContent() {
    return this._data.getText();
  }
  setReadOnly(t) {
    this._readOnly !== t && (this._readOnly = t, this._clientInitialized && this._connection.sendMessage({
      method: "update",
      readOnly: t
    }));
  }
  dispose() {
    this._disposables.forEach((t) => t.dispose()), this._disposables.length = 0;
  }
}
class T {
  constructor(t, e) {
    this._formatJson = e, this._onDidChangeData = new d(), this.onDidChangeData = this._onDidChangeData.event, this._onDidChangeText = new d(), this.onDidChangeText = this._onDidChangeText.event, this._resetTransformer(t);
  }
  _resetTransformer(t) {
    this._transformer = new c(
      () => this._onDidChangeText.fire(),
      () => {
      },
      t
    );
  }
  setText(t) {
    this._transformer && this._transformer.setText(t);
  }
  getText() {
    return this._transformer.getText();
  }
  setContentType(t) {
    if (this._contentType === t)
      return;
    const e = this._transformer.getText();
    switch (this._contentType = t, t) {
      case void 0:
        this._resetTransformer(this._transformer.getText());
        break;
      case "text":
        this._transformer = new c(
          () => this._onDidChangeText.fire(),
          () => this._onDidChangeData.fire(),
          e
        );
        break;
      case "json":
        this._transformer = new y(
          () => this._onDidChangeText.fire(),
          () => this._onDidChangeData.fire(),
          e,
          this._formatJson
        );
        break;
    }
  }
  _checkContentTypeDefined() {
    if (this._contentType === void 0)
      throw new Error("Bug - Cannot setData when no content type is set");
  }
  setData(t) {
    this._checkContentTypeDefined(), this._transformer.setData(t);
  }
  getData() {
    return this._checkContentTypeDefined(), this._transformer.getData();
  }
}
class f {
}
function m(i) {
  try {
    return { value: JSON.parse(i), error: void 0 };
  } catch (t) {
    return { value: void 0, error: t };
  }
}
class y extends f {
  constructor(t, e, n, s) {
    super(), this._onDidChangeText = t, this._onDidChangeData = e, this._formatJson = s, this._text = "", this._data = {}, this.setText(n, !0);
  }
  getText() {
    return this._text;
  }
  setText(t, e = !1) {
    if (this._text === t)
      return;
    this._text = t;
    let n = !1;
    const s = m(t);
    if (!s.error) {
      const r = this._data;
      this._data = s.value, o(r, this._data) || (n = !0);
    }
    e || (this._onDidChangeText(), n && this._onDidChangeData());
  }
  getData() {
    return this._data;
  }
  setData(t) {
    if (o(t, this._data))
      return;
    this._data = t;
    let e = !1;
    const n = JSON.stringify(t, void 0, this._formatJson ? 4 : void 0);
    this._text !== n && (this._text = n, e = !0), this._onDidChangeData(), e && this._onDidChangeText();
  }
}
class c extends f {
  constructor(t, e, n) {
    super(), this._onDidChangeText = t, this._onDidChangeData = e, this._text = "", this.setText(n);
  }
  getText() {
    return this._text;
  }
  setText(t) {
    this._text !== t && (this._text = t, this._onDidChangeText(), this._onDidChangeData());
  }
  getData() {
    return this._text;
  }
  setData(t) {
    if (typeof t != "string")
      throw new Error("Bug - Expected string data");
    this._text !== t && (this._onDidChangeData(), this._onDidChangeText());
  }
}
export {
  v as JsonWebEditorClient,
  O as WebEditorHost,
  l as WindowConnection,
  S as castConnection,
  j as createJsonWebEditorClient,
  H as vArray,
  E as vBoolean,
  b as vNumber,
  A as vObj,
  k as vObjAny,
  w as vString,
  M as vTuple,
  D as vUnchecked,
  z as vUndefined,
  I as vUnion
};
