export interface IValidator<T> {
    validate(content: unknown): {
        content: T;
        error: undefined;
    } | {
        content: undefined;
        error: ValidationError;
    };
}
export type ValidatorType<T> = T extends IValidator<infer U> ? U : never;
export interface ValidationError {
    message: string;
}
export declare function vString(): IValidator<string>;
export declare function vNumber(): IValidator<number>;
export declare function vBoolean(): IValidator<boolean>;
export declare function vObjAny(): IValidator<object>;
export declare function vUndefined(): IValidator<undefined>;
export declare function vUnchecked<T>(): IValidator<T>;
export type ObjectProperties = Record<string, any>;
export declare function vObj<T extends Record<string, IValidator<any>>>(properties: T): IValidator<{
    [K in keyof T]: ValidatorType<T[K]>;
}>;
export declare function vArray<T>(validator: IValidator<T>): IValidator<T[]>;
export declare function vTuple<T extends IValidator<any>[]>(...validators: T): IValidator<{
    [K in keyof T]: ValidatorType<T[K]>;
}>;
export declare function vUnion<T extends IValidator<any>[]>(...validators: T): IValidator<ValidatorType<T[number]>>;
