import { IConnection } from "./connection";
import type { EditorMessage, HostMessage } from "./web-editor-protocol";
import { IDisposable } from "./utils/disposable";
export type IServerConnection = IConnection<EditorMessage, HostMessage>;
export declare class WebEditorHost implements IDisposable {
    private readonly _onDidChangeTextContent;
    readonly onDidChangeTextContent: import("./utils/events").IEvent<{
        newTextContent: string;
    }>;
    private readonly _connection;
    private readonly errorHandler;
    private _readOnly;
    private readonly _data;
    private _clientInitialized;
    private readonly _disposables;
    private _settingDataFromClient;
    constructor(options: {
        connection: IServerConnection;
        initialTextContent?: string;
        readonly?: boolean;
        errorHandler?: (errorMessage: string, error: WebEditorHostError) => void;
        formatJson?: boolean;
    });
    setTextContent(newTextContent: string): void;
    getTextContent(): string;
    setReadOnly(readOnly: boolean): void;
    dispose(): void;
}
export type JsonValue = string | number | boolean | null | JsonValue[] | JSONObject;
interface JSONObject {
    [key: string]: JsonValue;
}
type WebEditorHostError = {
    kind: 'unsupportedVersion';
    message: EditorMessage;
} | {
    kind: 'contentIsReadonly';
    message: EditorMessage;
} | {
    kind: 'unknownMessage';
    message: EditorMessage;
} | {
    kind: 'optionsNotSupported';
    message: EditorMessage;
} | {};
export {};
