import { IValidator } from "./validators";
import { IConnection } from "./connection";
import type { EditorMessage, HostMessage } from "./web-editor-protocol";
export declare function createJsonWebEditorClient<T>(dataScheme: IValidator<T> | undefined, onUpdate: (data: T) => void, options?: {
    connection?: IClientConnection;
}): JsonWebEditorClient<T> | undefined;
export type IClientConnection = IConnection<HostMessage, EditorMessage>;
export declare class JsonWebEditorClient<T> {
    private readonly _validator;
    private readonly _connection;
    private readonly _handleContentDidChange;
    private _onDidConnect;
    readonly onDidConnect: Promise<void>;
    private _lastContent;
    private _shouldSendContentAfterInitialize;
    get isConnected(): boolean;
    get canExpectConnection(): boolean;
    /**
     * @internal
    */
    constructor(_validator: IValidator<T>, _connection: IClientConnection, _handleContentDidChange: (data: T) => void);
    dispose(): void;
    updateContent(content: T): void;
    private _initialized;
    private _handleMessage;
    private _updateContentFromHost;
}
